/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.opentelemetry;

import io.opentelemetry.OpenTelemetry;
import io.opentelemetry.common.AttributeValue;
import io.opentelemetry.common.Attributes;
import io.opentelemetry.correlationcontext.CorrelationContext;
import io.opentelemetry.correlationcontext.CorrelationContextManager;
import io.opentelemetry.correlationcontext.EntryMetadata;
import io.opentelemetry.trace.Span;
import io.opentelemetry.trace.attributes.SemanticAttributes;
import java.util.EnumMap;
import java.util.Map;
import org.apache.camel.tracing.SpanAdapter;
import org.apache.camel.tracing.Tag;

public class OpenTelemetrySpanAdapter
implements SpanAdapter {
    static final EntryMetadata DEFAULT_ENTRY_METADATA = EntryMetadata.create((EntryMetadata.EntryTtl)EntryMetadata.EntryTtl.UNLIMITED_PROPAGATION);
    private static final String DEFAULT_EVENT_NAME = "log";
    private static EnumMap<Tag, String> tagMap = new EnumMap(Tag.class);
    Span span;
    private CorrelationContextManager contextManager;
    private CorrelationContext correlationContext;
    private OpenTelemetrySpanAdapter parent;

    OpenTelemetrySpanAdapter(Span span) {
        this.span = span;
        this.contextManager = OpenTelemetry.getCorrelationContextManager();
    }

    OpenTelemetrySpanAdapter(Span span, CorrelationContext correlationContext) {
        this.span = span;
        this.contextManager = OpenTelemetry.getCorrelationContextManager();
        this.correlationContext = correlationContext;
    }

    Span getOpenTelemetrySpan() {
        return this.span;
    }

    public void setComponent(String component) {
        this.span.setAttribute("component", component);
    }

    public void setError(boolean error) {
        this.span.setAttribute("error", error);
    }

    public void setTag(Tag key, String value) {
        this.span.setAttribute(tagMap.get(key), value);
    }

    public void setTag(Tag key, Number value) {
        this.span.setAttribute(tagMap.get(key), (long)value.intValue());
    }

    public void setTag(String key, String value) {
        this.span.setAttribute(key, value);
    }

    public void setTag(String key, Number value) {
        this.span.setAttribute(key, (long)value.intValue());
    }

    public void setTag(String key, Boolean value) {
        this.span.setAttribute(key, value.booleanValue());
    }

    public void log(Map<String, String> fields) {
        this.span.addEvent(this.getEventNameFromFields(fields), this.convertToAttributes(fields));
    }

    String getEventNameFromFields(Map<String, ?> fields) {
        Object eventValue;
        Object object = eventValue = fields == null ? null : (Object)fields.get("event");
        if (eventValue != null) {
            return eventValue.toString();
        }
        return DEFAULT_EVENT_NAME;
    }

    Attributes convertToAttributes(Map<String, ?> fields) {
        Attributes.Builder attributesBuilder = Attributes.newBuilder();
        for (Map.Entry<String, ?> entry : fields.entrySet()) {
            String key = entry.getKey();
            Object value = entry.getValue();
            if (value == null) continue;
            if (value instanceof Byte || value instanceof Short || value instanceof Integer || value instanceof Long) {
                attributesBuilder.setAttribute(key, AttributeValue.longAttributeValue((long)((Number)value).longValue()));
                continue;
            }
            if (value instanceof Float || value instanceof Double) {
                attributesBuilder.setAttribute(key, AttributeValue.doubleAttributeValue((double)((Number)value).doubleValue()));
                continue;
            }
            if (value instanceof Boolean) {
                attributesBuilder.setAttribute(key, AttributeValue.booleanAttributeValue((boolean)((Boolean)value)));
                continue;
            }
            attributesBuilder.setAttribute(key, AttributeValue.stringAttributeValue((String)value.toString()));
        }
        return attributesBuilder.build();
    }

    public CorrelationContext getCorrelationContext() {
        return this.correlationContext;
    }

    public void setCorrelationContext(CorrelationContext correlationContext) {
        this.correlationContext = correlationContext;
    }

    public void setCorrelationContextItem(String key, String value) {
        CorrelationContext.Builder builder = this.contextManager.contextBuilder();
        if (this.correlationContext != null) {
            builder = builder.setParent(this.correlationContext);
        }
        this.correlationContext = builder.put(key, value, DEFAULT_ENTRY_METADATA).build();
    }

    public String getContextPropagationItem(String key) {
        if (this.correlationContext != null) {
            return this.correlationContext.getEntryValue(key);
        }
        return null;
    }

    static {
        tagMap.put(Tag.COMPONENT, "component");
        tagMap.put(Tag.DB_TYPE, SemanticAttributes.DB_SYSTEM.key());
        tagMap.put(Tag.DB_STATEMENT, SemanticAttributes.DB_STATEMENT.key());
        tagMap.put(Tag.DB_INSTANCE, SemanticAttributes.DB_NAME.key());
        tagMap.put(Tag.HTTP_METHOD, SemanticAttributes.HTTP_METHOD.key());
        tagMap.put(Tag.HTTP_STATUS, SemanticAttributes.HTTP_STATUS_CODE.key());
        tagMap.put(Tag.HTTP_URL, SemanticAttributes.HTTP_URL.key());
        tagMap.put(Tag.MESSAGE_BUS_DESTINATION, "message_bus.destination");
    }
}

