/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.opentelemetry;

import io.grpc.Context;
import io.opentelemetry.OpenTelemetry;
import io.opentelemetry.context.propagation.HttpTextFormat;
import io.opentelemetry.correlationcontext.CorrelationContext;
import io.opentelemetry.correlationcontext.CorrelationsContextUtils;
import io.opentelemetry.trace.DefaultTracer;
import io.opentelemetry.trace.Span;
import io.opentelemetry.trace.SpanContext;
import io.opentelemetry.trace.TracingContextUtils;
import java.util.Set;
import org.apache.camel.Exchange;
import org.apache.camel.api.management.ManagedResource;
import org.apache.camel.opentelemetry.OpenTelemetrySpanAdapter;
import org.apache.camel.opentelemetry.propagators.OpenTelemetryGetter;
import org.apache.camel.opentelemetry.propagators.OpenTelemetrySetter;
import org.apache.camel.tracing.ExtractAdapter;
import org.apache.camel.tracing.InjectAdapter;
import org.apache.camel.tracing.SpanAdapter;
import org.apache.camel.tracing.SpanDecorator;
import org.apache.camel.tracing.SpanKind;
import org.apache.camel.tracing.Tracer;
import org.apache.camel.tracing.decorators.AbstractInternalSpanDecorator;

@ManagedResource(description="OpenTelemetryTracer")
public class OpenTelemetryTracer
extends Tracer {
    private io.opentelemetry.trace.Tracer tracer;
    private String instrumentationName = "camel";

    public io.opentelemetry.trace.Tracer getTracer() {
        return this.tracer;
    }

    public void setTracer(io.opentelemetry.trace.Tracer tracer) {
        this.tracer = tracer;
    }

    public void setInstrumentationName(String instrumentationName) {
        this.instrumentationName = instrumentationName;
    }

    private Span.Kind mapToSpanKind(SpanKind kind) {
        switch (kind) {
            case SPAN_KIND_CLIENT: {
                return Span.Kind.CLIENT;
            }
            case SPAN_KIND_SERVER: {
                return Span.Kind.SERVER;
            }
            case CONSUMER: {
                return Span.Kind.CONSUMER;
            }
            case PRODUCER: {
                return Span.Kind.PRODUCER;
            }
        }
        return Span.Kind.SERVER;
    }

    protected void initTracer() {
        Set tracers;
        if (this.tracer == null && (tracers = this.getCamelContext().getRegistry().findByType(io.opentelemetry.trace.Tracer.class)).size() == 1) {
            this.tracer = (io.opentelemetry.trace.Tracer)tracers.iterator().next();
        }
        if (this.tracer == null) {
            this.tracer = OpenTelemetry.getTracer((String)this.instrumentationName);
        }
        if (this.tracer == null) {
            this.tracer = DefaultTracer.getInstance();
        }
    }

    protected SpanAdapter startSendingEventSpan(String operationName, SpanKind kind, SpanAdapter parent) {
        Span.Builder builder = this.tracer.spanBuilder(operationName).setSpanKind(this.mapToSpanKind(kind));
        CorrelationContext correlationContext = null;
        if (parent != null) {
            OpenTelemetrySpanAdapter oTelSpanWrapper = (OpenTelemetrySpanAdapter)parent;
            Span parentSpan = oTelSpanWrapper.getOpenTelemetrySpan();
            correlationContext = oTelSpanWrapper.getCorrelationContext();
            builder = builder.setParent(parentSpan);
        }
        return new OpenTelemetrySpanAdapter(builder.startSpan(), correlationContext);
    }

    protected SpanAdapter startExchangeBeginSpan(Exchange exchange, SpanDecorator sd, String operationName, SpanKind kind, SpanAdapter parent) {
        Span.Builder builder = this.tracer.spanBuilder(operationName);
        CorrelationContext correlationContext = null;
        if (parent != null) {
            OpenTelemetrySpanAdapter spanFromExchange = (OpenTelemetrySpanAdapter)parent;
            builder = builder.setParent(spanFromExchange.getOpenTelemetrySpan());
            correlationContext = spanFromExchange.getCorrelationContext();
        } else {
            ExtractAdapter adapter = sd.getExtractAdapter(exchange.getIn().getHeaders(), this.encoding);
            Context ctx = OpenTelemetry.getPropagators().getHttpTextFormat().extract(Context.current(), (Object)adapter, (HttpTextFormat.Getter)new OpenTelemetryGetter(adapter));
            Span span = TracingContextUtils.getSpan((Context)ctx);
            SpanContext parentFromHeaders = span.getContext();
            correlationContext = CorrelationsContextUtils.getCorrelationContext((Context)ctx);
            if (parentFromHeaders != null && parentFromHeaders.isValid()) {
                builder.setParent(parentFromHeaders).setSpanKind(this.mapToSpanKind(sd.getReceiverSpanKind()));
            } else if (!(sd instanceof AbstractInternalSpanDecorator)) {
                builder.setSpanKind(this.mapToSpanKind(sd.getReceiverSpanKind()));
            }
        }
        return new OpenTelemetrySpanAdapter(builder.startSpan(), correlationContext);
    }

    protected void finishSpan(SpanAdapter span) {
        OpenTelemetrySpanAdapter openTracingSpanWrapper = (OpenTelemetrySpanAdapter)span;
        openTracingSpanWrapper.getOpenTelemetrySpan().end();
    }

    protected void inject(SpanAdapter span, InjectAdapter adapter) {
        OpenTelemetrySpanAdapter spanFromExchange = (OpenTelemetrySpanAdapter)span;
        Context context = TracingContextUtils.withSpan((Span)spanFromExchange.getOpenTelemetrySpan(), (Context)Context.current());
        context = CorrelationsContextUtils.withCorrelationContext((CorrelationContext)spanFromExchange.getCorrelationContext(), (Context)context);
        OpenTelemetry.getPropagators().getHttpTextFormat().inject(context, (Object)adapter, (HttpTextFormat.Setter)new OpenTelemetrySetter());
    }
}

