/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.opentelemetry;

import io.opentelemetry.api.GlobalOpenTelemetry;
import io.opentelemetry.api.baggage.Baggage;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.SpanBuilder;
import io.opentelemetry.api.trace.SpanKind;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.ImplicitContextKeyed;
import io.opentelemetry.context.propagation.ContextPropagators;
import io.opentelemetry.context.propagation.TextMapGetter;
import io.opentelemetry.context.propagation.TextMapSetter;
import java.util.Set;
import org.apache.camel.Exchange;
import org.apache.camel.api.management.ManagedResource;
import org.apache.camel.opentelemetry.OpenTelemetrySpanAdapter;
import org.apache.camel.opentelemetry.propagators.OpenTelemetryGetter;
import org.apache.camel.opentelemetry.propagators.OpenTelemetrySetter;
import org.apache.camel.tracing.ExtractAdapter;
import org.apache.camel.tracing.InjectAdapter;
import org.apache.camel.tracing.SpanAdapter;
import org.apache.camel.tracing.SpanDecorator;
import org.apache.camel.tracing.Tracer;
import org.apache.camel.tracing.decorators.AbstractInternalSpanDecorator;

@ManagedResource(description="OpenTelemetryTracer")
public class OpenTelemetryTracer
extends Tracer {
    private io.opentelemetry.api.trace.Tracer tracer;
    private String instrumentationName = "camel";
    private ContextPropagators contextPropagators;

    public io.opentelemetry.api.trace.Tracer getTracer() {
        return this.tracer;
    }

    public void setTracer(io.opentelemetry.api.trace.Tracer tracer) {
        this.tracer = tracer;
    }

    public void setInstrumentationName(String instrumentationName) {
        this.instrumentationName = instrumentationName;
    }

    public ContextPropagators getContextPropagators() {
        return this.contextPropagators;
    }

    public void setContextPropagators(ContextPropagators contextPropagators) {
        this.contextPropagators = contextPropagators;
    }

    private SpanKind mapToSpanKind(org.apache.camel.tracing.SpanKind kind) {
        switch (kind) {
            case SPAN_KIND_CLIENT: {
                return SpanKind.CLIENT;
            }
            case SPAN_KIND_SERVER: {
                return SpanKind.SERVER;
            }
            case CONSUMER: {
                return SpanKind.CONSUMER;
            }
            case PRODUCER: {
                return SpanKind.PRODUCER;
            }
        }
        return SpanKind.SERVER;
    }

    protected void initTracer() {
        Set tracers;
        if (this.tracer == null && (tracers = this.getCamelContext().getRegistry().findByType(io.opentelemetry.api.trace.Tracer.class)).size() == 1) {
            this.tracer = (io.opentelemetry.api.trace.Tracer)tracers.iterator().next();
        }
        if (this.tracer == null) {
            this.tracer = GlobalOpenTelemetry.get().getTracer(this.instrumentationName);
        }
    }

    protected void initContextPropagators() {
        Set contextPropagatorsSet;
        if (this.contextPropagators == null && (contextPropagatorsSet = this.getCamelContext().getRegistry().findByType(ContextPropagators.class)).size() == 1) {
            this.contextPropagators = (ContextPropagators)contextPropagatorsSet.iterator().next();
        }
        if (this.contextPropagators == null) {
            this.contextPropagators = GlobalOpenTelemetry.get().getPropagators();
        }
    }

    protected SpanAdapter startSendingEventSpan(String operationName, org.apache.camel.tracing.SpanKind kind, SpanAdapter parent) {
        Baggage baggage = null;
        SpanBuilder builder = this.tracer.spanBuilder(operationName).setSpanKind(this.mapToSpanKind(kind));
        if (parent != null) {
            OpenTelemetrySpanAdapter oTelSpanWrapper = (OpenTelemetrySpanAdapter)parent;
            Span parentSpan = oTelSpanWrapper.getOpenTelemetrySpan();
            baggage = oTelSpanWrapper.getBaggage();
            builder = builder.setParent(Context.current().with((ImplicitContextKeyed)parentSpan));
        }
        return new OpenTelemetrySpanAdapter(builder.startSpan(), baggage);
    }

    protected SpanAdapter startExchangeBeginSpan(Exchange exchange, SpanDecorator sd, String operationName, org.apache.camel.tracing.SpanKind kind, SpanAdapter parent) {
        Baggage baggage;
        SpanBuilder builder = this.tracer.spanBuilder(operationName);
        if (parent != null) {
            OpenTelemetrySpanAdapter spanFromExchange = (OpenTelemetrySpanAdapter)parent;
            builder = builder.setParent(Context.current().with((ImplicitContextKeyed)spanFromExchange.getOpenTelemetrySpan()));
            baggage = spanFromExchange.getBaggage();
        } else {
            ExtractAdapter adapter = sd.getExtractAdapter(exchange.getIn().getHeaders(), this.encoding);
            Context ctx = this.contextPropagators.getTextMapPropagator().extract(Context.current(), (Object)adapter, (TextMapGetter)new OpenTelemetryGetter(adapter));
            Span span = Span.fromContext((Context)ctx);
            baggage = Baggage.fromContext((Context)ctx);
            if (span != null && span.getSpanContext().isValid()) {
                builder.setParent(ctx).setSpanKind(this.mapToSpanKind(sd.getReceiverSpanKind()));
            } else if (!(sd instanceof AbstractInternalSpanDecorator)) {
                builder.setSpanKind(this.mapToSpanKind(sd.getReceiverSpanKind()));
            }
        }
        return new OpenTelemetrySpanAdapter(builder.startSpan(), baggage);
    }

    protected void finishSpan(SpanAdapter span) {
        OpenTelemetrySpanAdapter openTracingSpanWrapper = (OpenTelemetrySpanAdapter)span;
        openTracingSpanWrapper.getOpenTelemetrySpan().end();
    }

    protected void inject(SpanAdapter span, InjectAdapter adapter) {
        OpenTelemetrySpanAdapter spanFromExchange = (OpenTelemetrySpanAdapter)span;
        Span otelSpan = spanFromExchange.getOpenTelemetrySpan();
        Context ctx = spanFromExchange.getBaggage() != null ? Context.current().with((ImplicitContextKeyed)otelSpan).with((ImplicitContextKeyed)spanFromExchange.getBaggage()) : Context.current().with((ImplicitContextKeyed)otelSpan);
        this.contextPropagators.getTextMapPropagator().inject(ctx, (Object)adapter, (TextMapSetter)new OpenTelemetrySetter());
    }
}

