/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.opentracing;

import io.opentracing.Span;
import org.apache.camel.Exchange;

public final class ActiveSpanManager {
    private static final String ACTIVE_SPAN_PROPERTY = "OpenTracing.activeSpan";

    private ActiveSpanManager() {
    }

    public static Span getSpan(Exchange exchange) {
        Holder holder = (Holder)exchange.getProperty(ACTIVE_SPAN_PROPERTY);
        if (holder != null) {
            return holder.getSpan();
        }
        return null;
    }

    public static void activate(Exchange exchange, Span span) {
        exchange.setProperty(ACTIVE_SPAN_PROPERTY, (Object)new Holder((Holder)exchange.getProperty(ACTIVE_SPAN_PROPERTY), span));
    }

    public static void deactivate(Exchange exchange) {
        Holder holder = (Holder)exchange.getProperty(ACTIVE_SPAN_PROPERTY);
        if (holder != null) {
            exchange.setProperty(ACTIVE_SPAN_PROPERTY, (Object)holder.getParent());
        }
    }

    public static class Holder {
        private Holder parent;
        private Span span;

        public Holder(Holder parent, Span span) {
            this.parent = parent;
            this.span = span;
        }

        public Holder getParent() {
            return this.parent;
        }

        public Span getSpan() {
            return this.span;
        }
    }
}

