/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.opentracing.decorators;

import io.opentracing.Span;
import io.opentracing.tag.Tags;
import java.util.Map;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.opentracing.decorators.AbstractSpanDecorator;

public class ElasticsearchSpanDecorator
extends AbstractSpanDecorator {
    public static final String ELASTICSEARCH_DB_TYPE = "elasticsearch";
    public static final String ELASTICSEARCH_CLUSTER_TAG = "elasticsearch.cluster";

    @Override
    public String getComponent() {
        return "elasticsearch-rest";
    }

    @Override
    public String getComponentClassName() {
        return "org.apache.camel.component.elasticsearch.ElasticsearchComponent";
    }

    @Override
    public String getOperationName(Exchange exchange, Endpoint endpoint) {
        Map<String, String> queryParameters = ElasticsearchSpanDecorator.toQueryParameters(endpoint.getEndpointUri());
        return queryParameters.containsKey("operation") ? queryParameters.get("operation") : super.getOperationName(exchange, endpoint);
    }

    @Override
    public void pre(Span span, Exchange exchange, Endpoint endpoint) {
        String cluster;
        super.pre(span, exchange, endpoint);
        span.setTag(Tags.DB_TYPE.getKey(), ELASTICSEARCH_DB_TYPE);
        Map<String, String> queryParameters = ElasticsearchSpanDecorator.toQueryParameters(endpoint.getEndpointUri());
        if (queryParameters.containsKey("indexName")) {
            span.setTag(Tags.DB_INSTANCE.getKey(), queryParameters.get("indexName"));
        }
        if ((cluster = ElasticsearchSpanDecorator.stripSchemeAndOptions(endpoint)) != null) {
            span.setTag(ELASTICSEARCH_CLUSTER_TAG, cluster);
        }
    }
}

