/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.optaplanner;

import org.apache.camel.Component;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePattern;
import org.apache.camel.component.ResourceEndpoint;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.util.ObjectHelper;
import org.optaplanner.core.api.domain.solution.Solution;
import org.optaplanner.core.api.solver.Solver;
import org.optaplanner.core.api.solver.SolverFactory;

@UriEndpoint(scheme="optaplanner", title="OptaPlanner", syntax="optaplanner:resourceUri", producerOnly=true, label="engine,planning")
public class OptaPlannerEndpoint
extends ResourceEndpoint {
    private SolverFactory solverFactory;

    public OptaPlannerEndpoint() {
    }

    public OptaPlannerEndpoint(String uri, Component component, String resourceUri) {
        super(uri, component, resourceUri);
    }

    public SolverFactory getSolverFactory() {
        return this.solverFactory;
    }

    public void setSolverFactory(SolverFactory solverFactory) {
        this.solverFactory = solverFactory;
    }

    public ExchangePattern getExchangePattern() {
        return ExchangePattern.InOut;
    }

    protected String createEndpointUri() {
        return "optaplanner:" + this.getResourceUri();
    }

    protected void onExchange(Exchange exchange) throws Exception {
        ObjectHelper.notNull((Object)this.solverFactory, (String)"solverFactory");
        Solver solver = this.solverFactory.buildSolver();
        Solution planningProblem = (Solution)exchange.getIn().getMandatoryBody(Solution.class);
        solver.solve(planningProblem);
        Solution bestSolution = solver.getBestSolution();
        exchange.getOut().setBody((Object)bestSolution);
        exchange.getOut().setHeaders(exchange.getIn().getHeaders());
        exchange.getOut().setAttachments(exchange.getIn().getAttachments());
    }
}

