/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.optaplanner;

import java.util.HashMap;
import java.util.Map;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.optaplanner.OptaPlannerConfiguration;
import org.apache.camel.component.optaplanner.OptaPlannerConsumer;
import org.apache.camel.component.optaplanner.OptaPlannerProducer;
import org.apache.camel.impl.DefaultEndpoint;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.optaplanner.core.api.solver.Solver;
import org.optaplanner.core.api.solver.SolverFactory;

@UriEndpoint(scheme="optaplanner", title="OptaPlanner", syntax="optaplanner:configFile", label="engine,planning")
public class OptaPlannerEndpoint
extends DefaultEndpoint {
    private static final Map<String, Solver> SOLVERS = new HashMap<String, Solver>();
    @UriParam
    private OptaPlannerConfiguration configuration;
    private SolverFactory solverFactory;

    public OptaPlannerEndpoint() {
    }

    public OptaPlannerEndpoint(String uri, Component component, OptaPlannerConfiguration configuration) {
        super(uri, component);
        this.configuration = configuration;
        this.solverFactory = SolverFactory.createFromXmlResource((String)configuration.getConfigFile());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Solver getOrCreateSolver(String solverId) throws Exception {
        Map<String, Solver> map = SOLVERS;
        synchronized (map) {
            Solver solver = SOLVERS.get(solverId);
            if (solver == null) {
                solver = this.createSolver();
                SOLVERS.put(solverId, solver);
            }
            return solver;
        }
    }

    protected Solver createSolver() {
        return this.solverFactory.buildSolver();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Solver getSolver(String solverId) {
        Map<String, Solver> map = SOLVERS;
        synchronized (map) {
            return SOLVERS.get(solverId);
        }
    }

    public Producer createProducer() throws Exception {
        return new OptaPlannerProducer(this, this.configuration);
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        return new OptaPlannerConsumer(this, processor, this.configuration);
    }

    public boolean isSingleton() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doStop() throws Exception {
        Map<String, Solver> map = SOLVERS;
        synchronized (map) {
            for (Solver solver : SOLVERS.values()) {
                solver.terminateEarly();
                SOLVERS.remove(solver);
            }
        }
        super.doStop();
    }
}

