/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.optaplanner;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.camel.Category;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.optaplanner.OptaPlannerConfiguration;
import org.apache.camel.component.optaplanner.OptaPlannerConsumer;
import org.apache.camel.component.optaplanner.OptaPlannerProducer;
import org.apache.camel.component.optaplanner.OptaplannerSolutionEventListener;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.support.DefaultEndpoint;
import org.optaplanner.core.api.solver.Solver;
import org.optaplanner.core.api.solver.SolverFactory;

@UriEndpoint(firstVersion="2.13.0", scheme="optaplanner", title="OptaPlanner", syntax="optaplanner:configFile", category={Category.ENGINE, Category.PLANNING})
public class OptaPlannerEndpoint
extends DefaultEndpoint {
    private static final Map<String, Solver<Object>> SOLVERS = new HashMap<String, Solver<Object>>();
    private static final Map<Long, Set<OptaplannerSolutionEventListener>> SOLUTION_LISTENER = new HashMap<Long, Set<OptaplannerSolutionEventListener>>();
    private SolverFactory<Object> solverFactory;
    @UriParam
    private OptaPlannerConfiguration configuration;

    public OptaPlannerEndpoint(String uri, Component component, OptaPlannerConfiguration configuration) {
        super(uri, component);
        this.configuration = configuration;
    }

    public OptaPlannerConfiguration getConfiguration() {
        return this.configuration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Solver<Object> getOrCreateSolver(String solverId) {
        Map<String, Solver<Object>> map = SOLVERS;
        synchronized (map) {
            Solver<Object> solver = SOLVERS.get(solverId);
            if (solver == null) {
                solver = this.createSolver();
                SOLVERS.put(solverId, solver);
            }
            return solver;
        }
    }

    protected Solver<Object> createSolver() {
        ClassLoader classLoader = this.getCamelContext().getApplicationContextClassLoader();
        this.solverFactory = SolverFactory.createFromXmlResource((String)this.configuration.getConfigFile(), (ClassLoader)classLoader);
        return this.solverFactory.buildSolver();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Solver<Object> getSolver(String solverId) {
        Map<String, Solver<Object>> map = SOLVERS;
        synchronized (map) {
            return SOLVERS.get(solverId);
        }
    }

    public Producer createProducer() {
        return new OptaPlannerProducer(this, this.configuration);
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        OptaPlannerConsumer consumer = new OptaPlannerConsumer(this, processor, this.configuration);
        this.configureConsumer((Consumer)consumer);
        return consumer;
    }

    protected void doStart() throws Exception {
        super.doStart();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doStop() throws Exception {
        Map<String, Solver<Object>> map = SOLVERS;
        synchronized (map) {
            for (Map.Entry<String, Solver<Object>> solver : SOLVERS.entrySet()) {
                solver.getValue().terminateEarly();
                SOLVERS.remove(solver.getKey());
            }
        }
        super.doStop();
    }

    protected Set<OptaplannerSolutionEventListener> getSolutionEventListeners(Long problemId) {
        return SOLUTION_LISTENER.get(problemId);
    }

    protected synchronized void addSolutionEventListener(Long problemId, OptaplannerSolutionEventListener listener) {
        Set<OptaplannerSolutionEventListener> listeners = SOLUTION_LISTENER.get(problemId);
        if (listeners == null) {
            listeners = new HashSet<OptaplannerSolutionEventListener>();
            listeners.add(listener);
            SOLUTION_LISTENER.put(problemId, listeners);
        } else {
            listeners.add(listener);
        }
    }

    protected synchronized void removeSolutionEventListener(Long problemId, OptaplannerSolutionEventListener listener) {
        Set<OptaplannerSolutionEventListener> listeners = SOLUTION_LISTENER.get(problemId);
        listeners.remove(listener);
        if (listeners.isEmpty()) {
            SOLUTION_LISTENER.remove(problemId);
        }
    }
}

