/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.optaplanner;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import org.apache.camel.AsyncCallback;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.component.optaplanner.OptaPlannerConfiguration;
import org.apache.camel.component.optaplanner.OptaPlannerEndpoint;
import org.apache.camel.component.optaplanner.OptaplannerEventSupport;
import org.apache.camel.support.DefaultAsyncProducer;
import org.optaplanner.core.api.solver.SolverFactory;
import org.optaplanner.core.api.solver.SolverJob;
import org.optaplanner.core.api.solver.SolverManager;
import org.optaplanner.core.api.solver.change.ProblemChange;
import org.optaplanner.core.config.solver.SolverConfig;
import org.optaplanner.core.config.solver.SolverManagerConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OptaPlannerProducer
extends DefaultAsyncProducer {
    private static final transient Logger LOGGER = LoggerFactory.getLogger(OptaPlannerProducer.class);
    private ExecutorService executor;
    private final OptaPlannerEndpoint endpoint;
    private final OptaPlannerConfiguration configuration;

    public OptaPlannerProducer(OptaPlannerEndpoint endpoint, OptaPlannerConfiguration configuration) {
        super((Endpoint)endpoint);
        this.endpoint = endpoint;
        this.configuration = configuration;
    }

    protected void doStart() throws Exception {
        if (this.configuration.isAsync()) {
            this.executor = this.endpoint.getCamelContext().getExecutorServiceManager().newFixedThreadPool((Object)this, this.endpoint.getEndpointUri(), this.configuration.getThreadPoolSize());
        }
        super.doStart();
    }

    protected void doStop() throws Exception {
        if (this.executor != null) {
            this.endpoint.getCamelContext().getExecutorServiceManager().shutdown(this.executor);
            this.executor = null;
        }
        super.doStop();
    }

    public boolean process(Exchange exchange, AsyncCallback callback) {
        try {
            Object body = exchange.getIn().getMandatoryBody();
            SolverManager<?, Long> solverManager = this.getSolverManager(exchange);
            Long problemId = this.endpoint.getConfiguration().getProblemId();
            LOGGER.debug("Asynchronously solving problem: [{}] with id [{}]", body, (Object)problemId);
            if (body instanceof ProblemChange) {
                solverManager.addProblemChange((Object)problemId, (ProblemChange)body);
            } else {
                if (this.isAsync(exchange)) {
                    this.executor.submit(() -> {
                        try {
                            OptaplannerEventSupport eventSupport = new OptaplannerEventSupport(this.endpoint, problemId);
                            SolverJob solverJob = solverManager.solveAndListen((Object)problemId, t -> body, eventSupport::updateBestSolution);
                            this.populateResult(exchange, solverJob);
                        }
                        catch (InterruptedException e) {
                            Thread.currentThread().interrupt();
                            exchange.setException((Throwable)e);
                        }
                        catch (Exception e) {
                            exchange.setException((Throwable)e);
                        }
                        finally {
                            callback.done(false);
                        }
                    });
                    return false;
                }
                SolverJob solverJob = solverManager.solve((Object)problemId, body);
                this.populateResult(exchange, solverJob);
            }
            callback.done(true);
            return true;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            exchange.setException((Throwable)e);
        }
        catch (Exception e) {
            exchange.setException((Throwable)e);
        }
        callback.done(true);
        return true;
    }

    private void populateResult(Exchange exchange, SolverJob<?, ?> solverJob) throws InterruptedException, ExecutionException {
        exchange.getIn().setBody(solverJob.getFinalBestSolution());
        exchange.getIn().setHeader("CamelOptaPlannerIsSolving", (Object)false);
    }

    private boolean isAsync(Exchange exchange) {
        Boolean isAsync = (Boolean)exchange.getIn().getHeader("CamelOptaPlannerIsAsync", Boolean.class);
        return isAsync != null ? isAsync.booleanValue() : this.configuration.isAsync();
    }

    private SolverManager<?, Long> getSolverManager(Exchange exchange) {
        if (this.configuration.getSolverManager() != null) {
            return this.configuration.getSolverManager();
        }
        SolverManager solverManager = (SolverManager)exchange.getIn().getHeader("CamelOptaPlannerSolverManager", SolverManager.class);
        if (solverManager == null) {
            if (this.configuration.getConfigFile() == null) {
                return null;
            }
            SolverConfig solverConfig = SolverConfig.createFromXmlResource((String)this.configuration.getConfigFile());
            SolverFactory solverFactory = SolverFactory.create((SolverConfig)solverConfig);
            solverManager = SolverManager.create((SolverFactory)solverFactory, (SolverManagerConfig)new SolverManagerConfig());
        }
        return solverManager;
    }
}

