/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.maven.packaging;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.apache.camel.maven.packaging.PackageHelper;
import org.apache.commons.io.FileUtils;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.sonatype.plexus.build.incremental.BuildContext;

public class PackageModelMojo
extends AbstractMojo {
    protected MavenProject project;
    protected File buildDir;
    protected File outDir;
    private MavenProjectHelper projectHelper;
    private BuildContext buildContext;

    public void execute() throws MojoExecutionException, MojoFailureException {
        PackageModelMojo.prepareModel(this.getLog(), this.project, this.projectHelper, this.outDir, this.buildDir, this.buildContext);
    }

    public static void prepareModel(Log log, MavenProject project, MavenProjectHelper projectHelper, File modelOutDir, File buildDir, BuildContext buildContext) throws MojoExecutionException {
        File camelMetaDir = new File(modelOutDir, "META-INF/services/org/apache/camel/");
        camelMetaDir.mkdirs();
        TreeSet<File> jsonFiles = new TreeSet<File>();
        if (buildDir != null && buildDir.isDirectory()) {
            File target = new File(buildDir, "classes/org/apache/camel/model");
            PackageHelper.findJsonFiles(target, jsonFiles, new PackageHelper.CamelComponentsModelFilter());
        }
        ArrayList<String> models = new ArrayList<String>();
        for (File file : jsonFiles) {
            String name = file.getName();
            if (!name.endsWith(".json")) continue;
            String modelName = name.substring(0, name.length() - 5);
            models.add(modelName);
        }
        Collections.sort(models);
        File outFile = new File(camelMetaDir, "model.properties");
        if (outFile.exists()) {
            try {
                List existing = FileUtils.readLines((File)outFile);
                existing = existing.stream().filter(l -> !l.startsWith("#")).collect(Collectors.toList());
                if (models.containsAll(existing)) {
                    log.debug((CharSequence)"No model changes detected");
                    return;
                }
            }
            catch (IOException existing) {
                // empty catch block
            }
        }
        try {
            OutputStream os = buildContext.newFileOutputStream(outFile);
            FileOutputStream fos = new FileOutputStream(outFile, false);
            fos.write("#Generated by camel-package-maven-plugin\n".getBytes());
            for (String name : models) {
                fos.write(name.getBytes());
                fos.write("\n".getBytes());
            }
            fos.close();
            os.close();
            log.info((CharSequence)("Generated " + outFile + " containing " + models.size() + " Camel models"));
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to write properties to " + outFile + ". Reason: " + e, (Exception)e);
        }
    }
}

