/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.maven.packaging;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.camel.maven.packaging.CollectionStringBuffer;
import org.json.simple.JsonObject;
import org.json.simple.Jsoner;

public final class JSonSchemaHelper {
    private JSonSchemaHelper() {
    }

    public static List<Map<String, String>> parseJsonSchema(String group, String json, boolean parseProperties) {
        ArrayList<Map<String, String>> answer = new ArrayList<Map<String, String>>();
        if (json == null) {
            return answer;
        }
        try {
            JsonObject output = (JsonObject)Jsoner.deserialize((String)json);
            for (String key : output.keySet()) {
                Map row = output.getMap(key);
                if (!key.equals(group)) continue;
                if (parseProperties) {
                    Iterator iterator = row.entrySet().iterator();
                    while (iterator.hasNext()) {
                        Map.Entry obj;
                        Map.Entry entry = obj = iterator.next();
                        LinkedHashMap<String, String> newRow = new LinkedHashMap<String, String>();
                        newRow.put("name", entry.getKey().toString());
                        Map<String, String> newData = JSonSchemaHelper.transformMap((Map)entry.getValue());
                        newRow.putAll(newData);
                        answer.add(newRow);
                    }
                    continue;
                }
                Map<String, String> newData = JSonSchemaHelper.transformMap(row);
                Iterator<Map.Entry<String, String>> iterator = newData.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry<String, String> obj;
                    Map.Entry<String, String> entry = obj = iterator.next();
                    LinkedHashMap<String, String> newRow = new LinkedHashMap<String, String>();
                    newRow.put(entry.getKey().toString(), entry.getValue().toString());
                    answer.add(newRow);
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot parse json", e);
        }
        return answer;
    }

    private static Map<String, String> transformMap(Map jsonMap) {
        LinkedHashMap<String, String> answer = new LinkedHashMap<String, String>();
        for (Map.Entry rowObj : jsonMap.entrySet()) {
            Map.Entry rowEntry = rowObj;
            Object newValue = rowEntry.getValue();
            if (newValue instanceof List) {
                List list = (List)newValue;
                CollectionStringBuffer csb = new CollectionStringBuffer(",");
                for (Object line : list) {
                    csb.append(line);
                }
                newValue = csb.toString();
            }
            String value = JSonSchemaHelper.escapeJson(newValue.toString());
            answer.put(rowEntry.getKey().toString(), value);
        }
        return answer;
    }

    private static String escapeJson(String value) {
        return value.replaceAll("\\\\r", "\\\\\\r").replaceAll("\\\\n", "\\\\\\n").replaceAll("\\\\t", "\\\\\\t");
    }

    public static String getSafeValue(String key, List<Map<String, String>> rows) {
        for (Map<String, String> row : rows) {
            String value = row.get(key);
            if (value == null) continue;
            return value;
        }
        return "";
    }

    public static String getSafeValue(String key, Map<String, String> rows) {
        String value = rows.get(key);
        if (value != null) {
            return value;
        }
        return "";
    }

    public static String getPropertyDefaultValue(List<Map<String, String>> rows, String name) {
        for (Map<String, String> row : rows) {
            String defaultValue = null;
            boolean found = false;
            if (row.containsKey("name")) {
                found = name.equals(row.get("name"));
            }
            if (row.containsKey("defaultValue")) {
                defaultValue = row.get("defaultValue");
            }
            if (!found) continue;
            return defaultValue;
        }
        return null;
    }

    public static String getPropertyJavaType(List<Map<String, String>> rows, String name) {
        for (Map<String, String> row : rows) {
            String javaType = null;
            boolean found = false;
            if (row.containsKey("name")) {
                found = name.equals(row.get("name"));
            }
            if (row.containsKey("javaType")) {
                javaType = row.get("javaType");
            }
            if (!found) continue;
            return javaType;
        }
        return null;
    }

    public static String getPropertyType(List<Map<String, String>> rows, String name) {
        for (Map<String, String> row : rows) {
            String type = null;
            boolean found = false;
            if (row.containsKey("name")) {
                found = name.equals(row.get("name"));
            }
            if (row.containsKey("type")) {
                type = row.get("type");
            }
            if (!found) continue;
            return type;
        }
        return null;
    }
}

