/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.maven.packaging;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOError;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Generated;
import org.apache.camel.maven.packaging.AbstractGeneratorMojo;
import org.apache.camel.maven.packaging.DynamicClassLoader;
import org.apache.camel.maven.packaging.JSonSchemaHelper;
import org.apache.camel.maven.packaging.PackageHelper;
import org.apache.camel.maven.packaging.StringHelper;
import org.apache.camel.maven.packaging.generics.GenericsUtil;
import org.apache.camel.maven.packaging.model.ComponentModel;
import org.apache.camel.maven.packaging.model.ComponentOptionModel;
import org.apache.camel.maven.packaging.model.EndpointOptionModel;
import org.apache.camel.maven.packaging.srcgen.GenericType;
import org.apache.camel.maven.packaging.srcgen.JavaClass;
import org.apache.camel.maven.packaging.srcgen.Method;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriParams;
import org.apache.camel.spi.UriPath;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.jboss.forge.roaster.model.util.Strings;

@Mojo(name="generate-endpoint-dsl", threadSafe=true, requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME, defaultPhase=LifecyclePhase.PROCESS_CLASSES)
public class EndpointDslMojo
extends AbstractMojo {
    private static final Map<String, Class<?>> PRIMITIVEMAP = new HashMap();
    @Parameter(property="project", required=true, readonly=true)
    protected MavenProject project;
    @Parameter(defaultValue="${project.build.directory}")
    protected File buildDir;
    @Parameter(defaultValue="${basedir}")
    protected File baseDir;
    @Parameter
    protected File outputDir;
    @Parameter
    protected String packageName = "org.apache.camel.builder.endpoint.dsl";
    DynamicClassLoader projectClassLoader;

    public void execute() throws MojoExecutionException, MojoFailureException {
        try {
            this.projectClassLoader = DynamicClassLoader.createDynamicClassLoader(this.project.getTestClasspathElements());
        }
        catch (DependencyResolutionRequiredException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        if (this.outputDir == null) {
            this.outputDir = PackageHelper.findCamelDirectory(this.baseDir, "core/camel-endpointdsl/src/main/java");
        }
        Map<File, Supplier<String>> files = PackageHelper.findJsonFiles(this.buildDir, p -> p.isDirectory() || p.getName().endsWith(".json")).stream().collect(Collectors.toMap(Function.identity(), s -> EndpointDslMojo.cache(() -> EndpointDslMojo.loadJson(s))));
        this.executeComponent(files);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String loadJson(File file) {
        try (FileInputStream is = new FileInputStream(file);){
            String string = PackageHelper.loadText(is);
            return string;
        }
        catch (IOException e) {
            throw new IOError(e);
        }
    }

    private static <T> Supplier<T> cache(final Supplier<T> supplier) {
        return new Supplier<T>(){
            T value;

            @Override
            public T get() {
                if (this.value == null) {
                    this.value = supplier.get();
                }
                return this.value;
            }
        };
    }

    private void executeComponent(Map<File, Supplier<String>> jsonFiles) throws MojoExecutionException, MojoFailureException {
        TreeSet<String> componentNames = new TreeSet<String>();
        this.findComponentNames(this.buildDir, componentNames);
        if (!componentNames.isEmpty()) {
            this.getLog().debug((CharSequence)("Found " + componentNames.size() + " components"));
            LinkedList<ComponentModel> allModels = new LinkedList<ComponentModel>();
            for (String componentName : componentNames) {
                String json = EndpointDslMojo.loadComponentJson(jsonFiles, componentName);
                if (json == null) continue;
                ComponentModel model = EndpointDslMojo.generateComponentModel(componentName, json);
                allModels.add(model);
            }
            Map<String, List<ComponentModel>> grModels = allModels.stream().collect(Collectors.groupingBy(ComponentModel::getJavaType));
            for (String componentClass : grModels.keySet()) {
                List<ComponentModel> compModels = grModels.get(componentClass);
                ComponentModel model = compModels.get(0);
                List aliases = compModels.stream().map(ComponentModel::getScheme).sorted().collect(Collectors.toList());
                String overrideComponentName = null;
                if (aliases.size() > 1) {
                    overrideComponentName = model.getArtifactId().replace("camel-", "");
                }
                this.createEndpointDsl(this.packageName, model, compModels, overrideComponentName);
            }
        }
    }

    private void createEndpointDsl(String packageName, ComponentModel model, List<ComponentModel> aliases, String overrideComponentName) throws MojoFailureException {
        String desc;
        Object method;
        String componentClassName = model.getJavaType();
        String builderName = this.getEndpointName(componentClassName);
        Class<?> realComponentClass = this.loadClass(componentClassName);
        Class<?> realEndpointClass = this.loadClass(this.findEndpointClassName(componentClassName));
        JavaClass javaClass = new JavaClass(this.getProjectClassLoader());
        javaClass.setPackage(packageName);
        javaClass.setName(builderName + "Factory");
        javaClass.setClass(false);
        javaClass.addImport("org.apache.camel.builder.EndpointConsumerBuilder");
        javaClass.addImport("org.apache.camel.builder.EndpointProducerBuilder");
        javaClass.addImport("org.apache.camel.builder.endpoint.AbstractEndpointBuilder");
        HashMap<String, JavaClass> enumClasses = new HashMap<String, JavaClass>();
        boolean advanced = false;
        for (EndpointOptionModel option : model.getEndpointOptions()) {
            if (!option.getLabel().contains("advanced")) continue;
            advanced = true;
        }
        JavaClass consumerClass = null;
        JavaClass advancedConsumerClass = null;
        JavaClass producerClass = null;
        JavaClass advancedProducerClass = null;
        if (!realEndpointClass.getAnnotation(UriEndpoint.class).producerOnly() && !realEndpointClass.getAnnotation(UriEndpoint.class).consumerOnly()) {
            String consumerName = builderName.replace("Endpoint", "EndpointConsumer");
            consumerClass = javaClass.addNestedType().setPublic().setClass(false);
            consumerClass.setName(consumerName);
            consumerClass.implementInterface("EndpointConsumerBuilder");
            this.generateDummyClass(consumerClass.getCanonicalName());
            consumerClass.getJavaDoc().setText("Builder for endpoint consumers for the " + model.getTitle() + " component.");
            if (advanced) {
                advancedConsumerClass = javaClass.addNestedType().setPublic().setClass(false);
                advancedConsumerClass.setName("Advanced" + consumerName);
                advancedConsumerClass.implementInterface("EndpointConsumerBuilder");
                this.generateDummyClass(advancedConsumerClass.getCanonicalName());
                advancedConsumerClass.getJavaDoc().setText("Advanced builder for endpoint consumers for the " + model.getTitle() + " component.");
                consumerClass.addMethod().setName("advanced").setReturnType(this.loadClass(advancedConsumerClass.getCanonicalName())).setDefault().setBody("return (Advanced" + consumerName + ") this;");
                advancedConsumerClass.addMethod().setName("basic").setReturnType(this.loadClass(consumerClass.getCanonicalName())).setDefault().setBody("return (" + consumerName + ") this;");
            }
            String producerName = builderName.replace("Endpoint", "EndpointProducer");
            producerClass = javaClass.addNestedType().setPublic().setClass(false);
            producerClass.setName(producerName);
            producerClass.implementInterface("EndpointProducerBuilder");
            this.generateDummyClass(producerClass.getCanonicalName());
            producerClass.getJavaDoc().setText("Builder for endpoint producers for the " + model.getTitle() + " component.");
            if (advanced) {
                advancedProducerClass = javaClass.addNestedType().setPublic().setClass(false);
                advancedProducerClass.setName("Advanced" + producerName);
                advancedProducerClass.implementInterface("EndpointProducerBuilder");
                this.generateDummyClass(advancedProducerClass.getCanonicalName());
                advancedProducerClass.getJavaDoc().setText("Advanced builder for endpoint producers for the " + model.getTitle() + " component.");
                producerClass.addMethod().setName("advanced").setReturnType(this.loadClass(advancedProducerClass.getCanonicalName())).setDefault().setBody("return (Advanced" + producerName + ") this;");
                advancedProducerClass.addMethod().setName("basic").setReturnType(this.loadClass(producerClass.getCanonicalName())).setDefault().setBody("return (" + producerName + ") this;");
            }
        }
        JavaClass advancedBuilderClass = null;
        JavaClass builderClass = javaClass.addNestedType().setPublic().setClass(false);
        builderClass.setName(builderName);
        if (realEndpointClass.getAnnotation(UriEndpoint.class).producerOnly()) {
            builderClass.implementInterface("EndpointProducerBuilder");
        } else if (realEndpointClass.getAnnotation(UriEndpoint.class).consumerOnly()) {
            builderClass.implementInterface("EndpointConsumerBuilder");
        } else {
            builderClass.implementInterface(consumerClass.getName());
            builderClass.implementInterface(producerClass.getName());
        }
        this.generateDummyClass(builderClass.getCanonicalName());
        builderClass.getJavaDoc().setText("Builder for endpoint for the " + model.getTitle() + " component.");
        if (advanced) {
            advancedBuilderClass = javaClass.addNestedType().setPublic().setClass(false);
            advancedBuilderClass.setName("Advanced" + builderName);
            if (realEndpointClass.getAnnotation(UriEndpoint.class).producerOnly()) {
                advancedBuilderClass.implementInterface("EndpointProducerBuilder");
            } else if (realEndpointClass.getAnnotation(UriEndpoint.class).consumerOnly()) {
                advancedBuilderClass.implementInterface("EndpointConsumerBuilder");
            } else {
                advancedBuilderClass.implementInterface(advancedConsumerClass.getName());
                advancedBuilderClass.implementInterface(advancedProducerClass.getName());
            }
            this.generateDummyClass(advancedBuilderClass.getCanonicalName());
            advancedBuilderClass.getJavaDoc().setText("Advanced builder for endpoint for the " + model.getTitle() + " component.");
            builderClass.addMethod().setName("advanced").setReturnType(this.loadClass(advancedBuilderClass.getCanonicalName())).setDefault().setBody("return (Advanced" + builderName + ") this;");
            advancedBuilderClass.addMethod().setName("basic").setReturnType(this.loadClass(builderClass.getCanonicalName())).setDefault().setBody("return (" + builderName + ") this;");
        }
        this.generateDummyClass(packageName + ".T");
        String doc = "Generated by camel-package-maven-plugin - do not edit this file!";
        if (!Strings.isBlank((String)model.getDescription())) {
            doc = model.getDescription() + "\n\n" + doc;
        }
        javaClass.getJavaDoc().setText(doc);
        javaClass.addAnnotation(Generated.class.getName()).setStringValue("value", EndpointDslMojo.class.getName());
        for (EndpointOptionModel option : model.getEndpointOptions()) {
            GenericType gtype;
            GenericType ogtype;
            if ("path".equals(option.getKind())) continue;
            ArrayList<JavaClass> targets = new ArrayList<JavaClass>();
            if (option.getLabel() != null) {
                if (option.getLabel().contains("producer")) {
                    if (option.getLabel().contains("advanced")) {
                        targets.add(advancedProducerClass);
                    } else {
                        targets.add(producerClass);
                    }
                } else if (option.getLabel().contains("consumer")) {
                    if (option.getLabel().contains("advanced")) {
                        targets.add(advancedConsumerClass);
                    } else {
                        targets.add(consumerClass);
                    }
                } else if (option.getLabel().contains("advanced")) {
                    targets.add(advancedConsumerClass);
                    targets.add(advancedProducerClass);
                    targets.add(advancedBuilderClass);
                } else {
                    targets.add(consumerClass);
                    targets.add(producerClass);
                    targets.add(builderClass);
                }
            }
            try {
                Field field = this.findField(realComponentClass, realEndpointClass, option);
                ogtype = new GenericType(GenericsUtil.resolveType(realEndpointClass, field));
                gtype = this.getType(javaClass, enumClasses, option.getEnums(), ogtype.toString());
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            for (JavaClass target : targets) {
                String desc2;
                if (target == null) continue;
                Method fluent = target.addMethod().setDefault().setName(option.getName()).setReturnType(new GenericType(this.loadClass(target.getCanonicalName()))).addParameter(EndpointDslMojo.isPrimitive(ogtype.toString()) ? ogtype : gtype, option.getName()).setBody("doSetProperty(\"" + option.getName() + "\", " + option.getName() + ");\nreturn this;\n");
                if ("true".equals(option.getDeprecated())) {
                    fluent.addAnnotation(Deprecated.class);
                }
                if (!Strings.isBlank((String)option.getDescription())) {
                    desc2 = option.getDescription();
                    if (!desc2.endsWith(".")) {
                        desc2 = desc2 + ".";
                    }
                    desc2 = desc2 + "\n";
                    desc2 = desc2 + "\nThe option is a: <code>" + ogtype.toString().replaceAll("<", "&lt;").replaceAll(">", "&gt;") + "</code> type.";
                    desc2 = desc2 + "\n";
                    if ("parameter".equals(option.getKind()) && "true".equals(option.getRequired())) {
                        desc2 = desc2 + "\nRequired: true";
                    }
                    desc2 = desc2 + "\nGroup: " + option.getGroup();
                    fluent.getJavaDoc().setFullText(desc2);
                }
                if (ogtype.getRawClass() == String.class) continue;
                fluent = target.addMethod().setDefault().setName(option.getName()).setReturnType(new GenericType(this.loadClass(target.getCanonicalName()))).addParameter(new GenericType((Type)((Object)String.class)), option.getName()).setBody("doSetProperty(\"" + option.getName() + "\", " + option.getName() + ");\nreturn this;\n");
                if ("true".equals(option.getDeprecated())) {
                    fluent.addAnnotation(Deprecated.class);
                }
                if (Strings.isBlank((String)option.getDescription())) continue;
                desc2 = option.getDescription();
                if (!desc2.endsWith(".")) {
                    desc2 = desc2 + ".";
                }
                desc2 = desc2 + "\n";
                desc2 = desc2 + "\nThe option will be converted to a <code>" + ogtype.toString().replaceAll("<", "&lt;").replaceAll(">", "&gt;") + "</code> type.";
                desc2 = desc2 + "\n";
                if ("parameter".equals(option.getKind()) && "true".equals(option.getRequired())) {
                    desc2 = desc2 + "\nRequired: true";
                }
                desc2 = desc2 + "\nGroup: " + option.getGroup();
                fluent.getJavaDoc().setFullText(desc2);
            }
        }
        javaClass.removeImport("T");
        if (aliases.size() == 1) {
            method = javaClass.addMethod().setDefault().setName(EndpointDslMojo.camelCaseLower(model.getScheme())).addParameter(String.class, "path").setReturnType(new GenericType(this.loadClass(builderClass.getCanonicalName()))).setBody("class " + builderName + "Impl extends AbstractEndpointBuilder implements " + builderName + ", Advanced" + builderName + " {\n    public " + builderName + "Impl(String path) {\n        super(\"" + model.getScheme() + "\", path);\n    }\n}\nreturn new " + builderName + "Impl(path);\n");
            if ("true".equals(model.getDeprecated())) {
                ((Method)method).addAnnotation(Deprecated.class);
            }
            desc = this.getMainDescription(model);
            ((Method)method).getJavaDoc().setText(desc);
        } else {
            for (ComponentModel componentModel : aliases) {
                Method method2 = javaClass.addMethod().setDefault().setName(EndpointDslMojo.camelCaseLower(componentModel.getScheme())).addParameter(String.class, "path").setReturnType(new GenericType(this.loadClass(builderClass.getCanonicalName()))).setBody("return " + EndpointDslMojo.camelCaseLower(model.getScheme()) + "(\"" + componentModel.getScheme() + "\", path);\n");
                if ("true".equals(model.getDeprecated())) {
                    method2.addAnnotation(Deprecated.class);
                }
                String desc3 = this.getMainDescription(componentModel);
                method2.getJavaDoc().setText(desc3);
            }
            method = javaClass.addMethod().setDefault().setName(EndpointDslMojo.camelCaseLower(model.getScheme())).addParameter(String.class, "scheme").addParameter(String.class, "path").setReturnType(new GenericType(this.loadClass(builderClass.getCanonicalName()))).setBody("class " + builderName + "Impl extends AbstractEndpointBuilder implements " + builderName + ", Advanced" + builderName + " {\n    public " + builderName + "Impl(String scheme, String path) {\n        super(scheme, path);\n    }\n}\nreturn new " + builderName + "Impl(scheme, path);\n");
            if ("true".equals(model.getDeprecated())) {
                ((Method)method).addAnnotation(Deprecated.class);
            }
            desc = model.getTitle() + " (" + model.getArtifactId() + ")";
            desc = desc + "\n" + model.getDescription();
            desc = desc + "\n";
            desc = desc + "\nCategory: " + model.getLabel();
            desc = desc + "\nAvailable as of version: " + model.getFirstVersionShort();
            desc = desc + "\nMaven coordinates: " + this.project.getGroupId() + ":" + this.project.getArtifactId();
            ((Method)method).getJavaDoc().setText(desc);
        }
        String fileName = packageName.replaceAll("\\.", "\\/") + "/" + builderName + "Factory.java";
        this.writeSourceIfChanged(javaClass, fileName, false);
    }

    private static String camelCaseLower(String s) {
        int i;
        while (s != null && (i = s.indexOf(45)) > 0) {
            s = s.substring(0, i) + s.substring(i + 1, i + 2).toUpperCase() + s.substring(i + 2);
        }
        while (s != null && (i = s.indexOf(43)) > 0) {
            s = s.substring(0, i) + s.substring(i + 1, i + 2).toUpperCase() + s.substring(i + 2);
        }
        if (s != null) {
            switch (s = s.substring(0, 1).toLowerCase() + s.substring(1)) {
                case "class": {
                    s = "clas";
                    break;
                }
                case "package": {
                    s = "packag";
                    break;
                }
                case "rest": {
                    s = "restEndpoint";
                    break;
                }
            }
        }
        return s;
    }

    private String getMainDescription(ComponentModel model) {
        String desc = model.getTitle() + " (" + model.getArtifactId() + ")";
        desc = desc + "\n" + model.getDescription();
        desc = desc + "\n";
        desc = desc + "\nCategory: " + model.getLabel();
        desc = desc + "\nAvailable as of version: " + model.getFirstVersionShort();
        desc = desc + "\nMaven coordinates: " + this.project.getGroupId() + ":" + this.project.getArtifactId();
        desc = desc + "\n";
        desc = desc + "\nSyntax: <code>" + model.getSyntax() + "</code>";
        for (EndpointOptionModel option : model.getEndpointOptions()) {
            if (!"path".equals(option.getKind())) continue;
            desc = desc + "\n";
            desc = desc + "\nPath parameter: " + option.getName();
            if ("true".equals(option.getRequired())) {
                desc = desc + " (required)";
            }
            if ("true".equals(option.getDeprecated())) {
                desc = desc + " <strong>deprecated</strong>";
            }
            desc = desc + "\n" + option.getDescription();
            if (!StringHelper.isEmpty(option.getDefaultValue())) {
                desc = desc + "\nDefault value: " + option.getDefaultValue();
            }
            if (StringHelper.isEmpty(option.getEnumValues())) continue;
            desc = desc + "\nThe value can be one of: " + this.wrapEnumValues(option.getEnumValues(), 120);
        }
        return desc;
    }

    private String wrapEnumValues(String enumValues, int watermark) {
        String text = enumValues.replace(',', ' ');
        String wrapped = StringHelper.wrapWords(text, "\n", watermark, true);
        wrapped = wrapped.replaceAll("\\s", ", ");
        return wrapped;
    }

    private String getMethodName(String type) {
        String builderName = this.getEndpointName(type);
        String methodName = builderName.replace("EndpointBuilder", "");
        methodName = methodName.substring(0, 1).toLowerCase() + methodName.substring(1);
        switch (type) {
            case "org.apache.camel.component.rest.RestComponent": {
                return "restEndpoint";
            }
            case "org.apache.camel.component.beanclass.ClassComponent": {
                return "classEndpoint";
            }
        }
        return methodName;
    }

    private String getEndpointName(String type) {
        int pos = type.lastIndexOf(".");
        String name = type.substring(pos + 1).replace("Component", "EndpointBuilder");
        switch (type) {
            case "org.apache.camel.component.atmosphere.websocket.WebsocketComponent": {
                return "AtmosphereWebsocketEndpointBuilder";
            }
            case "org.apache.camel.component.zookeepermaster.MasterComponent": {
                return "ZooKeeperMasterEndpointBuilder";
            }
        }
        return name;
    }

    private String findEndpointClassName(String type) {
        String endpointName = type.replaceFirst("Component", "Endpoint");
        switch (type) {
            case "org.apache.camel.component.disruptor.vm.DisruptorVmComponent": {
                return "org.apache.camel.component.disruptor.DisruptorEndpoint";
            }
            case "org.apache.camel.component.etcd.EtcdComponent": {
                return "org.apache.camel.component.etcd.AbstractEtcdPollingEndpoint";
            }
            case "org.apache.camel.websocket.jsr356.JSR356WebSocketComponent": {
                return "org.apache.camel.websocket.jsr356.JSR356Endpoint";
            }
        }
        return endpointName;
    }

    private Field findField(Class<?> realComponentClass, Class<?> realEndpointClass, EndpointOptionModel option) throws NoSuchFieldException {
        Field field = null;
        ArrayList classes = new ArrayList();
        classes.add(realComponentClass);
        classes.add(realEndpointClass);
        while (!classes.isEmpty()) {
            Class cl = (Class)classes.remove(0);
            for (Field f : cl.getDeclaredFields()) {
                UriParam param;
                String n = f.getName();
                UriPath path = f.getAnnotation(UriPath.class);
                if (path != null && !Strings.isBlank((String)path.name())) {
                    n = path.name();
                }
                if ((param = f.getAnnotation(UriParam.class)) != null && !Strings.isBlank((String)param.name())) {
                    n = param.name();
                }
                if (n.equals(option.getName())) {
                    field = f;
                    break;
                }
                if (!f.getType().isAnnotationPresent(UriParams.class)) continue;
                classes.add(f.getType());
            }
            if (field != null) break;
            if ((cl = cl.getSuperclass()) == null) continue;
            classes.add(cl);
        }
        if (field == null) {
            throw new NoSuchFieldException("Could not find field for option " + option.getName());
        }
        return field;
    }

    static boolean isPrimitive(String type) {
        return PRIMITIVEMAP.containsKey(type);
    }

    private Class<?> loadClass(String loadClassName) {
        Class<?> optionClass;
        String org = loadClassName;
        while (true) {
            try {
                optionClass = this.getProjectClassLoader().loadClass(loadClassName);
            }
            catch (ClassNotFoundException e) {
                int dotIndex = loadClassName.lastIndexOf(46);
                if (dotIndex == -1) {
                    throw new IllegalArgumentException(org);
                }
                loadClassName = loadClassName.substring(0, dotIndex) + "$" + loadClassName.substring(dotIndex + 1);
                continue;
            }
            break;
        }
        return optionClass;
    }

    private GenericType getType(JavaClass javaClass, Map<String, JavaClass> enumClasses, String enums, String type) {
        if ((type = type.trim()).endsWith("[]")) {
            GenericType t = this.getType(javaClass, enumClasses, enums, type.substring(0, type.length() - 2));
            return new GenericType(Array.newInstance(t.getRawClass(), 0).getClass(), t);
        }
        int genericIndex = type.indexOf(60);
        if (genericIndex > 0) {
            if (!type.endsWith(">")) {
                throw new IllegalArgumentException("Can not load type: " + type);
            }
            GenericType base = this.getType(javaClass, enumClasses, enums, type.substring(0, genericIndex));
            if (base.getRawClass() == Object.class) {
                return base;
            }
            String[] params = this.splitParams(type.substring(genericIndex + 1, type.length() - 1));
            GenericType[] types = new GenericType[params.length];
            for (int i = 0; i < params.length; ++i) {
                types[i] = this.getType(javaClass, enumClasses, enums, params[i]);
            }
            return new GenericType(base.getRawClass(), types);
        }
        if (EndpointDslMojo.isPrimitive(type)) {
            return new GenericType(PRIMITIVEMAP.get(type));
        }
        if (type.startsWith("? extends ")) {
            String raw = type.substring("? extends ".length());
            return new GenericType(this.loadClass(raw), GenericType.BoundType.Extends, new GenericType[0]);
        }
        if (type.startsWith("? super ")) {
            String raw = type.substring("? extends ".length());
            return new GenericType(this.loadClass(raw), GenericType.BoundType.Super, new GenericType[0]);
        }
        if (type.equals("?")) {
            return new GenericType(Object.class, GenericType.BoundType.Extends, new GenericType[0]);
        }
        if (this.loadClass(type).isEnum() && !this.isCamelCoreType(type)) {
            JavaClass enumClass;
            String enumClassName = type.substring(type.lastIndexOf(46) + 1);
            if (enumClassName.contains("$")) {
                enumClassName = enumClassName.substring(enumClassName.indexOf(36) + 1);
            }
            if ((enumClass = enumClasses.get(enumClassName)) == null) {
                enumClass = javaClass.addNestedType().setPackagePrivate().setName(enumClassName).setEnum(true);
                enumClass.getJavaDoc().setText("Proxy enum for <code>" + type + "</code> enum.");
                enumClasses.put(enumClassName, enumClass);
                for (Object value : this.loadClass(type).getEnumConstants()) {
                    enumClass.addValue(value.toString().replace('.', '_').replace('-', '_'));
                }
            }
            type = javaClass.getPackage() + "." + javaClass.getName() + "$" + enumClassName;
            return new GenericType(this.generateDummyClass(type));
        }
        if (!this.isCamelCoreType(type)) {
            this.getLog().debug((CharSequence)("Substituting java.lang.Object to " + type));
            return new GenericType((Type)((Object)Object.class));
        }
        return new GenericType(this.loadClass(type));
    }

    private String[] splitParams(String string) {
        ArrayList<String> params = new ArrayList<String>();
        int cur = 0;
        int start = 0;
        int opened = 0;
        while (true) {
            int nextComma = string.indexOf(44, cur);
            int nextOpen = string.indexOf(60, cur);
            int nextClose = string.indexOf(62, cur);
            if (nextComma < 0) {
                params.add(string.substring(start));
                return params.toArray(new String[0]);
            }
            if (!(nextOpen >= 0 && nextComma >= nextOpen || nextClose >= 0 && nextComma >= nextClose || opened != 0)) {
                params.add(string.substring(start, nextComma));
                start = cur = nextComma + 1;
                continue;
            }
            if (nextOpen < 0) {
                if (--opened < 0) {
                    throw new IllegalStateException();
                }
                cur = nextClose + 1;
                continue;
            }
            if (nextClose < 0 || nextOpen < nextClose) {
                ++opened;
                cur = nextOpen + 1;
                continue;
            }
            if (--opened < 0) {
                throw new IllegalStateException();
            }
            cur = nextClose + 1;
        }
    }

    private boolean isCamelCoreType(String type) {
        return type.startsWith("java.") || type.matches("org\\.apache\\.camel\\.(spi\\.)?([A-Za-z]+)");
    }

    private Class generateDummyClass(String clazzName) {
        return this.getProjectClassLoader().generateDummyClass(clazzName);
    }

    private DynamicClassLoader getProjectClassLoader() {
        return this.projectClassLoader;
    }

    private static String loadComponentJson(Map<File, Supplier<String>> jsonFiles, String componentName) {
        return EndpointDslMojo.loadJsonOfType(jsonFiles, componentName, "component");
    }

    private static String loadJsonOfType(Map<File, Supplier<String>> jsonFiles, String modelName, String type) {
        for (Map.Entry<File, Supplier<String>> entry : jsonFiles.entrySet()) {
            String json;
            if (!entry.getKey().getName().equals(modelName + ".json") || !(json = entry.getValue().get()).contains("\"kind\": \"" + type + "\"")) continue;
            return json;
        }
        return null;
    }

    private static ComponentModel generateComponentModel(String componentName, String json) {
        Object option;
        List<Map<String, String>> rows = JSonSchemaHelper.parseJsonSchema("component", json, false);
        ComponentModel component = new ComponentModel(true);
        component.setScheme(JSonSchemaHelper.getSafeValue("scheme", rows));
        component.setSyntax(JSonSchemaHelper.getSafeValue("syntax", rows));
        component.setAlternativeSyntax(JSonSchemaHelper.getSafeValue("alternativeSyntax", rows));
        component.setTitle(JSonSchemaHelper.getSafeValue("title", rows));
        component.setDescription(JSonSchemaHelper.getSafeValue("description", rows));
        component.setFirstVersion(JSonSchemaHelper.getSafeValue("firstVersion", rows));
        component.setLabel(JSonSchemaHelper.getSafeValue("label", rows));
        component.setDeprecated(JSonSchemaHelper.getSafeValue("deprecated", rows));
        component.setDeprecationNote(JSonSchemaHelper.getSafeValue("deprecationNote", rows));
        component.setConsumerOnly(JSonSchemaHelper.getSafeValue("consumerOnly", rows));
        component.setProducerOnly(JSonSchemaHelper.getSafeValue("producerOnly", rows));
        component.setJavaType(JSonSchemaHelper.getSafeValue("javaType", rows));
        component.setGroupId(JSonSchemaHelper.getSafeValue("groupId", rows));
        component.setArtifactId(JSonSchemaHelper.getSafeValue("artifactId", rows));
        component.setVersion(JSonSchemaHelper.getSafeValue("version", rows));
        rows = JSonSchemaHelper.parseJsonSchema("componentProperties", json, true);
        for (Map<String, String> row : rows) {
            option = new ComponentOptionModel();
            ((ComponentOptionModel)option).setName(JSonSchemaHelper.getSafeValue("name", row));
            ((ComponentOptionModel)option).setDisplayName(JSonSchemaHelper.getSafeValue("displayName", row));
            ((ComponentOptionModel)option).setKind(JSonSchemaHelper.getSafeValue("kind", row));
            ((ComponentOptionModel)option).setType(JSonSchemaHelper.getSafeValue("type", row));
            ((ComponentOptionModel)option).setJavaType(JSonSchemaHelper.getSafeValue("javaType", row));
            ((ComponentOptionModel)option).setDeprecated(JSonSchemaHelper.getSafeValue("deprecated", row));
            ((ComponentOptionModel)option).setDeprecationNote(JSonSchemaHelper.getSafeValue("deprecationNote", row));
            ((ComponentOptionModel)option).setDescription(JSonSchemaHelper.getSafeValue("description", row));
            ((ComponentOptionModel)option).setDefaultValue(JSonSchemaHelper.getSafeValue("defaultValue", row));
            ((ComponentOptionModel)option).setEnums(JSonSchemaHelper.getSafeValue("enum", row));
            component.addComponentOption((ComponentOptionModel)option);
        }
        rows = JSonSchemaHelper.parseJsonSchema("properties", json, true);
        for (Map<String, String> row : rows) {
            option = new EndpointOptionModel();
            ((EndpointOptionModel)option).setName(JSonSchemaHelper.getSafeValue("name", row));
            ((EndpointOptionModel)option).setDisplayName(JSonSchemaHelper.getSafeValue("displayName", row));
            ((EndpointOptionModel)option).setKind(JSonSchemaHelper.getSafeValue("kind", row));
            ((EndpointOptionModel)option).setGroup(JSonSchemaHelper.getSafeValue("group", row));
            ((EndpointOptionModel)option).setLabel(JSonSchemaHelper.getSafeValue("label", row));
            ((EndpointOptionModel)option).setRequired(JSonSchemaHelper.getSafeValue("required", row));
            ((EndpointOptionModel)option).setType(JSonSchemaHelper.getSafeValue("type", row));
            ((EndpointOptionModel)option).setJavaType(JSonSchemaHelper.getSafeValue("javaType", row));
            ((EndpointOptionModel)option).setEnums(JSonSchemaHelper.getSafeValue("enum", row));
            ((EndpointOptionModel)option).setPrefix(JSonSchemaHelper.getSafeValue("prefix", row));
            ((EndpointOptionModel)option).setMultiValue(JSonSchemaHelper.getSafeValue("multiValue", row));
            ((EndpointOptionModel)option).setDeprecated(JSonSchemaHelper.getSafeValue("deprecated", row));
            ((EndpointOptionModel)option).setDeprecationNote(JSonSchemaHelper.getSafeValue("deprecationNote", row));
            ((EndpointOptionModel)option).setDefaultValue(JSonSchemaHelper.getSafeValue("defaultValue", row));
            ((EndpointOptionModel)option).setDescription(JSonSchemaHelper.getSafeValue("description", row));
            ((EndpointOptionModel)option).setEnumValues(JSonSchemaHelper.getSafeValue("enum", row));
            component.addEndpointOption((EndpointOptionModel)option);
        }
        return component;
    }

    private void findComponentNames(File dir, Set<String> componentNames) {
        File[] files;
        File f = new File(dir, "classes/META-INF/services/org/apache/camel/component");
        if (f.exists() && f.isDirectory() && (files = f.listFiles()) != null) {
            for (File file : files) {
                String name;
                if (file.isDirectory() || (name = file.getName()).charAt(0) == '.') continue;
                componentNames.add(name);
            }
        }
    }

    private void writeSourceIfChanged(JavaClass source, String fileName, boolean innerClassesLast) throws MojoFailureException {
        this.writeSourceIfChanged(source.printClass(innerClassesLast), fileName);
    }

    private void writeSourceIfChanged(String source, String fileName) throws MojoFailureException {
        File target = new File(this.outputDir, fileName);
        try {
            String header;
            try (InputStream is = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("license-header-java.txt");){
                header = PackageHelper.loadText(is);
            }
            String code = header + source;
            this.getLog().debug((CharSequence)("Source code generated:\n" + code));
            AbstractGeneratorMojo.updateResource(null, target.toPath(), code);
        }
        catch (Exception e) {
            throw new MojoFailureException("IOError with file " + target, (Throwable)e);
        }
    }

    static {
        PRIMITIVEMAP.put("boolean", Boolean.class);
        PRIMITIVEMAP.put("char", Character.class);
        PRIMITIVEMAP.put("long", Long.class);
        PRIMITIVEMAP.put("int", Integer.class);
        PRIMITIVEMAP.put("integer", Integer.class);
        PRIMITIVEMAP.put("byte", Byte.class);
        PRIMITIVEMAP.put("short", Short.class);
        PRIMITIVEMAP.put("double", Double.class);
        PRIMITIVEMAP.put("float", Float.class);
    }
}

