/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.maven.packaging;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.camel.maven.packaging.AbstractGeneratorMojo;
import org.apache.camel.maven.packaging.PackageHelper;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.sonatype.plexus.build.incremental.BuildContext;

@Mojo(name="generate-components-list", threadSafe=true)
public class PackageComponentMojo
extends AbstractGeneratorMojo {
    @Parameter(defaultValue="${project.build.directory}/generated/camel/components")
    protected File componentOutDir;
    @Parameter(defaultValue="${project.build.directory}")
    protected File buildDir;

    public void execute() throws MojoExecutionException, MojoFailureException {
        PackageComponentMojo.prepareComponent(this.getLog(), this.project, this.projectHelper, this.buildDir, this.componentOutDir, this.buildContext);
    }

    public static int prepareComponent(Log log, MavenProject project, MavenProjectHelper projectHelper, File buildDir, File componentOutDir, BuildContext buildContext) throws MojoExecutionException {
        File[] files;
        File camelMetaDir = new File(componentOutDir, "META-INF/services/org/apache/camel/");
        if (projectHelper != null) {
            projectHelper.addResource(project, componentOutDir.getPath(), Collections.singletonList("**/component.properties"), Collections.emptyList());
        }
        if (!PackageHelper.haveResourcesChanged(log, project, buildContext, "META-INF/services/org/apache/camel/component")) {
            return 0;
        }
        StringBuilder buffer = new StringBuilder();
        int count = 0;
        HashSet<String> components = new HashSet<String>();
        File f = new File(project.getBasedir(), "target/classes");
        if ((f = new File(f, "META-INF/services/org/apache/camel/component")).exists() && f.isDirectory() && (files = f.listFiles()) != null) {
            for (File file : files) {
                String name;
                if (file.isDirectory() || (name = file.getName()).charAt(0) == '.') continue;
                ++count;
                if (buffer.length() > 0) {
                    buffer.append(" ");
                }
                buffer.append(name);
                components.add(file.getName());
            }
        }
        if (count > 0) {
            PackageComponentMojo.enrichComponentJsonFiles(log, project, buildDir, components);
        }
        if (count > 0) {
            String names = buffer.toString();
            Path outFile = camelMetaDir.toPath().resolve("component.properties");
            String properties = PackageComponentMojo.createProperties(project, "components", names);
            PackageComponentMojo.updateResource(buildContext, outFile, properties);
            log.info((CharSequence)("Generated " + outFile + " containing " + count + " Camel " + (count > 1 ? "components: " : "component: ") + names));
        } else {
            log.debug((CharSequence)"No META-INF/services/org/apache/camel/component directory found. Are you sure you have created a Camel component?");
        }
        return count;
    }

    private static void enrichComponentJsonFiles(Log log, MavenProject project, File buildDir, Set<String> components) throws MojoExecutionException {
        Set<File> files = PackageHelper.findJsonFiles(buildDir, p -> p.isDirectory() || p.getName().endsWith(".json"));
        for (File file : files) {
            String name = file.getName().substring(0, file.getName().length() - 5);
            if (!components.contains(name)) continue;
            log.debug((CharSequence)("Enriching component: " + name));
            try {
                String text = PackageHelper.loadText(new FileInputStream(file));
                text = text.replace("@@@DESCRIPTION@@@", project.getDescription());
                text = text.replace("@@@GROUPID@@@", project.getGroupId());
                text = text.replace("@@@ARTIFACTID@@@", project.getArtifactId());
                text = text.replace("@@@VERSIONID@@@", project.getVersion());
                boolean deprecated = project.getName().contains("(deprecated)");
                if (deprecated) {
                    text = text.replaceFirst(" {4}\"deprecated\": false,", "    \"deprecated\": true,");
                }
                PackageComponentMojo.updateResource(null, file.toPath(), text);
            }
            catch (IOException e) {
                throw new MojoExecutionException("Failed to update file " + file + ". Reason: " + e, (Exception)e);
            }
        }
    }
}

