/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.maven.packaging;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.camel.maven.packaging.AbstractGeneratorMojo;
import org.apache.camel.maven.packaging.JSonSchemaHelper;
import org.apache.camel.maven.packaging.PackageHelper;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.sonatype.plexus.build.incremental.BuildContext;

@Mojo(name="generate-dataformats-list", threadSafe=true)
public class PackageDataFormatMojo
extends AbstractGeneratorMojo {
    @Parameter(defaultValue="${project.build.directory}/generated/camel/dataformats")
    protected File dataFormatOutDir;
    @Parameter(defaultValue="${project.build.directory}/classes")
    protected File schemaOutDir;

    public void execute() throws MojoExecutionException, MojoFailureException {
        PackageDataFormatMojo.prepareDataFormat(this.getLog(), this.project, this.projectHelper, this.dataFormatOutDir, this.schemaOutDir, this.buildContext);
    }

    public static int prepareDataFormat(Log log, MavenProject project, MavenProjectHelper projectHelper, File dataFormatOutDir, File schemaOutDir, BuildContext buildContext) throws MojoExecutionException {
        int count;
        StringBuilder buffer;
        File camelMetaDir;
        block13: {
            String javaType;
            File[] files;
            camelMetaDir = new File(dataFormatOutDir, "META-INF/services/org/apache/camel/");
            if (projectHelper != null) {
                projectHelper.addResource(project, dataFormatOutDir.getPath(), Collections.singletonList("**/dataformat.properties"), Collections.emptyList());
            }
            if (!PackageHelper.haveResourcesChanged(log, project, buildContext, "META-INF/services/org/apache/camel/dataformat")) {
                return 0;
            }
            HashMap<String, String> javaTypes = new HashMap<String, String>();
            buffer = new StringBuilder();
            count = 0;
            File f = new File(project.getBasedir(), "target/classes");
            if ((f = new File(f, "META-INF/services/org/apache/camel/dataformat")).exists() && f.isDirectory() && (files = f.listFiles()) != null) {
                for (File file : files) {
                    javaType = PackageDataFormatMojo.readClassFromCamelResource(file, buffer, buildContext);
                    if (!file.isDirectory() && file.getName().charAt(0) != '.') {
                        ++count;
                    }
                    if (javaType == null) continue;
                    javaTypes.put(file.getName(), javaType);
                }
            }
            boolean apacheCamel = "org.apache.camel".equals(project.getGroupId());
            try {
                if (!apacheCamel || count <= 0) break block13;
                File core = PackageHelper.findCamelCoreDirectory(project.getBasedir());
                if (core != null) {
                    for (Map.Entry entry : javaTypes.entrySet()) {
                        String name = (String)entry.getKey();
                        javaType = (String)entry.getValue();
                        String modelName = PackageDataFormatMojo.asModelName(name);
                        FileInputStream is = new FileInputStream(new File(core, "target/classes/org/apache/camel/model/dataformat/" + modelName + ".json"));
                        String json = PackageHelper.loadText(is);
                        DataFormatModel dataFormatModel = PackageDataFormatMojo.extractDataFormatModel(project, json, modelName, name, javaType);
                        if (log.isDebugEnabled()) {
                            log.debug((CharSequence)("Model: " + dataFormatModel));
                        }
                        String properties = PackageHelper.after(json, "  \"properties\": {");
                        properties = PackageDataFormatMojo.prepareBindyProperties(name, properties);
                        properties = PackageDataFormatMojo.prepareJsonProperties(name, properties);
                        String schema = PackageDataFormatMojo.createParameterJsonSchema(dataFormatModel, properties);
                        if (log.isDebugEnabled()) {
                            log.debug((CharSequence)("JSon schema:\n" + schema));
                        }
                        Path out = schemaOutDir.toPath().resolve(PackageDataFormatMojo.schemaSubDirectory(dataFormatModel.getJavaType())).resolve(name + ".json");
                        PackageDataFormatMojo.updateResource(buildContext, out, schema);
                        if (!log.isDebugEnabled()) continue;
                        log.debug((CharSequence)("Generated " + out + " containing JSon schema for " + name + " data format"));
                    }
                    break block13;
                }
                throw new MojoExecutionException("Error finding core/camel-core/target/camel-core-engine-" + project.getVersion() + ".jar file. Make sure camel-core has been built first.");
            }
            catch (Exception e) {
                throw new MojoExecutionException("Error loading dataformat model from camel-core. Reason: " + e, e);
            }
        }
        if (count > 0) {
            String names = buffer.toString();
            Path outFile = camelMetaDir.toPath().resolve("dataformat.properties");
            String properties = PackageDataFormatMojo.createProperties(project, "dataFormats", names);
            PackageDataFormatMojo.updateResource(buildContext, outFile, properties);
            log.info((CharSequence)("Generated " + outFile + " containing " + count + " Camel " + (count > 1 ? "dataformats: " : "dataformat: ") + names));
        } else {
            log.debug((CharSequence)"No META-INF/services/org/apache/camel/dataformat directory found. Are you sure you have created a Camel data format?");
        }
        return count;
    }

    private static DataFormatModel extractDataFormatModel(MavenProject project, String json, String modelName, String name, String javaType) throws Exception {
        DataFormatModel dataFormatModel = new DataFormatModel();
        dataFormatModel.setName(name);
        dataFormatModel.setTitle("");
        dataFormatModel.setModelName(modelName);
        dataFormatModel.setLabel("");
        dataFormatModel.setDescription(project.getDescription());
        dataFormatModel.setJavaType(javaType);
        dataFormatModel.setGroupId(project.getGroupId());
        dataFormatModel.setArtifactId(project.getArtifactId());
        dataFormatModel.setVersion(project.getVersion());
        List<Map<String, String>> rows = JSonSchemaHelper.parseJsonSchema("model", json, false);
        for (Map<String, String> row : rows) {
            if (row.containsKey("title")) {
                String title = row.get("title");
                dataFormatModel.setTitle(PackageDataFormatMojo.asModelTitle(name, title));
            }
            if (row.containsKey("label")) {
                dataFormatModel.setLabel(row.get("label"));
            }
            if (row.containsKey("deprecated")) {
                dataFormatModel.setDeprecated(row.get("deprecated"));
            }
            if (row.containsKey("deprecationNote")) {
                dataFormatModel.setDeprecationNote(row.get("deprecationNote"));
            }
            if (row.containsKey("javaType")) {
                dataFormatModel.setModelJavaType(row.get("javaType"));
            }
            if (row.containsKey("firstVersion")) {
                dataFormatModel.setFirstVersion(row.get("firstVersion"));
            }
            if (!row.containsKey("description")) continue;
            dataFormatModel.setDescription(row.get("description"));
        }
        String firstVersion = PackageDataFormatMojo.prepareJsonFirstVersion(name);
        if (firstVersion != null) {
            dataFormatModel.setFirstVersion(firstVersion);
        }
        return dataFormatModel;
    }

    private static String prepareBindyProperties(String name, String properties) {
        String bindy = "\"enum\": [ \"Csv\", \"Fixed\", \"KeyValue\" ], \"deprecated\": \"false\", \"secret\": \"false\"";
        String bindyCsv = "\"enum\": [ \"Csv\", \"Fixed\", \"KeyValue\" ], \"deprecated\": \"false\", \"secret\": \"false\", \"defaultValue\": \"Csv\"";
        String bindyFixed = "\"enum\": [ \"Csv\", \"Fixed\", \"KeyValue\" ], \"deprecated\": \"false\", \"secret\": \"false\", \"defaultValue\": \"Fixed\"";
        String bindyKvp = "\"enum\": [ \"Csv\", \"Fixed\", \"KeyValue\" ], \"deprecated\": \"false\", \"secret\": \"false\", \"defaultValue\": \"KeyValue\"";
        if ("bindy-csv".equals(name)) {
            properties = properties.replace(bindy, bindyCsv);
        } else if ("bindy-fixed".equals(name)) {
            properties = properties.replace(bindy, bindyFixed);
        } else if ("bindy-kvp".equals(name)) {
            properties = properties.replace(bindy, bindyKvp);
        }
        return properties;
    }

    private static String prepareJsonProperties(String name, String properties) {
        String json = "\"enum\": [ \"Gson\", \"Jackson\", \"Johnzon\", \"XStream\", \"Fastjson\" ], \"deprecated\": \"false\", \"secret\": \"false\", \"defaultValue\": \"XStream\"";
        String jsonGson = "\"enum\": [ \"Gson\", \"Jackson\", \"Johnzon\", \"XStream\", \"Fastjson\" ], \"deprecated\": \"false\", \"secret\": \"false\", \"defaultValue\": \"Gson\"";
        String jsonJackson = "\"enum\": [ \"Gson\", \"Jackson\", \"Johnzon\", \"XStream\", \"Fastjson\" ], \"deprecated\": \"false\", \"secret\": \"false\", \"defaultValue\": \"Jackson\"";
        String jsonJohnzon = "\"enum\": [ \"Gson\", \"Jackson\", \"Johnzon\", \"XStream\", \"Fastjson\" ], \"deprecated\": \"false\", \"secret\": \"false\", \"defaultValue\": \"Johnzon\"";
        String jsonXStream = "\"enum\": [ \"Gson\", \"Jackson\", \"Johnzon\", \"XStream\", \"Fastjson\" ], \"deprecated\": \"false\", \"secret\": \"false\", \"defaultValue\": \"XStream\"";
        String jsonFastjson = "\"enum\": [ \"Gson\", \"Jackson\", \"Johnzon\", \"XStream\", \"Fastjson\" ], \"deprecated\": \"false\", \"secret\": \"false\", \"defaultValue\": \"Fastjson\"";
        if ("json-gson".equals(name)) {
            properties = properties.replace(json, jsonGson);
        } else if ("json-jackson".equals(name)) {
            properties = properties.replace(json, jsonJackson);
        } else if ("json-johnzon".equals(name)) {
            properties = properties.replace(json, jsonJohnzon);
        } else if ("json-xstream".equals(name)) {
            properties = properties.replace(json, jsonXStream);
        } else if ("json-fastjson".equals(name)) {
            properties = properties.replace(json, jsonFastjson);
        }
        return properties;
    }

    private static String prepareJsonFirstVersion(String name) {
        if ("json-gson".equals(name)) {
            return "2.10.0";
        }
        if ("json-jackson".equals(name)) {
            return "2.0.0";
        }
        if ("json-johnzon".equals(name)) {
            return "2.18.0";
        }
        if ("json-xstream".equals(name)) {
            return "2.0.0";
        }
        if ("json-fastjson".equals(name)) {
            return "2.20.0";
        }
        return null;
    }

    private static String readClassFromCamelResource(File file, StringBuilder buffer, BuildContext buildContext) throws MojoExecutionException {
        if (file.isDirectory()) {
            return null;
        }
        String name = file.getName();
        if (name.charAt(0) != '.') {
            if (buffer.length() > 0) {
                buffer.append(" ");
            }
            buffer.append(name);
        }
        if (!buildContext.hasDelta(file)) {
            return null;
        }
        try {
            String text = PackageHelper.loadText(new FileInputStream(file));
            Map<String, String> map = PackageHelper.parseAsMap(text);
            return map.get("class");
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to read file " + file + ". Reason: " + e, (Exception)e);
        }
    }

    private static String asModelName(String name) {
        if ("json-gson".equals(name) || "json-jackson".equals(name) || "json-johnzon".equals(name) || "json-xstream".equals(name) || "json-fastjson".equals(name)) {
            return "json";
        }
        if ("bindy-csv".equals(name) || "bindy-fixed".equals(name) || "bindy-kvp".equals(name)) {
            return "bindy";
        }
        if ("yaml-snakeyaml".equals(name)) {
            return "yaml";
        }
        return name;
    }

    private static String asModelTitle(String name, String title) {
        if ("json-gson".equals(name)) {
            return "JSon GSon";
        }
        if ("json-jackson".equals(name)) {
            return "JSon Jackson";
        }
        if ("json-johnzon".equals(name)) {
            return "JSon Johnzon";
        }
        if ("json-xstream".equals(name)) {
            return "JSon XStream";
        }
        if ("json-fastjson".equals(name)) {
            return "JSon Fastjson";
        }
        if ("bindy-csv".equals(name)) {
            return "Bindy CSV";
        }
        if ("bindy-fixed".equals(name)) {
            return "Bindy Fixed Length";
        }
        if ("bindy-kvp".equals(name)) {
            return "Bindy Key Value Pair";
        }
        if ("yaml-snakeyaml".equals(name)) {
            return "YAML SnakeYAML";
        }
        return title;
    }

    private static String schemaSubDirectory(String javaType) {
        int idx = javaType.lastIndexOf(46);
        String pckName = javaType.substring(0, idx);
        return pckName.replace('.', '/');
    }

    private static String createParameterJsonSchema(DataFormatModel dataFormatModel, String schema) {
        StringBuilder buffer = new StringBuilder("{");
        buffer.append("\n \"dataformat\": {");
        buffer.append("\n    \"name\": \"").append(dataFormatModel.getName()).append("\",");
        buffer.append("\n    \"kind\": \"").append("dataformat").append("\",");
        buffer.append("\n    \"modelName\": \"").append(dataFormatModel.getModelName()).append("\",");
        if (dataFormatModel.getTitle() != null) {
            buffer.append("\n    \"title\": \"").append(dataFormatModel.getTitle()).append("\",");
        }
        if (dataFormatModel.getDescription() != null) {
            buffer.append("\n    \"description\": \"").append(dataFormatModel.getDescription()).append("\",");
        }
        boolean deprecated = "true".equals(dataFormatModel.getDeprecated());
        buffer.append("\n    \"deprecated\": ").append(deprecated).append(",");
        if (dataFormatModel.getFirstVersion() != null) {
            buffer.append("\n    \"firstVersion\": \"").append(dataFormatModel.getFirstVersion()).append("\",");
        }
        buffer.append("\n    \"label\": \"").append(dataFormatModel.getLabel()).append("\",");
        buffer.append("\n    \"javaType\": \"").append(dataFormatModel.getJavaType()).append("\",");
        if (dataFormatModel.getModelJavaType() != null) {
            buffer.append("\n    \"modelJavaType\": \"").append(dataFormatModel.getModelJavaType()).append("\",");
        }
        buffer.append("\n    \"groupId\": \"").append(dataFormatModel.getGroupId()).append("\",");
        buffer.append("\n    \"artifactId\": \"").append(dataFormatModel.getArtifactId()).append("\",");
        buffer.append("\n    \"version\": \"").append(dataFormatModel.getVersion()).append("\"");
        buffer.append("\n  },");
        buffer.append("\n  \"properties\": {");
        buffer.append(schema);
        return buffer.toString();
    }

    private static class DataFormatModel {
        private String name;
        private String title;
        private String modelName;
        private String description;
        private String firstVersion;
        private String label;
        private String deprecated;
        private String deprecationNote;
        private String javaType;
        private String modelJavaType;
        private String groupId;
        private String artifactId;
        private String version;

        private DataFormatModel() {
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getTitle() {
            return this.title;
        }

        public void setTitle(String title) {
            this.title = title;
        }

        public String getModelName() {
            return this.modelName;
        }

        public void setModelName(String modelName) {
            this.modelName = modelName;
        }

        public String getModelJavaType() {
            return this.modelJavaType;
        }

        public void setModelJavaType(String modelJavaType) {
            this.modelJavaType = modelJavaType;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public String getFirstVersion() {
            return this.firstVersion;
        }

        public void setFirstVersion(String firstVersion) {
            this.firstVersion = firstVersion;
        }

        public String getLabel() {
            return this.label;
        }

        public void setLabel(String label) {
            this.label = label;
        }

        public String getDeprecated() {
            return this.deprecated;
        }

        public void setDeprecated(String deprecated) {
            this.deprecated = deprecated;
        }

        public String getDeprecationNote() {
            return this.deprecationNote;
        }

        public void setDeprecationNote(String deprecationNote) {
            this.deprecationNote = deprecationNote;
        }

        public String getJavaType() {
            return this.javaType;
        }

        public void setJavaType(String javaType) {
            this.javaType = javaType;
        }

        public String getGroupId() {
            return this.groupId;
        }

        public void setGroupId(String groupId) {
            this.groupId = groupId;
        }

        public String getArtifactId() {
            return this.artifactId;
        }

        public void setArtifactId(String artifactId) {
            this.artifactId = artifactId;
        }

        public String getVersion() {
            return this.version;
        }

        public void setVersion(String version) {
            this.version = version;
        }

        public String toString() {
            return "DataFormatModel[name='" + this.name + '\'' + ", title='" + this.title + '\'' + ", modelName='" + this.modelName + '\'' + ", description='" + this.description + '\'' + ", label='" + this.label + '\'' + ", deprecated='" + this.deprecated + '\'' + ", javaType='" + this.javaType + '\'' + ", modelJavaType='" + this.modelJavaType + '\'' + ", groupId='" + this.groupId + '\'' + ", artifactId='" + this.artifactId + '\'' + ", version='" + this.version + '\'' + ']';
        }
    }
}

