/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.maven.packaging;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.sonatype.plexus.build.incremental.BuildContext;

public final class PackageHelper {
    private PackageHelper() {
    }

    public static boolean haveResourcesChanged(Log log, MavenProject project, BuildContext buildContext, String suffix) {
        String baseDir = project.getBasedir().getAbsolutePath();
        for (Resource r : project.getBuild().getResources()) {
            File file = new File(r.getDirectory());
            if (file.isAbsolute()) {
                file = new File(r.getDirectory().substring(baseDir.length() + 1));
            }
            String path = file.getPath() + "/" + suffix;
            if (log.isDebugEnabled()) {
                log.debug((CharSequence)("Checking  if " + path + " (" + r.getDirectory() + "/" + suffix + ") has changed."));
            }
            if (!buildContext.hasDelta(path)) continue;
            log.debug((CharSequence)("Indeed " + suffix + " has changed."));
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String loadText(InputStream in) throws IOException {
        StringBuilder builder = new StringBuilder();
        InputStreamReader isr = new InputStreamReader(in);
        try {
            String line;
            LineNumberReader reader = new LineNumberReader(isr);
            while ((line = ((BufferedReader)reader).readLine()) != null) {
                builder.append(line);
                builder.append("\n");
            }
            String string = builder.toString();
            return string;
        }
        finally {
            isr.close();
            in.close();
        }
    }

    public static void writeText(File file, String text) throws IOException {
        try (FileOutputStream fos = new FileOutputStream(file, false);){
            fos.write(text.getBytes());
        }
    }

    public static String after(String text, String after) {
        if (!text.contains(after)) {
            return null;
        }
        return text.substring(text.indexOf(after) + after.length());
    }

    public static Map<String, String> parseAsMap(String data) {
        HashMap<String, String> answer = new HashMap<String, String>();
        if (data != null) {
            String[] lines;
            for (String line : lines = data.split("\n")) {
                int idx = line.indexOf(61);
                if (idx == -1) continue;
                String key = line.substring(0, idx);
                String value = line.substring(idx + 1);
                value = value.trim().replaceAll("\n", "");
                answer.put(key.trim(), value);
            }
        }
        return answer;
    }

    public static Set<File> findJsonFiles(File dir, FileFilter filter) {
        TreeSet<File> files = new TreeSet<File>();
        PackageHelper.findJsonFiles(dir, files, filter);
        return files;
    }

    public static void findJsonFiles(File dir, Set<File> found, FileFilter filter) {
        File[] files = dir.listFiles(filter);
        if (files != null) {
            for (File file : files) {
                boolean jsonFile;
                boolean bl = jsonFile = file.isFile() && file.getName().endsWith(".json");
                if (jsonFile) {
                    found.add(file);
                    continue;
                }
                if (!file.isDirectory()) continue;
                PackageHelper.findJsonFiles(file, found, filter);
            }
        }
    }

    public static File findCamelCoreDirectory(File dir) {
        return PackageHelper.findCamelDirectory(dir, "core/camel-core-engine");
    }

    public static File findCamelDirectory(File dir, String path) {
        if (dir == null) {
            return null;
        }
        Path p = dir.toPath().resolve(path);
        if (Files.isDirectory(p, new LinkOption[0])) {
            return p.toFile();
        }
        return PackageHelper.findCamelDirectory(dir.getParentFile(), path);
    }

    public static class CamelOthersModelFilter
    implements FileFilter {
        @Override
        public boolean accept(File pathname) {
            boolean special2;
            String name = pathname.getName();
            boolean special = "camel-core-osgi".equals(name) || "camel-core-xml".equals(name) || "camel-http-common".equals(name) || "camel-jetty-common".equals(name);
            boolean bl = special2 = "camel-as2".equals(name) || "camel-box".equals(name) || "camel-linkedin".equals(name) || "camel-olingo2".equals(name) || "camel-olingo4".equals(name) || "camel-salesforce".equals(name) || "camel-debezium".equals(name);
            if (special || special2) {
                return false;
            }
            return pathname.isDirectory() || name.endsWith(".json");
        }
    }

    public static class CamelComponentsModelFilter
    implements FileFilter {
        @Override
        public boolean accept(File pathname) {
            return pathname.isDirectory() || pathname.getName().endsWith(".json");
        }
    }
}

