/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.maven.packaging;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.apache.camel.maven.packaging.JSonSchemaHelper;
import org.apache.camel.maven.packaging.MvelHelper;
import org.apache.camel.maven.packaging.PackageHelper;
import org.apache.camel.maven.packaging.StringHelper;
import org.apache.camel.maven.packaging.model.ComponentModel;
import org.apache.camel.maven.packaging.model.ComponentOptionModel;
import org.apache.camel.maven.packaging.model.DataFormatModel;
import org.apache.camel.maven.packaging.model.DataFormatOptionModel;
import org.apache.camel.maven.packaging.model.EipModel;
import org.apache.camel.maven.packaging.model.EipOptionModel;
import org.apache.camel.maven.packaging.model.EndpointOptionModel;
import org.apache.camel.maven.packaging.model.LanguageModel;
import org.apache.camel.maven.packaging.model.LanguageOptionModel;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.mvel2.templates.TemplateRuntime;
import org.sonatype.plexus.build.incremental.BuildContext;

@Mojo(name="update-readme", threadSafe=true)
public class UpdateReadmeMojo
extends AbstractMojo {
    @Parameter(property="project", required=true, readonly=true)
    protected MavenProject project;
    @Parameter(defaultValue="${project.build.directory}")
    protected File buildDir;
    @Parameter(defaultValue="${basedir}/src/main/docs")
    protected File docDir;
    @Parameter(defaultValue="${basedir}/src/main/docs/eips")
    protected File eipDocDir;
    @Parameter
    protected Boolean failFast;
    @Component
    private BuildContext buildContext;

    public void execute() throws MojoExecutionException {
        this.executeComponent();
        this.executeDataFormat();
        this.executeLanguage();
        this.executeEips();
    }

    private void executeComponent() throws MojoExecutionException {
        List<String> componentNames = this.listDescriptorNamesOfType("component");
        TreeSet<File> jsonFiles = new TreeSet<File>();
        PackageHelper.findJsonFiles(this.buildDir, jsonFiles, new PackageHelper.CamelComponentsModelFilter());
        if (!componentNames.isEmpty()) {
            this.getLog().debug((CharSequence)("Found " + componentNames.size() + " components"));
            for (String componentName : componentNames) {
                String json = UpdateReadmeMojo.loadJsonFrom(jsonFiles, "component", componentName);
                if (json == null) continue;
                componentName = UpdateReadmeMojo.asComponentName(componentName);
                File file = new File(this.docDir, componentName + "-component.adoc");
                ComponentModel model = UpdateReadmeMojo.generateComponentModel(json);
                String title = UpdateReadmeMojo.asComponentTitle(model.getScheme(), model.getTitle());
                model.setTitle(title);
                if (!StringHelper.isEmpty(model.getAlternativeSchemes())) {
                    String first = model.getAlternativeSchemes().split(",")[0];
                    if (!model.getScheme().equals(first)) continue;
                }
                String docTitle = model.getTitle() + " Component";
                boolean deprecated = "true".equals(model.getDeprecated());
                if (deprecated) {
                    docTitle = docTitle + " (deprecated)";
                }
                boolean exists = file.exists();
                boolean updated = UpdateReadmeMojo.updateLink(file, componentName + "-component");
                updated |= UpdateReadmeMojo.updateTitles(file, docTitle);
                updated |= UpdateReadmeMojo.updateAvailableFrom(file, model.getFirstVersion());
                boolean hasOptions = model.getComponentOptions().stream().anyMatch(o -> !o.getName().equals("resolvePropertyPlaceholders"));
                if (!hasOptions) {
                    model.getComponentOptions().clear();
                }
                String options = UpdateReadmeMojo.evaluateTemplate("component-options.mvel", model);
                updated |= this.updateOptionsIn(file, "component", options);
                options = UpdateReadmeMojo.evaluateTemplate("endpoint-options.mvel", model);
                if (updated |= this.updateOptionsIn(file, "endpoint", options)) {
                    this.getLog().info((CharSequence)("Updated doc file: " + file));
                    continue;
                }
                if (exists) {
                    this.getLog().debug((CharSequence)("No changes to doc file: " + file));
                    continue;
                }
                this.getLog().warn((CharSequence)("No component doc file: " + file));
                if (!this.isFailFast()) continue;
                throw new MojoExecutionException("Failed build due failFast=true");
            }
        }
    }

    private void executeDataFormat() throws MojoExecutionException {
        List<String> dataFormatNames = this.listDescriptorNamesOfType("dataformat");
        TreeSet<File> jsonFiles = new TreeSet<File>();
        PackageHelper.findJsonFiles(this.buildDir, jsonFiles, new PackageHelper.CamelComponentsModelFilter());
        if (!dataFormatNames.isEmpty()) {
            this.getLog().debug((CharSequence)("Found " + dataFormatNames.size() + " dataformats"));
            for (String dataFormatName : dataFormatNames) {
                String json = UpdateReadmeMojo.loadJsonFrom(jsonFiles, "dataformat", dataFormatName);
                if (json == null) continue;
                dataFormatName = UpdateReadmeMojo.asDataFormatName(dataFormatName);
                File file = new File(this.docDir, dataFormatName + "-dataformat.adoc");
                DataFormatModel model = this.generateDataFormatModel(dataFormatName, json);
                String title = UpdateReadmeMojo.asDataFormatTitle(model.getName(), model.getTitle());
                model.setTitle(title);
                String docTitle = model.getTitle() + " DataFormat";
                boolean deprecated = "true".equals(model.getDeprecated());
                if (deprecated) {
                    docTitle = docTitle + " (deprecated)";
                }
                boolean exists = file.exists();
                boolean updated = UpdateReadmeMojo.updateLink(file, dataFormatName + "-dataformat");
                updated |= UpdateReadmeMojo.updateTitles(file, docTitle);
                updated |= UpdateReadmeMojo.updateAvailableFrom(file, model.getFirstVersion());
                String options = UpdateReadmeMojo.evaluateTemplate("dataformat-options.mvel", model);
                if (updated |= this.updateOptionsIn(file, "dataformat", options)) {
                    this.getLog().info((CharSequence)("Updated doc file: " + file));
                    continue;
                }
                if (exists) {
                    this.getLog().debug((CharSequence)("No changes to doc file: " + file));
                    continue;
                }
                this.getLog().warn((CharSequence)("No dataformat doc file: " + file));
                if (!this.isFailFast()) continue;
                throw new MojoExecutionException("Failed build due failFast=true");
            }
        }
    }

    private static String asComponentName(String name) {
        if (name.equals("imap") || name.equals("imaps") || name.equals("pop3") || name.equals("pop3s") || name.equals("smtp") || name.equals("smtps")) {
            return "mail";
        }
        return name;
    }

    private void executeLanguage() throws MojoExecutionException {
        List<String> languageNames = this.listDescriptorNamesOfType("language");
        TreeSet<File> jsonFiles = new TreeSet<File>();
        PackageHelper.findJsonFiles(this.buildDir, jsonFiles, new PackageHelper.CamelComponentsModelFilter());
        if (!languageNames.isEmpty()) {
            this.getLog().debug((CharSequence)("Found " + languageNames.size() + " languages"));
            for (String languageName : languageNames) {
                String json = UpdateReadmeMojo.loadJsonFrom(jsonFiles, "language", languageName);
                if (json == null) continue;
                File file = new File(this.docDir, languageName + "-language.adoc");
                LanguageModel model = this.generateLanguageModel(json);
                String docTitle = model.getTitle() + " Language";
                boolean deprecated = "true".equals(model.getDeprecated());
                if (deprecated) {
                    docTitle = docTitle + " (deprecated)";
                }
                boolean exists = file.exists();
                boolean updated = UpdateReadmeMojo.updateLink(file, languageName + "-language");
                updated |= UpdateReadmeMojo.updateTitles(file, docTitle);
                updated |= UpdateReadmeMojo.updateAvailableFrom(file, model.getFirstVersion());
                String options = UpdateReadmeMojo.evaluateTemplate("language-options.mvel", model);
                if (updated |= this.updateOptionsIn(file, "language", options)) {
                    this.getLog().info((CharSequence)("Updated doc file: " + file));
                    continue;
                }
                if (exists) {
                    this.getLog().debug((CharSequence)("No changes to doc file: " + file));
                    continue;
                }
                this.getLog().warn((CharSequence)("No language doc file: " + file));
                if (!this.isFailFast()) continue;
                throw new MojoExecutionException("Failed build due failFast=true");
            }
        }
    }

    private void executeEips() throws MojoExecutionException {
        String currentDir = Paths.get(".", new String[0]).normalize().toAbsolutePath().toString();
        if (!currentDir.endsWith("camel-core")) {
            return;
        }
        TreeSet<File> jsonFiles = new TreeSet<File>();
        File coreDir = new File(".");
        if (coreDir.isDirectory()) {
            File target = new File(coreDir, "target/classes/org/apache/camel/model");
            PackageHelper.findJsonFiles(target, jsonFiles, new PackageHelper.CamelComponentsModelFilter());
        }
        if (!jsonFiles.isEmpty()) {
            this.getLog().debug((CharSequence)("Found " + jsonFiles.size() + " eips"));
            for (File jsonFile : jsonFiles) {
                String json = UpdateReadmeMojo.loadEipJson(jsonFile);
                if (json == null) continue;
                EipModel model = this.generateEipModel(json);
                String title = model.getTitle();
                model.setTitle(title);
                String eipName = model.getName();
                if (!model.getLabel().startsWith("eip")) continue;
                File file = new File(this.eipDocDir, eipName + "-eip.adoc");
                String docTitle = model.getTitle() + " EIP";
                boolean deprecated = model.isDeprecated();
                if (deprecated) {
                    docTitle = docTitle + " (deprecated)";
                }
                boolean exists = file.exists();
                boolean updated = UpdateReadmeMojo.updateLink(file, eipName + "-eip");
                updated |= UpdateReadmeMojo.updateTitles(file, docTitle);
                String options = UpdateReadmeMojo.evaluateTemplate("eip-options.mvel", model);
                if (updated |= this.updateOptionsIn(file, "eip", options)) {
                    this.getLog().info((CharSequence)("Updated doc file: " + file));
                    continue;
                }
                if (exists) {
                    this.getLog().debug((CharSequence)("No changes to doc file: " + file));
                    continue;
                }
                this.getLog().warn((CharSequence)("No eip doc file: " + file));
                if (!this.isFailFast()) continue;
                throw new MojoExecutionException("Failed build due failFast=true");
            }
        }
    }

    private static String asComponentTitle(String name, String title) {
        if (name.equals("imap") || name.equals("imaps") || name.equals("pop3") || name.equals("pop3s") || name.equals("smtp") || name.equals("smtps")) {
            return "Mail";
        }
        return title;
    }

    private static String asDataFormatName(String name) {
        if (name.startsWith("bindy")) {
            return "bindy";
        }
        return name;
    }

    private static String asDataFormatTitle(String name, String title) {
        if (name.startsWith("bindy")) {
            return "Bindy";
        }
        return title;
    }

    private static boolean updateLink(File file, String link) throws MojoExecutionException {
        if (!file.exists()) {
            return false;
        }
        boolean updated = false;
        try (FileInputStream fileStream = new FileInputStream(file);){
            ArrayList<String> newLines = new ArrayList<String>();
            String text = PackageHelper.loadText(fileStream);
            String[] lines = text.split("\n");
            for (int i = 0; i < lines.length; ++i) {
                String line = lines[i];
                if (i == 0) {
                    String newLine = "[[" + link + "]]";
                    newLines.add(newLine);
                    boolean bl = updated = !line.equals(newLine);
                    if (!updated) continue;
                    newLines.add(line);
                    continue;
                }
                newLines.add(line);
            }
            if (updated) {
                String newText = newLines.stream().collect(Collectors.joining("\n"));
                PackageHelper.writeText(file, newText);
            }
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error reading file " + file + " Reason: " + e, e);
        }
        return updated;
    }

    private static boolean updateTitles(File file, String title) throws MojoExecutionException {
        if (!file.exists()) {
            return false;
        }
        boolean updated = false;
        try (FileInputStream fileStream = new FileInputStream(file);){
            ArrayList<String> newLines = new ArrayList<String>();
            String text = PackageHelper.loadText(fileStream);
            String[] lines = text.split("\n");
            for (int i = 1; i < lines.length; ++i) {
                String line = lines[i];
                if (i == 1) {
                    String newLine = "= " + title;
                    newLines.add(newLine);
                    updated = !line.equals(newLine);
                    continue;
                }
                if (line.startsWith("^^^") || line.startsWith("~~~") || line.startsWith("+++")) {
                    String level = line.startsWith("+++") ? "===" : "==";
                    int idx = newLines.size() - 1;
                    String prev = (String)newLines.get(idx);
                    newLines.set(idx, level + " " + prev);
                    idx = newLines.size() - 2;
                    if (idx >= 0 && (prev = (String)newLines.get(idx)).startsWith("[[")) {
                        newLines.remove(idx);
                    }
                    updated = true;
                    continue;
                }
                newLines.add(line);
            }
            if (updated) {
                String newText = newLines.stream().collect(Collectors.joining("\n"));
                PackageHelper.writeText(file, newText);
            }
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error reading file " + file + " Reason: " + e, e);
        }
        return updated;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean updateAvailableFrom(File file, String firstVersion) throws MojoExecutionException {
        if (firstVersion == null) return false;
        if (!file.exists()) {
            return false;
        }
        String version = firstVersion;
        String[] parts = firstVersion.split("\\.");
        if (parts.length == 3 && parts[2].equals("0")) {
            version = parts[0] + "." + parts[1];
        }
        boolean updated = false;
        try (FileInputStream fileStream = new FileInputStream(file);){
            String newLine;
            String text = PackageHelper.loadText(fileStream);
            String[] lines = text.split("\n");
            ArrayList<String> newLines = new ArrayList<String>();
            newLines.addAll(Arrays.asList(lines));
            if (lines.length < 5) {
                boolean bl = false;
                return bl;
            }
            boolean title = lines[1].startsWith("#") || lines[1].startsWith("=");
            boolean empty = lines[2].trim().isEmpty();
            boolean availableFrom = lines[3].trim().contains("Available as of") || lines[3].trim().contains("Available in");
            boolean empty2 = lines[4].trim().isEmpty();
            if (title && empty && availableFrom) {
                newLine = "*Available as of Camel version " + version + "*";
                if (!newLine.equals(lines[3])) {
                    newLines.set(3, newLine);
                    updated = true;
                }
                if (!empty2) {
                    newLines.add(4, "");
                    updated = true;
                }
            } else if (!availableFrom) {
                newLine = "*Available as of Camel version " + version + "*";
                newLines.add(3, newLine);
                newLines.add(4, "");
                updated = true;
            }
            if (!updated) return updated;
            String newText = newLines.stream().collect(Collectors.joining("\n"));
            PackageHelper.writeText(file, newText);
            return updated;
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error reading file " + file + " Reason: " + e, e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean updateOptionsIn(File file, String kind, String changed) throws MojoExecutionException {
        if (!file.exists()) {
            return false;
        }
        String updated = changed.trim();
        try (FileInputStream fileStream = new FileInputStream(file);){
            String text = PackageHelper.loadText(fileStream);
            String existing = StringHelper.between(text, "// " + kind + " options: START", "// " + kind + " options: END");
            if (existing != null) {
                if ((existing = existing.trim()).equals(updated)) {
                    boolean bl = false;
                    return bl;
                }
                String before = StringHelper.before(text, "// " + kind + " options: START");
                String after = StringHelper.after(text, "// " + kind + " options: END");
                text = before + "// " + kind + " options: START\n" + updated + "\n// " + kind + " options: END" + after;
                PackageHelper.writeText(file, text);
                boolean bl = true;
                return bl;
            }
            this.getLog().warn((CharSequence)("Cannot find markers in file " + file));
            this.getLog().warn((CharSequence)"Add the following markers");
            this.getLog().warn((CharSequence)("\t// " + kind + " options: START"));
            this.getLog().warn((CharSequence)("\t// " + kind + " options: END"));
            if (this.isFailFast()) {
                throw new MojoExecutionException("Failed build due failFast=true");
            }
            boolean bl = false;
            return bl;
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error reading file " + file + " Reason: " + e, (Exception)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String loadJsonFrom(Set<File> jsonFiles, String kind, String name) {
        Iterator<File> iterator = jsonFiles.iterator();
        while (iterator.hasNext()) {
            File file = iterator.next();
            if (!file.getName().equals(name + ".json")) continue;
            try {
                FileInputStream fileStream = new FileInputStream(file);
                Throwable throwable = null;
                try {
                    String json = PackageHelper.loadText(fileStream);
                    boolean isRequestedKind = json.contains("\"kind\": \"" + kind + "\"");
                    if (!isRequestedKind) continue;
                    String string = json;
                    return string;
                }
                catch (Throwable throwable4) {
                    throwable = throwable4;
                    throw throwable4;
                }
                finally {
                    if (fileStream == null) continue;
                    if (throwable != null) {
                        try {
                            ((InputStream)fileStream).close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        continue;
                    }
                    ((InputStream)fileStream).close();
                }
            }
            catch (IOException iOException) {}
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String loadEipJson(File file) {
        try (FileInputStream fileStream = new FileInputStream(file);){
            String json = PackageHelper.loadText(fileStream);
            boolean isEip = json.contains("\"kind\": \"model\"");
            if (!isEip) return null;
            String string = json;
            return string;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    private static ComponentModel generateComponentModel(String json) {
        String desc;
        Object option;
        List<Map<String, String>> rows = JSonSchemaHelper.parseJsonSchema("component", json, false);
        ComponentModel component = new ComponentModel(true);
        component.setScheme(JSonSchemaHelper.getSafeValue("scheme", rows));
        component.setSyntax(JSonSchemaHelper.getSafeValue("syntax", rows));
        component.setAlternativeSyntax(JSonSchemaHelper.getSafeValue("alternativeSyntax", rows));
        component.setAlternativeSchemes(JSonSchemaHelper.getSafeValue("alternativeSchemes", rows));
        component.setTitle(JSonSchemaHelper.getSafeValue("title", rows));
        component.setDescription(JSonSchemaHelper.getSafeValue("description", rows));
        component.setFirstVersion(JSonSchemaHelper.getSafeValue("firstVersion", rows));
        component.setLabel(JSonSchemaHelper.getSafeValue("label", rows));
        component.setDeprecated(JSonSchemaHelper.getSafeValue("deprecated", rows));
        component.setDeprecationNote(JSonSchemaHelper.getSafeValue("deprecationNote", rows));
        component.setConsumerOnly(JSonSchemaHelper.getSafeValue("consumerOnly", rows));
        component.setProducerOnly(JSonSchemaHelper.getSafeValue("producerOnly", rows));
        component.setJavaType(JSonSchemaHelper.getSafeValue("javaType", rows));
        component.setGroupId(JSonSchemaHelper.getSafeValue("groupId", rows));
        component.setArtifactId(JSonSchemaHelper.getSafeValue("artifactId", rows));
        component.setVersion(JSonSchemaHelper.getSafeValue("version", rows));
        String oldGroup = null;
        rows = JSonSchemaHelper.parseJsonSchema("componentProperties", json, true);
        for (Map<String, String> row : rows) {
            option = new ComponentOptionModel();
            ((ComponentOptionModel)option).setName(JSonSchemaHelper.getSafeValue("name", row));
            ((ComponentOptionModel)option).setDisplayName(JSonSchemaHelper.getSafeValue("displayName", row));
            ((ComponentOptionModel)option).setKind(JSonSchemaHelper.getSafeValue("kind", row));
            ((ComponentOptionModel)option).setGroup(JSonSchemaHelper.getSafeValue("group", row));
            ((ComponentOptionModel)option).setRequired(JSonSchemaHelper.getSafeValue("required", row));
            ((ComponentOptionModel)option).setType(JSonSchemaHelper.getSafeValue("type", row));
            ((ComponentOptionModel)option).setJavaType(JSonSchemaHelper.getSafeValue("javaType", row));
            ((ComponentOptionModel)option).setEnums(JSonSchemaHelper.getSafeValue("enum", row));
            ((ComponentOptionModel)option).setDeprecated(JSonSchemaHelper.getSafeValue("deprecated", row));
            ((ComponentOptionModel)option).setDeprecationNote(JSonSchemaHelper.getSafeValue("deprecationNote", row));
            ((ComponentOptionModel)option).setSecret(JSonSchemaHelper.getSafeValue("secret", row));
            ((ComponentOptionModel)option).setDefaultValue(JSonSchemaHelper.getSafeValue("defaultValue", row));
            ((ComponentOptionModel)option).setDescription(JSonSchemaHelper.getSafeValue("description", row));
            if ("true".equals(((ComponentOptionModel)option).getRequired())) {
                desc = "*Required* " + ((ComponentOptionModel)option).getDescription();
                ((ComponentOptionModel)option).setDescription(desc);
            }
            if ("true".equals(((ComponentOptionModel)option).getDeprecated())) {
                desc = "*Deprecated* " + ((ComponentOptionModel)option).getDescription();
                ((ComponentOptionModel)option).setDescription(desc);
                if (!StringHelper.isEmpty(((ComponentOptionModel)option).getDeprecationNote())) {
                    desc = ((ComponentOptionModel)option).getDescription();
                    desc = !desc.endsWith(".") ? desc + ". Deprecation note: " + ((ComponentOptionModel)option).getDeprecationNote() : desc + " Deprecation note: " + ((ComponentOptionModel)option).getDeprecationNote();
                    ((ComponentOptionModel)option).setDescription(desc);
                }
            }
            component.addComponentOption((ComponentOptionModel)option);
            if (oldGroup == null || !oldGroup.equals(((ComponentOptionModel)option).getGroup())) {
                ((ComponentOptionModel)option).setNewGroup(true);
            }
            oldGroup = ((ComponentOptionModel)option).getGroup();
        }
        oldGroup = null;
        rows = JSonSchemaHelper.parseJsonSchema("properties", json, true);
        for (Map<String, String> row : rows) {
            option = new EndpointOptionModel();
            ((EndpointOptionModel)option).setName(JSonSchemaHelper.getSafeValue("name", row));
            ((EndpointOptionModel)option).setDisplayName(JSonSchemaHelper.getSafeValue("displayName", row));
            ((EndpointOptionModel)option).setKind(JSonSchemaHelper.getSafeValue("kind", row));
            ((EndpointOptionModel)option).setGroup(JSonSchemaHelper.getSafeValue("group", row));
            ((EndpointOptionModel)option).setRequired(JSonSchemaHelper.getSafeValue("required", row));
            ((EndpointOptionModel)option).setType(JSonSchemaHelper.getSafeValue("type", row));
            ((EndpointOptionModel)option).setJavaType(JSonSchemaHelper.getSafeValue("javaType", row));
            ((EndpointOptionModel)option).setEnums(JSonSchemaHelper.getSafeValue("enum", row));
            ((EndpointOptionModel)option).setPrefix(JSonSchemaHelper.getSafeValue("prefix", row));
            ((EndpointOptionModel)option).setMultiValue(JSonSchemaHelper.getSafeValue("multiValue", row));
            ((EndpointOptionModel)option).setDeprecated(JSonSchemaHelper.getSafeValue("deprecated", row));
            ((EndpointOptionModel)option).setDeprecationNote(JSonSchemaHelper.getSafeValue("deprecationNote", row));
            ((EndpointOptionModel)option).setSecret(JSonSchemaHelper.getSafeValue("secret", row));
            ((EndpointOptionModel)option).setDefaultValue(JSonSchemaHelper.getSafeValue("defaultValue", row));
            ((EndpointOptionModel)option).setDescription(JSonSchemaHelper.getSafeValue("description", row));
            if ("true".equals(((EndpointOptionModel)option).getRequired())) {
                desc = "*Required* " + ((EndpointOptionModel)option).getDescription();
                ((EndpointOptionModel)option).setDescription(desc);
            }
            if ("true".equals(((EndpointOptionModel)option).getDeprecated())) {
                desc = "*Deprecated* " + ((EndpointOptionModel)option).getDescription();
                ((EndpointOptionModel)option).setDescription(desc);
                if (!StringHelper.isEmpty(((EndpointOptionModel)option).getDeprecationNote())) {
                    desc = ((EndpointOptionModel)option).getDescription();
                    desc = !desc.endsWith(".") ? desc + ". Deprecation note: " + ((EndpointOptionModel)option).getDeprecationNote() : desc + " Deprecation note: " + ((EndpointOptionModel)option).getDeprecationNote();
                    ((EndpointOptionModel)option).setDescription(desc);
                }
            }
            if ("path".equals(((EndpointOptionModel)option).getKind())) {
                component.addEndpointPathOption((EndpointOptionModel)option);
            } else {
                component.addEndpointOption((EndpointOptionModel)option);
            }
            if (oldGroup == null || !oldGroup.equals(((EndpointOptionModel)option).getGroup())) {
                ((EndpointOptionModel)option).setNewGroup(true);
            }
            oldGroup = ((EndpointOptionModel)option).getGroup();
        }
        return component;
    }

    private DataFormatModel generateDataFormatModel(String dataFormatName, String json) {
        List<Map<String, String>> rows = JSonSchemaHelper.parseJsonSchema("dataformat", json, false);
        DataFormatModel dataFormat = new DataFormatModel();
        dataFormat.setTitle(JSonSchemaHelper.getSafeValue("title", rows));
        dataFormat.setModelName(JSonSchemaHelper.getSafeValue("modelName", rows));
        dataFormat.setName(JSonSchemaHelper.getSafeValue("name", rows));
        dataFormat.setDescription(JSonSchemaHelper.getSafeValue("description", rows));
        dataFormat.setFirstVersion(JSonSchemaHelper.getSafeValue("firstVersion", rows));
        dataFormat.setLabel(JSonSchemaHelper.getSafeValue("label", rows));
        dataFormat.setDeprecated(JSonSchemaHelper.getSafeValue("deprecated", rows));
        dataFormat.setDeprecationNote(JSonSchemaHelper.getSafeValue("deprecationNote", rows));
        dataFormat.setJavaType(JSonSchemaHelper.getSafeValue("javaType", rows));
        dataFormat.setGroupId(JSonSchemaHelper.getSafeValue("groupId", rows));
        dataFormat.setArtifactId(JSonSchemaHelper.getSafeValue("artifactId", rows));
        dataFormat.setVersion(JSonSchemaHelper.getSafeValue("version", rows));
        rows = JSonSchemaHelper.parseJsonSchema("properties", json, true);
        for (Map<String, String> row : rows) {
            DataFormatOptionModel option = new DataFormatOptionModel();
            option.setName(JSonSchemaHelper.getSafeValue("name", row));
            option.setDisplayName(JSonSchemaHelper.getSafeValue("displayName", row));
            option.setKind(JSonSchemaHelper.getSafeValue("kind", row));
            option.setType(JSonSchemaHelper.getSafeValue("type", row));
            option.setJavaType(JSonSchemaHelper.getSafeValue("javaType", row));
            option.setDeprecated(JSonSchemaHelper.getSafeValue("deprecated", row));
            option.setDeprecationNote(JSonSchemaHelper.getSafeValue("deprecationNote", row));
            option.setEnumValues(JSonSchemaHelper.getSafeValue("enum", row));
            option.setDefaultValue(JSonSchemaHelper.getSafeValue("defaultValue", row));
            option.setDescription(JSonSchemaHelper.getSafeValue("description", row));
            if (dataFormatName.startsWith("bindy") && option.getName().equals("type")) {
                option.setDefaultValue("");
                String doc = option.getDescription() + " The default value is either Csv or KeyValue depending on chosen dataformat.";
                option.setDescription(doc);
            }
            if ("true".equals(option.getDeprecated())) {
                String desc = "*Deprecated* " + option.getDescription();
                option.setDescription(desc);
                if (!StringHelper.isEmpty(option.getDeprecationNote())) {
                    desc = option.getDescription();
                    desc = !desc.endsWith(".") ? desc + ". Deprecation note: " + option.getDeprecationNote() : desc + " Deprecation note: " + option.getDeprecationNote();
                    option.setDescription(desc);
                }
            }
            if ("id".equals(option.getName())) {
                this.getLog().debug((CharSequence)("Skipping option: " + option.getName()));
                continue;
            }
            dataFormat.addDataFormatOption(option);
        }
        return dataFormat;
    }

    private LanguageModel generateLanguageModel(String json) {
        List<Map<String, String>> rows = JSonSchemaHelper.parseJsonSchema("language", json, false);
        LanguageModel language = new LanguageModel();
        language.setTitle(JSonSchemaHelper.getSafeValue("title", rows));
        language.setModelName(JSonSchemaHelper.getSafeValue("modelName", rows));
        language.setName(JSonSchemaHelper.getSafeValue("name", rows));
        language.setDescription(JSonSchemaHelper.getSafeValue("description", rows));
        language.setFirstVersion(JSonSchemaHelper.getSafeValue("firstVersion", rows));
        language.setLabel(JSonSchemaHelper.getSafeValue("label", rows));
        language.setDeprecated(JSonSchemaHelper.getSafeValue("deprecated", rows));
        language.setDeprecationNote(JSonSchemaHelper.getSafeValue("deprecationNote", rows));
        language.setJavaType(JSonSchemaHelper.getSafeValue("javaType", rows));
        language.setGroupId(JSonSchemaHelper.getSafeValue("groupId", rows));
        language.setArtifactId(JSonSchemaHelper.getSafeValue("artifactId", rows));
        language.setVersion(JSonSchemaHelper.getSafeValue("version", rows));
        rows = JSonSchemaHelper.parseJsonSchema("properties", json, true);
        for (Map<String, String> row : rows) {
            LanguageOptionModel option = new LanguageOptionModel();
            option.setName(JSonSchemaHelper.getSafeValue("name", row));
            option.setDisplayName(JSonSchemaHelper.getSafeValue("displayName", row));
            option.setKind(JSonSchemaHelper.getSafeValue("kind", row));
            option.setType(JSonSchemaHelper.getSafeValue("type", row));
            option.setJavaType(JSonSchemaHelper.getSafeValue("javaType", row));
            option.setDeprecated(JSonSchemaHelper.getSafeValue("deprecated", row));
            option.setDeprecationNote(JSonSchemaHelper.getSafeValue("deprecationNote", row));
            option.setEnumValues(JSonSchemaHelper.getSafeValue("enum", row));
            option.setDefaultValue(JSonSchemaHelper.getSafeValue("defaultValue", row));
            option.setDescription(JSonSchemaHelper.getSafeValue("description", row));
            if ("true".equals(option.getDeprecated())) {
                String desc = "*Deprecated* " + option.getDescription();
                option.setDescription(desc);
                if (!StringHelper.isEmpty(option.getDeprecationNote())) {
                    desc = option.getDescription();
                    desc = !desc.endsWith(".") ? desc + ". Deprecation note: " + option.getDeprecationNote() : desc + " Deprecation note: " + option.getDeprecationNote();
                    option.setDescription(desc);
                }
            }
            if ("id".equals(option.getName()) || "expression".equals(option.getName())) {
                this.getLog().debug((CharSequence)("Skipping option: " + option.getName()));
                continue;
            }
            language.addLanguageOption(option);
        }
        return language;
    }

    private EipModel generateEipModel(String json) {
        List<Map<String, String>> rows = JSonSchemaHelper.parseJsonSchema("model", json, false);
        EipModel eip = new EipModel();
        eip.setName(JSonSchemaHelper.getSafeValue("name", rows));
        eip.setTitle(JSonSchemaHelper.getSafeValue("title", rows));
        eip.setDescription(JSonSchemaHelper.getSafeValue("description", rows));
        eip.setJavaType(JSonSchemaHelper.getSafeValue("javaType", rows));
        eip.setLabel(JSonSchemaHelper.getSafeValue("label", rows));
        eip.setDeprecated("true".equals(JSonSchemaHelper.getSafeValue("deprecated", rows)));
        eip.setDeprecationNote(JSonSchemaHelper.getSafeValue("deprecationNote", rows));
        eip.setInput("true".equals(JSonSchemaHelper.getSafeValue("input", rows)));
        eip.setOutput("true".equals(JSonSchemaHelper.getSafeValue("output", rows)));
        rows = JSonSchemaHelper.parseJsonSchema("properties", json, true);
        for (Map<String, String> row : rows) {
            String desc;
            EipOptionModel option = new EipOptionModel();
            option.setName(JSonSchemaHelper.getSafeValue("name", row));
            option.setDisplayName(JSonSchemaHelper.getSafeValue("displayName", row));
            option.setType(JSonSchemaHelper.getSafeValue("type", row));
            option.setJavaType(JSonSchemaHelper.getSafeValue("javaType", row));
            option.setRequired(JSonSchemaHelper.getSafeValue("required", row));
            option.setDeprecated("true".equals(JSonSchemaHelper.getSafeValue("deprecated", row)));
            option.setDeprecationNote(JSonSchemaHelper.getSafeValue("deprecationNote", row));
            option.setDefaultValue(JSonSchemaHelper.getSafeValue("defaultValue", row));
            option.setDescription(JSonSchemaHelper.getSafeValue("description", row));
            option.setInput("true".equals(JSonSchemaHelper.getSafeValue("input", row)));
            option.setOutput("true".equals(JSonSchemaHelper.getSafeValue("output", row)));
            if ("true".equals(option.getRequired())) {
                desc = "*Required* " + option.getDescription();
                option.setDescription(desc);
            }
            if (option.isDeprecated()) {
                desc = "*Deprecated* " + option.getDescription();
                option.setDescription(desc);
                if (!StringHelper.isEmpty(option.getDeprecationNote())) {
                    desc = option.getDescription();
                    desc = !desc.endsWith(".") ? desc + ". Deprecation note: " + option.getDeprecationNote() : desc + " Deprecation note: " + option.getDeprecationNote();
                    option.setDescription(desc);
                }
            }
            if ("id".equals(option.getName()) || "description".equals(option.getName()) || "expression".equals(option.getName()) || "outputs".equals(option.getName())) {
                this.getLog().debug((CharSequence)("Skipping option: " + option.getName()));
                continue;
            }
            eip.addEipOptionModel(option);
        }
        return eip;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String evaluateTemplate(String templateName, Object model) throws MojoExecutionException {
        try (InputStream templateStream = UpdateReadmeMojo.class.getClassLoader().getResourceAsStream(templateName);){
            String template = PackageHelper.loadText(templateStream);
            String string = (String)TemplateRuntime.eval((String)template, (Object)model, Collections.singletonMap("util", MvelHelper.INSTANCE));
            return string;
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error processing mvel template `" + templateName + "`", (Exception)e);
        }
    }

    private List<String> listDescriptorNamesOfType(String type) {
        File[] files;
        ArrayList<String> names = new ArrayList<String>();
        File f = new File(this.project.getBasedir(), "target/classes");
        if ((f = new File(f, "META-INF/services/org/apache/camel/" + type)).exists() && f.isDirectory() && (files = f.listFiles()) != null) {
            for (File file : files) {
                String name;
                if (file.isDirectory() || (name = file.getName()).charAt(0) == '.') continue;
                names.add(name);
            }
        }
        return names;
    }

    private boolean isFailFast() {
        return this.failFast != null && this.failFast != false;
    }
}

