/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.maven.packaging;

import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.TreeSet;
import org.apache.camel.maven.packaging.ErrorDetail;
import org.apache.camel.maven.packaging.PackageHelper;
import org.apache.camel.maven.packaging.StringHelper;
import org.apache.camel.maven.packaging.ValidateHelper;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.sonatype.plexus.build.incremental.BuildContext;

@Mojo(name="validate-components", threadSafe=true)
public class ValidateComponentMojo
extends AbstractMojo {
    @Parameter(property="project", required=true, readonly=true)
    protected MavenProject project;
    @Parameter(defaultValue="true")
    protected Boolean validate;
    @Parameter(defaultValue="${project.build.directory}/classes/")
    protected File outDir;
    @Component
    private MavenProjectHelper projectHelper;
    @Component
    private BuildContext buildContext;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (!this.validate.booleanValue()) {
            this.getLog().info((CharSequence)"Validation disabled");
        } else {
            TreeSet<File> jsonFiles = new TreeSet<File>();
            PackageHelper.findJsonFiles(this.outDir, jsonFiles, new CamelComponentsFileFilter());
            boolean failed = false;
            for (File file : jsonFiles) {
                String name = ValidateHelper.asName(file);
                ErrorDetail detail = new ErrorDetail();
                this.getLog().debug((CharSequence)("Validating file " + file));
                ValidateHelper.validate(file, detail);
                if (!detail.hasErrors()) continue;
                failed = true;
                this.getLog().warn((CharSequence)("The " + detail.getKind() + ": " + name + " has validation errors"));
                if (detail.isMissingDescription()) {
                    this.getLog().warn((CharSequence)("Missing description on: " + detail.getKind()));
                }
                if (detail.isMissingLabel()) {
                    this.getLog().warn((CharSequence)("Missing label on: " + detail.getKind()));
                }
                if (detail.isMissingSyntax()) {
                    this.getLog().warn((CharSequence)"Missing syntax on endpoint");
                }
                if (detail.isMissingUriPath()) {
                    this.getLog().warn((CharSequence)"Missing @UriPath on endpoint");
                }
                if (!detail.getMissingComponentDocumentation().isEmpty()) {
                    this.getLog().warn((CharSequence)("Missing component documentation for the following options:" + StringHelper.indentCollection("\n\t", detail.getMissingComponentDocumentation())));
                }
                if (detail.getMissingEndpointDocumentation().isEmpty()) continue;
                this.getLog().warn((CharSequence)("Missing endpoint documentation for the following options:" + StringHelper.indentCollection("\n\t", detail.getMissingEndpointDocumentation())));
            }
            if (failed) {
                throw new MojoFailureException("Validating failed, see errors above!");
            }
            this.getLog().info((CharSequence)"Validation complete");
        }
    }

    private class CamelComponentsFileFilter
    implements FileFilter {
        private CamelComponentsFileFilter() {
        }

        @Override
        public boolean accept(File pathname) {
            if (pathname.isDirectory() && pathname.getName().equals("model")) {
                return false;
            }
            if (pathname.isFile() && pathname.getName().endsWith(".json")) {
                try {
                    String json = PackageHelper.loadText(new FileInputStream(pathname));
                    return json != null && json.contains("\"kind\": \"component\"");
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            return pathname.isDirectory() || pathname.isFile() && pathname.getName().equals("component.properties");
        }
    }
}

