/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.maven.packaging.model;

import java.util.ArrayList;
import java.util.List;
import org.apache.camel.maven.packaging.StringHelper;
import org.apache.camel.maven.packaging.model.ComponentOptionModel;
import org.apache.camel.maven.packaging.model.EndpointOptionModel;

public class ComponentModel {
    private final boolean coreOnly;
    private String kind;
    private String scheme;
    private String syntax;
    private String alternativeSyntax;
    private String alternativeSchemes;
    private String title;
    private String description;
    private String firstVersion;
    private String label;
    private String deprecated;
    private String deprecationNote;
    private String consumerOnly;
    private String producerOnly;
    private String javaType;
    private String groupId;
    private String artifactId;
    private String version;
    private final List<ComponentOptionModel> componentOptions = new ArrayList<ComponentOptionModel>();
    private final List<EndpointOptionModel> endpointPathOptions = new ArrayList<EndpointOptionModel>();
    private final List<EndpointOptionModel> endpointOptions = new ArrayList<EndpointOptionModel>();

    public ComponentModel(boolean coreOnly) {
        this.coreOnly = coreOnly;
    }

    public String getKind() {
        return this.kind;
    }

    public void setKind(String kind) {
        this.kind = kind;
    }

    public String getScheme() {
        return this.scheme;
    }

    public void setScheme(String scheme) {
        this.scheme = scheme;
    }

    public String getSyntax() {
        return this.syntax;
    }

    public void setSyntax(String syntax) {
        this.syntax = syntax;
    }

    public String getAlternativeSyntax() {
        return this.alternativeSyntax;
    }

    public void setAlternativeSyntax(String alternativeSyntax) {
        this.alternativeSyntax = alternativeSyntax;
    }

    public String getAlternativeSchemes() {
        return this.alternativeSchemes;
    }

    public void setAlternativeSchemes(String alternativeSchemes) {
        this.alternativeSchemes = alternativeSchemes;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getFirstVersion() {
        return this.firstVersion;
    }

    public void setFirstVersion(String firstVersion) {
        this.firstVersion = firstVersion;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public String getDeprecated() {
        return this.deprecated;
    }

    public void setDeprecated(String deprecated) {
        this.deprecated = deprecated;
    }

    public String getDeprecationNote() {
        return this.deprecationNote;
    }

    public void setDeprecationNote(String deprecationNote) {
        this.deprecationNote = deprecationNote;
    }

    public String getConsumerOnly() {
        return this.consumerOnly;
    }

    public void setConsumerOnly(String consumerOnly) {
        this.consumerOnly = consumerOnly;
    }

    public String getProducerOnly() {
        return this.producerOnly;
    }

    public void setProducerOnly(String producerOnly) {
        this.producerOnly = producerOnly;
    }

    public String getJavaType() {
        return this.javaType;
    }

    public void setJavaType(String javaType) {
        this.javaType = javaType;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public void setArtifactId(String artifactId) {
        this.artifactId = artifactId;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public List<ComponentOptionModel> getComponentOptions() {
        return this.componentOptions;
    }

    public void addComponentOption(ComponentOptionModel option) {
        this.componentOptions.add(option);
    }

    public List<EndpointOptionModel> getEndpointOptions() {
        return this.endpointOptions;
    }

    public List<EndpointOptionModel> getEndpointPathOptions() {
        return this.endpointPathOptions;
    }

    public void addEndpointOption(EndpointOptionModel option) {
        this.endpointOptions.add(option);
    }

    public void addEndpointPathOption(EndpointOptionModel option) {
        this.endpointPathOptions.add(option);
    }

    public String getShortJavaType() {
        return StringHelper.getClassShortName(this.javaType);
    }

    public String getDocLink() {
        if ("camel-as2".equals(this.artifactId)) {
            return "camel-as2/camel-as2-component/src/main/docs/";
        }
        if ("camel-box".equals(this.artifactId)) {
            return "camel-box/camel-box-component/src/main/docs/";
        }
        if ("camel-fhir".equals(this.artifactId)) {
            return "camel-fhir/camel-fhir-component/src/main/docs/";
        }
        if ("camel-linkedin".equals(this.artifactId)) {
            return "camel-linkedin/camel-linkedin-component/src/main/docs/";
        }
        if ("camel-olingo2".equals(this.artifactId)) {
            return "camel-olingo2/camel-olingo2-component/src/main/docs/";
        }
        if ("camel-olingo4".equals(this.artifactId)) {
            return "camel-olingo4/camel-olingo4-component/src/main/docs/";
        }
        if ("camel-salesforce".equals(this.artifactId)) {
            return "camel-salesforce/camel-salesforce-component/src/main/docs/";
        }
        if ("camel-servicenow".equals(this.artifactId)) {
            return "camel-servicenow/camel-servicenow-component/src/main/docs/";
        }
        if ("camel-debezium".equals(this.artifactId)) {
            return "camel-debezium/camel-debezium-component/src/main/docs/";
        }
        if ("camel-core".equals(this.artifactId)) {
            return this.coreOnly ? "src/main/docs/" : "../core/camel-core-engine/src/main/docs/";
        }
        return this.artifactId + "/src/main/docs/";
    }

    public String getFirstVersionShort() {
        return StringHelper.cutLastZeroDigit(this.firstVersion);
    }
}

