/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.maven.packaging.srcgen;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.camel.maven.packaging.srcgen.Annotation;
import org.apache.camel.maven.packaging.srcgen.GenericType;
import org.apache.camel.maven.packaging.srcgen.Javadoc;
import org.apache.camel.maven.packaging.srcgen.Param;

public class Method {
    String name;
    GenericType returnType;
    boolean isDefault;
    boolean isPublic;
    boolean isProtected;
    boolean isStatic;
    boolean isConstructor;
    String body;
    List<Param> parameters = new ArrayList<Param>();
    List<GenericType> exceptions = new ArrayList<GenericType>();
    List<Annotation> annotations = new ArrayList<Annotation>();
    Javadoc javadoc = new Javadoc();

    public Method setPublic() {
        this.isPublic = true;
        this.isProtected = false;
        return this;
    }

    public Method setProtected() {
        this.isPublic = false;
        this.isProtected = true;
        return this;
    }

    public Method setStatic() {
        this.isStatic = true;
        return this;
    }

    public Method setDefault() {
        this.isDefault = true;
        return this;
    }

    public String getName() {
        return this.name;
    }

    public Method setName(String name) {
        this.name = name;
        return this;
    }

    public GenericType getReturnType() {
        return this.returnType;
    }

    public Method setReturnType(Type returnType) {
        return this.setReturnType(new GenericType(returnType));
    }

    public Method setReturnType(GenericType returnType) {
        this.returnType = returnType;
        return this;
    }

    public Method addParameter(Class<?> type, String name) {
        return this.addParameter(new GenericType(type), name);
    }

    public Method addParameter(GenericType type, String name) {
        this.parameters.add(new Param(type, name));
        return this;
    }

    public String getBody() {
        return this.body;
    }

    public Method setBody(String body) {
        this.body = body;
        return this;
    }

    public Method addThrows(Class<?> type) {
        return this.addThrows(new GenericType(type));
    }

    public Method addThrows(GenericType type) {
        this.exceptions.add(type);
        return this;
    }

    public Annotation addAnnotation(Class<? extends java.lang.annotation.Annotation> clazz) {
        Annotation ann = new Annotation(clazz);
        this.annotations.add(ann);
        return ann;
    }

    public boolean hasAnnotation(Class<? extends java.lang.annotation.Annotation> clazz) {
        return this.annotations.stream().map(Annotation::getType).anyMatch(clazz::equals);
    }

    public Annotation getAnnotation(Class<? extends java.lang.annotation.Annotation> clazz) {
        return this.annotations.stream().filter(a -> Objects.equals(a.getType(), clazz)).findAny().orElse(null);
    }

    public Javadoc getJavaDoc() {
        return this.javadoc;
    }

    public Method setConstructor(boolean cns) {
        this.isConstructor = cns;
        return this;
    }

    public boolean hasJavaDoc() {
        return this.javadoc.text != null;
    }
}

