/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.maven.packaging;

import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Pattern;
import org.apache.camel.maven.packaging.PackageHelper;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;

@Mojo(name="prepare-catalog-springboot", threadSafe=true)
public class PrepareCatalogSpringBootMojo
extends AbstractMojo {
    public static final int BUFFER_SIZE = 131072;
    private static final Pattern ARTIFACT_PATTERN = Pattern.compile("\"artifactId\": \"camel-(.*)\"");
    @Parameter(property="project", required=true, readonly=true)
    protected MavenProject project;
    @Parameter(defaultValue="${project.build.directory}/classes/org/apache/camel/catalog/springboot/components")
    protected File componentsOutDir;
    @Parameter(defaultValue="${project.build.directory}/classes/org/apache/camel/catalog/springboot/dataformats")
    protected File dataFormatsOutDir;
    @Parameter(defaultValue="${project.build.directory}/classes/org/apache/camel/catalog/springboot/languages")
    protected File languagesOutDir;
    @Parameter(defaultValue="${project.build.directory}/classes/org/apache/camel/catalog/springboot/others")
    protected File othersOutDir;
    @Parameter(defaultValue="${project.build.directory}/../../../platforms/spring-boot/components-starter")
    protected File componentsStarterDir;
    @Parameter(defaultValue="${project.build.directory}/../../../components")
    protected File componentsDir;
    @Parameter(defaultValue="${project.build.directory}/../../../core/camel-core-engine")
    protected File coreDir;
    @Parameter(defaultValue="${project.build.directory}/../../../core/camel-base")
    protected File baseDir;
    @Component
    private MavenProjectHelper projectHelper;

    public void execute() throws MojoExecutionException, MojoFailureException {
        Set<String> starters = this.findSpringBootStarters();
        this.executeComponents(starters);
        this.executeDataFormats(starters);
        this.executeLanguages(starters);
        this.executeOthers(starters);
    }

    protected void executeComponents(Set<String> starters) throws MojoExecutionException, MojoFailureException {
        File[] components;
        this.getLog().info((CharSequence)"Copying all Camel component json descriptors");
        TreeSet<File> jsonFiles = new TreeSet<File>();
        TreeSet<File> componentFiles = new TreeSet<File>();
        if (this.componentsDir != null && this.componentsDir.isDirectory() && (components = this.componentsDir.listFiles()) != null) {
            for (File dir : components) {
                if (!dir.isDirectory() || "target".equals(dir.getName())) continue;
                File target = new File(dir, "target/classes");
                if (!starters.contains(dir.getName())) continue;
                if ("camel-as2".equals(dir.getName())) {
                    target = new File(dir, "camel-as2-component/target/classes");
                } else if ("camel-box".equals(dir.getName())) {
                    target = new File(dir, "camel-box-component/target/classes");
                } else if ("camel-salesforce".equals(dir.getName())) {
                    target = new File(dir, "camel-salesforce-component/target/classes");
                } else if ("camel-servicenow".equals(dir.getName())) {
                    target = new File(dir, "camel-servicenow-component/target/classes");
                } else {
                    boolean active;
                    File src = new File(dir, "src");
                    boolean bl = active = src.isDirectory() && src.exists();
                    if (!active) continue;
                }
                this.findComponentFilesRecursive(target, jsonFiles, componentFiles, new CamelComponentsFileFilter());
            }
        }
        if (this.coreDir != null && this.coreDir.isDirectory()) {
            File target = new File(this.coreDir, "target/classes");
            this.findComponentFilesRecursive(target, jsonFiles, componentFiles, new CamelComponentsFileFilter());
        }
        this.getLog().info((CharSequence)("Found " + componentFiles.size() + " component.properties files"));
        this.getLog().info((CharSequence)("Found " + jsonFiles.size() + " component json files"));
        this.componentsOutDir.mkdirs();
        for (File file : jsonFiles) {
            try {
                String text = PackageHelper.loadText(new FileInputStream(file));
                text = ARTIFACT_PATTERN.matcher(text).replaceFirst("\"artifactId\": \"camel-$1-starter\"");
                File to = new File(this.componentsOutDir, file.getName());
                FileOutputStream fos = new FileOutputStream(to, false);
                fos.write(text.getBytes());
                fos.close();
            }
            catch (IOException e) {
                throw new MojoFailureException("Cannot write json file " + file, (Throwable)e);
            }
        }
        File all = new File(this.componentsOutDir, "../components.properties");
        try {
            FileOutputStream fos = new FileOutputStream(all, false);
            String[] names = this.componentsOutDir.list();
            ArrayList<String> components2 = new ArrayList<String>();
            for (String name : names) {
                if (!name.endsWith(".json")) continue;
                String componentName = name.substring(0, name.length() - 5);
                components2.add(componentName);
            }
            Collections.sort(components2);
            for (String name : components2) {
                fos.write(name.getBytes());
                fos.write("\n".getBytes());
            }
            fos.close();
        }
        catch (IOException e) {
            throw new MojoFailureException("Error writing to file " + all);
        }
    }

    protected void executeDataFormats(Set<String> starters) throws MojoExecutionException, MojoFailureException {
        File[] dataFormats;
        this.getLog().info((CharSequence)"Copying all Camel dataformat json descriptors");
        TreeSet<File> jsonFiles = new TreeSet<File>();
        TreeSet<File> dataFormatFiles = new TreeSet<File>();
        if (this.componentsDir != null && this.componentsDir.isDirectory() && (dataFormats = this.componentsDir.listFiles()) != null) {
            for (File dir : dataFormats) {
                boolean active;
                if (!dir.isDirectory() || "target".equals(dir.getName()) || !starters.contains(dir.getName())) continue;
                File src = new File(dir, "src");
                boolean bl = active = src.isDirectory() && src.exists();
                if (!active) continue;
                File target = new File(dir, "target/classes");
                this.findDataFormatFilesRecursive(target, jsonFiles, dataFormatFiles, new CamelDataFormatsFileFilter());
            }
        }
        if (this.coreDir != null && this.coreDir.isDirectory()) {
            File target = new File(this.coreDir, "target/classes");
            this.findDataFormatFilesRecursive(target, jsonFiles, dataFormatFiles, new CamelDataFormatsFileFilter());
        }
        this.getLog().info((CharSequence)("Found " + dataFormatFiles.size() + " dataformat.properties files"));
        this.getLog().info((CharSequence)("Found " + jsonFiles.size() + " dataformat json files"));
        this.dataFormatsOutDir.mkdirs();
        for (File file : jsonFiles) {
            try {
                String text = PackageHelper.loadText(new FileInputStream(file));
                text = ARTIFACT_PATTERN.matcher(text).replaceFirst("\"artifactId\": \"camel-$1-starter\"");
                File to = new File(this.dataFormatsOutDir, file.getName());
                FileOutputStream fos = new FileOutputStream(to, false);
                fos.write(text.getBytes());
                fos.close();
            }
            catch (IOException e) {
                throw new MojoFailureException("Cannot write json file " + file, (Throwable)e);
            }
        }
        File all = new File(this.dataFormatsOutDir, "../dataformats.properties");
        try {
            FileOutputStream fos = new FileOutputStream(all, false);
            String[] names = this.dataFormatsOutDir.list();
            ArrayList<String> dataFormats2 = new ArrayList<String>();
            for (String name : names) {
                if (!name.endsWith(".json")) continue;
                String dataFormatName = name.substring(0, name.length() - 5);
                dataFormats2.add(dataFormatName);
            }
            Collections.sort(dataFormats2);
            for (String name : dataFormats2) {
                fos.write(name.getBytes());
                fos.write("\n".getBytes());
            }
            fos.close();
        }
        catch (IOException e) {
            throw new MojoFailureException("Error writing to file " + all);
        }
    }

    protected void executeLanguages(Set<String> starters) throws MojoExecutionException, MojoFailureException {
        File[] languages;
        this.getLog().info((CharSequence)"Copying all Camel language json descriptors");
        TreeSet<File> jsonFiles = new TreeSet<File>();
        TreeSet<File> languageFiles = new TreeSet<File>();
        if (this.componentsDir != null && this.componentsDir.isDirectory() && (languages = this.componentsDir.listFiles()) != null) {
            for (File dir : languages) {
                boolean active;
                if (!starters.contains(dir.getName())) continue;
                File src = new File(dir, "src");
                boolean bl = active = src.isDirectory() && src.exists();
                if (!active || !dir.isDirectory() || "target".equals(dir.getName())) continue;
                File target = new File(dir, "target/classes");
                this.findLanguageFilesRecursive(target, jsonFiles, languageFiles, new CamelLanguagesFileFilter());
            }
        }
        if (this.baseDir != null && this.baseDir.isDirectory()) {
            Object target = new File(this.baseDir, "target/classes");
            this.findLanguageFilesRecursive((File)target, jsonFiles, languageFiles, new CamelLanguagesFileFilter());
            target = new File(this.coreDir, "../camel-jaxp/target/classes");
            this.findLanguageFilesRecursive((File)target, jsonFiles, languageFiles, new CamelLanguagesFileFilter());
        }
        this.getLog().info((CharSequence)("Found " + languageFiles.size() + " language.properties files"));
        this.getLog().info((CharSequence)("Found " + jsonFiles.size() + " language json files"));
        this.languagesOutDir.mkdirs();
        for (File file : jsonFiles) {
            try {
                String text = PackageHelper.loadText(new FileInputStream(file));
                text = ARTIFACT_PATTERN.matcher(text).replaceFirst("\"artifactId\": \"camel-$1-starter\"");
                File to = new File(this.languagesOutDir, file.getName());
                FileOutputStream fos = new FileOutputStream(to, false);
                fos.write(text.getBytes());
                fos.close();
            }
            catch (IOException e) {
                throw new MojoFailureException("Cannot write json file " + file, (Throwable)e);
            }
        }
        File all = new File(this.languagesOutDir, "../languages.properties");
        try {
            FileOutputStream fos = new FileOutputStream(all, false);
            String[] names = this.languagesOutDir.list();
            ArrayList<String> languages2 = new ArrayList<String>();
            for (String name : names) {
                if (!name.endsWith(".json")) continue;
                String languageName = name.substring(0, name.length() - 5);
                languages2.add(languageName);
            }
            Collections.sort(languages2);
            for (String name : languages2) {
                fos.write(name.getBytes());
                fos.write("\n".getBytes());
            }
            fos.close();
        }
        catch (IOException e) {
            throw new MojoFailureException("Error writing to file " + all);
        }
    }

    protected void executeOthers(Set<String> starters) throws MojoExecutionException, MojoFailureException {
        Object others;
        this.getLog().info((CharSequence)"Copying all Camel other json descriptors");
        TreeSet<File> jsonFiles = new TreeSet<File>();
        TreeSet<File> otherFiles = new TreeSet<File>();
        if (this.componentsDir != null && this.componentsDir.isDirectory() && (others = this.componentsDir.listFiles()) != null) {
            for (File dir : others) {
                boolean active;
                if (!starters.contains(dir.getName())) continue;
                int special = "camel-core-osgi".equals(dir.getName()) || "camel-core-xml".equals(dir.getName()) || "camel-http-common".equals(dir.getName()) || "camel-jetty-common".equals(dir.getName()) ? 1 : 0;
                boolean special2 = "camel-as2".equals(dir.getName()) || "camel-box".equals(dir.getName()) || "camel-olingo2".equals(dir.getName()) || "camel-olingo4".equals(dir.getName()) || "camel-servicenow".equals(dir.getName()) || "camel-salesforce".equals(dir.getName());
                boolean special3 = "camel-debezium-common".equals(dir.getName());
                if (special != 0 || special2 || special3) continue;
                File src = new File(dir, "src");
                boolean bl = active = src.isDirectory() && src.exists();
                if (!active || !dir.isDirectory() || "target".equals(dir.getName())) continue;
                File target = new File(dir, "target/classes");
                this.findOtherFilesRecursive(target, jsonFiles, otherFiles, new CamelOthersFileFilter());
            }
        }
        this.getLog().info((CharSequence)("Found " + otherFiles.size() + " other.properties files"));
        this.getLog().info((CharSequence)("Found " + jsonFiles.size() + " other json files"));
        this.othersOutDir.mkdirs();
        for (File file : jsonFiles) {
            try {
                String text = PackageHelper.loadText(new FileInputStream(file));
                text = ARTIFACT_PATTERN.matcher(text).replaceFirst("\"artifactId\": \"camel-$1-starter\"");
                File to = new File(this.othersOutDir, file.getName());
                FileOutputStream fos = new FileOutputStream(to, false);
                fos.write(text.getBytes());
                fos.close();
            }
            catch (IOException e) {
                throw new MojoFailureException("Cannot write json file " + file, (Throwable)e);
            }
        }
        File all = new File(this.othersOutDir, "../others.properties");
        try {
            FileOutputStream fos = new FileOutputStream(all, false);
            String[] names = this.othersOutDir.list();
            ArrayList<String> others2 = new ArrayList<String>();
            for (String name : names) {
                if (!name.endsWith(".json")) continue;
                String otherName = name.substring(0, name.length() - 5);
                others2.add(otherName);
            }
            Collections.sort(others2);
            for (String name : others2) {
                fos.write(name.getBytes());
                fos.write("\n".getBytes());
            }
            fos.close();
        }
        catch (IOException e) {
            throw new MojoFailureException("Error writing to file " + all);
        }
    }

    private void findComponentFilesRecursive(File dir, Set<File> found, Set<File> components, FileFilter filter) {
        File[] files = dir.listFiles(filter);
        if (files != null) {
            for (File file : files) {
                boolean componentFile;
                boolean rootDir = "classes".equals(dir.getName()) || "META-INF".equals(dir.getName());
                boolean jsonFile = !rootDir && file.isFile() && file.getName().endsWith(".json");
                boolean bl = componentFile = !rootDir && file.isFile() && file.getName().equals("component.properties");
                if (jsonFile) {
                    found.add(file);
                    continue;
                }
                if (componentFile) {
                    components.add(file);
                    continue;
                }
                if (!file.isDirectory()) continue;
                this.findComponentFilesRecursive(file, found, components, filter);
            }
        }
    }

    private void findDataFormatFilesRecursive(File dir, Set<File> found, Set<File> dataFormats, FileFilter filter) {
        File[] files = dir.listFiles(filter);
        if (files != null) {
            for (File file : files) {
                boolean dataFormatFile;
                boolean rootDir = "classes".equals(dir.getName()) || "META-INF".equals(dir.getName());
                boolean jsonFile = !rootDir && file.isFile() && file.getName().endsWith(".json");
                boolean bl = dataFormatFile = !rootDir && file.isFile() && file.getName().equals("dataformat.properties");
                if (jsonFile) {
                    found.add(file);
                    continue;
                }
                if (dataFormatFile) {
                    dataFormats.add(file);
                    continue;
                }
                if (!file.isDirectory()) continue;
                this.findDataFormatFilesRecursive(file, found, dataFormats, filter);
            }
        }
    }

    private void findLanguageFilesRecursive(File dir, Set<File> found, Set<File> languages, FileFilter filter) {
        File[] files = dir.listFiles(filter);
        if (files != null) {
            for (File file : files) {
                boolean languageFile;
                boolean rootDir = "classes".equals(dir.getName()) || "META-INF".equals(dir.getName());
                boolean jsonFile = !rootDir && file.isFile() && file.getName().endsWith(".json");
                boolean bl = languageFile = !rootDir && file.isFile() && file.getName().equals("language.properties");
                if (jsonFile) {
                    found.add(file);
                    continue;
                }
                if (languageFile) {
                    languages.add(file);
                    continue;
                }
                if (!file.isDirectory()) continue;
                this.findLanguageFilesRecursive(file, found, languages, filter);
            }
        }
    }

    private void findOtherFilesRecursive(File dir, Set<File> found, Set<File> others, FileFilter filter) {
        File[] files = dir.listFiles(filter);
        if (files != null) {
            for (File file : files) {
                boolean otherFile;
                boolean rootDir = "classes".equals(dir.getName()) || "META-INF".equals(dir.getName());
                boolean jsonFile = rootDir && file.isFile() && file.getName().endsWith(".json");
                boolean bl = otherFile = !rootDir && file.isFile() && file.getName().equals("other.properties");
                if (jsonFile) {
                    found.add(file);
                    continue;
                }
                if (otherFile) {
                    others.add(file);
                    continue;
                }
                if (!file.isDirectory()) continue;
                this.findOtherFilesRecursive(file, found, others, filter);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFile(File from, File to) throws IOException {
        FileChannel in = null;
        FileChannel out = null;
        try (FileInputStream fis = new FileInputStream(from);
             FileOutputStream fos = new FileOutputStream(to);){
            try {
                in = fis.getChannel();
                out = fos.getChannel();
                long size = in.size();
                for (long position = 0L; position < size; position += in.transferTo(position, 131072L, out)) {
                }
            }
            finally {
                if (in != null) {
                    in.close();
                }
                if (out != null) {
                    out.close();
                }
            }
        }
    }

    private Set<String> findSpringBootStarters() {
        LinkedHashSet<String> answer = new LinkedHashSet<String>();
        String[] names = this.componentsStarterDir.list();
        if (names != null) {
            for (String name : names) {
                if (!name.startsWith("camel-") || !name.endsWith("-starter")) continue;
                String regular = name.substring(0, name.length() - 8);
                answer.add(regular);
            }
        }
        this.getLog().info((CharSequence)("Found " + answer.size() + " Camel Spring Boot starters from: " + this.componentsStarterDir));
        return answer;
    }

    private class CamelOthersFileFilter
    implements FileFilter {
        private CamelOthersFileFilter() {
        }

        @Override
        public boolean accept(File pathname) {
            if (pathname.isFile() && pathname.getName().endsWith(".json")) {
                try {
                    String json = PackageHelper.loadText(new FileInputStream(pathname));
                    return json != null && json.contains("\"kind\": \"other\"");
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            return pathname.isDirectory() || pathname.isFile() && pathname.getName().equals("other.properties");
        }
    }

    private class CamelLanguagesFileFilter
    implements FileFilter {
        private CamelLanguagesFileFilter() {
        }

        @Override
        public boolean accept(File pathname) {
            if (pathname.isDirectory() && pathname.getName().equals("model")) {
                return false;
            }
            if (pathname.isFile() && pathname.getName().endsWith(".json")) {
                try {
                    String json = PackageHelper.loadText(new FileInputStream(pathname));
                    return json != null && json.contains("\"kind\": \"language\"");
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            return pathname.isDirectory() || pathname.isFile() && pathname.getName().equals("language.properties");
        }
    }

    private class CamelDataFormatsFileFilter
    implements FileFilter {
        private CamelDataFormatsFileFilter() {
        }

        @Override
        public boolean accept(File pathname) {
            if (pathname.isDirectory() && pathname.getName().equals("model")) {
                return false;
            }
            if (pathname.isFile() && pathname.getName().endsWith(".json")) {
                try {
                    String json = PackageHelper.loadText(new FileInputStream(pathname));
                    return json != null && json.contains("\"kind\": \"dataformat\"");
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            return pathname.isDirectory() || pathname.isFile() && pathname.getName().equals("dataformat.properties");
        }
    }

    private class CamelComponentsFileFilter
    implements FileFilter {
        private CamelComponentsFileFilter() {
        }

        @Override
        public boolean accept(File pathname) {
            if (pathname.isDirectory() && pathname.getName().equals("model")) {
                return false;
            }
            if (pathname.isFile() && pathname.getName().endsWith(".json")) {
                try {
                    String json = PackageHelper.loadText(new FileInputStream(pathname));
                    return json != null && json.contains("\"kind\": \"component\"");
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            return pathname.isDirectory() || pathname.isFile() && pathname.getName().equals("component.properties");
        }
    }
}

