/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.maven.packaging;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;
import org.apache.camel.maven.packaging.PackageHelper;
import org.apache.camel.maven.packaging.StringHelper;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;

@Mojo(name="prepare-parent-pom", threadSafe=true)
public class PrepareParentPomMojo
extends AbstractMojo {
    @Parameter(property="project", required=true, readonly=true)
    protected MavenProject project;
    @Parameter(defaultValue="${project.build.directory}/../../../parent/pom.xml")
    protected File parentPom;
    @Parameter(defaultValue="${project.build.directory}/../../../components")
    protected File componentsDir;
    @Parameter(defaultValue="${project.build.directory}/../../../platforms/spring-boot/components-starter")
    protected File startersDir;
    @Component
    private MavenProjectHelper projectHelper;

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.updateParentPom("org.apache.camel", this.componentsDir, "camel components");
        this.updateParentPom("org.apache.camel.springboot", this.startersDir, "camel starters");
    }

    protected void updateParentPom(String groupId, File dir, String token) throws MojoExecutionException, MojoFailureException {
        TreeSet<String> artifactIds = new TreeSet<String>();
        try {
            HashSet<File> poms = new HashSet<File>();
            this.findComponentPoms(dir, poms);
            for (File pom : poms) {
                String aid = this.asArtifactId(pom);
                if (aid == null) continue;
                artifactIds.add(aid);
            }
        }
        catch (IOException e) {
            throw new MojoFailureException("Error due " + e.getMessage(), (Throwable)e);
        }
        this.getLog().debug((CharSequence)("ArtifactIds: " + artifactIds));
        StringBuilder sb = new StringBuilder();
        for (String aid : artifactIds) {
            sb.append("      <dependency>\n");
            sb.append("        <groupId>" + groupId + "</groupId>\n");
            sb.append("        <artifactId>" + aid + "</artifactId>\n");
            sb.append("        <version>${project.version}</version>\n");
            sb.append("      </dependency>\n");
        }
        String changed = sb.toString();
        boolean updated = this.updateParentPom(this.parentPom, token, changed);
        if (updated) {
            this.getLog().info((CharSequence)"Updated parent/pom.xml file");
        } else {
            this.getLog().debug((CharSequence)"No changes to parent/pom.xml file");
        }
        this.getLog().info((CharSequence)("parent/pom.xml contains " + artifactIds.size() + " " + token + " dependencies"));
    }

    private void findComponentPoms(File parentDir, Set<File> components) {
        File[] files = parentDir.listFiles();
        if (files != null) {
            for (File file : files) {
                if (file.isDirectory() && file.getName().startsWith("camel-")) {
                    this.findComponentPoms(file, components);
                    continue;
                }
                if (!parentDir.getName().startsWith("camel-") || !file.getName().equals("pom.xml")) continue;
                components.add(file);
            }
        }
    }

    private String asArtifactId(File pom) throws IOException {
        String text = PackageHelper.loadText(new FileInputStream(pom));
        if ((text = PackageHelper.after(text, "</parent>")) != null) {
            text = StringHelper.between(text, "<artifactId>", "</artifactId>");
            return text;
        }
        return null;
    }

    private boolean updateParentPom(File file, String token, String changed) throws MojoExecutionException {
        String start = "<!-- " + token + ": START -->";
        String end = "<!-- " + token + ": END -->";
        if (!file.exists()) {
            return false;
        }
        try {
            String text = PackageHelper.loadText(new FileInputStream(file));
            String existing = StringHelper.between(text, start, end);
            if (existing != null) {
                if ((existing = existing.trim()).equals(changed = changed.trim())) {
                    return false;
                }
                String before = StringHelper.before(text, start);
                String after = StringHelper.after(text, end);
                text = before + start + "\n      " + changed + "\n      " + end + after;
                PackageHelper.writeText(file, text);
                return true;
            }
            return false;
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error reading file " + file + " Reason: " + e, e);
        }
    }
}

