/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.maven.packaging.model;

import org.apache.camel.maven.packaging.StringHelper;

public class EipOptionModel {
    private String name;
    private String displayName;
    private String title;
    private String required;
    private String javaType;
    private String type;
    private String label;
    private String defaultValue;
    private String description;
    private boolean deprecated;
    private String deprecationNote;
    private boolean input;
    private boolean output;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getJavaType() {
        return this.javaType;
    }

    public void setJavaType(String javaType) {
        this.javaType = javaType;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getRequired() {
        return this.required;
    }

    public void setRequired(String required) {
        this.required = required;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public boolean isDeprecated() {
        return this.deprecated;
    }

    public void setDeprecated(boolean deprecated) {
        this.deprecated = deprecated;
    }

    public String getDeprecationNote() {
        return this.deprecationNote;
    }

    public void setDeprecationNote(String deprecationNote) {
        this.deprecationNote = deprecationNote;
    }

    public boolean isInput() {
        return this.input;
    }

    public void setInput(boolean input) {
        this.input = input;
    }

    public String getInput() {
        return this.input ? "true" : "false";
    }

    public boolean isOutput() {
        return this.output;
    }

    public void setOutput(boolean output) {
        this.output = output;
    }

    public String getOutput() {
        return this.output ? "true" : "false";
    }

    public String getShortJavaType() {
        return StringHelper.getClassShortName(this.javaType);
    }

    @Deprecated
    public String getShortJavaType(int watermark) {
        String text = StringHelper.getClassShortName(this.javaType);
        if ("object".equals(this.type)) {
            text = StringHelper.wrapCamelCaseWords(text, watermark, " ");
        }
        return text;
    }

    public String getShortDefaultValue(int watermark) {
        if (this.defaultValue.isEmpty()) {
            return "";
        }
        String text = this.defaultValue;
        if (text.endsWith("<T>")) {
            text = text.substring(0, text.length() - 3);
        } else if (text.endsWith("<T>>")) {
            text = text.substring(0, text.length() - 4);
        }
        return text;
    }

    public String getShortName(int watermark) {
        String text = StringHelper.wrapCamelCaseWords(this.name, watermark, " ");
        return Character.toLowerCase(text.charAt(0)) + text.substring(1);
    }
}

