/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.maven.packaging.srcgen;

import java.lang.reflect.Array;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public class GenericType {
    private static final GenericType ALL = new GenericType((Type)((Object)Object.class));
    private static final GenericType[] EMPTY = new GenericType[0];
    private static final Map<String, Class> PRIMITIVE_CLASSES = new HashMap<String, Class>();
    private final Class clazz;
    private GenericType[] parameters;
    private BoundType boundType;

    public GenericType(Type type) {
        this(GenericType.getConcreteClass(type), GenericType.parametersOf(type));
    }

    public GenericType(Class clazz, GenericType ... parameters) {
        this(clazz, BoundType.Exact, parameters);
    }

    public GenericType(Class clazz, BoundType boundType, GenericType ... parameters) {
        this.clazz = clazz;
        this.parameters = parameters;
        this.boundType = boundType;
    }

    public static GenericType parse(String type, ClassLoader loader) throws ClassNotFoundException, IllegalArgumentException {
        if ((type = type.trim()).endsWith("[]")) {
            GenericType t = GenericType.parse(type.substring(0, type.length() - 2), loader);
            return new GenericType(Array.newInstance(t.getRawClass(), 0).getClass(), t);
        }
        int genericIndex = type.indexOf(60);
        if (genericIndex > 0) {
            if (!type.endsWith(">")) {
                throw new IllegalArgumentException("Can not load type: " + type);
            }
            GenericType base = GenericType.parse(type.substring(0, genericIndex), loader);
            String[] params = type.substring(genericIndex + 1, type.length() - 1).split(",");
            GenericType[] types = new GenericType[params.length];
            for (int i = 0; i < params.length; ++i) {
                types[i] = GenericType.parse(params[i], loader);
            }
            return new GenericType(base.getRawClass(), types);
        }
        if (GenericType.isPrimitive(type)) {
            return new GenericType(PRIMITIVE_CLASSES.get(type));
        }
        if (type.startsWith("? extends ")) {
            String raw = type.substring("? extends ".length());
            return new GenericType(GenericType.loadClass(loader, raw), BoundType.Extends, new GenericType[0]);
        }
        if (type.startsWith("? super ")) {
            String raw = type.substring("? extends ".length());
            return new GenericType(GenericType.loadClass(loader, raw), BoundType.Super, new GenericType[0]);
        }
        if (type.equals("?")) {
            return new GenericType(Object.class, BoundType.Extends, new GenericType[0]);
        }
        if (loader != null) {
            return new GenericType(GenericType.loadClass(loader, type));
        }
        throw new IllegalArgumentException("Unsupported loader: " + loader);
    }

    static boolean isPrimitive(String type) {
        return PRIMITIVE_CLASSES.containsKey(type);
    }

    private static Class<?> loadClass(ClassLoader loader, String loadClassName) throws ClassNotFoundException {
        Class<?> optionClass;
        String org = loadClassName;
        while (true) {
            try {
                optionClass = loader.loadClass(loadClassName);
            }
            catch (ClassNotFoundException e) {
                int dotIndex = loadClassName.lastIndexOf(46);
                if (dotIndex == -1) {
                    throw new ClassNotFoundException(org);
                }
                loadClassName = loadClassName.substring(0, dotIndex) + "$" + loadClassName.substring(dotIndex + 1);
                continue;
            }
            break;
        }
        return optionClass;
    }

    public Class<?> getRawClass() {
        return this.clazz;
    }

    public GenericType getActualTypeArgument(int i) {
        if (this.parameters.length == 0) {
            return ALL;
        }
        return this.parameters[i];
    }

    public int size() {
        return this.parameters.length;
    }

    public String toString() {
        if (this.parameters.length == 0 && this.boundType == BoundType.Extends && this.clazz == Object.class) {
            return "?";
        }
        StringBuilder sb = new StringBuilder();
        if (this.boundType == BoundType.Extends) {
            sb.append("? extends ");
        } else if (this.boundType == BoundType.Super) {
            sb.append("? super ");
        }
        Class<?> cl = this.getRawClass();
        if (cl.isArray()) {
            if (this.parameters.length > 0) {
                return this.parameters[0].toString() + "[]";
            }
            return cl.getComponentType().getName() + "[]";
        }
        sb.append(cl.getName());
        if (this.parameters.length > 0) {
            sb.append("<");
            for (int i = 0; i < this.parameters.length; ++i) {
                if (i > 0) {
                    sb.append(", ");
                }
                sb.append(this.parameters[i].toString());
            }
            sb.append(">");
        }
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.boundType == null ? 0 : this.boundType.hashCode());
        result = 31 * result + (this.clazz == null ? 0 : this.clazz.hashCode());
        result = 31 * result + Arrays.hashCode(this.parameters);
        return result;
    }

    public boolean equals(Object object) {
        if (!(object instanceof GenericType)) {
            return false;
        }
        GenericType other = (GenericType)object;
        if (this.getRawClass() != other.getRawClass()) {
            return false;
        }
        if (this.boundType != other.boundType) {
            return false;
        }
        if (this.parameters == null) {
            return other.parameters == null;
        }
        if (other.parameters == null) {
            return false;
        }
        if (this.parameters.length != other.parameters.length) {
            return false;
        }
        for (int i = 0; i < this.parameters.length; ++i) {
            if (this.parameters[i].equals(other.parameters[i])) continue;
            return false;
        }
        return true;
    }

    static GenericType bound(GenericType type) {
        if (type.boundType != BoundType.Exact) {
            return new GenericType(type.getRawClass(), BoundType.Exact, type.parameters);
        }
        return type;
    }

    static BoundType boundType(GenericType type) {
        return type.boundType;
    }

    static BoundType boundType(Type type) {
        if (type instanceof WildcardType) {
            WildcardType wct = (WildcardType)type;
            return wct.getLowerBounds().length == 0 ? BoundType.Extends : BoundType.Super;
        }
        return BoundType.Exact;
    }

    static GenericType[] parametersOf(Type type) {
        if (type instanceof Class) {
            Class clazz = (Class)type;
            if (clazz.isArray()) {
                GenericType t = new GenericType(clazz.getComponentType());
                if (t.size() > 0) {
                    return new GenericType[]{t};
                }
                return EMPTY;
            }
            return EMPTY;
        }
        if (type instanceof ParameterizedType) {
            ParameterizedType pt = (ParameterizedType)type;
            Type[] parameters = pt.getActualTypeArguments();
            GenericType[] gts = new GenericType[parameters.length];
            for (int i = 0; i < gts.length; ++i) {
                gts[i] = new GenericType(parameters[i]);
            }
            return gts;
        }
        if (type instanceof GenericArrayType) {
            return new GenericType[]{new GenericType(((GenericArrayType)type).getGenericComponentType())};
        }
        if (type instanceof WildcardType) {
            return EMPTY;
        }
        throw new IllegalStateException();
    }

    static Class<?> getConcreteClass(Type type) {
        Type ntype = GenericType.collapse(type);
        if (ntype instanceof Class) {
            return (Class)ntype;
        }
        if (ntype instanceof ParameterizedType) {
            return GenericType.getConcreteClass(GenericType.collapse(((ParameterizedType)ntype).getRawType()));
        }
        throw new RuntimeException("Unknown type " + type);
    }

    static Type collapse(Type target) {
        if (target instanceof Class || target instanceof ParameterizedType) {
            return target;
        }
        if (target instanceof TypeVariable) {
            return GenericType.collapse(((TypeVariable)target).getBounds()[0]);
        }
        if (target instanceof GenericArrayType) {
            Type t = GenericType.collapse(((GenericArrayType)target).getGenericComponentType());
            while (t instanceof ParameterizedType) {
                t = GenericType.collapse(((ParameterizedType)t).getRawType());
            }
            return Array.newInstance((Class)t, 0).getClass();
        }
        if (target instanceof WildcardType) {
            WildcardType wct = (WildcardType)target;
            if (wct.getLowerBounds().length == 0) {
                return GenericType.collapse(wct.getUpperBounds()[0]);
            }
            return GenericType.collapse(wct.getLowerBounds()[0]);
        }
        throw new RuntimeException("Huh? " + target);
    }

    static {
        PRIMITIVE_CLASSES.put("int", Integer.TYPE);
        PRIMITIVE_CLASSES.put("short", Short.TYPE);
        PRIMITIVE_CLASSES.put("long", Long.TYPE);
        PRIMITIVE_CLASSES.put("byte", Byte.TYPE);
        PRIMITIVE_CLASSES.put("char", Character.TYPE);
        PRIMITIVE_CLASSES.put("float", Float.TYPE);
        PRIMITIVE_CLASSES.put("double", Double.TYPE);
        PRIMITIVE_CLASSES.put("boolean", Boolean.TYPE);
        PRIMITIVE_CLASSES.put("void", Void.TYPE);
    }

    public static enum BoundType {
        Exact,
        Extends,
        Super;

    }
}

