/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.maven.packaging;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Modifier;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.camel.maven.packaging.AbstractGeneratorMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.Index;
import org.jboss.jandex.IndexReader;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.Type;

@Mojo(name="generate-type-converter-loader", threadSafe=true, requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME, defaultPhase=LifecyclePhase.PROCESS_CLASSES)
public class TypeConverterLoaderGeneratorMojo
extends AbstractGeneratorMojo {
    public static final DotName CONVERTER_ANNOTATION = DotName.createSimple((String)"org.apache.camel.Converter");
    @Parameter(defaultValue="${project.build.outputDirectory}")
    protected File classesDirectory;
    @Parameter(defaultValue="${project.basedir}/src/generated/java")
    protected File sourcesOutputDir;
    @Parameter(defaultValue="${project.basedir}/src/generated/resources")
    protected File resourcesOutputDir;

    public void execute() throws MojoExecutionException, MojoFailureException {
        Index index;
        if (this.classesDirectory == null) {
            this.classesDirectory = new File(this.project.getBuild().getOutputDirectory());
        }
        if (this.sourcesOutputDir == null) {
            this.sourcesOutputDir = new File(this.project.getBasedir(), "src/generated/java");
        }
        if (this.resourcesOutputDir == null) {
            this.resourcesOutputDir = new File(this.project.getBasedir(), "src/generated/resources");
        }
        if ("pom".equals(this.project.getPackaging())) {
            return;
        }
        Path output = Paths.get(this.project.getBuild().getOutputDirectory(), new String[0]);
        try (InputStream is = Files.newInputStream(output.resolve("META-INF/jandex.idx"), new OpenOption[0]);){
            index = new IndexReader(is).read();
        }
        catch (IOException e) {
            throw new MojoExecutionException("IOException: " + e.getMessage(), (Exception)e);
        }
        TreeMap<String, ClassConverters> converters = new TreeMap<String, ClassConverters>();
        List annotations = index.getAnnotations(CONVERTER_ANNOTATION);
        annotations.stream().filter(annotation -> annotation.target().kind() == AnnotationTarget.Kind.CLASS).filter(annotation -> annotation.target().asClass().nestingType() == ClassInfo.NestingType.TOP_LEVEL).filter(annotation -> TypeConverterLoaderGeneratorMojo.asBoolean(annotation, "generateLoader")).forEach(annotation -> {
            String currentClass = annotation.target().asClass().name().toString();
            ClassConverters classConverters = new ClassConverters();
            converters.put(currentClass + "Loader", classConverters);
            classConverters.setIgnoreOnLoadError(TypeConverterLoaderGeneratorMojo.asBoolean(annotation, "ignoreOnLoadError"));
            annotations.stream().filter(an -> an.target().kind() == AnnotationTarget.Kind.METHOD).filter(an -> currentClass.equals(an.target().asMethod().declaringClass().name().toString())).forEach(an -> {
                MethodInfo ee = an.target().asMethod();
                if (TypeConverterLoaderGeneratorMojo.asBoolean(an, "fallback")) {
                    classConverters.addFallbackTypeConverter(ee);
                } else {
                    Type to = ee.returnType();
                    Type from = (Type)ee.parameters().get(0);
                    classConverters.addTypeConverter(to, from, ee);
                }
            });
        });
        if (!converters.isEmpty()) {
            converters.forEach((currentClass, classConverters) -> {
                String source = this.writeConverters((String)currentClass, (ClassConverters)classConverters);
                this.updateResource(this.sourcesOutputDir.toPath(), currentClass.replace('.', '/') + ".java", source);
            });
            this.updateResource(this.resourcesOutputDir.toPath(), "META-INF/services/org/apache/camel/TypeConverterLoader", "# Generated by camel build tools - do NOT edit this file!\n" + String.join((CharSequence)"\n", converters.keySet()) + "\n");
        }
    }

    private String writeConverters(String fqn, ClassConverters converters) {
        int pos = fqn.lastIndexOf(46);
        String p = fqn.substring(0, pos);
        String c = fqn.substring(pos + 1);
        LinkedHashSet<String> converterClasses = new LinkedHashSet<String>();
        StringBuilder writer = new StringBuilder();
        writer.append("/* ").append("Generated by camel build tools - do NOT edit this file!").append(" */\n");
        writer.append("package ").append(p).append(";\n");
        writer.append("\n");
        writer.append("import org.apache.camel.Exchange;\n");
        writer.append("import org.apache.camel.TypeConversionException;\n");
        writer.append("import org.apache.camel.TypeConverterLoaderException;\n");
        writer.append("import org.apache.camel.spi.TypeConverterLoader;\n");
        writer.append("import org.apache.camel.spi.TypeConverterRegistry;\n");
        writer.append("import org.apache.camel.support.SimpleTypeConverter;\n");
        writer.append("import org.apache.camel.support.TypeConverterSupport;\n");
        writer.append("import org.apache.camel.util.DoubleMap;\n");
        writer.append("\n");
        writer.append("/**\n");
        writer.append(" * ").append("Generated by camel build tools - do NOT edit this file!").append("\n");
        writer.append(" */\n");
        writer.append("@SuppressWarnings(\"unchecked\")\n");
        writer.append("public final class ").append(c).append(" implements TypeConverterLoader {\n");
        writer.append("\n");
        writer.append("    ").append("public ").append(c).append("() {\n");
        writer.append("    }\n");
        writer.append("\n");
        writer.append("    @Override\n");
        writer.append("    public void load(TypeConverterRegistry registry) throws TypeConverterLoaderException {\n");
        if (converters.size() > 0L) {
            if (converters.isIgnoreOnLoadError()) {
                writer.append("        try {\n");
                writer.append("            registerConverters(registry);\n");
                writer.append("        } catch (Throwable e) {\n");
                writer.append("            // ignore on load error\n");
                writer.append("        }\n");
            } else {
                writer.append("        registerConverters(registry);\n");
            }
        }
        if (converters.sizeFallback() > 0L) {
            writer.append("        registerFallbackConverters(registry);\n");
        }
        writer.append("    }\n");
        writer.append("\n");
        if (converters.size() > 0L) {
            writer.append("    private void registerConverters(TypeConverterRegistry registry) {\n");
            for (Map.Entry entry : converters.getConverters().entrySet()) {
                for (Map.Entry from : ((Map)entry.getValue()).entrySet()) {
                    boolean allowNull = TypeConverterLoaderGeneratorMojo.isAllowNull((MethodInfo)from.getValue());
                    writer.append("        addTypeConverter(registry, ").append((String)entry.getKey()).append(".class").append(", ").append(this.toString((Type)from.getKey())).append(".class, ").append(Boolean.toString(allowNull)).append(",\n");
                    writer.append("            (type, exchange, value) -> ").append(this.toJava((MethodInfo)from.getValue(), converterClasses)).append(");\n");
                }
            }
            writer.append("    }\n");
            writer.append("\n");
            writer.append("    private static void addTypeConverter(TypeConverterRegistry registry, Class<?> toType, Class<?> fromType, boolean allowNull, SimpleTypeConverter.ConversionMethod method) { \n");
            writer.append("        registry.addTypeConverter(toType, fromType, new SimpleTypeConverter(allowNull, method));\n");
            writer.append("    }\n");
            writer.append("\n");
        }
        if (converters.sizeFallback() > 0L) {
            writer.append("    private void registerFallbackConverters(TypeConverterRegistry registry) {\n");
            for (MethodInfo methodInfo : converters.getFallbackConverters()) {
                boolean allowNull = TypeConverterLoaderGeneratorMojo.isAllowNull(methodInfo);
                boolean canPromote = TypeConverterLoaderGeneratorMojo.isFallbackCanPromote(methodInfo);
                writer.append("        addFallbackTypeConverter(registry, ").append(Boolean.toString(allowNull)).append(", ").append(Boolean.toString(canPromote)).append(", ").append("(type, exchange, value) -> ").append(this.toJavaFallback(methodInfo, converterClasses)).append(");\n");
            }
            writer.append("    }\n");
            writer.append("\n");
            writer.append("    private static void addFallbackTypeConverter(TypeConverterRegistry registry, boolean allowNull, boolean canPromote, SimpleTypeConverter.ConversionMethod method) { \n");
            writer.append("        registry.addFallbackTypeConverter(new SimpleTypeConverter(allowNull, method), canPromote);\n");
            writer.append("    }\n");
            writer.append("\n");
        }
        for (String string : converterClasses) {
            String s = string.substring(string.lastIndexOf(46) + 1);
            String v = s.substring(0, 1).toLowerCase() + s.substring(1);
            writer.append("    private volatile ").append(string).append(" ").append(v).append(";\n");
            writer.append("    private ").append(string).append(" get").append(s).append("() {\n");
            writer.append("        if (").append(v).append(" == null) {\n");
            writer.append("            ").append(v).append(" = new ").append(string).append("();\n");
            writer.append("        }\n");
            writer.append("        return ").append(v).append(";\n");
            writer.append("    }\n");
        }
        writer.append("}\n");
        return writer.toString();
    }

    private String toString(Type type) {
        return type.toString().replaceAll("<.*>", "").replace('$', '.');
    }

    private String toJava(MethodInfo converter, Set<String> converterClasses) {
        String pfx;
        if (Modifier.isStatic(converter.flags())) {
            pfx = converter.declaringClass().toString() + "." + converter.name();
        } else {
            converterClasses.add(converter.declaringClass().toString());
            pfx = "get" + converter.declaringClass().simpleName() + "()." + converter.name();
        }
        String type = this.toString((Type)converter.parameters().get(0));
        String cast = type.equals("java.lang.Object") ? "" : "(" + type + ") ";
        return pfx + "(" + cast + "value" + (converter.parameters().size() == 2 ? ", exchange" : "") + ")";
    }

    private String toJavaFallback(MethodInfo converter, Set<String> converterClasses) {
        String pfx;
        if (Modifier.isStatic(converter.flags())) {
            pfx = converter.declaringClass().toString() + "." + converter.name();
        } else {
            converterClasses.add(converter.declaringClass().toString());
            pfx = "get" + converter.declaringClass().simpleName() + "()." + converter.name();
        }
        String type = this.toString((Type)converter.parameters().get(converter.parameters().size() - 2));
        String cast = type.equals("java.lang.Object") ? "" : "(" + type + ") ";
        return pfx + "(type, " + (converter.parameters().size() == 4 ? "exchange, " : "") + cast + "value, registry)";
    }

    private static boolean isFallbackCanPromote(MethodInfo element) {
        return TypeConverterLoaderGeneratorMojo.asBoolean(element.annotation(CONVERTER_ANNOTATION), "fallbackCanPromote");
    }

    private static boolean isAllowNull(MethodInfo element) {
        return TypeConverterLoaderGeneratorMojo.asBoolean(element.annotation(CONVERTER_ANNOTATION), "allowNull");
    }

    private static boolean asBoolean(AnnotationInstance ai, String name) {
        AnnotationValue av = ai.value(name);
        return av != null && av.asBoolean();
    }

    public static final class ClassConverters {
        private final Comparator<Type> comparator;
        private final Map<String, Map<Type, MethodInfo>> converters = new TreeMap<String, Map<Type, MethodInfo>>();
        private final List<MethodInfo> fallbackConverters = new ArrayList<MethodInfo>();
        private int size;
        private int sizeFallback;
        private boolean ignoreOnLoadError;

        ClassConverters() {
            this.comparator = (o1, o2) -> o1.toString().compareTo(o2.toString());
        }

        public boolean isIgnoreOnLoadError() {
            return this.ignoreOnLoadError;
        }

        void setIgnoreOnLoadError(boolean ignoreOnLoadError) {
            this.ignoreOnLoadError = ignoreOnLoadError;
        }

        void addTypeConverter(Type to, Type from, MethodInfo ee) {
            this.converters.computeIfAbsent(ClassConverters.toString(to), c -> new TreeMap(this.comparator)).put(from, ee);
            ++this.size;
        }

        void addFallbackTypeConverter(MethodInfo ee) {
            this.fallbackConverters.add(ee);
            ++this.sizeFallback;
        }

        public Map<String, Map<Type, MethodInfo>> getConverters() {
            return this.converters;
        }

        public List<MethodInfo> getFallbackConverters() {
            return this.fallbackConverters;
        }

        public long size() {
            return this.size;
        }

        public long sizeFallback() {
            return this.sizeFallback;
        }

        public boolean isEmpty() {
            return this.size == 0 && this.sizeFallback == 0;
        }

        private static String toString(Type type) {
            return type.toString().replaceAll("<.*>", "").replace('$', '.');
        }
    }
}

