/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.maven.packaging;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.LineNumberReader;
import java.io.StringReader;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Generated;
import org.apache.camel.maven.packaging.AbstractGeneratorMojo;
import org.apache.camel.tooling.model.BaseModel;
import org.apache.camel.tooling.model.ComponentModel;
import org.apache.camel.tooling.model.JsonMapper;
import org.apache.camel.tooling.util.JavadocHelper;
import org.apache.camel.tooling.util.PackageHelper;
import org.apache.camel.tooling.util.Strings;
import org.apache.camel.tooling.util.srcgen.GenericType;
import org.apache.camel.tooling.util.srcgen.JavaClass;
import org.apache.camel.tooling.util.srcgen.Method;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.jboss.forge.roaster.Roaster;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.dom.ASTNode;
import org.jboss.forge.roaster.model.Type;
import org.jboss.forge.roaster.model.source.JavaClassSource;
import org.jboss.forge.roaster.model.source.MethodSource;
import org.jboss.forge.roaster.model.source.ParameterSource;
import org.sonatype.plexus.build.incremental.BuildContext;

@Mojo(name="generate-endpoint-dsl", threadSafe=true, requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME, defaultPhase=LifecyclePhase.PROCESS_CLASSES)
public class EndpointDslMojo
extends AbstractGeneratorMojo {
    @Parameter(defaultValue="${project.build.directory}")
    protected File buildDir;
    @Parameter(defaultValue="${project.basedir}")
    protected File baseDir;
    @Parameter(defaultValue="org.apache.camel.builder.endpoint")
    protected String endpointFactoriesPackageName;
    @Parameter(defaultValue="org.apache.camel.builder.endpoint.dsl")
    protected String componentsFactoriesPackageName;
    @Parameter
    protected File sourcesOutputDir;
    @Parameter
    protected File componentsMetadata;
    @Parameter
    protected File outputResourcesDir;
    @Parameter(defaultValue="${project.build.directory}/../../../catalog/camel-catalog/src/generated/resources/org/apache/camel/catalog/components")
    protected File jsonDir;
    private transient String licenseHeader;

    @Override
    public void execute(MavenProject project, MavenProjectHelper projectHelper, BuildContext buildContext) throws MojoFailureException, MojoExecutionException {
        this.buildDir = new File(project.getBuild().getDirectory());
        this.baseDir = project.getBasedir();
        this.endpointFactoriesPackageName = "org.apache.camel.builder.endpoint";
        this.componentsFactoriesPackageName = "org.apache.camel.builder.endpoint.dsl";
        super.execute(project, projectHelper, buildContext);
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        File camelDir = PackageHelper.findCamelDirectory((File)this.baseDir, (String)"dsl/camel-endpointdsl");
        if (camelDir == null) {
            this.getLog().debug((CharSequence)"No dsl/camel-endpointdsl folder found, skipping execution");
            return;
        }
        Path root = camelDir.toPath();
        if (this.sourcesOutputDir == null) {
            this.sourcesOutputDir = root.resolve("src/generated/java").toFile();
        }
        if (this.outputResourcesDir == null) {
            this.outputResourcesDir = root.resolve("src/generated/resources").toFile();
        }
        if (this.componentsMetadata == null) {
            this.componentsMetadata = this.outputResourcesDir.toPath().resolve("metadata.json").toFile();
        }
        ArrayList<ComponentModel> models = new ArrayList<ComponentModel>();
        for (File file : this.jsonDir.listFiles()) {
            BaseModel model = JsonMapper.generateModel((Path)file.toPath());
            models.add((ComponentModel)model);
        }
        this.executeComponent(models);
    }

    private void executeComponent(List<ComponentModel> allModels) throws MojoFailureException {
        if (!allModels.isEmpty()) {
            this.getLog().debug((CharSequence)("Found " + allModels.size() + " components"));
            Map<String, List<ComponentModel>> grModels = allModels.stream().collect(Collectors.groupingBy(BaseModel::getJavaType));
            try (InputStream is = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("license-header-java.txt");){
                this.licenseHeader = PackageHelper.loadText((InputStream)is);
            }
            catch (Exception e) {
                throw new MojoFailureException("Error loading license-header-java.txt file", (Throwable)e);
            }
            for (List<ComponentModel> compModels : grModels.values()) {
                if (compModels.size() > 1) {
                    compModels.sort((o1, o2) -> {
                        String s1 = o1.getScheme();
                        String s2 = o2.getScheme();
                        String as = o1.getAlternativeSchemes();
                        int i1 = as.indexOf(s1);
                        int i2 = as.indexOf(s2);
                        return Integer.compare(i1, i2);
                    });
                }
                ComponentModel model = compModels.get(0);
                List aliases = compModels.stream().map(ComponentModel::getScheme).collect(Collectors.toList());
                String overrideComponentName = null;
                if (aliases.size() > 1) {
                    overrideComponentName = model.getArtifactId().replace("camel-", "");
                }
                this.createEndpointDsl(model, compModels, overrideComponentName);
            }
        }
    }

    private void createEndpointDsl(ComponentModel model, List<ComponentModel> aliases, String overrideComponentName) throws MojoFailureException {
        ArrayList<Method> staticBuilders = new ArrayList<Method>();
        boolean updated = this.doCreateEndpointDsl(model, aliases, staticBuilders);
        this.getLog().debug((CharSequence)"Load components EndpointFactories");
        List<File> endpointFactories = this.loadAllComponentsDslEndpointFactoriesAsFile();
        this.getLog().debug((CharSequence)"Regenerate EndpointBuilderFactory");
        updated |= this.synchronizeEndpointBuilderFactoryInterface(endpointFactories);
        this.getLog().debug((CharSequence)"Regenerate EndpointBuilders");
        updated |= this.synchronizeEndpointBuildersInterface(endpointFactories);
        this.getLog().debug((CharSequence)"Regenerate StaticEndpointBuilders");
        if (updated |= this.synchronizeEndpointBuildersStaticClass(staticBuilders)) {
            this.getLog().info((CharSequence)("Updated EndpointDsl: " + model.getScheme()));
        }
    }

    private boolean doCreateEndpointDsl(ComponentModel model, List<ComponentModel> aliases, List<Method> staticBuilders) throws MojoFailureException {
        String componentClassName = model.getJavaType();
        String builderName = this.getEndpointName(componentClassName);
        JavaClass javaClass = new JavaClass((ClassLoader)this.getProjectClassLoader());
        javaClass.setPackage(this.componentsFactoriesPackageName);
        javaClass.setName(builderName + "Factory");
        javaClass.setClass(false);
        javaClass.addImport("java.util.*");
        javaClass.addImport("java.util.concurrent.*");
        javaClass.addImport("java.util.function.*");
        javaClass.addImport("java.util.stream.*");
        javaClass.addImport("org.apache.camel.builder.EndpointConsumerBuilder");
        javaClass.addImport("org.apache.camel.builder.EndpointProducerBuilder");
        javaClass.addImport("org.apache.camel.builder.endpoint.AbstractEndpointBuilder");
        boolean hasAdvanced = false;
        for (ComponentModel.EndpointOptionModel option : model.getEndpointOptions()) {
            if (option.getLabel() == null || !option.getLabel().contains("advanced")) continue;
            hasAdvanced = true;
            break;
        }
        JavaClass consumerClass = null;
        JavaClass advancedConsumerClass = null;
        JavaClass producerClass = null;
        JavaClass advancedProducerClass = null;
        if (!model.isProducerOnly() && !model.isConsumerOnly()) {
            String consumerName = builderName.replace("Endpoint", "EndpointConsumer");
            consumerClass = javaClass.addNestedType().setPublic().setClass(false);
            consumerClass.setName(consumerName);
            consumerClass.implementInterface("EndpointConsumerBuilder");
            this.generateDummyClass(consumerClass.getCanonicalName());
            consumerClass.getJavaDoc().setText("Builder for endpoint consumers for the " + model.getTitle() + " component.");
            if (hasAdvanced) {
                advancedConsumerClass = javaClass.addNestedType().setPublic().setClass(false);
                advancedConsumerClass.setName("Advanced" + consumerName);
                advancedConsumerClass.implementInterface("EndpointConsumerBuilder");
                this.generateDummyClass(advancedConsumerClass.getCanonicalName());
                advancedConsumerClass.getJavaDoc().setText("Advanced builder for endpoint consumers for the " + model.getTitle() + " component.");
                consumerClass.addMethod().setName("advanced").setReturnType(this.loadClass(advancedConsumerClass.getCanonicalName())).setDefault().setBody("return (Advanced" + consumerName + ") this;");
                advancedConsumerClass.addMethod().setName("basic").setReturnType(this.loadClass(consumerClass.getCanonicalName())).setDefault().setBody("return (" + consumerName + ") this;");
            }
            String producerName = builderName.replace("Endpoint", "EndpointProducer");
            producerClass = javaClass.addNestedType().setPublic().setClass(false);
            producerClass.setName(producerName);
            producerClass.implementInterface("EndpointProducerBuilder");
            this.generateDummyClass(producerClass.getCanonicalName());
            producerClass.getJavaDoc().setText("Builder for endpoint producers for the " + model.getTitle() + " component.");
            if (hasAdvanced) {
                advancedProducerClass = javaClass.addNestedType().setPublic().setClass(false);
                advancedProducerClass.setName("Advanced" + producerName);
                advancedProducerClass.implementInterface("EndpointProducerBuilder");
                this.generateDummyClass(advancedProducerClass.getCanonicalName());
                advancedProducerClass.getJavaDoc().setText("Advanced builder for endpoint producers for the " + model.getTitle() + " component.");
                producerClass.addMethod().setName("advanced").setReturnType(this.loadClass(advancedProducerClass.getCanonicalName())).setDefault().setBody("return (Advanced" + producerName + ") this;");
                advancedProducerClass.addMethod().setName("basic").setReturnType(this.loadClass(producerClass.getCanonicalName())).setDefault().setBody("return (" + producerName + ") this;");
            }
        }
        JavaClass advancedBuilderClass = null;
        JavaClass builderClass = javaClass.addNestedType().setPublic().setClass(false);
        builderClass.setName(builderName);
        if (model.isProducerOnly()) {
            builderClass.implementInterface("EndpointProducerBuilder");
        } else if (model.isConsumerOnly()) {
            builderClass.implementInterface("EndpointConsumerBuilder");
        } else {
            builderClass.implementInterface(consumerClass.getName());
            builderClass.implementInterface(producerClass.getName());
        }
        this.generateDummyClass(builderClass.getCanonicalName());
        builderClass.getJavaDoc().setText("Builder for endpoint for the " + model.getTitle() + " component.");
        if (hasAdvanced) {
            advancedBuilderClass = javaClass.addNestedType().setPublic().setClass(false);
            advancedBuilderClass.setName("Advanced" + builderName);
            if (model.isProducerOnly()) {
                advancedBuilderClass.implementInterface("EndpointProducerBuilder");
            } else if (model.isConsumerOnly()) {
                advancedBuilderClass.implementInterface("EndpointConsumerBuilder");
            } else {
                advancedBuilderClass.implementInterface(advancedConsumerClass.getName());
                advancedBuilderClass.implementInterface(advancedProducerClass.getName());
            }
            this.generateDummyClass(advancedBuilderClass.getCanonicalName());
            advancedBuilderClass.getJavaDoc().setText("Advanced builder for endpoint for the " + model.getTitle() + " component.");
            builderClass.addMethod().setName("advanced").setReturnType(this.loadClass(advancedBuilderClass.getCanonicalName())).setDefault().setBody("return (Advanced" + builderName + ") this;");
            advancedBuilderClass.addMethod().setName("basic").setReturnType(this.loadClass(builderClass.getCanonicalName())).setDefault().setBody("return (" + builderName + ") this;");
        }
        this.generateDummyClass(this.componentsFactoriesPackageName + ".T");
        Object doc = "Generated by camel build tools - do NOT edit this file!";
        if (!Strings.isEmpty((String)model.getDescription())) {
            doc = model.getDescription() + "\n\n" + (String)doc;
        }
        javaClass.getJavaDoc().setText((String)doc);
        javaClass.addAnnotation(Generated.class).setStringValue("value", EndpointDslMojo.class.getName());
        for (ComponentModel.EndpointOptionModel option : model.getEndpointOptions()) {
            String label;
            if ("path".equals(option.getKind())) continue;
            ArrayList<JavaClass> targets = new ArrayList<JavaClass>();
            String string = label = option.getLabel() != null ? option.getLabel() : "";
            if (label != null) {
                if (label.contains("producer")) {
                    if (label.contains("advanced")) {
                        targets.add(advancedProducerClass != null ? advancedProducerClass : advancedBuilderClass);
                    } else {
                        targets.add(producerClass != null ? producerClass : builderClass);
                    }
                } else if (label.contains("consumer")) {
                    if (label.contains("advanced")) {
                        targets.add(advancedConsumerClass != null ? advancedConsumerClass : advancedBuilderClass);
                    } else {
                        targets.add(consumerClass != null ? consumerClass : builderClass);
                    }
                } else if (label.contains("advanced")) {
                    targets.add(advancedConsumerClass);
                    targets.add(advancedProducerClass);
                    targets.add(advancedBuilderClass);
                } else {
                    targets.add(consumerClass);
                    targets.add(producerClass);
                    targets.add(builderClass);
                }
            }
            for (JavaClass target : targets) {
                Object text;
                Method fluent;
                String desc;
                boolean multiValued;
                if (target == null) continue;
                Object baseDesc = option.getDescription();
                if (!Strings.isEmpty((String)baseDesc)) {
                    if (!((String)(baseDesc = JavadocHelper.xmlEncode((String)baseDesc))).endsWith(".")) {
                        baseDesc = (String)baseDesc + ".";
                    }
                    baseDesc = (String)baseDesc + "\n";
                    baseDesc = (String)baseDesc + "@@REPLACE_ME@@";
                    if (option.isMultiValue()) {
                        baseDesc = (String)baseDesc + "\nThe option is multivalued, and you can use the " + option.getName() + "(String, Object) method to add a value (call the method multiple times to set more values).";
                    }
                    baseDesc = (String)baseDesc + "\n";
                    if ("parameter".equals(option.getKind()) && option.isRequired()) {
                        baseDesc = (String)baseDesc + "\nRequired: true";
                    }
                    if (option.getDefaultValue() != null) {
                        String value = JavadocHelper.xmlEncode((String)option.getDefaultValue().toString());
                        baseDesc = (String)baseDesc + "\nDefault: " + value;
                    }
                    baseDesc = (String)baseDesc + "\nGroup: " + option.getGroup();
                }
                if (multiValued = option.isMultiValue()) {
                    desc = ((String)baseDesc).replace("@@REPLACE_ME@@", "\nThe option is a: <code>" + option.getJavaType().replace("<", "&lt;").replace(">", "&gt;") + "</code> type.");
                    desc = JavadocHelper.xmlEncode((String)desc);
                    fluent = target.addMethod().setDefault().setName(option.getName()).setReturnType(new GenericType(this.loadClass(target.getCanonicalName()))).addParameter(new GenericType(String.class), "key").addParameter(new GenericType(Object.class), "value").setBody(new String[]{"doSetMultiValueProperty(\"" + option.getName() + "\", \"" + option.getPrefix() + "\" + key, value);", "return this;\n"});
                    if (option.isDeprecated()) {
                        fluent.addAnnotation(Deprecated.class);
                    }
                    text = desc;
                    text = (String)text + "\n\n@param key the option key";
                    text = (String)text + "\n@param value the option value";
                    text = (String)text + "\n@return the dsl builder\n";
                    fluent.getJavaDoc().setText((String)text);
                    fluent = target.addMethod().setDefault().setName(option.getName()).setReturnType(new GenericType(this.loadClass(target.getCanonicalName()))).addParameter(new GenericType(Map.class), "values").setBody(new String[]{"doSetMultiValueProperties(\"" + option.getName() + "\", \"" + option.getPrefix() + "\", values);", "return this;\n"});
                    if (option.isDeprecated()) {
                        fluent.addAnnotation(Deprecated.class);
                    }
                    text = desc;
                    text = (String)text + "\n\n@param values the values";
                    text = (String)text + "\n@return the dsl builder\n";
                    fluent.getJavaDoc().setText((String)text);
                    continue;
                }
                desc = ((String)baseDesc).replace("@@REPLACE_ME@@", "\nThe option is a: <code>" + option.getJavaType().replace("<", "&lt;").replace(">", "&gt;") + "</code> type.");
                desc = JavadocHelper.xmlEncode((String)desc);
                fluent = target.addMethod().setDefault().setName(option.getName()).setReturnType(new GenericType(this.loadClass(target.getCanonicalName()))).addParameter(EndpointDslMojo.optionJavaType(option), option.getName()).setBody(new String[]{"doSetProperty(\"" + option.getName() + "\", " + option.getName() + ");", "return this;\n"});
                if (option.isDeprecated()) {
                    fluent.addAnnotation(Deprecated.class);
                }
                text = desc;
                text = (String)text + "\n\n@param " + option.getName() + " the value to set";
                text = (String)text + "\n@return the dsl builder\n";
                fluent.getJavaDoc().setText((String)text);
                if ("String".equals(EndpointDslMojo.optionJavaType(option))) continue;
                desc = ((String)baseDesc).replace("@@REPLACE_ME@@", "\nThe option will be converted to a <code>" + option.getJavaType().replace("<", "&lt;").replace(">", "&gt;") + "</code> type.");
                desc = JavadocHelper.xmlEncode((String)desc);
                fluent = target.addMethod().setDefault().setName(option.getName()).setReturnType(new GenericType(this.loadClass(target.getCanonicalName()))).addParameter(new GenericType(String.class), option.getName()).setBody(new String[]{"doSetProperty(\"" + option.getName() + "\", " + option.getName() + ");", "return this;\n"});
                if (option.isDeprecated()) {
                    fluent.addAnnotation(Deprecated.class);
                }
                text = desc;
                text = (String)text + "\n\n@param " + option.getName() + " the value to set";
                text = (String)text + "\n@return the dsl builder\n";
                fluent.getJavaDoc().setText((String)text);
            }
        }
        javaClass.removeImport("T");
        JavaClass dslClass = javaClass.addNestedType();
        dslClass.setName(this.getComponentNameFromType(componentClassName) + "Builders");
        dslClass.setClass(false);
        Object adv = hasAdvanced ? ", Advanced" + builderName : "";
        Method method = javaClass.addMethod().setStatic().setName("endpointBuilder").addParameter(String.class, "componentName").addParameter(String.class, "path").setReturnType(new GenericType(this.loadClass(builderClass.getCanonicalName()))).setBody(new String[]{"class " + builderName + "Impl extends AbstractEndpointBuilder implements " + builderName + (String)adv + " {", "    public " + builderName + "Impl(String path) {", "        super(componentName, path);", "    }", "}", "return new " + builderName + "Impl(path);", ""});
        if (model.isDeprecated()) {
            method.addAnnotation(Deprecated.class);
        }
        if (aliases.size() == 1) {
            String desc = this.getMainDescription(model);
            String methodName = EndpointDslMojo.camelCaseLower(model.getScheme());
            method = dslClass.addMethod().setStatic().setName(methodName).addParameter(String.class, "path").setReturnType(new GenericType(this.loadClass(builderClass.getCanonicalName()))).setDefault().setBodyF("return %s.%s(%s);", new Object[]{javaClass.getName(), "endpointBuilder", "\"" + model.getScheme() + "\", path"});
            Object javaDoc = desc;
            javaDoc = (String)javaDoc + "\n\n@param path " + EndpointDslMojo.pathParameterJavaDoc(model);
            javaDoc = (String)javaDoc + "\n@return the dsl builder\n";
            method.getJavaDoc().setText((String)javaDoc);
            if (model.isDeprecated()) {
                method.addAnnotation(Deprecated.class);
            }
            method = method.copy();
            method.setPublic().setStatic();
            method.setReturnType(builderClass.getCanonicalName().replace('$', '.'));
            method.setBodyF("return %s.%s(%s);", new Object[]{javaClass.getCanonicalName(), "endpointBuilder", "\"" + model.getScheme() + "\", path"});
            staticBuilders.add(method);
            method = dslClass.addMethod().setStatic().setName(methodName).addParameter(String.class, "componentName").addParameter(String.class, "path").setReturnType(new GenericType(this.loadClass(builderClass.getCanonicalName()))).setDefault().setBodyF("return %s.%s(%s);", new Object[]{javaClass.getName(), "endpointBuilder", "componentName, path"});
            javaDoc = desc;
            javaDoc = (String)javaDoc + "\n\n@param componentName to use a custom component name for the endpoint instead of the default name";
            javaDoc = (String)javaDoc + "\n@param path " + EndpointDslMojo.pathParameterJavaDoc(model);
            javaDoc = (String)javaDoc + "\n@return the dsl builder\n";
            method.getJavaDoc().setText((String)javaDoc);
            if (model.isDeprecated()) {
                method.addAnnotation(Deprecated.class);
            }
            method = method.copy();
            method.setPublic().setStatic();
            method.setReturnType(builderClass.getCanonicalName().replace('$', '.'));
            method.setBodyF("return %s.%s(%s);", new Object[]{javaClass.getCanonicalName(), "endpointBuilder", "componentName, path"});
            staticBuilders.add(method);
        } else {
            boolean firstAlias = true;
            for (ComponentModel componentModel : aliases) {
                String desc = this.getMainDescription(componentModel);
                String methodName = EndpointDslMojo.camelCaseLower(componentModel.getScheme());
                method = dslClass.addMethod().setStatic().setName(methodName).addParameter(String.class, "path").setReturnType(new GenericType(this.loadClass(builderClass.getCanonicalName()))).setDefault().setBodyF("return %s.%s(%s);", new Object[]{javaClass.getName(), "endpointBuilder", "\"" + componentModel.getScheme() + "\", path"});
                Object javaDoc = desc;
                javaDoc = (String)javaDoc + "\n\n@param path " + EndpointDslMojo.pathParameterJavaDoc(componentModel);
                javaDoc = (String)javaDoc + "\n@return the dsl builder\n";
                method.getJavaDoc().setText((String)javaDoc);
                if (componentModel.isDeprecated()) {
                    method.addAnnotation(Deprecated.class);
                }
                if (firstAlias) {
                    method = method.copy();
                    method.setPublic().setStatic();
                    method.setReturnType(builderClass.getCanonicalName().replace('$', '.'));
                    method.setBodyF("return %s.%s(%s);", new Object[]{javaClass.getCanonicalName(), "endpointBuilder", "\"" + componentModel.getScheme() + "\", path"});
                    staticBuilders.add(method);
                }
                if (firstAlias) {
                    method = dslClass.addMethod().setStatic().setName(methodName).addParameter(String.class, "componentName").addParameter(String.class, "path").setReturnType(new GenericType(this.loadClass(builderClass.getCanonicalName()))).setDefault().setBodyF("return %s.%s(%s);", new Object[]{javaClass.getName(), "endpointBuilder", "componentName, path"});
                    javaDoc = desc;
                    javaDoc = (String)javaDoc + "\n\n@param componentName to use a custom component name for the endpoint instead of the default name";
                    javaDoc = (String)javaDoc + "\n@param path " + EndpointDslMojo.pathParameterJavaDoc(componentModel);
                    javaDoc = (String)javaDoc + "\n@return the dsl builder\n";
                    method.getJavaDoc().setText((String)javaDoc);
                    if (componentModel.isDeprecated()) {
                        method.addAnnotation(Deprecated.class);
                    }
                }
                if (firstAlias) {
                    method = method.copy();
                    method.setPublic().setStatic();
                    method.setReturnType(builderClass.getCanonicalName().replace('$', '.'));
                    method.setBodyF("return %s.%s(%s);", new Object[]{javaClass.getCanonicalName(), "endpointBuilder", "componentName, path"});
                    staticBuilders.add(method);
                }
                firstAlias = false;
            }
        }
        return this.writeSourceIfChanged(javaClass, this.componentsFactoriesPackageName.replace('.', '/'), builderName + "Factory.java", false);
    }

    private static String optionJavaType(ComponentModel.EndpointOptionModel option) {
        String answer = option.getJavaType();
        if (answer.startsWith("java.lang.")) {
            return answer.substring(10);
        }
        if (answer.startsWith("java.util.concurrent.")) {
            return answer.substring(21);
        }
        if (answer.startsWith("java.util.function.")) {
            return answer.substring(19);
        }
        if (answer.startsWith("java.util.stream.")) {
            return answer.substring(17);
        }
        if (answer.startsWith("java.util.")) {
            return answer.substring(10);
        }
        return answer;
    }

    private static String pathParameterJavaDoc(ComponentModel model) {
        int pos = model.getSyntax().indexOf(58);
        if (pos != -1) {
            return model.getSyntax().substring(pos + 1);
        }
        return model.getSyntax();
    }

    private boolean synchronizeEndpointBuilderFactoryInterface(List<File> factories) throws MojoFailureException {
        JavaClass javaClass = new JavaClass((ClassLoader)this.getProjectClassLoader());
        javaClass.setPackage(this.endpointFactoriesPackageName);
        javaClass.setName("EndpointBuilderFactory");
        javaClass.setClass(false);
        javaClass.setPublic();
        javaClass.getJavaDoc().setText("Generated by camel build tools - do NOT edit this file!");
        javaClass.addAnnotation(Generated.class).setStringValue("value", EndpointDslMojo.class.getName());
        javaClass.addImport("java.util.List");
        javaClass.addImport("java.util.stream.Collectors");
        javaClass.addImport("java.util.stream.Stream");
        javaClass.addMethod().setDefault().setReturnType("org.apache.camel.Expression").setName("endpoints").addParameter("org.apache.camel.builder.EndpointProducerBuilder", "endpoints", true).setBody(new String[]{"return new org.apache.camel.support.ExpressionAdapter() {", "", "    private List<org.apache.camel.Expression> expressions = null;", "", "    @Override", "    public Object evaluate(org.apache.camel.Exchange exchange) {", "        return expressions.stream().map(e -> e.evaluate(exchange, Object.class)).collect(Collectors.toList());", "    }", "", "    @Override", "    public void init(org.apache.camel.CamelContext context) {", "        super.init(context);", "        expressions = Stream.of(endpoints)", "                .map(epb -> epb.expr(context))", "                .collect(Collectors.toList());", "    }", "};"});
        for (File factory : factories) {
            String factoryName = Strings.before((String)factory.getName(), (String)".");
            String endpointsName = factoryName.replace("EndpointBuilderFactory", "Builders");
            javaClass.implementInterface(this.componentsFactoriesPackageName + "." + factoryName + "." + endpointsName);
        }
        return this.writeSourceIfChanged("//CHECKSTYLE:OFF\n" + javaClass.printClass() + "\n//CHECKSTYLE:ON", this.endpointFactoriesPackageName.replace('.', '/'), "EndpointBuilderFactory.java");
    }

    private boolean synchronizeEndpointBuildersInterface(List<File> factories) throws MojoFailureException {
        JavaClass javaClass = new JavaClass((ClassLoader)this.getProjectClassLoader());
        javaClass.setPackage(this.endpointFactoriesPackageName);
        javaClass.setName("EndpointBuilders");
        javaClass.setClass(false);
        javaClass.setPublic();
        javaClass.getJavaDoc().setText("Generated by camel build tools - do NOT edit this file!");
        javaClass.addAnnotation(Generated.class).setStringValue("value", EndpointDslMojo.class.getName());
        for (File factory : factories) {
            javaClass.implementInterface(this.componentsFactoriesPackageName + "." + Strings.before((String)factory.getName(), (String)"."));
        }
        return this.writeSourceIfChanged("//CHECKSTYLE:OFF\n" + javaClass.printClass() + "\n//CHECKSTYLE:ON", this.endpointFactoriesPackageName.replace(".", "/"), "EndpointBuilders.java");
    }

    private boolean synchronizeEndpointBuildersStaticClass(List<Method> methods) throws MojoFailureException {
        File file = new File(this.sourcesOutputDir.getPath() + "/" + this.endpointFactoriesPackageName.replace(".", "/"), "StaticEndpointBuilders.java");
        if (file.exists()) {
            try {
                String sourceCode = PackageHelper.loadText((File)file);
                JavaClassSource source = (JavaClassSource)Roaster.parse((String)sourceCode);
                for (MethodSource ms : source.getMethods()) {
                    boolean exist = methods.stream().anyMatch(m -> m.getName().equals(ms.getName()) && m.getParameters().size() == ms.getParameters().size());
                    if (exist) continue;
                    Method method = new Method();
                    if (ms.isStatic()) {
                        method.setStatic();
                    }
                    method.setPublic();
                    method.setName(ms.getName());
                    String body = ms.getBody();
                    body = body.replaceAll(",(\\S)", ", $1");
                    method.setBody(body);
                    method.setReturnType(EndpointDslMojo.getQualifiedType(ms.getReturnType()));
                    for (Object o : ms.getParameters()) {
                        if (!(o instanceof ParameterSource)) continue;
                        ParameterSource ps = (ParameterSource)o;
                        method.addParameter(EndpointDslMojo.getQualifiedType(ps.getType()), ps.getName());
                    }
                    String doc = EndpointDslMojo.extractJavaDoc(sourceCode, ms);
                    method.getJavaDoc().setFullText(doc);
                    if (ms.getAnnotation(Deprecated.class) != null) {
                        method.addAnnotation(Deprecated.class);
                    }
                    methods.add(method);
                }
            }
            catch (IOException e) {
                throw new MojoFailureException("Cannot parse existing java source file: " + file + " due to " + e.getMessage(), (Throwable)e);
            }
        }
        JavaClass javaClass = new JavaClass((ClassLoader)this.getProjectClassLoader());
        javaClass.setPackage(this.endpointFactoriesPackageName);
        javaClass.setName("StaticEndpointBuilders");
        javaClass.setClass(true);
        javaClass.setPublic();
        javaClass.getJavaDoc().setText("Generated by camel build tools - do NOT edit this file!");
        javaClass.addAnnotation(Generated.class).setStringValue("value", EndpointDslMojo.class.getName());
        Collections.sort(methods, (m1, m2) -> m1.getName().compareToIgnoreCase(m2.getName()));
        for (Method method : methods) {
            javaClass.addMethod(method);
        }
        String printClass = javaClass.printClass();
        return this.writeSourceIfChanged("//CHECKSTYLE:OFF\n" + printClass + "\n//CHECKSTYLE:ON", this.endpointFactoriesPackageName.replace(".", "/"), "StaticEndpointBuilders.java");
    }

    private static String getQualifiedType(Type type) {
        String val = type.getQualifiedName();
        if (val.startsWith("java.lang.")) {
            val = val.substring(10);
        }
        return val;
    }

    protected static String extractJavaDoc(String sourceCode, MethodSource ms) throws IOException {
        Object internal = ms.getJavaDoc().getInternal();
        if (internal instanceof ASTNode) {
            int pos = ((ASTNode)internal).getStartPosition();
            int len = ((ASTNode)internal).getLength();
            if (pos > 0 && len > 0) {
                String line;
                String doc = sourceCode.substring(pos, pos + len);
                LineNumberReader ln = new LineNumberReader(new StringReader(doc));
                StringBuilder sb = new StringBuilder();
                while ((line = ln.readLine()) != null) {
                    if ((line = line.trim()).startsWith("/**") || line.startsWith("*/")) continue;
                    if (line.startsWith("*")) {
                        line = line.substring(1).trim();
                    }
                    sb.append(line);
                    sb.append("\n");
                }
                doc = sb.toString();
                return doc;
            }
        }
        return null;
    }

    private List<File> loadAllComponentsDslEndpointFactoriesAsFile() {
        File allComponentsDslEndpointFactory = new File(this.sourcesOutputDir, this.componentsFactoriesPackageName.replace('.', '/'));
        File[] files = allComponentsDslEndpointFactory.listFiles();
        if (files == null) {
            return Collections.emptyList();
        }
        return Arrays.stream(files).filter(file -> file.isFile() && file.getName().endsWith(".java") && file.exists()).sorted().collect(Collectors.toList());
    }

    private static String camelCaseLower(String s) {
        int i;
        while (s != null && (i = ((String)s).indexOf(45)) > 0) {
            s = ((String)s).substring(0, i) + ((String)s).substring(i + 1, i + 2).toUpperCase() + ((String)s).substring(i + 2);
        }
        while (s != null && (i = ((String)s).indexOf(43)) > 0) {
            s = ((String)s).substring(0, i) + ((String)s).substring(i + 1, i + 2).toUpperCase() + ((String)s).substring(i + 2);
        }
        if (s != null) {
            switch (s = ((String)s).substring(0, 1).toLowerCase() + ((String)s).substring(1)) {
                case "class": {
                    s = "clas";
                    break;
                }
                case "package": {
                    s = "packag";
                    break;
                }
                case "rest": {
                    s = "restEndpoint";
                    break;
                }
            }
        }
        return s;
    }

    private String getMainDescription(ComponentModel model) {
        String desc = model.getTitle() + " (" + model.getArtifactId() + ")";
        desc = desc + "\n" + model.getDescription();
        desc = desc + "\n";
        desc = desc + "\nCategory: " + model.getLabel();
        desc = desc + "\nSince: " + model.getFirstVersionShort();
        desc = desc + "\nMaven coordinates: " + model.getGroupId() + ":" + model.getArtifactId();
        desc = desc + "\n";
        desc = desc + "\nSyntax: <code>" + model.getSyntax() + "</code>";
        for (ComponentModel.EndpointOptionModel option : model.getEndpointOptions()) {
            if (!"path".equals(option.getKind())) continue;
            desc = desc + "\n";
            desc = desc + "\nPath parameter: " + option.getName();
            if (option.isRequired()) {
                desc = desc + " (required)";
            }
            if (option.isDeprecated()) {
                desc = desc + " <strong>deprecated</strong>";
            }
            desc = desc + "\n" + option.getDescription();
            if (option.getDefaultValue() != null) {
                desc = desc + "\nDefault value: " + option.getDefaultValue();
            }
            if (option.getEnums() == null || option.getEnums().isEmpty()) continue;
            desc = desc + "\nThere are " + option.getEnums().size() + " enums and the value can be one of: " + this.wrapEnumValues(option.getEnums());
        }
        return desc;
    }

    private String wrapEnumValues(List<String> enumValues) {
        return String.join((CharSequence)", ", enumValues);
    }

    private String getComponentNameFromType(String type) {
        int pos = type.lastIndexOf(46);
        String name = type.substring(pos + 1).replace("Component", "");
        switch (type) {
            case "org.apache.camel.component.atmosphere.websocket.WebsocketComponent": {
                return "AtmosphereWebsocket";
            }
            case "org.apache.camel.component.zookeepermaster.MasterComponent": {
                return "ZooKeeperMaster";
            }
            case "org.apache.camel.component.jetty9.JettyHttpComponent9": {
                return "JettyHttp";
            }
        }
        return name;
    }

    private String getEndpointName(String type) {
        return this.getComponentNameFromType(type) + "EndpointBuilder";
    }

    private Class generateDummyClass(String clazzName) {
        return this.getProjectClassLoader().generateDummyClass(clazzName);
    }

    private boolean writeSourceIfChanged(JavaClass source, String filePath, String fileName, boolean innerClassesLast) throws MojoFailureException {
        return this.writeSourceIfChanged(source.printClass(innerClassesLast), filePath, fileName);
    }

    private boolean writeSourceIfChanged(String source, String filePath, String fileName) throws MojoFailureException {
        try {
            String code = this.licenseHeader + source;
            this.getLog().debug((CharSequence)("Source code generated:\n" + code));
            return this.updateResource(this.sourcesOutputDir.toPath(), filePath + "/" + fileName, code);
        }
        catch (Exception e) {
            throw new MojoFailureException("IOError with file " + filePath + "/" + fileName, (Throwable)e);
        }
    }
}

