/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.maven.packaging.dsl;

import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.camel.tooling.model.ComponentModel;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.CaseUtils;

public final class DslHelper {
    private DslHelper() {
    }

    public static List<File> loadAllJavaFiles(File dir, String targetJavaPackageName) {
        File allComponentsDslEndpointFactory = new File(dir, targetJavaPackageName.replace('.', '/'));
        return DslHelper.loadAllJavaFiles(allComponentsDslEndpointFactory);
    }

    public static List<File> loadAllJavaFiles(File dir) {
        File[] files = dir.listFiles();
        if (files == null) {
            return Collections.emptyList();
        }
        return Arrays.stream(files).filter(file -> file.isFile() && file.getName().endsWith(".java") && file.exists()).sorted().collect(Collectors.toList());
    }

    public static String toCamelCaseLower(String schema) {
        String convertedText = CaseUtils.toCamelCase((String)schema, (boolean)false, (char[])new char[]{'-', '+'});
        if (convertedText != null) {
            switch (convertedText) {
                case "class": {
                    convertedText = "clas";
                    break;
                }
                case "package": {
                    convertedText = "packag";
                    break;
                }
                case "rest": {
                    convertedText = "restEndpoint";
                    break;
                }
            }
        }
        return convertedText;
    }

    public static String getMainDescriptionWithoutPathOptions(ComponentModel componentModel) {
        String desc = componentModel.getTitle() + " (" + componentModel.getArtifactId() + ")";
        desc = desc + "\n" + componentModel.getDescription();
        desc = desc + "\n";
        desc = desc + "\nCategory: " + componentModel.getLabel();
        desc = desc + "\nSince: " + componentModel.getFirstVersionShort();
        desc = desc + "\nMaven coordinates: " + componentModel.getGroupId() + ":" + componentModel.getArtifactId();
        return desc;
    }

    public static String getMainDescription(ComponentModel componentModel) {
        Object desc = DslHelper.getMainDescriptionWithoutPathOptions(componentModel);
        desc = (String)desc + "\n";
        desc = (String)desc + "\nSyntax: <code>" + componentModel.getSyntax() + "</code>";
        for (ComponentModel.EndpointOptionModel option : componentModel.getEndpointOptions()) {
            if (!"path".equals(option.getKind())) continue;
            desc = (String)desc + "\n";
            desc = (String)desc + "\nPath parameter: " + option.getName();
            if (option.isRequired()) {
                desc = (String)desc + " (required)";
            }
            if (option.isDeprecated()) {
                desc = (String)desc + " <strong>deprecated</strong>";
            }
            desc = (String)desc + "\n" + option.getDescription();
            if (option.getDefaultValue() != null) {
                desc = (String)desc + "\nDefault value: " + option.getDefaultValue();
            }
            if (option.getEnums() == null || option.getEnums().isEmpty()) continue;
            desc = (String)desc + "\nThere are " + option.getEnums().size() + " enums and the value can be one of: " + DslHelper.wrapEnumValues(option.getEnums());
        }
        return desc;
    }

    public static String generateComponentBuilderClassName(ComponentModel componentModel, String suffix) {
        return StringUtils.capitalize((String)DslHelper.toCamelCaseLower(componentModel.getScheme())) + "Component" + suffix;
    }

    private static String wrapEnumValues(List<String> enumValues) {
        return String.join((CharSequence)", ", enumValues);
    }
}

