/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.maven.packaging;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.Set;
import java.util.StringJoiner;
import java.util.TreeSet;
import org.apache.camel.maven.packaging.AbstractGeneratorMojo;
import org.apache.camel.tooling.util.PackageHelper;
import org.apache.camel.tooling.util.Strings;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.Index;
import org.jboss.jandex.IndexReader;

@Mojo(name="update-classloaded-helper", threadSafe=true)
public class UpdateEagerClassloadedHelper
extends AbstractGeneratorMojo {
    public static final DotName EAGER_CLASSLOADED = DotName.createSimple((String)"org.apache.camel.spi.annotations.EagerClassloaded");
    private static final String[] MODULES = new String[]{"camel-base-engine", "camel-core-processor", "camel-support"};
    private static final String START_TOKEN = "// EAGER-CLASSLOADED: START";
    private static final String END_TOKEN = "// EAGER-CLASSLOADED: END";
    @Parameter(defaultValue="${project.basedir}/")
    protected File baseDir;

    public void execute() throws MojoExecutionException, MojoFailureException {
        File mainDir = PackageHelper.findCamelDirectory((File)this.baseDir, (String)"core/camel-main");
        if (mainDir == null) {
            this.getLog().debug((CharSequence)"No core/camel-main folder found, skipping execution");
            return;
        }
        TreeSet<String> fqns = new TreeSet<String>();
        for (String p : MODULES) {
            File dir = PackageHelper.findCamelDirectory((File)this.baseDir, (String)("core/" + p));
            if (dir == null || !dir.exists() || !dir.isDirectory()) continue;
            Path output = Paths.get(dir.getAbsolutePath() + "/target/classes", new String[0]);
            this.discoverClasses(output, fqns);
        }
        if (fqns.isEmpty()) {
            return;
        }
        this.getLog().info((CharSequence)("There are " + fqns.size() + " classes to eager loaded across the Camel core modules"));
        try {
            boolean updated = this.updateHelper(mainDir, fqns);
            if (updated) {
                this.getLog().info((CharSequence)"Updated camel-main/src/main/java/org/apache/camel/main/EagerClassloadedHelper.java file");
            } else {
                this.getLog().debug((CharSequence)"No changes to camel-main/src/main/java/org/apache/camel/main/EagerClassloadedHelper.java file");
            }
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error updating EagerClassloadedHelper.java", e);
        }
    }

    private void discoverClasses(Path output, Set<String> fqns) {
        Index index;
        try (InputStream is = Files.newInputStream(output.resolve("META-INF/jandex.idx"), new OpenOption[0]);){
            index = new IndexReader(is).read();
        }
        catch (IOException e) {
            return;
        }
        List annotations = index.getAnnotations(EAGER_CLASSLOADED);
        annotations.stream().filter(annotation -> annotation.target().kind() == AnnotationTarget.Kind.CLASS).filter(annotation -> annotation.target().asClass().nestingType() == ClassInfo.NestingType.TOP_LEVEL).forEach(annotation -> {
            String fqn = annotation.target().asClass().name().toString();
            fqns.add(fqn);
        });
    }

    private boolean updateHelper(File camelDir, Set<String> fqns) throws Exception {
        File java = new File(camelDir, "src/main/java/org/apache/camel/main/EagerClassloadedHelper.java");
        Object text = PackageHelper.loadText((File)java);
        String spaces8 = "        ";
        StringJoiner sb = new StringJoiner("\n");
        sb.add(spaces8 + "count = " + fqns.size() + ";");
        for (String name : fqns) {
            sb.add(spaces8 + name + ".onClassloaded(LOG);");
        }
        String changed = sb.toString();
        String existing = Strings.between((String)text, (String)START_TOKEN, (String)END_TOKEN);
        if (existing != null) {
            if ((existing = existing.trim()).equals(changed = changed.trim())) {
                return false;
            }
            String before = Strings.before((String)text, (String)START_TOKEN);
            String after = Strings.after((String)text, (String)END_TOKEN);
            text = before + "// EAGER-CLASSLOADED: START\n" + spaces8 + changed + "\n" + spaces8 + END_TOKEN + after;
            PackageHelper.writeText((File)java, (String)text);
            return true;
        }
        return false;
    }
}

