/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.maven.packaging;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.camel.maven.packaging.AbstractGeneratorMojo;
import org.apache.camel.maven.packaging.MvelHelper;
import org.apache.camel.tooling.model.AnnotationModel;
import org.apache.camel.tooling.model.ArtifactModel;
import org.apache.camel.tooling.model.BaseModel;
import org.apache.camel.tooling.model.BaseOptionModel;
import org.apache.camel.tooling.model.ComponentModel;
import org.apache.camel.tooling.model.DataFormatModel;
import org.apache.camel.tooling.model.EipModel;
import org.apache.camel.tooling.model.JsonMapper;
import org.apache.camel.tooling.model.LanguageModel;
import org.apache.camel.tooling.model.OtherModel;
import org.apache.camel.tooling.util.PackageHelper;
import org.apache.camel.tooling.util.Strings;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.jboss.forge.roaster.Roaster;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.dom.ASTNode;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.dom.AnnotationTypeMemberDeclaration;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.dom.Javadoc;
import org.jboss.forge.roaster.model.source.AnnotationElementSource;
import org.jboss.forge.roaster.model.source.JavaAnnotationSource;
import org.mvel2.templates.TemplateRuntime;
import org.sonatype.plexus.build.incremental.BuildContext;

@Mojo(name="update-readme", threadSafe=true)
public class UpdateReadmeMojo
extends AbstractGeneratorMojo {
    private static final boolean RELOCATE_MANUAL_ATTRIBUTES = false;
    private static final Pattern[] MANUAL_ATTRIBUTES = new Pattern[]{Pattern.compile(":(group): *(.*)"), Pattern.compile(":(summary-group): *(.*)"), Pattern.compile(":(camel-spring-boot-name): *(.*)"), Pattern.compile(":(starter-artifactid): *(.*)")};
    @Parameter(defaultValue="${project.build.directory}")
    protected File buildDir;
    @Parameter(defaultValue="${project.basedir}/src/main/docs")
    protected File componentDocDir;
    @Parameter(defaultValue="${project.basedir}/src/main/docs")
    protected File dataformatDocDir;
    @Parameter(defaultValue="${project.basedir}/src/main/docs")
    protected File languageDocDir;
    @Parameter(defaultValue="${project.basedir}/src/main/docs/modules/languages/pages")
    protected File languageDocDir2;
    @Parameter
    protected File eipDocDir;
    @Parameter
    protected Boolean failFast;
    protected List<Path> sourceRoots;

    @Override
    public void execute(MavenProject project, MavenProjectHelper projectHelper, BuildContext buildContext) throws MojoFailureException, MojoExecutionException {
        this.buildDir = new File(project.getBuild().getDirectory());
        this.componentDocDir = new File(project.getBasedir(), "src/main/docs");
        this.dataformatDocDir = new File(project.getBasedir(), "src/main/docs");
        this.languageDocDir = new File(project.getBasedir(), "/src/main/docs");
        this.languageDocDir2 = new File(project.getBasedir(), "/src/main/docs/modules/languages/pages");
        File engine = PackageHelper.findCamelDirectory((File)project.getBasedir(), (String)"camel-core-engine");
        this.eipDocDir = new File(engine, "/src/main/docs/modules/eips/pages");
        super.execute(project, projectHelper, buildContext);
    }

    public void execute() throws MojoExecutionException {
        this.getLog().debug((CharSequence)"UpdateReadmeMojo execute");
        this.executeComponent();
        this.executeOther();
        this.executeDataFormat();
        this.executeLanguage();
        this.executeEips();
    }

    private void executeComponent() throws MojoExecutionException {
        String kind = "component";
        List<String> componentNames = this.listDescriptorNamesOfType("component");
        TreeSet<File> jsonFiles = new TreeSet<File>();
        PackageHelper.findJsonFiles((File)this.buildDir, jsonFiles);
        if (!componentNames.isEmpty()) {
            if (this.getLog().isDebugEnabled()) {
                this.getLog().debug((CharSequence)("Found " + componentNames.size() + " components"));
            }
            for (String componentName : componentNames) {
                String json = UpdateReadmeMojo.loadJsonFrom(jsonFiles, "component", componentName);
                if (json == null) continue;
                componentName = UpdateReadmeMojo.asComponentName(componentName);
                File file = new File(this.componentDocDir, componentName + "-component.adoc");
                boolean exists = file.exists();
                ComponentModel model = this.generateComponentModel(json);
                String title = UpdateReadmeMojo.asComponentTitle(model.getScheme(), model.getTitle());
                model.setTitle(title);
                boolean updated = this.updateHeader(componentName, file, (BaseModel<? extends BaseOptionModel>)model, " Component", "component");
                this.checkComponentHeader(file);
                this.checkSince(file);
                updated |= this.updateOptionsIn(file, "component-configure", "");
                String options = UpdateReadmeMojo.evaluateTemplate("component-options.mvel", model);
                updated |= this.updateOptionsIn(file, "component", options);
                if (updated |= this.updateOptionsIn(file, "endpoint", "")) {
                    this.getLog().info((CharSequence)("Updated doc file: " + file));
                    continue;
                }
                if (exists) {
                    if (!this.getLog().isDebugEnabled()) continue;
                    this.getLog().debug((CharSequence)("No changes to doc file: " + file));
                    continue;
                }
                this.getLog().warn((CharSequence)("No component doc file: " + file));
                if (!this.isFailFast()) continue;
                throw new MojoExecutionException("Failed build due failFast=true");
            }
        }
    }

    private void executeOther() throws MojoExecutionException {
        TreeSet jsonFiles = new TreeSet();
        PackageHelper.findJsonFiles((File)this.buildDir, jsonFiles);
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((CharSequence)("UpdateReadmeMojo jsonFiles: " + jsonFiles));
        }
        if (!jsonFiles.isEmpty()) {
            if (this.getLog().isDebugEnabled()) {
                this.getLog().debug((CharSequence)("Found " + jsonFiles.size() + " miscellaneous components"));
            }
            for (File jsonFile : jsonFiles) {
                String kind = "other";
                String json = UpdateReadmeMojo.loadJsonFrom(jsonFile, "other");
                if (json == null) continue;
                OtherModel model = this.generateOtherModel(json);
                String title = model.getTitle();
                model.setTitle(title);
                String componentName = UpdateReadmeMojo.asComponentName(model.getName());
                File file = new File(this.componentDocDir, componentName + ".adoc");
                boolean exists = file.exists();
                boolean updated = this.updateHeader(componentName, file, (BaseModel<? extends BaseOptionModel>)model, " Component", "other");
                this.checkSince(file);
                if (updated) {
                    this.getLog().info((CharSequence)("Updated doc file: " + file));
                    continue;
                }
                if (exists) {
                    if (!this.getLog().isDebugEnabled()) continue;
                    this.getLog().debug((CharSequence)("No changes to doc file: " + file));
                    continue;
                }
                this.getLog().warn((CharSequence)("No component doc file: " + file));
                if (!this.isFailFast()) continue;
                throw new MojoExecutionException("Failed build due failFast=true");
            }
        }
    }

    private void executeDataFormat() throws MojoExecutionException {
        String kind = "dataformat";
        List<String> dataFormatNames = this.listDescriptorNamesOfType("dataformat");
        TreeSet<File> jsonFiles = new TreeSet<File>();
        PackageHelper.findJsonFiles((File)this.buildDir, jsonFiles);
        if (!dataFormatNames.isEmpty()) {
            if (this.getLog().isDebugEnabled()) {
                this.getLog().debug((CharSequence)("Found " + dataFormatNames.size() + " dataformats"));
            }
            for (String dataFormatName : dataFormatNames) {
                String json = UpdateReadmeMojo.loadJsonFrom(jsonFiles, "dataformat", dataFormatName);
                if (json == null) continue;
                dataFormatName = UpdateReadmeMojo.asDataFormatName(dataFormatName);
                File file = new File(this.dataformatDocDir, dataFormatName + "-dataformat.adoc");
                DataFormatModel model = this.generateDataFormatModel(json);
                if ("bindy".equals(dataFormatName)) {
                    model.getOptions().stream().filter(o -> "type".equals(o.getName())).forEach(o -> o.setDefaultValue(null));
                }
                String title = UpdateReadmeMojo.asDataFormatTitle(model.getName(), model.getTitle());
                model.setTitle(title);
                boolean exists = file.exists();
                boolean updated = this.updateHeader(dataFormatName, file, (BaseModel<? extends BaseOptionModel>)model, " DataFormat", "dataformat");
                this.checkSince(file);
                String options = UpdateReadmeMojo.evaluateTemplate("dataformat-options.mvel", model);
                updated |= this.updateOptionsIn(file, "dataformat", options);
                if ("bindy".equals(dataFormatName)) {
                    updated |= this.updateAnnotationsIn(file);
                }
                if (updated) {
                    this.getLog().info((CharSequence)("Updated doc file: " + file));
                    continue;
                }
                if (exists) {
                    if (!this.getLog().isDebugEnabled()) continue;
                    this.getLog().debug((CharSequence)("No changes to doc file: " + file));
                    continue;
                }
                this.getLog().warn((CharSequence)("No dataformat doc file: " + file));
                if (!this.isFailFast()) continue;
                throw new MojoExecutionException("Failed build due failFast=true");
            }
        }
    }

    private static String asComponentName(String name) {
        if (UpdateReadmeMojo.isMailComponent(name)) {
            return "mail";
        }
        return name;
    }

    private void executeLanguage() throws MojoExecutionException {
        String kind = "language";
        List<String> languageNames = this.listDescriptorNamesOfType("language");
        TreeSet<File> jsonFiles = new TreeSet<File>();
        PackageHelper.findJsonFiles((File)this.buildDir, jsonFiles);
        if (!languageNames.isEmpty()) {
            if (this.getLog().isDebugEnabled()) {
                this.getLog().debug((CharSequence)("Found " + languageNames.size() + " languages"));
            }
            for (String languageName : languageNames) {
                String json = UpdateReadmeMojo.loadJsonFrom(jsonFiles, "language", languageName);
                if (json == null) continue;
                File file = new File(this.languageDocDir, languageName + "-language.adoc");
                boolean exists = file.exists();
                if (!exists) {
                    file = new File(this.languageDocDir2, languageName + "-language.adoc");
                    exists = file.exists();
                }
                LanguageModel model = JsonMapper.generateLanguageModel((String)json);
                boolean updated = this.updateHeader(languageName, file, (BaseModel<? extends BaseOptionModel>)model, " Language", "language");
                this.checkSince(file);
                String options = UpdateReadmeMojo.evaluateTemplate("language-options.mvel", model);
                if (updated |= this.updateOptionsIn(file, "language", options)) {
                    this.getLog().info((CharSequence)("Updated doc file: " + file));
                    continue;
                }
                if (exists) {
                    if (!this.getLog().isDebugEnabled()) continue;
                    this.getLog().debug((CharSequence)("No changes to doc file: " + file));
                    continue;
                }
                this.getLog().warn((CharSequence)("No language doc file: " + file));
                if (!this.isFailFast()) continue;
                throw new MojoExecutionException("Failed build due failFast=true");
            }
        }
    }

    private void executeEips() throws MojoExecutionException {
        String currentDir = this.project.getBasedir().toString();
        if (!currentDir.endsWith("camel-core-engine")) {
            return;
        }
        TreeSet jsonFiles = new TreeSet();
        File coreDir = PackageHelper.findCamelDirectory((File)this.project.getBasedir(), (String)"camel-core-model");
        if (coreDir.isDirectory()) {
            File target = new File(coreDir, "src/generated/resources/org/apache/camel/model");
            PackageHelper.findJsonFiles((File)target, jsonFiles);
        }
        if (!jsonFiles.isEmpty()) {
            if (this.getLog().isDebugEnabled()) {
                this.getLog().debug((CharSequence)("Found " + jsonFiles.size() + " eips"));
            }
            for (File jsonFile : jsonFiles) {
                String json = UpdateReadmeMojo.loadEipJson(jsonFile);
                if (json == null) continue;
                EipModel model = JsonMapper.generateEipModel((String)json);
                String kind = "eip";
                if (!model.getLabel().startsWith("eip")) continue;
                String eipName = model.getName();
                File file = new File(this.eipDocDir, eipName + "-eip.adoc");
                boolean exists = file.exists();
                boolean updated = this.updateHeader(eipName, file, (BaseModel<? extends BaseOptionModel>)model, " EIP", "eip");
                String options = UpdateReadmeMojo.evaluateTemplate("eip-options.mvel", model);
                if (updated |= this.updateOptionsIn(file, "eip", options)) {
                    this.getLog().info((CharSequence)("Updated doc file: " + file));
                    continue;
                }
                if (exists) {
                    if (!this.getLog().isDebugEnabled()) continue;
                    this.getLog().debug((CharSequence)("No changes to doc file: " + file));
                    continue;
                }
                this.getLog().warn((CharSequence)("No eip doc file: " + file));
                if (!this.isFailFast()) continue;
                throw new MojoExecutionException("Failed build due failFast=true");
            }
        }
    }

    private static String asComponentTitle(String name, String title) {
        if (UpdateReadmeMojo.isMailComponent(name)) {
            return "Mail";
        }
        return title;
    }

    private static boolean isMailComponent(String name) {
        return name.equals("imap") || name.equals("imaps") || name.equals("pop3") || name.equals("pop3s") || name.equals("smtp") || name.equals("smtps");
    }

    private static String asDataFormatName(String name) {
        if (name.startsWith("bindy")) {
            return "bindy";
        }
        return name;
    }

    private static String asDataFormatTitle(String name, String title) {
        if (name.startsWith("bindy")) {
            return "Bindy";
        }
        return title;
    }

    private boolean updateHeader(String name, File file, BaseModel<? extends BaseOptionModel> model, String titleSuffix, String kind) throws MojoExecutionException {
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((CharSequence)("updateHeader " + file));
        }
        if (model == null || !file.exists()) {
            return false;
        }
        boolean updated = false;
        try {
            String text = PackageHelper.loadText((File)file);
            String[] lines = text.split("\n");
            if (lines.length < 5) {
                return false;
            }
            LinkedHashMap<String, String> manualAttributes = new LinkedHashMap<String, String>();
            block2: for (String line : lines) {
                if (line.length() == 0) break;
                for (Pattern attrName : MANUAL_ATTRIBUTES) {
                    Matcher m = attrName.matcher(line);
                    if (!m.matches()) continue;
                    manualAttributes.put(m.group(1), m.group(2));
                    continue block2;
                }
            }
            ArrayList<Object> newLines = new ArrayList<Object>(lines.length + 8);
            String title = model.getTitle() + titleSuffix;
            if (model.isDeprecated()) {
                title = title + " (deprecated)";
            }
            newLines.add("= " + title);
            newLines.add(":doctitle: " + model.getTitle());
            String shortName = "mail".equals(name) ? "imap" : name;
            newLines.add(":shortname: " + shortName);
            if (model instanceof ArtifactModel) {
                newLines.add(":artifactid: " + ((ArtifactModel)model).getArtifactId());
            }
            newLines.add(":description: " + model.getDescription());
            newLines.add(":since: " + model.getFirstVersionShort());
            newLines.add(":supportlevel: " + model.getSupportLevel().toString() + (model.isDeprecated() ? "-deprecated" : ""));
            if (model.isDeprecated()) {
                newLines.add(":deprecated: *deprecated*");
            }
            if (model instanceof ComponentModel) {
                newLines.add(":component-header: " + UpdateReadmeMojo.generateComponentHeader((ComponentModel)model));
                if (Arrays.asList(model.getLabel().split(",")).contains("core")) {
                    newLines.add(":core:");
                }
            }
            if (!manualAttributes.isEmpty()) {
                newLines.add("//Manually maintained attributes");
                for (Map.Entry entry : manualAttributes.entrySet()) {
                    newLines.add(":" + (String)entry.getKey() + ": " + (String)entry.getValue());
                }
            }
            newLines.add("");
            for (int i = 0; i < lines.length && i <= newLines.size() - 1; ++i) {
                if (((String)newLines.get(i)).equals(lines[i])) continue;
                updated = true;
                break;
            }
            boolean copy = false;
            if (updated) {
                for (String line : lines) {
                    if (!copy && line.isEmpty()) {
                        copy = true;
                        continue;
                    }
                    if (!copy) continue;
                    newLines.add(line);
                }
                if (!copy) {
                    throw new MojoFailureException("File " + file + " has unexpected structure with no empty line.");
                }
            }
            if (updated) {
                if (!((String)newLines.get(newLines.size() - 1)).isEmpty()) {
                    newLines.add("");
                }
                String string = String.join((CharSequence)"\n", newLines);
                PackageHelper.writeText((File)file, (String)string);
            }
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error reading file " + file + " Reason: " + e, e);
        }
        return updated;
    }

    private void checkComponentHeader(File file) throws MojoExecutionException {
        String loadedText;
        if (!file.exists()) {
            return;
        }
        String headerText = "*{component-header}*";
        try {
            loadedText = PackageHelper.loadText((File)file);
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error reading file " + file + " Reason: " + e, e);
        }
        if (!loadedText.contains("*{component-header}*")) {
            throw new MojoExecutionException("File " + file + " does not contain required string `*{component-header}*'");
        }
    }

    private void checkSince(File file) throws MojoExecutionException {
        String loadedText;
        if (!file.exists()) {
            return;
        }
        String sinceText = "*Since Camel {since}*";
        try {
            loadedText = PackageHelper.loadText((File)file);
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error reading file " + file + " Reason: " + e, e);
        }
        if (!loadedText.contains("*Since Camel {since}*")) {
            throw new MojoExecutionException("File " + file + " does not contain required string '*Since Camel {since}*'");
        }
    }

    private static String generateComponentHeader(ComponentModel model) {
        boolean consumerOnly = model.isConsumerOnly();
        boolean producerOnly = model.isProducerOnly();
        if (!consumerOnly && producerOnly) {
            return "Only producer is supported";
        }
        if (consumerOnly && !producerOnly) {
            return "Only consumer is supported";
        }
        return "Both producer and consumer are supported";
    }

    private boolean updateOptionsIn(File file, String kind, String changed) throws MojoExecutionException {
        if (!file.exists()) {
            return false;
        }
        String updated = changed.trim();
        try {
            Object text = PackageHelper.loadText((File)file);
            String existing = Strings.between((String)text, (String)("// " + kind + " options: START"), (String)("// " + kind + " options: END"));
            if (existing != null) {
                if ((existing = existing.trim()).equals(updated)) {
                    return false;
                }
                String before = Strings.before((String)text, (String)("// " + kind + " options: START"));
                String after = Strings.after((String)text, (String)("// " + kind + " options: END"));
                text = before + "// " + kind + " options: START\n" + updated + "\n// " + kind + " options: END" + after;
                PackageHelper.writeText((File)file, (String)text);
                return true;
            }
            this.getLog().warn((CharSequence)("Cannot find markers in file " + file));
            this.getLog().warn((CharSequence)"Add the following markers");
            this.getLog().warn((CharSequence)("\t// " + kind + " options: START"));
            this.getLog().warn((CharSequence)("\t// " + kind + " options: END"));
            if (this.isFailFast()) {
                throw new MojoExecutionException("Failed build due failFast=true");
            }
            return false;
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error reading file " + file + " Reason: " + e, (Exception)e);
        }
    }

    private boolean updateAnnotationsIn(File file) throws MojoExecutionException {
        if (!file.exists()) {
            return false;
        }
        try {
            String text = PackageHelper.loadText((File)file);
            String updated = this.updateAnnotationRecursivelyIn(text);
            if (text.equals(updated)) {
                return false;
            }
            PackageHelper.writeText((File)file, (String)updated);
            return true;
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error reading file " + file + " Reason: " + e, (Exception)e);
        }
    }

    private String updateAnnotationRecursivelyIn(String text) throws MojoExecutionException {
        String annotationInterface = Strings.between((String)text, (String)"// annotation interface:", (String)"// annotation options: START");
        if (annotationInterface == null) {
            return text;
        }
        Class<?> annotation = this.loadClass(annotationInterface = annotationInterface.trim());
        if (!annotation.isAnnotation()) {
            throw new MojoExecutionException("Interface " + annotationInterface + " is not an annotation");
        }
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((CharSequence)("Processing annotation " + annotationInterface));
        }
        AnnotationModel model = this.generateAnnotationModel(annotation);
        String options = UpdateReadmeMojo.evaluateTemplate("annotation-options.mvel", model);
        String updated = options.trim();
        String existing = Strings.between((String)text, (String)"// annotation options: START", (String)"// annotation options: END");
        if (existing == null) {
            return text;
        }
        existing = existing.trim();
        String after = Strings.after((String)text, (String)"// annotation options: END");
        String afterUpdated = this.updateAnnotationRecursivelyIn(after);
        if (existing.equals(updated) && Objects.equals(after, afterUpdated)) {
            return text;
        }
        String before = Strings.before((String)text, (String)"// annotation options: START");
        return before + "// annotation options: START\n" + updated + "\n// annotation options: END" + afterUpdated;
    }

    private static String loadJsonFrom(Set<File> jsonFiles, String kind, String name) {
        for (File file : jsonFiles) {
            String json;
            if (!file.getName().equals(name + ".json") || (json = UpdateReadmeMojo.doLoad(file, kind)) == null) continue;
            return json;
        }
        return null;
    }

    private static String loadJsonFrom(File file, String kind) {
        String json;
        if (file.getName().endsWith(".json") && (json = UpdateReadmeMojo.doLoad(file, kind)) != null) {
            return json;
        }
        return null;
    }

    private static String doLoad(File file, String kind) {
        try {
            String json = PackageHelper.loadText((File)file);
            if (Objects.equals(kind, PackageHelper.getSchemaKind((String)json))) {
                return json;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    private static String loadEipJson(File file) {
        try {
            String json = PackageHelper.loadText((File)file);
            if ("model".equals(PackageHelper.getSchemaKind((String)json))) {
                return json;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    private ComponentModel generateComponentModel(String json) {
        return JsonMapper.generateComponentModel((String)json);
    }

    private OtherModel generateOtherModel(String json) {
        OtherModel other = JsonMapper.generateOtherModel((String)json);
        return other;
    }

    private DataFormatModel generateDataFormatModel(String json) {
        return JsonMapper.generateDataFormatModel((String)json);
    }

    private AnnotationModel generateAnnotationModel(Class<?> annotation) {
        String source = this.loadJavaSource(annotation.getName());
        JavaAnnotationSource annotationSource = this.parseAnnotationSource(source);
        AnnotationModel model = new AnnotationModel();
        for (Method method : annotation.getDeclaredMethods()) {
            String javadoc;
            AnnotationModel.AnnotationOptionModel option = new AnnotationModel.AnnotationOptionModel();
            option.setName(method.getName());
            option.setType(method.getReturnType().getSimpleName());
            if (method.getDefaultValue() != null) {
                option.setOptional(true);
                option.setDefaultValue(method.getDefaultValue().toString());
            }
            if (!Strings.isNullOrEmpty((String)(javadoc = this.findJavaDoc(source, annotationSource, method)))) {
                option.setDescription(javadoc.trim());
            }
            model.addOption(option);
        }
        return model;
    }

    private String loadJavaSource(String className) {
        try {
            Path file = this.getSourceRoots().stream().map(d -> d.resolve(className.replace('.', '/') + ".java")).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).findFirst().orElse(null);
            if (file == null) {
                throw new FileNotFoundException("Unable to find source for " + className);
            }
            return PackageHelper.loadText((Path)file);
        }
        catch (IOException e) {
            String classpath;
            try {
                classpath = this.project.getCompileClasspathElements().toString();
            }
            catch (Exception e2) {
                classpath = e2.toString();
            }
            throw new RuntimeException("Unable to load source for class " + className + " in folders " + this.getSourceRoots() + " (classpath: " + classpath + ")");
        }
    }

    private JavaAnnotationSource parseAnnotationSource(String source) {
        return (JavaAnnotationSource)Roaster.parse(JavaAnnotationSource.class, (String)source);
    }

    private List<Path> getSourceRoots() {
        if (this.sourceRoots == null) {
            this.sourceRoots = this.project.getCompileSourceRoots().stream().map(x$0 -> Paths.get(x$0, new String[0])).collect(Collectors.toList());
        }
        return this.sourceRoots;
    }

    private String findJavaDoc(String source, JavaAnnotationSource annotationSource, Method method) {
        AnnotationElementSource element = annotationSource.getAnnotationElement(method.getName());
        if (element == null) {
            return null;
        }
        return UpdateReadmeMojo.getJavaDocText(source, element);
    }

    static String getJavaDocText(String source, AnnotationElementSource member) {
        if (member == null) {
            return null;
        }
        AnnotationTypeMemberDeclaration decl = (AnnotationTypeMemberDeclaration)member.getInternal();
        Javadoc jd = decl.getJavadoc();
        if (source == null || jd.tags().isEmpty()) {
            return null;
        }
        ASTNode n = (ASTNode)jd.tags().get(0);
        String txt = source.substring(n.getStartPosition(), n.getStartPosition() + n.getLength());
        return txt.replaceAll(" *\n *\\* *\n", "\n\n").replaceAll(" *\n *\\* +", "\n");
    }

    private static String evaluateTemplate(String templateName, Object model) throws MojoExecutionException {
        String string;
        block8: {
            InputStream templateStream = UpdateReadmeMojo.class.getClassLoader().getResourceAsStream(templateName);
            try {
                String template = PackageHelper.loadText((InputStream)templateStream);
                string = (String)TemplateRuntime.eval((String)template, (Object)model, Collections.singletonMap("util", MvelHelper.INSTANCE));
                if (templateStream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (templateStream != null) {
                        try {
                            templateStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new MojoExecutionException("Error processing mvel template `" + templateName + "`", (Exception)e);
                }
            }
            templateStream.close();
        }
        return string;
    }

    private List<String> listDescriptorNamesOfType(String type) {
        File[] files;
        ArrayList<String> names = new ArrayList<String>();
        File f = new File(this.project.getBasedir(), "target/classes");
        if ((f = new File(f, "META-INF/services/org/apache/camel/" + type)).exists() && f.isDirectory() && (files = f.listFiles()) != null) {
            for (File file : files) {
                String name;
                if (file.isDirectory() || (name = file.getName()).charAt(0) == '.') continue;
                names.add(name);
            }
        }
        Collections.sort(names);
        return names;
    }

    private boolean isFailFast() {
        return this.failFast != null && this.failFast != false;
    }
}

