/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.maven.packaging.generics;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.jboss.jandex.Index;
import org.jboss.jandex.IndexReader;

public final class PackagePluginUtils {
    private PackagePluginUtils() {
    }

    public static Index readJandexIndex(MavenProject project) throws MojoExecutionException {
        Index index;
        Path output = Paths.get(project.getBuild().getOutputDirectory(), new String[0]);
        try (InputStream is = Files.newInputStream(output.resolve("META-INF/jandex.idx"), new OpenOption[0]);){
            index = new IndexReader(is).read();
        }
        catch (IOException e) {
            throw new MojoExecutionException("IOException: " + e.getMessage(), (Exception)e);
        }
        return index;
    }

    public static String joinHeaderAndSource(String licenseHeader, String source) {
        StringBuilder sb = new StringBuilder(licenseHeader);
        sb.append("\n");
        sb.append(source);
        return sb.toString();
    }
}

