/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.maven.packaging;

import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import java.util.TreeSet;
import org.apache.camel.maven.packaging.AbstractGeneratorMojo;
import org.apache.camel.maven.packaging.generics.PackagePluginUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.jboss.jandex.DotName;
import org.jboss.jandex.Index;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.Type;

@Mojo(name="generate-invoke-on-header", threadSafe=true, defaultPhase=LifecyclePhase.PROCESS_CLASSES, requiresDependencyCollection=ResolutionScope.COMPILE, requiresDependencyResolution=ResolutionScope.COMPILE)
public class GenerateInvokeOnHeaderMojo
extends AbstractGeneratorMojo {
    public static final DotName HEADER_ANNOTATION = DotName.createSimple((String)"org.apache.camel.spi.InvokeOnHeader");
    @Parameter(defaultValue="${project.build.directory}")
    protected File buildDir;
    @Parameter(defaultValue="${project.basedir}/src/generated/java")
    protected File sourcesOutputDir;
    @Parameter(defaultValue="${project.basedir}/src/generated/resources")
    protected File resourcesOutputDir;

    public void execute() throws MojoExecutionException, MojoFailureException {
        Index index;
        if ("pom".equals(this.project.getPackaging())) {
            return;
        }
        this.buildDir = new File(this.project.getBuild().getDirectory());
        if (this.sourcesOutputDir == null) {
            this.sourcesOutputDir = new File(this.project.getBasedir(), "src/generated/java");
        }
        if (this.resourcesOutputDir == null) {
            this.resourcesOutputDir = new File(this.project.getBasedir(), "src/generated/resources");
        }
        if ((index = PackagePluginUtils.readJandexIndexIgnoreMissing(this.project, this.getLog())) == null) {
            return;
        }
        HashMap classes = new HashMap();
        List annotations = index.getAnnotations(HEADER_ANNOTATION);
        annotations.forEach(a -> {
            boolean isVoid;
            String currentClass = a.target().asMethod().declaringClass().name().toString();
            String value = a.value().asString();
            MethodInfo mi = a.target().asMethod();
            InvokeOnHeaderModel model = new InvokeOnHeaderModel();
            model.setKey(value);
            model.setMethodName(mi.name());
            boolean bl = isVoid = Type.Kind.VOID == mi.returnType().kind();
            if (isVoid) {
                model.setReturnType("VOID");
            } else {
                model.setReturnType(mi.returnType().toString());
            }
            for (Type type : mi.parameters()) {
                String arg = type.name().toString();
                model.addArgs(arg);
            }
            Set set = classes.computeIfAbsent(currentClass, k -> new TreeSet<InvokeOnHeaderModel>(Comparator.comparing(InvokeOnHeaderModel::getKey)));
            set.add(model);
        });
        try {
            for (Map.Entry entry : classes.entrySet()) {
                this.createInvokeOnHeaderFactory((String)entry.getKey(), (Set)entry.getValue());
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException("IOException: " + e.getMessage(), (Exception)e);
        }
    }

    protected void createInvokeOnHeaderFactory(String fqn, Set<InvokeOnHeaderModel> models) throws IOException {
        String tfqn = this.generateInvokeOnHeaderFactory(fqn, models, this.sourcesOutputDir);
        this.updateResource(this.resourcesOutputDir.toPath(), "META-INF/services/org/apache/camel/invoke-on-header/" + fqn, "# Generated by camel build tools - do NOT edit this file!\nclass=" + tfqn + "\n");
    }

    @Deprecated
    private String generateInvokeOnHeaderFactory(String fqn, Set<InvokeOnHeaderModel> models, File outputDir) {
        int pos = fqn.lastIndexOf(46);
        String pn = fqn.substring(0, pos);
        String cn = fqn.substring(pos + 1) + "InvokeOnHeaderFactory";
        String en = fqn;
        String pfqn = fqn;
        StringWriter sw = new StringWriter();
        this.generateInvokeOnHeaderSource(pn, cn, en, pfqn, sw, models);
        String source = sw.toString();
        String fileName = pn.replace('.', '/') + "/" + cn + ".java";
        outputDir.mkdirs();
        boolean updated = GenerateInvokeOnHeaderMojo.updateResource(this.buildContext, outputDir.toPath().resolve(fileName), source);
        if (updated) {
            this.getLog().info((CharSequence)("Updated " + fileName));
        }
        return pn + "." + cn;
    }

    private void generateInvokeOnHeaderSource(String pn, String cn, String en, String pfqn, StringWriter w, Set<InvokeOnHeaderModel> models) {
        w.write("/* Generated by camel build tools - do NOT edit this file! */\n");
        w.write("package " + pn + ";\n");
        w.write("\n");
        w.write("import org.apache.camel.AsyncCallback;\n");
        w.write("import org.apache.camel.Exchange;\n");
        w.write("import org.apache.camel.spi.InvokeOnHeaderStrategy;\n");
        w.write("import " + pfqn + ";\n");
        w.write("\n");
        w.write("/**\n");
        w.write(" * Generated by camel build tools - do NOT edit this file!\n");
        w.write(" */\n");
        w.write("@SuppressWarnings(\"unchecked\")\n");
        w.write("public class " + cn + " implements InvokeOnHeaderStrategy");
        w.write(" {\n");
        w.write("\n");
        w.write("    @Override\n");
        w.write("    public Object invoke(Object obj, String key, Exchange exchange, AsyncCallback callback) throws Exception {\n");
        w.write("        " + en + " target = (" + en + ") obj;\n");
        if (!models.isEmpty()) {
            w.write("        switch (key) {\n");
            for (InvokeOnHeaderModel option : models) {
                boolean sync = true;
                String invoke = "target." + option.getMethodName() + "(";
                if (!option.getArgs().isEmpty()) {
                    StringJoiner sj = new StringJoiner(", ");
                    for (String arg : option.getArgs()) {
                        String ba = this.bindArg(arg);
                        sync &= !ba.equals("callback");
                        sj.add(ba);
                    }
                    invoke = invoke + sj.toString();
                }
                String ret = "null";
                if (!sync) {
                    ret = "callback";
                }
                invoke = invoke + ")";
                if (!option.getKey().toLowerCase().equals(option.getKey())) {
                    w.write(String.format("        case \"%s\":\n", option.getKey().toLowerCase()));
                }
                if (!sync || option.getReturnType().equals("VOID")) {
                    w.write(String.format("        case \"%s\": %s; return %s;\n", option.getKey(), invoke, ret));
                    continue;
                }
                w.write(String.format("        case \"%s\": return %s;\n", option.getKey(), invoke));
            }
            w.write("        default: return null;\n");
            w.write("        }\n");
        }
        w.write("    }\n");
        w.write("\n");
        w.write("}\n");
        w.write("\n");
    }

    protected String bindArg(String type) {
        if ("org.apache.camel.Exchange".equals(type)) {
            return "exchange";
        }
        if ("org.apache.camel.Message".equals(type)) {
            return "exchange.getMessage()";
        }
        if ("org.apache.camel.AsyncCallback".equals(type)) {
            return "callback";
        }
        if ("org.apache.camel.CamelContext".equals(type)) {
            return "exchange.getContext()";
        }
        return "exchange.getMessage().getBody(" + type + ".class)";
    }

    private static class InvokeOnHeaderModel {
        private String key;
        private String methodName;
        private String returnType;
        private final List<String> args = new ArrayList<String>();

        private InvokeOnHeaderModel() {
        }

        public String getKey() {
            return this.key;
        }

        public void setKey(String key) {
            this.key = key;
        }

        public String getMethodName() {
            return this.methodName;
        }

        public void setMethodName(String methodName) {
            this.methodName = methodName;
        }

        public String getReturnType() {
            return this.returnType;
        }

        public void setReturnType(String returnType) {
            this.returnType = returnType;
        }

        public List<String> getArgs() {
            return this.args;
        }

        public void addArgs(String arg) {
            this.args.add(arg);
        }
    }
}

