/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.maven.packaging;

import java.io.File;
import java.io.IOError;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.function.Supplier;
import org.apache.camel.tooling.util.FileUtil;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.sonatype.plexus.build.incremental.BuildContext;

public abstract class AbstractGeneratorMojo
extends AbstractMojo {
    public static final String GENERATED_MSG = "Generated by camel build tools - do NOT edit this file!";
    public static final String NL = "\n";
    @Parameter(property="project", required=true, readonly=true)
    protected MavenProject project;
    @Component
    protected MavenProjectHelper projectHelper;
    @Component
    protected BuildContext buildContext;

    public void execute(MavenProject project, MavenProjectHelper projectHelper, BuildContext buildContext) throws MojoFailureException, MojoExecutionException {
        this.project = project;
        this.projectHelper = projectHelper;
        this.buildContext = buildContext;
        this.execute();
    }

    protected void addResourceDirectory(Path path) {
        this.projectHelper.addResource(this.project, path.toString(), Collections.singletonList("**/*"), Collections.emptyList());
    }

    public void refresh(Path file) {
        AbstractGeneratorMojo.refresh(this.buildContext, file);
    }

    protected boolean updateResource(Path dir, String fileName, String data) {
        boolean updated = AbstractGeneratorMojo.updateResource(this.buildContext, dir.resolve(fileName), data);
        if (!fileName.endsWith(".java")) {
            Path outputDir = Paths.get(this.project.getBuild().getOutputDirectory(), new String[0]);
            updated |= AbstractGeneratorMojo.updateResource(this.buildContext, outputDir.resolve(fileName), data);
        }
        return updated;
    }

    protected String createProperties(String key, String val) {
        return AbstractGeneratorMojo.createProperties(this.project, key, val);
    }

    public static String createProperties(MavenProject project, String key, String val) {
        StringBuilder properties = new StringBuilder();
        properties.append("# Generated by camel build tools - do NOT edit this file!\n");
        properties.append(key).append("=").append(val).append(NL);
        properties.append("groupId=").append(project.getGroupId()).append(NL);
        properties.append("artifactId=").append(project.getArtifactId()).append(NL);
        properties.append("version=").append(project.getVersion()).append(NL);
        properties.append("projectName=").append(project.getName()).append(NL);
        if (project.getDescription() != null) {
            properties.append("projectDescription=").append(project.getDescription()).append(NL);
        }
        String data = properties.toString();
        return data;
    }

    public static void refresh(BuildContext buildContext, Path file) {
        if (buildContext != null) {
            buildContext.refresh(file.toFile());
        }
    }

    public static boolean updateResource(BuildContext buildContext, Path out, String data) {
        try {
            if (FileUtil.updateFile((Path)out, (String)data)) {
                AbstractGeneratorMojo.refresh(buildContext, out);
                return true;
            }
        }
        catch (IOException e) {
            throw new IOError(e);
        }
        return false;
    }

    public static boolean haveResourcesChanged(Log log, MavenProject project, BuildContext buildContext, String suffix) {
        String baseDir = project.getBasedir().getAbsolutePath();
        for (Resource r : project.getBuild().getResources()) {
            File file = new File(r.getDirectory());
            if (file.isAbsolute()) {
                file = new File(r.getDirectory().substring(baseDir.length() + 1));
            }
            String path = file.getPath() + "/" + suffix;
            if (log.isDebugEnabled()) {
                log.debug((CharSequence)("Checking  if " + path + " (" + r.getDirectory() + "/" + suffix + ") has changed."));
            }
            if (!buildContext.hasDelta(path)) continue;
            log.debug((CharSequence)("Indeed " + suffix + " has changed."));
            return true;
        }
        return false;
    }

    protected static <T> Supplier<T> cache(final Supplier<T> supplier) {
        return new Supplier<T>(){
            T value;

            @Override
            public T get() {
                if (this.value == null) {
                    this.value = supplier.get();
                }
                return this.value;
            }
        };
    }
}

