/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.maven.packaging;

import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import org.apache.camel.maven.packaging.AbstractGeneratorMojo;
import org.apache.camel.maven.packaging.DynamicClassLoader;
import org.apache.camel.maven.packaging.PropertyMainConfigurerGenerator;
import org.apache.camel.tooling.model.BaseOptionModel;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.springframework.util.ReflectionUtils;

@Mojo(name="generate-main-configurer", threadSafe=true, defaultPhase=LifecyclePhase.PROCESS_CLASSES)
public class MainConfigurerMojo
extends AbstractGeneratorMojo {
    private static final String[] CLASS_NAMES = new String[]{"org.apache.camel.main.MainConfigurationProperties", "org.apache.camel.main.HystrixConfigurationProperties", "org.apache.camel.main.Resilience4jConfigurationProperties", "org.apache.camel.main.RestConfigurationProperties", "org.apache.camel.ExtendedCamelContext"};
    @Parameter(defaultValue="${project.basedir}/src/generated/java")
    protected File srcOutDir;
    @Parameter(defaultValue="${project.basedir}/src/generated/resources")
    protected File resourcesOutputDir;
    private DynamicClassLoader projectClassLoader;

    public void execute() throws MojoExecutionException, MojoFailureException {
        ArrayList<String> cp = new ArrayList<String>();
        cp.add(0, this.project.getBuild().getOutputDirectory());
        this.project.getDependencyArtifacts().forEach(a -> {
            if (a.isResolved() && a.getFile() != null) {
                cp.add(a.getFile().getPath());
            }
        });
        this.projectClassLoader = DynamicClassLoader.createDynamicClassLoader(cp);
        for (String fqn : CLASS_NAMES) {
            try {
                List<Option> options = this.processClass(fqn);
                this.generateConfigurer(fqn, options);
                this.generateMetaInfConfigurer(fqn);
            }
            catch (Exception e) {
                throw new MojoExecutionException("Error processing class: " + fqn, e);
            }
        }
    }

    private List<Option> processClass(String name) throws ClassNotFoundException {
        ArrayList<Option> answer = new ArrayList<Option>();
        Class<?> clazz = this.projectClassLoader.loadClass(name);
        ReflectionUtils.doWithMethods(clazz, m -> {
            boolean setter = m.getName().length() >= 4 && m.getName().startsWith("set") && Character.isUpperCase(m.getName().charAt(3));
            setter &= Modifier.isPublic(m.getModifiers()) && m.getParameterCount() == 1;
            if (setter &= this.filterSetter(m)) {
                String t = Character.toUpperCase(m.getName().charAt(3)) + m.getName().substring(4);
                answer.add(new Option(t, m.getParameterTypes()[0]));
            }
        });
        return answer;
    }

    private boolean filterSetter(Method setter) {
        if ("setBindingMode".equals(setter.getName())) {
            return setter.getParameterTypes()[0] == String.class;
        }
        if ("setHostNameResolver".equals(setter.getName())) {
            return setter.getParameterTypes()[0] == String.class;
        }
        return true;
    }

    private void generateConfigurer(String name, List<Option> options) throws IOException {
        String pn = "org.apache.camel.main";
        String cn = name.substring(name.lastIndexOf(46) + 1) + "Configurer";
        String en = name;
        String pfqn = name;
        String psn = "org.apache.camel.support.component.PropertyConfigurerSupport";
        StringWriter sw = new StringWriter();
        PropertyMainConfigurerGenerator.generatePropertyConfigurer(pn, cn, en, pfqn, psn, options, sw);
        String source = sw.toString();
        String fileName = pn.replace('.', '/') + "/" + cn + ".java";
        boolean updated = this.updateResource(this.srcOutDir.toPath(), fileName, source);
        if (updated) {
            this.getLog().info((CharSequence)("Updated " + fileName));
        }
    }

    private void generateMetaInfConfigurer(String name) {
        String pn = "org.apache.camel.main";
        String en = name.substring(name.lastIndexOf(46) + 1);
        try (StringWriter w = new StringWriter();){
            ((Writer)w).append("# Generated by camel build tools - do NOT edit this file!\n");
            ((Writer)w).append("class=").append(pn).append(".").append(en).append("Configurer").append("\n");
            this.updateResource(this.resourcesOutputDir.toPath(), "META-INF/services/org/apache/camel/configurer/" + en, ((Object)w).toString());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static class Option
    extends BaseOptionModel {
        public Option(String name, Class type) {
            this.setName(name);
            this.setJavaType(type.getName());
        }
    }
}

