/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.maven.packaging;

import java.io.IOException;
import java.io.Writer;
import java.util.Collection;
import java.util.Comparator;
import java.util.stream.Collectors;
import org.apache.camel.tooling.model.BaseOptionModel;

public final class PropertyMainConfigurerGenerator {
    private PropertyMainConfigurerGenerator() {
    }

    public static void generatePropertyConfigurer(String pn, String cn, String en, String pfqn, String psn, Collection<? extends BaseOptionModel> options, Writer w) throws IOException {
        w.write("/* Generated by camel build tools - do NOT edit this file! */\n");
        w.write("package " + pn + ";\n");
        w.write("\n");
        w.write("import org.apache.camel.CamelContext;\n");
        w.write("import org.apache.camel.spi.GeneratedPropertyConfigurer;\n");
        w.write("import " + pfqn + ";\n");
        w.write("\n");
        w.write("/**\n");
        w.write(" * Generated by camel build tools - do NOT edit this file!\n");
        w.write(" */\n");
        w.write("@SuppressWarnings(\"unchecked\")\n");
        w.write("public class " + cn + " extends " + psn + " implements GeneratedPropertyConfigurer {\n");
        w.write("\n");
        if (!options.isEmpty()) {
            options = options.stream().sorted(Comparator.comparing(BaseOptionModel::getName)).collect(Collectors.toList());
            w.write("    @Override\n");
            w.write("    public boolean configure(CamelContext camelContext, Object obj, String name, Object value, boolean ignoreCase) {\n");
            if (!options.isEmpty()) {
                w.write("        " + en + " target = (" + en + ") obj;\n");
                w.write("        switch (ignoreCase ? name.toLowerCase() : name) {\n");
                for (BaseOptionModel option : options) {
                    String getOrSet = option.getName();
                    getOrSet = Character.toUpperCase(getOrSet.charAt(0)) + getOrSet.substring(1);
                    String setterLambda = PropertyMainConfigurerGenerator.setterLambda(getOrSet, option.getJavaType());
                    if (!option.getName().toLowerCase().equals(option.getName())) {
                        w.write(String.format("        case \"%s\":\n", option.getName().toLowerCase()));
                    }
                    w.write(String.format("        case \"%s\": %s; return true;\n", option.getName(), setterLambda));
                }
                w.write("        default: return false;\n");
                w.write("        }\n");
            }
            w.write("    }\n");
        }
        w.write("\n");
        w.write("}\n");
        w.write("\n");
    }

    private static String setterLambda(String getOrSet, String type) {
        if (type.indexOf(60) != -1) {
            type = type.substring(0, type.indexOf(60));
        }
        type = type.replace('$', '.');
        getOrSet = "target.set" + getOrSet;
        return String.format("%s(property(camelContext, %s.class, value))", getOrSet, type);
    }
}

