/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.maven.packaging;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.TreeSet;
import org.apache.camel.maven.packaging.MvelHelper;
import org.apache.camel.maven.packaging.UpdateReadmeMojo;
import org.apache.camel.tooling.model.ArtifactModel;
import org.apache.camel.tooling.model.BaseModel;
import org.apache.camel.tooling.model.ComponentModel;
import org.apache.camel.tooling.model.DataFormatModel;
import org.apache.camel.tooling.model.JsonMapper;
import org.apache.camel.tooling.model.LanguageModel;
import org.apache.camel.tooling.model.OtherModel;
import org.apache.camel.tooling.util.PackageHelper;
import org.apache.camel.tooling.util.Strings;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.mvel2.templates.TemplateRuntime;

@Mojo(name="update-doc-component-list", threadSafe=true)
public class UpdateDocComponentListMojo
extends AbstractMojo {
    @Parameter(property="project", required=true, readonly=true)
    protected MavenProject project;
    @Parameter(defaultValue="${project.build.directory}/classes/org/apache/camel/catalog/components")
    protected File componentsDir;
    @Parameter(defaultValue="${project.build.directory}/classes/org/apache/camel/catalog/dataformats")
    protected File dataFormatsDir;
    @Parameter(defaultValue="${project.build.directory}/classes/org/apache/camel/catalog/languages")
    protected File languagesDir;
    @Parameter(defaultValue="${project.build.directory}/classes/org/apache/camel/catalog/others")
    protected File othersDir;
    @Parameter(defaultValue="${project.directory}/../../../docs/components/modules/ROOT/pages/index.adoc")
    protected File websiteComponentsIndex;
    @Parameter(defaultValue="${project.directory}/../../../docs/components/modules/dataformats/pages/index.adoc")
    protected File websiteDataFormatsIndex;
    @Parameter(defaultValue="${project.directory}/../../../docs/components/modules/languages/pages/index.adoc")
    protected File websiteLanguagesIndex;
    @Component
    private MavenProjectHelper projectHelper;

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.executeComponentsList();
        this.executeDataFormatsList();
        this.executeLanguagesList();
        this.executeOthersReadme();
    }

    protected void executeComponentsList() throws MojoExecutionException, MojoFailureException {
        File[] files;
        TreeSet<File> componentFiles = new TreeSet<File>();
        if (this.componentsDir != null && this.componentsDir.isDirectory() && (files = this.componentsDir.listFiles()) != null) {
            componentFiles.addAll(Arrays.asList(files));
        }
        try {
            ArrayList<ComponentModel> models = new ArrayList<ComponentModel>();
            for (File file : componentFiles) {
                String json = PackageHelper.loadText((File)file);
                ComponentModel model = JsonMapper.generateComponentModel((String)json);
                boolean add = true;
                if (!Strings.isNullOrEmpty((String)model.getAlternativeSchemes())) {
                    String first = model.getAlternativeSchemes().split(",")[0];
                    if (!model.getScheme().equals(first)) {
                        add = false;
                    }
                }
                if (!add) continue;
                models.add(model);
                if (!"imap".equals(model.getScheme())) continue;
                model.setScheme("mail");
                model.setTitle("Mail");
            }
            models.sort((m1, m2) -> m1.getTitle().compareToIgnoreCase(m2.getTitle()));
            long count = models.stream().map(ArtifactModel::getArtifactId).distinct().count();
            long deprecated = models.stream().filter(BaseModel::isDeprecated).count();
            File file = this.websiteComponentsIndex;
            boolean exists = file.exists();
            String changed = this.templateComponents(models, count, deprecated);
            boolean updated = this.updateComponents(file, changed);
            if (updated) {
                this.getLog().info((CharSequence)("Updated website doc file: " + file));
            } else if (exists) {
                this.getLog().debug((CharSequence)("No changes to website doc file: " + file));
            } else {
                this.getLog().warn((CharSequence)("No website doc file: " + file));
            }
        }
        catch (IOException e) {
            throw new MojoFailureException("Error due " + e.getMessage(), (Throwable)e);
        }
    }

    protected void executeOthersReadme() throws MojoExecutionException, MojoFailureException {
        File[] files;
        TreeSet<File> otherFiles = new TreeSet<File>();
        if (this.othersDir != null && this.othersDir.isDirectory() && (files = this.othersDir.listFiles()) != null) {
            otherFiles.addAll(Arrays.asList(files));
        }
        try {
            ArrayList<OtherModel> models = new ArrayList<OtherModel>();
            for (File file : otherFiles) {
                String json = PackageHelper.loadText((File)file);
                OtherModel model = JsonMapper.generateOtherModel((String)json);
                models.add(model);
            }
            models.sort((m1, m2) -> m1.getTitle().compareToIgnoreCase(m2.getTitle()));
            long count = models.stream().map(ArtifactModel::getArtifactId).distinct().count();
            long deprecated = models.stream().filter(BaseModel::isDeprecated).count();
            File file = this.websiteComponentsIndex;
            boolean exists = file.exists();
            String changed = this.templateOthers(models, count, deprecated);
            boolean updated = this.updateOthers(file, changed);
            if (updated) {
                this.getLog().info((CharSequence)("Updated website doc file: " + file));
            } else if (exists) {
                this.getLog().debug((CharSequence)("No changes to website doc file: " + file));
            } else {
                this.getLog().warn((CharSequence)("No website doc file: " + file));
            }
        }
        catch (IOException e) {
            throw new MojoFailureException("Error due " + e.getMessage(), (Throwable)e);
        }
    }

    protected void executeDataFormatsList() throws MojoExecutionException, MojoFailureException {
        File[] files;
        TreeSet<File> dataFormatFiles = new TreeSet<File>();
        if (this.dataFormatsDir != null && this.dataFormatsDir.isDirectory() && (files = this.dataFormatsDir.listFiles()) != null) {
            dataFormatFiles.addAll(Arrays.asList(files));
        }
        try {
            ArrayList<DataFormatModel> models = new ArrayList<DataFormatModel>();
            for (File file : dataFormatFiles) {
                String json = PackageHelper.loadText((File)file);
                DataFormatModel model = JsonMapper.generateDataFormatModel((String)json);
                if (model.getName().startsWith("bindy")) {
                    model.setName("bindy");
                }
                models.add(model);
            }
            models.sort((m1, m2) -> m1.getTitle().compareToIgnoreCase(m2.getTitle()));
            long count = models.stream().map(ArtifactModel::getArtifactId).distinct().count();
            long deprecated = models.stream().filter(BaseModel::isDeprecated).count();
            File file = this.websiteDataFormatsIndex;
            boolean exists = file.exists();
            String changed = this.templateDataFormats(models, count, deprecated);
            boolean updated = this.updateDataFormats(file, changed);
            if (updated) {
                this.getLog().info((CharSequence)("Updated website doc file: " + file));
            } else if (exists) {
                this.getLog().debug((CharSequence)("No changes to website doc file: " + file));
            } else {
                this.getLog().warn((CharSequence)("No website doc file: " + file));
            }
        }
        catch (IOException e) {
            throw new MojoFailureException("Error due " + e.getMessage(), (Throwable)e);
        }
    }

    protected void executeLanguagesList() throws MojoExecutionException, MojoFailureException {
        File[] files;
        TreeSet<File> languageFiles = new TreeSet<File>();
        if (this.languagesDir != null && this.languagesDir.isDirectory() && (files = this.languagesDir.listFiles()) != null) {
            languageFiles.addAll(Arrays.asList(files));
        }
        try {
            ArrayList<LanguageModel> models = new ArrayList<LanguageModel>();
            for (File file : languageFiles) {
                String json = PackageHelper.loadText((File)file);
                LanguageModel model = JsonMapper.generateLanguageModel((String)json);
                models.add(model);
            }
            models.sort((m1, m2) -> m1.getTitle().compareToIgnoreCase(m2.getTitle()));
            long count = models.stream().map(ArtifactModel::getArtifactId).distinct().count();
            long deprecated = models.stream().filter(BaseModel::isDeprecated).count();
            File file = this.websiteLanguagesIndex;
            boolean exists = file.exists();
            String changed = this.templateLanguages(models, count, deprecated);
            boolean updated = this.updateLanguages(file, changed);
            if (updated) {
                this.getLog().info((CharSequence)("Updated website doc file: " + file));
            } else if (exists) {
                this.getLog().debug((CharSequence)("No changes to website doc file: " + file));
            } else {
                this.getLog().warn((CharSequence)("No website doc file: " + file));
            }
        }
        catch (IOException e) {
            throw new MojoFailureException("Error due " + e.getMessage(), (Throwable)e);
        }
    }

    private String templateComponents(List<ComponentModel> models, long artifacts, long deprecated) throws MojoExecutionException {
        try {
            String template = this.loadResource("website-components-list.mvel");
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("components", models);
            map.put("numberOfArtifacts", artifacts);
            map.put("numberOfDeprecated", deprecated);
            String out = (String)TemplateRuntime.eval((String)template, map, Collections.singletonMap("util", MvelHelper.INSTANCE));
            return out;
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error processing mvel template. Reason: " + e, e);
        }
    }

    private String templateOthers(List<OtherModel> models, long artifacts, long deprecated) throws MojoExecutionException {
        try {
            String template = this.loadResource("website-others-list.mvel");
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("others", models);
            map.put("numberOfArtifacts", artifacts);
            map.put("numberOfDeprecated", deprecated);
            String out = (String)TemplateRuntime.eval((String)template, map, Collections.singletonMap("util", MvelHelper.INSTANCE));
            return out;
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error processing mvel template. Reason: " + e, e);
        }
    }

    private String templateDataFormats(List<DataFormatModel> models, long artifacts, long deprecated) throws MojoExecutionException {
        try {
            String template = this.loadResource("website-dataformats-list.mvel");
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("dataformats", models);
            map.put("numberOfArtifacts", artifacts);
            map.put("numberOfDeprecated", deprecated);
            String out = (String)TemplateRuntime.eval((String)template, map, Collections.singletonMap("util", MvelHelper.INSTANCE));
            return out;
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error processing mvel template. Reason: " + e, e);
        }
    }

    private String templateLanguages(List<LanguageModel> models, long artifacts, long deprecated) throws MojoExecutionException {
        try {
            String template = this.loadResource("website-languages-list.mvel");
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("languages", models);
            map.put("numberOfArtifacts", artifacts);
            map.put("numberOfDeprecated", deprecated);
            String out = (String)TemplateRuntime.eval((String)template, map, Collections.singletonMap("util", MvelHelper.INSTANCE));
            return out;
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error processing mvel template. Reason: " + e, e);
        }
    }

    private String loadResource(String name) throws IOException {
        return PackageHelper.loadText((InputStream)UpdateReadmeMojo.class.getClassLoader().getResourceAsStream(name));
    }

    private boolean updateComponents(File file, String changed) throws MojoExecutionException {
        if (!file.exists()) {
            return false;
        }
        try {
            String text = PackageHelper.loadText((File)file);
            String existing = Strings.between((String)text, (String)"// components: START", (String)"// components: END");
            if (existing != null) {
                if ((existing = existing.trim()).equals(changed = changed.trim())) {
                    return false;
                }
                String before = Strings.before((String)text, (String)"// components: START");
                String after = Strings.after((String)text, (String)"// components: END");
                text = before + "// components: START\n" + changed + "\n// components: END" + after;
                PackageHelper.writeText((File)file, (String)text);
                return true;
            }
            this.getLog().warn((CharSequence)("Cannot find markers in file " + file));
            this.getLog().warn((CharSequence)"Add the following markers");
            this.getLog().warn((CharSequence)"\t// components: START");
            this.getLog().warn((CharSequence)"\t// components: END");
            return false;
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error reading file " + file + " Reason: " + e, e);
        }
    }

    private boolean updateOthers(File file, String changed) throws MojoExecutionException {
        if (!file.exists()) {
            return false;
        }
        try {
            String text = PackageHelper.loadText((File)file);
            String existing = Strings.between((String)text, (String)"// others: START", (String)"// others: END");
            if (existing != null) {
                if ((existing = existing.trim()).equals(changed = changed.trim())) {
                    return false;
                }
                String before = Strings.before((String)text, (String)"// others: START");
                String after = Strings.after((String)text, (String)"// others: END");
                text = before + "// others: START\n" + changed + "\n// others: END" + after;
                PackageHelper.writeText((File)file, (String)text);
                return true;
            }
            this.getLog().warn((CharSequence)("Cannot find markers in file " + file));
            this.getLog().warn((CharSequence)"Add the following markers");
            this.getLog().warn((CharSequence)"\t// others: START");
            this.getLog().warn((CharSequence)"\t// others: END");
            return false;
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error reading file " + file + " Reason: " + e, e);
        }
    }

    private boolean updateDataFormats(File file, String changed) throws MojoExecutionException {
        if (!file.exists()) {
            return false;
        }
        try {
            String text = PackageHelper.loadText((File)file);
            String existing = Strings.between((String)text, (String)"// dataformats: START", (String)"// dataformats: END");
            if (existing != null) {
                if ((existing = existing.trim()).equals(changed = changed.trim())) {
                    return false;
                }
                String before = Strings.before((String)text, (String)"// dataformats: START");
                String after = Strings.after((String)text, (String)"// dataformats: END");
                text = before + "// dataformats: START\n" + changed + "\n// dataformats: END" + after;
                PackageHelper.writeText((File)file, (String)text);
                return true;
            }
            this.getLog().warn((CharSequence)("Cannot find markers in file " + file));
            this.getLog().warn((CharSequence)"Add the following markers");
            this.getLog().warn((CharSequence)"\t// dataformats: START");
            this.getLog().warn((CharSequence)"\t// dataformats: END");
            return false;
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error reading file " + file + " Reason: " + e, e);
        }
    }

    private boolean updateLanguages(File file, String changed) throws MojoExecutionException {
        if (!file.exists()) {
            return false;
        }
        try {
            String text = PackageHelper.loadText((File)file);
            String existing = Strings.between((String)text, (String)"// languages: START", (String)"// languages: END");
            if (existing != null) {
                if ((existing = existing.trim()).equals(changed = changed.trim())) {
                    return false;
                }
                String before = Strings.before((String)text, (String)"// languages: START");
                String after = Strings.after((String)text, (String)"// languages: END");
                text = before + "// languages: START\n" + changed + "\n// languages: END" + after;
                PackageHelper.writeText((File)file, (String)text);
                return true;
            }
            this.getLog().warn((CharSequence)("Cannot find markers in file " + file));
            this.getLog().warn((CharSequence)"Add the following markers");
            this.getLog().warn((CharSequence)"\t// languages: START");
            this.getLog().warn((CharSequence)"\t// languages: END");
            return false;
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error reading file " + file + " Reason: " + e, e);
        }
    }
}

