/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.maven.packaging.generics;

import java.lang.reflect.Array;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Stream;

public final class ClassUtil {
    public static final Map<Class<?>, Class<?>> PRIMITIVE_TO_WRAPPERS_MAP;
    public static final Type[] NO_TYPES;

    private ClassUtil() {
        throw new UnsupportedOperationException();
    }

    public static boolean isSame(Type type1, Type type2) {
        if (type1 instanceof Class && ((Class)type1).isPrimitive()) {
            type1 = PRIMITIVE_TO_WRAPPERS_MAP.get(type1);
        }
        if (type2 instanceof Class && ((Class)type2).isPrimitive()) {
            type2 = PRIMITIVE_TO_WRAPPERS_MAP.get(type2);
        }
        return type1 == type2;
    }

    public static Class<?> getPrimitiveWrapper(Class<?> clazz) {
        return PRIMITIVE_TO_WRAPPERS_MAP.get(clazz);
    }

    public static Class<?> getClass(Type type) {
        return ClassUtil.getClazz(type);
    }

    public static boolean isParameterizedType(Type type) {
        return type instanceof ParameterizedType;
    }

    public static boolean isWildCardType(Type type) {
        return type instanceof WildcardType;
    }

    public static boolean isClassAssignableFrom(Class<?> lhs, Class<?> rhs) {
        if (lhs.isPrimitive()) {
            lhs = ClassUtil.getPrimitiveWrapper(lhs);
        }
        if (rhs.isPrimitive()) {
            rhs = ClassUtil.getPrimitiveWrapper(rhs);
        }
        return lhs.isAssignableFrom(rhs);
    }

    public static Class<?> getClazz(Type type) {
        if (type instanceof ParameterizedType) {
            ParameterizedType pt = (ParameterizedType)type;
            return (Class)pt.getRawType();
        }
        if (type instanceof Class) {
            return (Class)type;
        }
        if (type instanceof GenericArrayType) {
            GenericArrayType arrayType = (GenericArrayType)type;
            return Array.newInstance(ClassUtil.getClazz(arrayType.getGenericComponentType()), 0).getClass();
        }
        if (type instanceof WildcardType) {
            WildcardType wildcardType = (WildcardType)type;
            Type[] bounds = wildcardType.getUpperBounds();
            if (bounds.length > 1) {
                throw new IllegalArgumentException("Illegal use of wild card type with more than one upper bound: " + wildcardType);
            }
            if (bounds.length == 0) {
                return Object.class;
            }
            return ClassUtil.getClass(bounds[0]);
        }
        if (type instanceof TypeVariable) {
            TypeVariable typeVariable = (TypeVariable)type;
            if (typeVariable.getBounds().length > 1) {
                throw new IllegalArgumentException("Illegal use of type variable with more than one bound: " + typeVariable);
            }
            Type[] bounds = typeVariable.getBounds();
            if (bounds.length == 0) {
                return Object.class;
            }
            return ClassUtil.getClass(bounds[0]);
        }
        throw new IllegalArgumentException("Unsupported type " + type);
    }

    public static boolean isRawClassEquals(Type ipType, Type apiType) {
        Class ipClass = ClassUtil.getRawPrimitiveType(ipType);
        Class apiClass = ClassUtil.getRawPrimitiveType(apiType);
        if (ipClass == null || apiClass == null) {
            return false;
        }
        return ipClass.equals(apiClass);
    }

    private static Class getRawPrimitiveType(Type type) {
        if (type instanceof Class) {
            if (((Class)type).isPrimitive()) {
                return ClassUtil.getPrimitiveWrapper((Class)type);
            }
            return (Class)type;
        }
        if (type instanceof ParameterizedType) {
            return ClassUtil.getRawPrimitiveType(((ParameterizedType)type).getRawType());
        }
        return null;
    }

    public static boolean hasAnnotation(String fqAnnotationName, Class<?> cl) {
        return Stream.of(cl.getAnnotations()).map(annotation -> annotation.annotationType().getName()).filter(fqAnnotationName::equals).findFirst().isPresent();
    }

    static {
        HashMap<Class<Object>, Class<Void>> primitiveToWrappersMap = new HashMap<Class<Object>, Class<Void>>();
        primitiveToWrappersMap.put(Integer.TYPE, Integer.class);
        primitiveToWrappersMap.put(Float.TYPE, Float.class);
        primitiveToWrappersMap.put(Double.TYPE, Double.class);
        primitiveToWrappersMap.put(Character.TYPE, Character.class);
        primitiveToWrappersMap.put(Long.TYPE, Long.class);
        primitiveToWrappersMap.put(Byte.TYPE, Byte.class);
        primitiveToWrappersMap.put(Short.TYPE, Short.class);
        primitiveToWrappersMap.put(Boolean.TYPE, Boolean.class);
        primitiveToWrappersMap.put(Void.TYPE, Void.class);
        PRIMITIVE_TO_WRAPPERS_MAP = Collections.unmodifiableMap(primitiveToWrappersMap);
        NO_TYPES = new Type[0];
    }
}

