/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.maven.packaging;

import java.util.Locale;

public final class SchemaHelper {
    private SchemaHelper() {
    }

    public static String dashToCamelCase(String text) {
        if (text == null) {
            return null;
        }
        int length = text.length();
        if (length == 0) {
            return text;
        }
        if (text.indexOf(45) == -1) {
            return text;
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            if (c == '-') {
                sb.append(Character.toUpperCase(text.charAt(++i)));
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public static String camelCaseToDash(String text) {
        if (text == null || text.isEmpty()) {
            return text;
        }
        StringBuilder answer = new StringBuilder();
        Character prev = null;
        char[] arr = text.toCharArray();
        for (int i = 0; i < arr.length; ++i) {
            char ch = arr[i];
            Character next = i < arr.length - 1 ? Character.valueOf(arr[i + 1]) : null;
            if (ch == '-' || ch == '_') {
                answer.append("-");
            } else if (Character.isUpperCase(ch) && prev != null && !Character.isUpperCase(prev.charValue())) {
                if (prev.charValue() != '-' && prev.charValue() != '_') {
                    answer.append("-");
                }
                answer.append(ch);
            } else if (Character.isUpperCase(ch) && prev != null && next != null && Character.isLowerCase(next.charValue())) {
                if (prev.charValue() != '-' && prev.charValue() != '_') {
                    answer.append("-");
                }
                answer.append(ch);
            } else {
                answer.append(ch);
            }
            prev = Character.valueOf(ch);
        }
        return answer.toString().toLowerCase(Locale.ENGLISH);
    }
}

