/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.maven.packaging;

import java.io.File;
import java.io.IOError;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Generated;
import org.apache.camel.maven.packaging.AbstractGeneratorMojo;
import org.apache.camel.maven.packaging.dsl.component.ComponentsDslMetadataRegistry;
import org.apache.camel.maven.packaging.generics.GenericsUtil;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriParams;
import org.apache.camel.spi.UriPath;
import org.apache.camel.tooling.model.BaseModel;
import org.apache.camel.tooling.model.ComponentModel;
import org.apache.camel.tooling.model.JsonMapper;
import org.apache.camel.tooling.util.PackageHelper;
import org.apache.camel.tooling.util.Strings;
import org.apache.camel.tooling.util.srcgen.GenericType;
import org.apache.camel.tooling.util.srcgen.JavaClass;
import org.apache.camel.tooling.util.srcgen.Method;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.sonatype.plexus.build.incremental.BuildContext;

@Mojo(name="generate-endpoint-dsl", threadSafe=true, requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME, defaultPhase=LifecyclePhase.PROCESS_CLASSES)
public class EndpointDslMojo
extends AbstractGeneratorMojo {
    private static final Map<String, Class<?>> PRIMITIVEMAP = new HashMap();
    @Parameter(defaultValue="${project.build.directory}")
    protected File buildDir;
    @Parameter(defaultValue="${project.basedir}")
    protected File baseDir;
    @Parameter(defaultValue="org.apache.camel.builder.endpoint")
    protected String endpointFactoriesPackageName;
    @Parameter(defaultValue="org.apache.camel.builder.endpoint.dsl")
    protected String componentsFactoriesPackageName;
    @Parameter(defaultValue="true")
    protected boolean generateEndpointBuilderFactory;
    @Parameter(defaultValue="true")
    protected boolean generateEndpointBuilders;
    @Parameter(defaultValue="true")
    protected boolean generateEndpointDsl;
    @Parameter
    protected File sourcesOutputDir;
    @Parameter
    protected File componentsMetadata;
    @Parameter
    protected File outputResourcesDir;

    @Override
    public void execute(MavenProject project, MavenProjectHelper projectHelper, BuildContext buildContext) throws MojoFailureException, MojoExecutionException {
        this.buildDir = new File(project.getBuild().getDirectory());
        this.baseDir = project.getBasedir();
        this.endpointFactoriesPackageName = "org.apache.camel.builder.endpoint";
        this.componentsFactoriesPackageName = "org.apache.camel.builder.endpoint.dsl";
        this.generateEndpointBuilderFactory = true;
        this.generateEndpointBuilders = true;
        super.execute(project, projectHelper, buildContext);
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        Map<File, Supplier<String>> files;
        Path root = PackageHelper.findCamelDirectory((File)this.baseDir, (String)"core/camel-endpointdsl").toPath();
        if (this.sourcesOutputDir == null) {
            this.sourcesOutputDir = root.resolve("src/generated/java").toFile();
        }
        if (this.outputResourcesDir == null) {
            this.outputResourcesDir = root.resolve("src/generated/resources").toFile();
        }
        if (this.componentsMetadata == null) {
            this.componentsMetadata = this.outputResourcesDir.toPath().resolve("metadata.json").toFile();
        }
        try {
            files = Files.find(this.buildDir.toPath(), Integer.MAX_VALUE, (p, a) -> a.isRegularFile() && p.toFile().getName().endsWith(".json"), new FileVisitOption[0]).collect(Collectors.toMap(Path::toFile, s -> EndpointDslMojo.cache(() -> EndpointDslMojo.loadJson(s.toFile()))));
        }
        catch (IOException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        this.executeComponent(files);
    }

    private static String loadJson(File file) {
        try {
            return PackageHelper.loadText((File)file);
        }
        catch (IOException e) {
            throw new IOError(e);
        }
    }

    private void executeComponent(Map<File, Supplier<String>> jsonFiles) throws MojoFailureException {
        TreeSet<String> componentNames = new TreeSet<String>();
        this.findComponentNames(this.buildDir, componentNames);
        if (!componentNames.isEmpty()) {
            this.getLog().debug((CharSequence)("Found " + componentNames.size() + " components"));
            LinkedList<ComponentModel> allModels = new LinkedList<ComponentModel>();
            for (String componentName : componentNames) {
                String json = EndpointDslMojo.loadComponentJson(jsonFiles, componentName);
                if (json == null) continue;
                ComponentModel model = JsonMapper.generateComponentModel((String)json);
                allModels.add(model);
            }
            Map<String, List<ComponentModel>> grModels = allModels.stream().collect(Collectors.groupingBy(BaseModel::getJavaType));
            for (String componentClass : grModels.keySet()) {
                List<ComponentModel> compModels = grModels.get(componentClass);
                ComponentModel model = compModels.get(0);
                List aliases = compModels.stream().map(ComponentModel::getScheme).sorted().collect(Collectors.toList());
                String overrideComponentName = null;
                if (aliases.size() > 1) {
                    overrideComponentName = model.getArtifactId().replace("camel-", "");
                }
                this.createEndpointDsl(model, compModels, overrideComponentName);
            }
        }
    }

    private void createEndpointDsl(ComponentModel model, List<ComponentModel> aliases, String overrideComponentName) throws MojoFailureException {
        boolean updated = this.doCreateEndpointDsl(model, aliases, overrideComponentName);
        this.getLog().debug((CharSequence)"Load components EndpointFactories");
        List<File> endpointFactories = this.loadAllComponentsDslEndpointFactoriesAsFile();
        this.getLog().debug((CharSequence)"Regenerate EndpointBuilderFactory");
        updated |= this.synchronizeEndpointBuilderFactoryInterface(endpointFactories);
        this.getLog().debug((CharSequence)"Regenerate EndpointBuilders");
        if (updated |= this.synchronizeEndpointBuildersInterface(endpointFactories)) {
            this.getLog().info((CharSequence)("Updated EndpointDsl: " + model.getScheme()));
        }
    }

    private ComponentsDslMetadataRegistry syncAndUpdateComponentsMetadataRegistry(ComponentModel componentModel, String className) {
        ComponentsDslMetadataRegistry componentsDslMetadataRegistry = new ComponentsDslMetadataRegistry(this.sourcesOutputDir.toPath().resolve(this.componentsFactoriesPackageName.replace('.', '/')).toFile(), this.componentsMetadata);
        componentsDslMetadataRegistry.addComponentToMetadataAndSyncMetadataFile(componentModel, className);
        this.getLog().debug((CharSequence)("Update components metadata with " + className));
        return componentsDslMetadataRegistry;
    }

    private boolean doCreateEndpointDsl(ComponentModel model, List<ComponentModel> aliases, String overrideComponentName) throws MojoFailureException {
        String desc;
        Method method;
        String componentClassName = model.getJavaType();
        String builderName = this.getEndpointName(componentClassName);
        Class<?> realComponentClass = this.loadClass(componentClassName);
        Class<?> realEndpointClass = this.loadClass(this.findEndpointClassName(componentClassName));
        JavaClass javaClass = new JavaClass((ClassLoader)this.getProjectClassLoader());
        javaClass.setPackage(this.componentsFactoriesPackageName);
        javaClass.setName(builderName + "Factory");
        javaClass.setClass(false);
        javaClass.addImport("org.apache.camel.builder.EndpointConsumerBuilder");
        javaClass.addImport("org.apache.camel.builder.EndpointProducerBuilder");
        javaClass.addImport("org.apache.camel.builder.endpoint.AbstractEndpointBuilder");
        HashMap<String, JavaClass> enumClasses = new HashMap<String, JavaClass>();
        boolean hasAdvanced = false;
        for (ComponentModel.EndpointOptionModel option : model.getEndpointOptions()) {
            if (option.getLabel() == null || !option.getLabel().contains("advanced")) continue;
            hasAdvanced = true;
            break;
        }
        JavaClass consumerClass = null;
        JavaClass advancedConsumerClass = null;
        JavaClass producerClass = null;
        JavaClass advancedProducerClass = null;
        if (!realEndpointClass.getAnnotation(UriEndpoint.class).producerOnly() && !realEndpointClass.getAnnotation(UriEndpoint.class).consumerOnly()) {
            String consumerName = builderName.replace("Endpoint", "EndpointConsumer");
            consumerClass = javaClass.addNestedType().setPublic().setClass(false);
            consumerClass.setName(consumerName);
            consumerClass.implementInterface("EndpointConsumerBuilder");
            this.generateDummyClass(consumerClass.getCanonicalName());
            consumerClass.getJavaDoc().setText("Builder for endpoint consumers for the " + model.getTitle() + " component.");
            if (hasAdvanced) {
                advancedConsumerClass = javaClass.addNestedType().setPublic().setClass(false);
                advancedConsumerClass.setName("Advanced" + consumerName);
                advancedConsumerClass.implementInterface("EndpointConsumerBuilder");
                this.generateDummyClass(advancedConsumerClass.getCanonicalName());
                advancedConsumerClass.getJavaDoc().setText("Advanced builder for endpoint consumers for the " + model.getTitle() + " component.");
                consumerClass.addMethod().setName("advanced").setReturnType(this.loadClass(advancedConsumerClass.getCanonicalName())).setDefault().setBody("return (Advanced" + consumerName + ") this;");
                advancedConsumerClass.addMethod().setName("basic").setReturnType(this.loadClass(consumerClass.getCanonicalName())).setDefault().setBody("return (" + consumerName + ") this;");
            }
            String producerName = builderName.replace("Endpoint", "EndpointProducer");
            producerClass = javaClass.addNestedType().setPublic().setClass(false);
            producerClass.setName(producerName);
            producerClass.implementInterface("EndpointProducerBuilder");
            this.generateDummyClass(producerClass.getCanonicalName());
            producerClass.getJavaDoc().setText("Builder for endpoint producers for the " + model.getTitle() + " component.");
            if (hasAdvanced) {
                advancedProducerClass = javaClass.addNestedType().setPublic().setClass(false);
                advancedProducerClass.setName("Advanced" + producerName);
                advancedProducerClass.implementInterface("EndpointProducerBuilder");
                this.generateDummyClass(advancedProducerClass.getCanonicalName());
                advancedProducerClass.getJavaDoc().setText("Advanced builder for endpoint producers for the " + model.getTitle() + " component.");
                producerClass.addMethod().setName("advanced").setReturnType(this.loadClass(advancedProducerClass.getCanonicalName())).setDefault().setBody("return (Advanced" + producerName + ") this;");
                advancedProducerClass.addMethod().setName("basic").setReturnType(this.loadClass(producerClass.getCanonicalName())).setDefault().setBody("return (" + producerName + ") this;");
            }
        }
        JavaClass advancedBuilderClass = null;
        JavaClass builderClass = javaClass.addNestedType().setPublic().setClass(false);
        builderClass.setName(builderName);
        if (realEndpointClass.getAnnotation(UriEndpoint.class).producerOnly()) {
            builderClass.implementInterface("EndpointProducerBuilder");
        } else if (realEndpointClass.getAnnotation(UriEndpoint.class).consumerOnly()) {
            builderClass.implementInterface("EndpointConsumerBuilder");
        } else {
            builderClass.implementInterface(consumerClass.getName());
            builderClass.implementInterface(producerClass.getName());
        }
        this.generateDummyClass(builderClass.getCanonicalName());
        builderClass.getJavaDoc().setText("Builder for endpoint for the " + model.getTitle() + " component.");
        if (hasAdvanced) {
            advancedBuilderClass = javaClass.addNestedType().setPublic().setClass(false);
            advancedBuilderClass.setName("Advanced" + builderName);
            if (realEndpointClass.getAnnotation(UriEndpoint.class).producerOnly()) {
                advancedBuilderClass.implementInterface("EndpointProducerBuilder");
            } else if (realEndpointClass.getAnnotation(UriEndpoint.class).consumerOnly()) {
                advancedBuilderClass.implementInterface("EndpointConsumerBuilder");
            } else {
                advancedBuilderClass.implementInterface(advancedConsumerClass.getName());
                advancedBuilderClass.implementInterface(advancedProducerClass.getName());
            }
            this.generateDummyClass(advancedBuilderClass.getCanonicalName());
            advancedBuilderClass.getJavaDoc().setText("Advanced builder for endpoint for the " + model.getTitle() + " component.");
            builderClass.addMethod().setName("advanced").setReturnType(this.loadClass(advancedBuilderClass.getCanonicalName())).setDefault().setBody("return (Advanced" + builderName + ") this;");
            advancedBuilderClass.addMethod().setName("basic").setReturnType(this.loadClass(builderClass.getCanonicalName())).setDefault().setBody("return (" + builderName + ") this;");
        }
        this.generateDummyClass(this.componentsFactoriesPackageName + ".T");
        String doc = "Generated by camel build tools - do NOT edit this file!";
        if (!Strings.isEmpty((String)model.getDescription())) {
            doc = model.getDescription() + "\n\n" + doc;
        }
        javaClass.getJavaDoc().setText(doc);
        javaClass.addAnnotation(Generated.class).setStringValue("value", EndpointDslMojo.class.getName());
        for (ComponentModel.EndpointOptionModel option : model.getEndpointOptions()) {
            GenericType gtype;
            GenericType ogtype;
            String label;
            if ("path".equals(option.getKind())) continue;
            ArrayList<JavaClass> targets = new ArrayList<JavaClass>();
            String string = label = option.getLabel() != null ? option.getLabel() : "";
            if (label != null) {
                if (label.contains("producer")) {
                    if (label.contains("advanced")) {
                        targets.add(advancedProducerClass != null ? advancedProducerClass : advancedBuilderClass);
                    } else {
                        targets.add(producerClass != null ? producerClass : builderClass);
                    }
                } else if (label.contains("consumer")) {
                    if (label.contains("advanced")) {
                        targets.add(advancedConsumerClass != null ? advancedConsumerClass : advancedBuilderClass);
                    } else {
                        targets.add(consumerClass != null ? consumerClass : builderClass);
                    }
                } else if (label.contains("advanced")) {
                    targets.add(advancedConsumerClass);
                    targets.add(advancedProducerClass);
                    targets.add(advancedBuilderClass);
                } else {
                    targets.add(consumerClass);
                    targets.add(producerClass);
                    targets.add(builderClass);
                }
            }
            try {
                Field field = this.findField(realComponentClass, realEndpointClass, option);
                ogtype = new GenericType(GenericsUtil.resolveType(realEndpointClass, field));
                gtype = this.getType(javaClass, enumClasses, option.getEnums(), ogtype.toString());
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            for (JavaClass target : targets) {
                String desc2;
                if (target == null) continue;
                Method fluent = target.addMethod().setDefault().setName(option.getName()).setReturnType(new GenericType(this.loadClass(target.getCanonicalName()))).addParameter(EndpointDslMojo.isPrimitive(ogtype.toString()) ? ogtype : gtype, option.getName()).setBody(new String[]{"doSetProperty(\"" + option.getName() + "\", " + option.getName() + ");", "return this;\n"});
                if (option.isDeprecated()) {
                    fluent.addAnnotation(Deprecated.class);
                }
                if (!Strings.isEmpty((String)option.getDescription())) {
                    desc2 = option.getDescription();
                    if (!desc2.endsWith(".")) {
                        desc2 = desc2 + ".";
                    }
                    desc2 = desc2 + "\n";
                    desc2 = desc2 + "\nThe option is a: <code>" + ogtype.toString().replace("<", "&lt;").replace(">", "&gt;") + "</code> type.";
                    desc2 = desc2 + "\n";
                    if ("parameter".equals(option.getKind()) && option.isRequired()) {
                        desc2 = desc2 + "\nRequired: true";
                    }
                    if (option.getDefaultValue() != null) {
                        desc2 = desc2 + "\nDefault: " + option.getDefaultValue();
                    }
                    desc2 = desc2 + "\nGroup: " + option.getGroup();
                    fluent.getJavaDoc().setFullText(desc2);
                }
                if (ogtype.getRawClass() == String.class) continue;
                fluent = target.addMethod().setDefault().setName(option.getName()).setReturnType(new GenericType(this.loadClass(target.getCanonicalName()))).addParameter(new GenericType(String.class), option.getName()).setBody(new String[]{"doSetProperty(\"" + option.getName() + "\", " + option.getName() + ");", "return this;\n"});
                if (option.isDeprecated()) {
                    fluent.addAnnotation(Deprecated.class);
                }
                if (Strings.isEmpty((String)option.getDescription())) continue;
                desc2 = option.getDescription();
                if (!desc2.endsWith(".")) {
                    desc2 = desc2 + ".";
                }
                desc2 = desc2 + "\n";
                desc2 = desc2 + "\nThe option will be converted to a <code>" + ogtype.toString().replace("<", "&lt;").replace(">", "&gt;") + "</code> type.";
                desc2 = desc2 + "\n";
                if ("parameter".equals(option.getKind()) && option.isRequired()) {
                    desc2 = desc2 + "\nRequired: true";
                }
                if (option.getDefaultValue() != null) {
                    desc2 = desc2 + "\nDefault: " + option.getDefaultValue();
                }
                desc2 = desc2 + "\nGroup: " + option.getGroup();
                fluent.getJavaDoc().setFullText(desc2);
            }
        }
        javaClass.removeImport("T");
        JavaClass dslClass = javaClass.addNestedType();
        dslClass.setName(this.getComponentNameFromType(componentClassName) + "Builders");
        dslClass.setClass(false);
        if (aliases.size() == 1) {
            method = javaClass.addMethod().setStatic().setName(EndpointDslMojo.camelCaseLower(model.getScheme())).addParameter(String.class, "path").setReturnType(new GenericType(this.loadClass(builderClass.getCanonicalName()))).setBody(new String[]{"class " + builderName + "Impl extends AbstractEndpointBuilder implements " + builderName + ", Advanced" + builderName + " {", "    public " + builderName + "Impl(String path) {", "        super(\"" + model.getScheme() + "\", path);", "    }", "}", "return new " + builderName + "Impl(path);", ""});
            if (model.isDeprecated()) {
                method.addAnnotation(Deprecated.class);
            }
            desc = this.getMainDescription(model);
            method.getJavaDoc().setText(desc);
            dslClass.addMethod(method.copy()).setDefault().setBodyF("return %s.%s(%s);", new Object[]{javaClass.getName(), method.getName(), String.join((CharSequence)",", method.getParametersNames())});
        } else {
            for (ComponentModel componentModel : aliases) {
                Method method2 = javaClass.addMethod().setStatic().setName(EndpointDslMojo.camelCaseLower(componentModel.getScheme())).addParameter(String.class, "path").setReturnType(new GenericType(this.loadClass(builderClass.getCanonicalName()))).setBody("return " + EndpointDslMojo.camelCaseLower(model.getScheme()) + "(\"" + componentModel.getScheme() + "\", path);\n");
                if (model.isDeprecated()) {
                    method2.addAnnotation(Deprecated.class);
                }
                String desc3 = this.getMainDescription(componentModel);
                method2.getJavaDoc().setText(desc3);
                dslClass.addMethod(method2.copy()).setDefault().setBodyF("return %s.%s(%s);", new Object[]{javaClass.getName(), method2.getName(), String.join((CharSequence)",", method2.getParametersNames())});
            }
            method = javaClass.addMethod().setStatic().setName(EndpointDslMojo.camelCaseLower(model.getScheme())).addParameter(String.class, "scheme").addParameter(String.class, "path").setReturnType(new GenericType(this.loadClass(builderClass.getCanonicalName()))).setBody(new String[]{"class " + builderName + "Impl extends AbstractEndpointBuilder implements " + builderName + ", Advanced" + builderName + " {", "    public " + builderName + "Impl(String scheme, String path) {", "        super(scheme, path);", "    }", "}", "return new " + builderName + "Impl(scheme, path);\n"});
            if (model.isDeprecated()) {
                method.addAnnotation(Deprecated.class);
            }
            desc = model.getTitle() + " (" + model.getArtifactId() + ")";
            desc = desc + "\n" + model.getDescription();
            desc = desc + "\n";
            desc = desc + "\nCategory: " + model.getLabel();
            desc = desc + "\nSince: " + model.getFirstVersionShort();
            desc = desc + "\nMaven coordinates: " + this.project.getGroupId() + ":" + this.project.getArtifactId();
            method.getJavaDoc().setText(desc);
            dslClass.addMethod(method.copy()).setDefault().setBodyF("return %s.%s(%s);", new Object[]{javaClass.getName(), method.getName(), String.join((CharSequence)",", method.getParametersNames())});
        }
        return this.writeSourceIfChanged(javaClass, this.componentsFactoriesPackageName.replace('.', '/'), builderName + "Factory.java", false);
    }

    private boolean synchronizeEndpointBuilderFactoryInterface(List<File> factories) throws MojoFailureException {
        JavaClass javaClass = new JavaClass((ClassLoader)this.getProjectClassLoader());
        javaClass.setPackage(this.endpointFactoriesPackageName);
        javaClass.setName("EndpointBuilderFactory");
        javaClass.setClass(false);
        javaClass.setPublic();
        javaClass.getJavaDoc().setText("Generated by camel build tools - do NOT edit this file!");
        javaClass.addAnnotation(Generated.class).setStringValue("value", EndpointDslMojo.class.getName());
        javaClass.addImport("java.util.List");
        javaClass.addImport("java.util.stream.Collectors");
        javaClass.addImport("java.util.stream.Stream");
        javaClass.addMethod().setDefault().setReturnType("org.apache.camel.Expression").setName("endpoints").addParameter("org.apache.camel.builder.EndpointProducerBuilder", "endpoints", true).setBody(new String[]{"return new org.apache.camel.support.ExpressionAdapter() {", "    List<org.apache.camel.Expression> expressions = Stream.of(endpoints)", "        .map(org.apache.camel.builder.EndpointProducerBuilder::expr)", "        .collect(Collectors.toList());", "", "    @Override", "    public Object evaluate(org.apache.camel.Exchange exchange) {", "        return expressions.stream().map(e -> e.evaluate(exchange, Object.class)).collect(Collectors.toList());", "    }", "};"});
        for (File factory : factories) {
            String factoryName = Strings.before((String)factory.getName(), (String)".");
            String endpointsName = factoryName.replace("EndpointBuilderFactory", "Builders");
            javaClass.implementInterface(this.componentsFactoriesPackageName + "." + factoryName + "." + endpointsName);
        }
        return this.writeSourceIfChanged("//CHECKSTYLE:OFF\n" + javaClass.printClass() + "\n//CHECKSTYLE:ON", this.endpointFactoriesPackageName.replace('.', '/'), "EndpointBuilderFactory.java");
    }

    private boolean synchronizeEndpointBuildersInterface(List<File> factories) throws MojoFailureException {
        JavaClass javaClass = new JavaClass((ClassLoader)this.getProjectClassLoader());
        javaClass.setPackage(this.endpointFactoriesPackageName);
        javaClass.setName("EndpointBuilders");
        javaClass.setClass(false);
        javaClass.setPublic();
        javaClass.getJavaDoc().setText("Generated by camel build tools - do NOT edit this file!");
        javaClass.addAnnotation(Generated.class).setStringValue("value", EndpointDslMojo.class.getName());
        for (File factory : factories) {
            javaClass.implementInterface(this.componentsFactoriesPackageName + "." + Strings.before((String)factory.getName(), (String)"."));
        }
        return this.writeSourceIfChanged("//CHECKSTYLE:OFF\n" + javaClass.printClass() + "\n//CHECKSTYLE:ON", this.endpointFactoriesPackageName.replace(".", "/"), "EndpointBuilders.java");
    }

    private List<File> loadAllComponentsDslEndpointFactoriesAsFile() {
        File allComponentsDslEndpointFactory = new File(this.sourcesOutputDir, this.componentsFactoriesPackageName.replace('.', '/'));
        File[] files = allComponentsDslEndpointFactory.listFiles();
        if (files == null) {
            return Collections.emptyList();
        }
        return Arrays.stream(files).filter(file -> file.isFile() && file.getName().endsWith(".java") && file.exists()).sorted().collect(Collectors.toList());
    }

    private static String camelCaseLower(String s) {
        int i;
        while (s != null && (i = s.indexOf(45)) > 0) {
            s = s.substring(0, i) + s.substring(i + 1, i + 2).toUpperCase() + s.substring(i + 2);
        }
        while (s != null && (i = s.indexOf(43)) > 0) {
            s = s.substring(0, i) + s.substring(i + 1, i + 2).toUpperCase() + s.substring(i + 2);
        }
        if (s != null) {
            switch (s = s.substring(0, 1).toLowerCase() + s.substring(1)) {
                case "class": {
                    s = "clas";
                    break;
                }
                case "package": {
                    s = "packag";
                    break;
                }
                case "rest": {
                    s = "restEndpoint";
                    break;
                }
            }
        }
        return s;
    }

    private String getMainDescription(ComponentModel model) {
        String desc = model.getTitle() + " (" + model.getArtifactId() + ")";
        desc = desc + "\n" + model.getDescription();
        desc = desc + "\n";
        desc = desc + "\nCategory: " + model.getLabel();
        desc = desc + "\nSince: " + model.getFirstVersionShort();
        desc = desc + "\nMaven coordinates: " + this.project.getGroupId() + ":" + this.project.getArtifactId();
        desc = desc + "\n";
        desc = desc + "\nSyntax: <code>" + model.getSyntax() + "</code>";
        for (ComponentModel.EndpointOptionModel option : model.getEndpointOptions()) {
            if (!"path".equals(option.getKind())) continue;
            desc = desc + "\n";
            desc = desc + "\nPath parameter: " + option.getName();
            if (option.isRequired()) {
                desc = desc + " (required)";
            }
            if (option.isDeprecated()) {
                desc = desc + " <strong>deprecated</strong>";
            }
            desc = desc + "\n" + option.getDescription();
            if (option.getDefaultValue() != null) {
                desc = desc + "\nDefault value: " + option.getDefaultValue();
            }
            if (option.getEnums() == null || option.getEnums().isEmpty()) continue;
            desc = desc + "\nThe value can be one of: " + this.wrapEnumValues(option.getEnums());
        }
        return desc;
    }

    private String wrapEnumValues(List<String> enumValues) {
        return String.join((CharSequence)", ", enumValues);
    }

    private String getComponentNameFromType(String type) {
        int pos = type.lastIndexOf(46);
        String name = type.substring(pos + 1).replace("Component", "");
        switch (type) {
            case "org.apache.camel.component.atmosphere.websocket.WebsocketComponent": {
                return "AtmosphereWebsocket";
            }
            case "org.apache.camel.component.zookeepermaster.MasterComponent": {
                return "ZooKeeperMaster";
            }
            case "org.apache.camel.component.jetty9.JettyHttpComponent9": {
                return "JettyHttp";
            }
        }
        return name;
    }

    private String getEndpointName(String type) {
        return this.getComponentNameFromType(type) + "EndpointBuilder";
    }

    private String findEndpointClassName(String type) {
        String endpointName = type.replaceFirst("Component", "Endpoint");
        switch (type) {
            case "org.apache.camel.component.disruptor.vm.DisruptorVmComponent": {
                return "org.apache.camel.component.disruptor.DisruptorEndpoint";
            }
            case "org.apache.camel.component.etcd.EtcdComponent": {
                return "org.apache.camel.component.etcd.AbstractEtcdPollingEndpoint";
            }
            case "org.apache.camel.websocket.jsr356.JSR356WebSocketComponent": {
                return "org.apache.camel.websocket.jsr356.JSR356Endpoint";
            }
        }
        return endpointName;
    }

    private Field findField(Class<?> realComponentClass, Class<?> realEndpointClass, ComponentModel.EndpointOptionModel option) throws NoSuchFieldException {
        Field field = null;
        ArrayList classes = new ArrayList();
        classes.add(realComponentClass);
        classes.add(realEndpointClass);
        while (!classes.isEmpty()) {
            Class cl = (Class)classes.remove(0);
            for (Field f : cl.getDeclaredFields()) {
                UriParam param;
                String n = f.getName();
                UriPath path = f.getAnnotation(UriPath.class);
                if (path != null && !Strings.isEmpty((String)path.name())) {
                    n = path.name();
                }
                if ((param = f.getAnnotation(UriParam.class)) != null && !Strings.isEmpty((String)param.name())) {
                    n = param.name();
                }
                if (n.equals(option.getName())) {
                    field = f;
                    break;
                }
                if (!f.getType().isAnnotationPresent(UriParams.class)) continue;
                classes.add(f.getType());
            }
            if (field != null) break;
            if ((cl = cl.getSuperclass()) == null) continue;
            classes.add(cl);
        }
        if (field == null) {
            throw new NoSuchFieldException("Could not find field for option " + option.getName());
        }
        return field;
    }

    private static boolean isPrimitive(String type) {
        return PRIMITIVEMAP.containsKey(type);
    }

    private GenericType getType(JavaClass javaClass, Map<String, JavaClass> enumClasses, List<String> enums, String type) {
        if ((type = type.trim()).endsWith("[]")) {
            GenericType t = this.getType(javaClass, enumClasses, enums, type.substring(0, type.length() - 2));
            return new GenericType(Array.newInstance(t.getRawClass(), 0).getClass(), new GenericType[]{t});
        }
        int genericIndex = type.indexOf(60);
        if (genericIndex > 0) {
            if (!type.endsWith(">")) {
                throw new IllegalArgumentException("Can not load type: " + type);
            }
            GenericType base = this.getType(javaClass, enumClasses, enums, type.substring(0, genericIndex));
            if (base.getRawClass() == Object.class) {
                return base;
            }
            String[] params = this.splitParams(type.substring(genericIndex + 1, type.length() - 1));
            GenericType[] types = new GenericType[params.length];
            for (int i = 0; i < params.length; ++i) {
                types[i] = this.getType(javaClass, enumClasses, enums, params[i]);
            }
            return new GenericType(base.getRawClass(), types);
        }
        if (EndpointDslMojo.isPrimitive(type)) {
            return new GenericType((Type)PRIMITIVEMAP.get(type));
        }
        if (type.startsWith("? extends ")) {
            String raw = type.substring("? extends ".length());
            return new GenericType(this.loadClass(raw), GenericType.BoundType.Extends, new GenericType[0]);
        }
        if (type.startsWith("? super ")) {
            String raw = type.substring("? extends ".length());
            return new GenericType(this.loadClass(raw), GenericType.BoundType.Super, new GenericType[0]);
        }
        if (type.equals("?")) {
            return new GenericType(Object.class, GenericType.BoundType.Extends, new GenericType[0]);
        }
        if (this.loadClass(type).isEnum() && !this.isCamelCoreType(type)) {
            JavaClass enumClass;
            String enumClassName = type.substring(type.lastIndexOf(46) + 1);
            if (enumClassName.contains("$")) {
                enumClassName = enumClassName.substring(enumClassName.indexOf(36) + 1);
            }
            if ((enumClass = enumClasses.get(enumClassName)) == null) {
                enumClass = javaClass.addNestedType().setPackagePrivate().setName(enumClassName).setEnum(true);
                enumClass.getJavaDoc().setText("Proxy enum for <code>" + type + "</code> enum.");
                enumClasses.put(enumClassName, enumClass);
                for (Object value : this.loadClass(type).getEnumConstants()) {
                    enumClass.addValue(((Enum)value).name().replace('.', '_').replace('-', '_'));
                }
            }
            type = javaClass.getPackage() + "." + javaClass.getName() + "$" + enumClassName;
            return new GenericType((Type)this.generateDummyClass(type));
        }
        if (!this.isCamelCoreType(type)) {
            this.getLog().debug((CharSequence)("Substituting java.lang.Object to " + type));
            return new GenericType(Object.class);
        }
        return new GenericType(this.loadClass(type));
    }

    private String[] splitParams(String string) {
        ArrayList<String> params = new ArrayList<String>();
        int cur = 0;
        int start = 0;
        int opened = 0;
        while (true) {
            int nextComma = string.indexOf(44, cur);
            int nextOpen = string.indexOf(60, cur);
            int nextClose = string.indexOf(62, cur);
            if (nextComma < 0) {
                params.add(string.substring(start));
                return params.toArray(new String[0]);
            }
            if (!(nextOpen >= 0 && nextComma >= nextOpen || nextClose >= 0 && nextComma >= nextClose || opened != 0)) {
                params.add(string.substring(start, nextComma));
                start = cur = nextComma + 1;
                continue;
            }
            if (nextOpen < 0) {
                if (--opened < 0) {
                    throw new IllegalStateException();
                }
                cur = nextClose + 1;
                continue;
            }
            if (nextClose < 0 || nextOpen < nextClose) {
                ++opened;
                cur = nextOpen + 1;
                continue;
            }
            if (--opened < 0) {
                throw new IllegalStateException();
            }
            cur = nextClose + 1;
        }
    }

    private boolean isCamelCoreType(String type) {
        return type.startsWith("java.") || type.matches("org\\.apache\\.camel\\.(spi\\.)?([A-Za-z]+)");
    }

    private Class generateDummyClass(String clazzName) {
        return this.getProjectClassLoader().generateDummyClass(clazzName);
    }

    private static String loadComponentJson(Map<File, Supplier<String>> jsonFiles, String componentName) {
        return EndpointDslMojo.loadJsonOfType(jsonFiles, componentName, "component");
    }

    private static String loadJsonOfType(Map<File, Supplier<String>> jsonFiles, String modelName, String type) {
        for (Map.Entry<File, Supplier<String>> entry : jsonFiles.entrySet()) {
            String json;
            if (!entry.getKey().getName().equals(modelName + ".json") || !type.equals(PackageHelper.getSchemaKind((String)(json = entry.getValue().get())))) continue;
            return json;
        }
        return null;
    }

    private void findComponentNames(File dir, Set<String> componentNames) {
        File[] files;
        File f = new File(dir, "classes/META-INF/services/org/apache/camel/component");
        if (f.exists() && f.isDirectory() && (files = f.listFiles()) != null) {
            for (File file : files) {
                String name;
                if (file.isDirectory() || (name = file.getName()).charAt(0) == '.') continue;
                componentNames.add(name);
            }
        }
    }

    private boolean writeSourceIfChanged(JavaClass source, String filePath, String fileName, boolean innerClassesLast) throws MojoFailureException {
        return this.writeSourceIfChanged(source.printClass(innerClassesLast), filePath, fileName);
    }

    private boolean writeSourceIfChanged(String source, String filePath, String fileName) throws MojoFailureException {
        try {
            String header;
            try (InputStream is = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("license-header-java.txt");){
                header = PackageHelper.loadText((InputStream)is);
            }
            String code = header + source;
            this.getLog().debug((CharSequence)("Source code generated:\n" + code));
            return this.updateResource(this.sourcesOutputDir.toPath(), filePath + "/" + fileName, code);
        }
        catch (Exception e) {
            throw new MojoFailureException("IOError with file " + filePath + "/" + fileName, (Throwable)e);
        }
    }

    static {
        PRIMITIVEMAP.put("boolean", Boolean.class);
        PRIMITIVEMAP.put("char", Character.class);
        PRIMITIVEMAP.put("long", Long.class);
        PRIMITIVEMAP.put("int", Integer.class);
        PRIMITIVEMAP.put("integer", Integer.class);
        PRIMITIVEMAP.put("byte", Byte.class);
        PRIMITIVEMAP.put("short", Short.class);
        PRIMITIVEMAP.put("double", Double.class);
        PRIMITIVEMAP.put("float", Float.class);
    }
}

