/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.maven.packaging;

import java.io.BufferedWriter;
import java.io.File;
import java.io.IOError;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.zip.ZipFile;
import org.apache.camel.maven.packaging.AbstractGeneratorMojo;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.sonatype.plexus.build.incremental.BuildContext;

public abstract class AbstractGenerateMojo
extends AbstractMojo {
    @Parameter(property="project", required=true, readonly=true)
    protected MavenProject project;
    @Component
    protected MavenProjectHelper projectHelper;
    @Component
    protected BuildContext buildContext;
    @Component
    private MavenSession session;
    @Parameter(defaultValue="${showStaleFiles}")
    private boolean showStaleFiles;

    public void execute() throws MojoExecutionException, MojoFailureException {
        try {
            if (!this.isUpToDate(this.project)) {
                this.doExecute();
                this.writeIncrementalInfo(this.project);
            }
        }
        catch (Exception e) {
            throw new MojoFailureException("Error generating data " + e.toString(), (Throwable)e);
        }
    }

    protected abstract void doExecute() throws MojoFailureException, MojoExecutionException;

    protected void invoke(Class<? extends AbstractMojo> mojoClass) throws MojoExecutionException, MojoFailureException {
        try {
            AbstractMojo mojo = mojoClass.newInstance();
            mojo.setLog(this.getLog());
            mojo.setPluginContext(this.getPluginContext());
            ((AbstractGeneratorMojo)mojo).execute(this.project, this.projectHelper, this.buildContext);
        }
        catch (MojoExecutionException | MojoFailureException e) {
            throw e;
        }
        catch (Exception e) {
            throw new MojoFailureException("Unable to create mojo", (Throwable)e);
        }
    }

    private void writeIncrementalInfo(MavenProject project) throws MojoExecutionException {
        try {
            Path cacheData = this.getIncrementalDataPath(project);
            String curdata = this.getIncrementalData();
            Files.createDirectories(cacheData.getParent(), new FileAttribute[0]);
            try (BufferedWriter w = Files.newBufferedWriter(cacheData, new OpenOption[0]);){
                w.append(curdata);
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error checking manifest uptodate status", (Exception)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean isUpToDate(MavenProject project) throws MojoExecutionException {
        try {
            Path cacheData = this.getIncrementalDataPath(project);
            String prvdata = Files.isRegularFile(cacheData, new LinkOption[0]) ? new String(Files.readAllBytes(cacheData), StandardCharsets.UTF_8) : null;
            String curdata = this.getIncrementalData();
            if (curdata.equals(prvdata)) {
                long lastmod = Files.getLastModifiedTime(cacheData, new LinkOption[0]).toMillis();
                Set stale = Stream.concat(Stream.concat(project.getCompileSourceRoots().stream().map(File::new), Stream.of(new File(project.getBuild().getOutputDirectory()))), project.getArtifacts().stream().map(Artifact::getFile)).flatMap(f -> this.newer(lastmod, (File)f)).collect(Collectors.toSet());
                if (stale.isEmpty()) {
                    this.getLog().info((CharSequence)"Skipping generation, everything is up to date.");
                    return true;
                }
                this.getLog().info((CharSequence)"Stale files detected, re-generating.");
                if (this.showStaleFiles) {
                    this.getLog().info((CharSequence)("Stale files: " + stale.stream().collect(Collectors.joining(", "))));
                    return false;
                }
                if (!this.getLog().isDebugEnabled()) return false;
                this.getLog().debug((CharSequence)("Stale files: " + stale.stream().collect(Collectors.joining(", "))));
                return false;
            }
            if (prvdata == null) {
                this.getLog().info((CharSequence)"No previous run data found, generating files.");
                return false;
            }
            this.getLog().info((CharSequence)"Configuration changed, re-generating files.");
            return false;
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error checking uptodate status", (Exception)e);
        }
    }

    private String getIncrementalData() {
        return "";
    }

    private Path getIncrementalDataPath(MavenProject project) {
        return Paths.get(project.getBuild().getDirectory(), "camel-package-maven-plugin", "org.apache.camel_camel-package-maven-plugin_info_xx");
    }

    private long lastmod(Path p) {
        try {
            return Files.getLastModifiedTime(p, new LinkOption[0]).toMillis();
        }
        catch (IOException e) {
            return 0L;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Stream<String> newer(long lastmod, File file) {
        Stream<String> stream;
        if (file.isDirectory()) {
            return Files.walk(file.toPath(), new FileVisitOption[0]).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(p -> this.lastmod((Path)p) > lastmod).map(Path::toString);
        }
        if (!file.isFile()) return Stream.empty();
        if (this.lastmod(file.toPath()) <= lastmod) return Stream.empty();
        if (!file.getName().endsWith(".jar")) return Stream.of(file.toString());
        ZipFile zf = new ZipFile(file);
        try {
            stream = zf.stream().filter(ze -> !ze.isDirectory()).filter(ze -> ze.getLastModifiedTime().toMillis() > lastmod).map(ze -> file.toString() + "!" + ze.getName()).collect(Collectors.toList()).stream();
        }
        catch (Throwable throwable) {
            try {
                try {
                    zf.close();
                    throw throwable;
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new IOError(e);
            }
        }
        zf.close();
        return stream;
    }
}

