/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.maven.packaging;

import java.io.BufferedReader;
import java.io.IOError;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.camel.tooling.util.PackageHelper;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.snakeyaml.engine.v2.api.Load;
import org.snakeyaml.engine.v2.api.LoadSettings;

@Mojo(name="xref-check", threadSafe=true)
public class XRefCheckMojo
extends AbstractMojo {
    public static final String PLAYBOOK = "antora-playbook-local-xref-check.yml";
    @Parameter(property="project", required=true, readonly=true)
    protected MavenProject project;

    public void execute() throws MojoExecutionException, MojoFailureException {
        try {
            List<String> unresolved = this.checkXRef(this.project.getBasedir().toPath());
            if (!unresolved.isEmpty()) {
                this.getLog().error((CharSequence)"Unresolved xrefs:");
                for (String ref : unresolved) {
                    this.getLog().error((CharSequence)("  " + ref));
                }
                throw new MojoFailureException("Unresolved xrefs");
            }
        }
        catch (IOException e) {
            throw new MojoFailureException("Error checking xref", (Throwable)e);
        }
    }

    public List<String> checkXRef(Path path) throws IOException {
        Map site;
        ArrayList<String> unresolved = new ArrayList<String>();
        Load yaml = new Load(LoadSettings.builder().build());
        try (BufferedReader r = Files.newBufferedReader(path.resolve(PLAYBOOK));){
            site = (Map)yaml.loadFromReader((Reader)r);
        }
        Map<String, String> attributes = (Map<String, String>)((Map)site.get("asciidoc")).get("attributes");
        if (attributes != null) {
            attributes = attributes.entrySet().stream().collect(Collectors.toMap(e -> "{" + (String)e.getKey() + "}", e -> (String)e.getValue()));
        }
        HashMap<String, List> componentPaths = new HashMap<String, List>();
        HashMap<String, List> componentNavs = new HashMap<String, List>();
        TreeMap<String, Path> pages = new TreeMap<String, Path>();
        for (Map source : (List)((Map)site.get("content")).get("sources")) {
            Map antora;
            Iterator url = (String)source.get("url");
            String startPath = (String)source.get("start_path");
            Path root = path.resolve((String)((Object)url)).resolve(startPath).normalize();
            try (BufferedReader r = Files.newBufferedReader(root.resolve("antora.yml"));){
                antora = (Map)yaml.loadFromReader((Reader)r);
            }
            String name = (String)antora.get("name");
            componentPaths.computeIfAbsent(name, n -> new ArrayList()).add(root);
            componentNavs.computeIfAbsent(name, n -> new ArrayList()).addAll(Optional.ofNullable((List)antora.get("nav")).orElse(Collections.emptyList()));
        }
        for (String component : componentPaths.keySet()) {
            for (String nav : (List)componentNavs.get(component)) {
                Optional<Path> n2 = ((List)componentPaths.get(component)).stream().map(p -> p.resolve(nav)).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).findFirst();
                if (!n2.isPresent()) continue;
                Path f = n2.get();
                Path m = f.getParent();
                while (!m.getParent().getFileName().toString().equals("modules")) {
                    m = m.getParent();
                }
                pages.put(component + ":" + m.getFileName().toString() + ":" + f.getFileName().toString(), n2.get());
            }
            for (Path root : (List)componentPaths.get(component)) {
                Files.list(root.resolve("modules")).filter(x$0 -> Files.isDirectory(x$0, new LinkOption[0])).filter(p -> Files.isDirectory(p.resolve("pages"), new LinkOption[0])).forEach(module -> {
                    String m = module.getFileName().toString();
                    Path pagesDir = module.resolve("pages");
                    this.walk(pagesDir).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).forEach(page -> {
                        Path rel = pagesDir.relativize((Path)page);
                        pages.put(component + ":" + m + ":" + rel.toString(), (Path)page);
                    });
                });
            }
        }
        Pattern xref = Pattern.compile("\\b(?<all>xref:(?<link>[^\\[]+.adoc)[^\\]]*\\])");
        for (Map.Entry page : pages.entrySet()) {
            int firstDot = ((String)page.getKey()).indexOf(58);
            int secondDot = firstDot >= 0 ? ((String)page.getKey()).indexOf(58, firstDot + 1) : -1;
            String component = secondDot >= 0 ? ((String)page.getKey()).substring(0, firstDot) : "";
            String module2 = secondDot >= 0 ? ((String)page.getKey()).substring(firstDot + 1, secondDot) : "";
            String str = PackageHelper.loadText((Path)((Path)page.getValue()));
            for (Map.Entry<String, String> repl : attributes.entrySet()) {
                str = str.replace(repl.getKey(), repl.getValue());
            }
            Matcher m = xref.matcher(str);
            while (m.find()) {
                String rem;
                String ml;
                String cl;
                String link = m.group("link");
                String all = m.group("all");
                String[] groups = link.split(":");
                if (groups.length == 3) {
                    cl = groups[0];
                    ml = groups[1].isEmpty() ? "ROOT" : groups[1];
                    rem = groups[2];
                } else if (groups.length == 2) {
                    cl = component;
                    ml = groups[0];
                    rem = groups[1];
                } else {
                    cl = component;
                    ml = module2;
                    rem = groups[0];
                }
                if (cl.startsWith("latest@")) {
                    cl = cl.substring("latest@".length());
                }
                if (pages.containsKey(link = cl + ":" + ml + ":" + rem)) continue;
                long line = str.chars().limit(m.start()).filter(c -> c == 10).count() + 1L;
                String prnt = Stream.of(all.split("\n")).map(String::trim).collect(Collectors.joining(" "));
                unresolved.add((String)page.getKey() + " (" + page.getValue() + ") at line " + line + ": " + prnt);
            }
        }
        return unresolved;
    }

    private Stream<Path> walk(Path p) {
        try {
            return Files.walk(p, new FileVisitOption[0]);
        }
        catch (IOException e) {
            throw new IOError(e);
        }
    }
}

