/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.maven.packaging;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.apache.camel.maven.packaging.AbstractGeneratorMojo;
import org.apache.camel.maven.packaging.MvelHelper;
import org.apache.camel.tooling.model.ArtifactModel;
import org.apache.camel.tooling.model.BaseModel;
import org.apache.camel.tooling.model.BaseOptionModel;
import org.apache.camel.tooling.model.ComponentModel;
import org.apache.camel.tooling.model.DataFormatModel;
import org.apache.camel.tooling.model.EipModel;
import org.apache.camel.tooling.model.JsonMapper;
import org.apache.camel.tooling.model.LanguageModel;
import org.apache.camel.tooling.model.OtherModel;
import org.apache.camel.tooling.util.PackageHelper;
import org.apache.camel.tooling.util.Strings;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.mvel2.templates.TemplateRuntime;
import org.sonatype.plexus.build.incremental.BuildContext;

@Mojo(name="update-readme", threadSafe=true)
public class UpdateReadmeMojo
extends AbstractGeneratorMojo {
    private static final Pattern[] MANUAL_ATTRIBUTES = new Pattern[]{Pattern.compile(":(group): *(.*)"), Pattern.compile(":(summary-group): *(.*)")};
    @Parameter(defaultValue="${project.build.directory}")
    protected File buildDir;
    @Parameter(defaultValue="${project.basedir}/src/main/docs")
    protected File componentDocDir;
    @Parameter(defaultValue="${project.basedir}/src/main/docs")
    protected File dataformatDocDir;
    @Parameter(defaultValue="${project.basedir}/src/main/docs")
    protected File languageDocDir;
    @Parameter(defaultValue="${project.basedir}/src/main/docs/modules/languages/pages")
    protected File languageDocDir2;
    @Parameter(defaultValue="${project.basedir}/src/main/docs/modules/eips/pages")
    protected File eipDocDir;
    @Parameter
    protected Boolean failFast;

    @Override
    public void execute(MavenProject project, MavenProjectHelper projectHelper, BuildContext buildContext) throws MojoFailureException, MojoExecutionException {
        this.buildDir = new File(project.getBuild().getDirectory());
        this.componentDocDir = new File(project.getBasedir(), "src/main/docs");
        this.dataformatDocDir = new File(project.getBasedir(), "src/main/docs");
        this.languageDocDir = new File(project.getBasedir(), "/src/main/docs");
        this.languageDocDir2 = new File(project.getBasedir(), "/src/main/docs/modules/languages/pages");
        this.eipDocDir = new File(project.getBasedir(), "src/main/docs/modules/eips/pages");
        super.execute(project, projectHelper, buildContext);
    }

    public void execute() throws MojoExecutionException {
        this.getLog().debug((CharSequence)"UpdateReadmeMojo execute");
        this.executeComponent();
        this.executeOther();
        this.executeDataFormat();
        this.executeLanguage();
        this.executeEips();
    }

    private void executeComponent() throws MojoExecutionException {
        String kind = "component";
        List<String> componentNames = this.listDescriptorNamesOfType("component");
        TreeSet<File> jsonFiles = new TreeSet<File>();
        PackageHelper.findJsonFiles((File)this.buildDir, jsonFiles);
        if (!componentNames.isEmpty()) {
            this.getLog().debug((CharSequence)("Found " + componentNames.size() + " components"));
            for (String componentName : componentNames) {
                String json = UpdateReadmeMojo.loadJsonFrom(jsonFiles, "component", componentName);
                if (json == null) continue;
                componentName = UpdateReadmeMojo.asComponentName(componentName);
                File file = new File(this.componentDocDir, componentName + "-" + "component" + ".adoc");
                boolean exists = file.exists();
                ComponentModel model = this.generateComponentModel(json);
                String title = UpdateReadmeMojo.asComponentTitle(model.getScheme(), model.getTitle());
                model.setTitle(title);
                if (!Strings.isEmpty((String)model.getAlternativeSchemes())) {
                    String first = model.getAlternativeSchemes().split(",")[0];
                    if (!model.getScheme().equals(first)) continue;
                }
                boolean updated = this.updateHeader(componentName, file, (BaseModel<? extends BaseOptionModel>)model, " Component", "component");
                this.checkComponentHeader(file, model);
                this.checkSince(file, (ArtifactModel<?>)model);
                boolean hasOptions = model.getComponentOptions().stream().anyMatch(o -> !o.getName().equals("resolvePropertyPlaceholders"));
                if (!hasOptions) {
                    model.getComponentOptions().clear();
                }
                Stream.concat(model.getComponentOptions().stream(), model.getEndpointOptions().stream()).forEach(option -> {
                    String desc = option.getDescription();
                    desc = desc.replaceAll("\\\\n", "\n");
                    option.setDescription(desc);
                });
                String options = UpdateReadmeMojo.evaluateTemplate("component-options.mvel", model);
                updated |= this.updateOptionsIn(file, "component", options);
                options = UpdateReadmeMojo.evaluateTemplate("endpoint-options.mvel", model);
                if (updated |= this.updateOptionsIn(file, "endpoint", options)) {
                    this.getLog().info((CharSequence)("Updated doc file: " + file));
                } else if (exists) {
                    this.getLog().debug((CharSequence)("No changes to doc file: " + file));
                } else {
                    this.getLog().warn((CharSequence)("No component doc file: " + file));
                    if (this.isFailFast()) {
                        throw new MojoExecutionException("Failed build due failFast=true");
                    }
                }
                if (!updated && !exists) continue;
                try {
                    Path root = PackageHelper.findCamelDirectory((File)this.project.getBasedir(), (String)"core/camel-core").toPath().getParent().getParent();
                    String text = PackageHelper.loadText((File)file);
                    this.updateResource(root.resolve("catalog/camel-catalog/src/generated/resources/org/apache/camel/catalog/docs"), file.getName(), text);
                    String rep = "$1\n//THIS FILE IS COPIED: EDIT THE SOURCE FILE:\n:page-source: " + root.relativize(file.toPath());
                    text = Pattern.compile("^(= .+)$", 8).matcher(text).replaceAll(rep);
                    this.updateResource(root.resolve("docs/components/modules/ROOT/pages"), file.getName(), text);
                }
                catch (IOException e) {
                    throw new MojoExecutionException("Error reading file " + file + " Reason: " + e, (Exception)e);
                }
            }
        }
    }

    private void executeOther() throws MojoExecutionException {
        TreeSet jsonFiles = new TreeSet();
        PackageHelper.findJsonFiles((File)this.buildDir, jsonFiles);
        this.getLog().debug((CharSequence)("UpdateReadmeMojo jsonFiles: " + jsonFiles));
        if (!jsonFiles.isEmpty()) {
            this.getLog().debug((CharSequence)("Found " + jsonFiles.size() + "miscellaneous components"));
            for (File jsonFile : jsonFiles) {
                String kind = "other";
                String json = UpdateReadmeMojo.loadJsonFrom(jsonFile, "other");
                if (json == null) continue;
                OtherModel model = this.generateOtherModel(json);
                String title = model.getTitle();
                model.setTitle(title);
                String componentName = UpdateReadmeMojo.asComponentName(model.getName());
                File file = new File(this.componentDocDir, componentName + ".adoc");
                boolean exists = file.exists();
                boolean updated = this.updateHeader(componentName, file, (BaseModel<? extends BaseOptionModel>)model, " Component", "other");
                this.checkSince(file, (ArtifactModel<?>)model);
                if (updated) {
                    this.getLog().info((CharSequence)("Updated doc file: " + file));
                } else if (exists) {
                    this.getLog().debug((CharSequence)("No changes to doc file: " + file));
                } else {
                    this.getLog().warn((CharSequence)("No component doc file: " + file));
                    if (this.isFailFast()) {
                        throw new MojoExecutionException("Failed build due failFast=true");
                    }
                }
                if (!updated && !exists) continue;
                try {
                    Path root = PackageHelper.findCamelDirectory((File)this.project.getBasedir(), (String)"core/camel-core").toPath().getParent().getParent();
                    String text = PackageHelper.loadText((File)file);
                    this.updateResource(root.resolve("catalog/camel-catalog/src/generated/resources/org/apache/camel/catalog/docs"), file.getName(), text);
                    String rep = "$1\n//THIS FILE IS COPIED: EDIT THE SOURCE FILE:\n:page-source: " + root.relativize(file.toPath());
                    text = Pattern.compile("^(= .+)$", 8).matcher(text).replaceAll(rep);
                    this.updateResource(root.resolve("docs/components/modules/others/pages"), file.getName(), text);
                }
                catch (IOException e) {
                    throw new MojoExecutionException("Error reading file " + file + " Reason: " + e, (Exception)e);
                }
            }
        }
    }

    private void executeDataFormat() throws MojoExecutionException {
        String kind = "dataformat";
        List<String> dataFormatNames = this.listDescriptorNamesOfType("dataformat");
        TreeSet<File> jsonFiles = new TreeSet<File>();
        PackageHelper.findJsonFiles((File)this.buildDir, jsonFiles);
        if (!dataFormatNames.isEmpty()) {
            this.getLog().debug((CharSequence)("Found " + dataFormatNames.size() + " dataformats"));
            for (String dataFormatName : dataFormatNames) {
                String json = UpdateReadmeMojo.loadJsonFrom(jsonFiles, "dataformat", dataFormatName);
                if (json == null) continue;
                dataFormatName = UpdateReadmeMojo.asDataFormatName(dataFormatName);
                File file = new File(this.dataformatDocDir, dataFormatName + "-" + "dataformat" + ".adoc");
                DataFormatModel model = this.generateDataFormatModel(json);
                if ("bindy".equals(dataFormatName)) {
                    model.getOptions().stream().filter(o -> "type".equals(o.getName())).forEach(o -> o.setDefaultValue(null));
                }
                String title = UpdateReadmeMojo.asDataFormatTitle(model.getName(), model.getTitle());
                model.setTitle(title);
                boolean exists = file.exists();
                boolean updated = this.updateHeader(dataFormatName, file, (BaseModel<? extends BaseOptionModel>)model, " DataFormat", "dataformat");
                this.checkSince(file, (ArtifactModel<?>)model);
                String options = UpdateReadmeMojo.evaluateTemplate("dataformat-options.mvel", model);
                if (updated |= this.updateOptionsIn(file, "dataformat", options)) {
                    this.getLog().info((CharSequence)("Updated doc file: " + file));
                } else if (exists) {
                    this.getLog().debug((CharSequence)("No changes to doc file: " + file));
                } else {
                    this.getLog().warn((CharSequence)("No dataformat doc file: " + file));
                    if (this.isFailFast()) {
                        throw new MojoExecutionException("Failed build due failFast=true");
                    }
                }
                if (!updated && !exists) continue;
                try {
                    Path root = PackageHelper.findCamelDirectory((File)this.project.getBasedir(), (String)"core/camel-core").toPath().getParent().getParent();
                    String text = PackageHelper.loadText((File)file);
                    this.updateResource(root.resolve("catalog/camel-catalog/src/generated/resources/org/apache/camel/catalog/docs"), file.getName(), text);
                    String rep = "$1\n//THIS FILE IS COPIED: EDIT THE SOURCE FILE:\n:page-source: " + root.relativize(file.toPath());
                    text = Pattern.compile("^(= .+)$", 8).matcher(text).replaceAll(rep);
                    this.updateResource(root.resolve("docs/components/modules/dataformats/pages"), file.getName(), text);
                }
                catch (IOException e) {
                    throw new MojoExecutionException("Error reading file " + file + " Reason: " + e, (Exception)e);
                }
            }
        }
    }

    private static String asComponentName(String name) {
        if (name.equals("imap") || name.equals("imaps") || name.equals("pop3") || name.equals("pop3s") || name.equals("smtp") || name.equals("smtps")) {
            return "mail";
        }
        return name;
    }

    private void executeLanguage() throws MojoExecutionException {
        String kind = "language";
        List<String> languageNames = this.listDescriptorNamesOfType("language");
        TreeSet<File> jsonFiles = new TreeSet<File>();
        PackageHelper.findJsonFiles((File)this.buildDir, jsonFiles);
        if (!languageNames.isEmpty()) {
            this.getLog().debug((CharSequence)("Found " + languageNames.size() + " languages"));
            for (String languageName : languageNames) {
                String json = UpdateReadmeMojo.loadJsonFrom(jsonFiles, "language", languageName);
                if (json == null) continue;
                File file = new File(this.languageDocDir, languageName + "-" + "language" + ".adoc");
                boolean exists = file.exists();
                if (!exists) {
                    file = new File(this.languageDocDir2, languageName + "-" + "language" + ".adoc");
                    exists = file.exists();
                }
                LanguageModel model = JsonMapper.generateLanguageModel((String)json);
                model.getOptions().removeIf(opt -> Objects.equals(opt.getName(), "id") || Objects.equals(opt.getName(), "expression"));
                model.getOptions().stream().filter(BaseOptionModel::isDeprecated).forEach(option -> {
                    String desc = "*Deprecated* " + option.getDescription();
                    if (!Strings.isEmpty((String)option.getDeprecationNote())) {
                        desc = option.getDescription();
                        if (!desc.endsWith(".")) {
                            desc = desc + ".";
                        }
                        desc = desc + " Deprecation note: " + option.getDeprecationNote();
                    }
                    option.setDescription(desc);
                });
                boolean updated = this.updateHeader(languageName, file, (BaseModel<? extends BaseOptionModel>)model, " Language", "language");
                this.checkSince(file, (ArtifactModel<?>)model);
                String options = UpdateReadmeMojo.evaluateTemplate("language-options.mvel", model);
                if (updated |= this.updateOptionsIn(file, "language", options)) {
                    this.getLog().info((CharSequence)("Updated doc file: " + file));
                } else if (exists) {
                    this.getLog().debug((CharSequence)("No changes to doc file: " + file));
                } else {
                    this.getLog().warn((CharSequence)("No language doc file: " + file));
                    if (this.isFailFast()) {
                        throw new MojoExecutionException("Failed build due failFast=true");
                    }
                }
                if (!updated && !exists) continue;
                try {
                    Path root = PackageHelper.findCamelDirectory((File)this.project.getBasedir(), (String)"core/camel-core").toPath().getParent().getParent();
                    String text = PackageHelper.loadText((File)file);
                    this.updateResource(root.resolve("catalog/camel-catalog/src/generated/resources/org/apache/camel/catalog/docs"), file.getName(), text);
                    String rep = "$1\n//THIS FILE IS COPIED: EDIT THE SOURCE FILE:\n:page-source: " + root.relativize(file.toPath());
                    text = Pattern.compile("^(= .+)$", 8).matcher(text).replaceAll(rep);
                    this.updateResource(root.resolve("docs/components/modules/languages/pages"), file.getName(), text);
                }
                catch (IOException e) {
                    throw new MojoExecutionException("Error reading file " + file + " Reason: " + e, (Exception)e);
                }
            }
        }
    }

    private void executeEips() throws MojoExecutionException {
        String currentDir = Paths.get(".", new String[0]).normalize().toAbsolutePath().toString();
        if (!currentDir.endsWith("camel-core-engine")) {
            return;
        }
        TreeSet jsonFiles = new TreeSet();
        File coreDir = new File(".");
        if (coreDir.isDirectory()) {
            File target = new File(coreDir, "target/classes/org/apache/camel/model");
            PackageHelper.findJsonFiles((File)target, jsonFiles);
        }
        if (!jsonFiles.isEmpty()) {
            this.getLog().debug((CharSequence)("Found " + jsonFiles.size() + " eips"));
            for (File jsonFile : jsonFiles) {
                String json = UpdateReadmeMojo.loadEipJson(jsonFile);
                if (json == null) continue;
                EipModel model = JsonMapper.generateEipModel((String)json);
                model.getOptions().removeIf(option -> "id".equals(option.getName()) || "description".equals(option.getName()) || "expression".equals(option.getName()) || "outputs".equals(option.getName()));
                model.getOptions().stream().filter(BaseOptionModel::isRequired).forEach(option -> {
                    String desc = "*Required* " + option.getDescription();
                    option.setDescription(desc);
                });
                model.getOptions().stream().filter(BaseOptionModel::isDeprecated).forEach(option -> {
                    String desc = "*Deprecated* " + option.getDescription();
                    if (!Strings.isEmpty((String)option.getDeprecationNote())) {
                        if (!desc.endsWith(".")) {
                            desc = desc + ".";
                        }
                        desc = desc + " Deprecation note: " + option.getDeprecationNote();
                    }
                    option.setDescription(desc);
                });
                String eipName = model.getName();
                String kind = "eip";
                if (!model.getLabel().startsWith("eip")) continue;
                File file = new File(this.eipDocDir, eipName + "-" + "eip" + ".adoc");
                boolean exists = file.exists();
                boolean updated = this.updateHeader(eipName, file, (BaseModel<? extends BaseOptionModel>)model, " EIP", "eip");
                String options = UpdateReadmeMojo.evaluateTemplate("eip-options.mvel", model);
                if (updated |= this.updateOptionsIn(file, "eip", options)) {
                    this.getLog().info((CharSequence)("Updated doc file: " + file));
                } else if (exists) {
                    this.getLog().debug((CharSequence)("No changes to doc file: " + file));
                } else {
                    this.getLog().warn((CharSequence)("No eip doc file: " + file));
                    if (this.isFailFast()) {
                        throw new MojoExecutionException("Failed build due failFast=true");
                    }
                }
                if (!updated && !exists) continue;
                try {
                    Path root = PackageHelper.findCamelDirectory((File)this.project.getBasedir(), (String)"core/camel-core").toPath().getParent().getParent();
                    String text = PackageHelper.loadText((File)file);
                    this.updateResource(root.resolve("catalog/camel-catalog/src/generated/resources/org/apache/camel/catalog/docs"), file.getName(), text);
                }
                catch (IOException e) {
                    throw new MojoExecutionException("Error reading file " + file + " Reason: " + e, (Exception)e);
                }
            }
        }
    }

    private static String asComponentTitle(String name, String title) {
        if (name.equals("imap") || name.equals("imaps") || name.equals("pop3") || name.equals("pop3s") || name.equals("smtp") || name.equals("smtps")) {
            return "Mail";
        }
        return title;
    }

    private static String asDataFormatName(String name) {
        if (name.startsWith("bindy")) {
            return "bindy";
        }
        return name;
    }

    private static String asDataFormatTitle(String name, String title) {
        if (name.startsWith("bindy")) {
            return "Bindy";
        }
        return title;
    }

    private boolean updateHeader(String name, File file, BaseModel<? extends BaseOptionModel> model, String titleSuffix, String kind) throws MojoExecutionException {
        this.getLog().debug((CharSequence)("updateHeader " + file));
        String linkSuffix = "-" + kind;
        if (model == null || !file.exists()) {
            return false;
        }
        boolean updated = false;
        try {
            String text = PackageHelper.loadText((File)file);
            String[] lines = text.split("\n");
            if (lines.length < 5) {
                return false;
            }
            LinkedHashMap<String, String> manualAttributes = new LinkedHashMap<String, String>();
            block2: for (String line : lines) {
                if (line.length() == 0) break;
                for (Pattern attrName : MANUAL_ATTRIBUTES) {
                    Matcher m = attrName.matcher(line);
                    if (!m.matches()) continue;
                    manualAttributes.put(m.group(1), m.group(2));
                    continue block2;
                }
            }
            ArrayList<String> newLines = new ArrayList<String>(lines.length + 8);
            newLines.add("[[" + name + linkSuffix + "]]");
            String title = model.getTitle() + titleSuffix;
            if (model.isDeprecated()) {
                title = title + " (deprecated)";
            }
            newLines.add("= " + title);
            newLines.add(":docTitle: " + model.getTitle());
            if (model instanceof ArtifactModel) {
                newLines.add(":artifactId: " + ((ArtifactModel)model).getArtifactId());
            }
            newLines.add(":description: " + model.getDescription());
            newLines.add(":since: " + model.getFirstVersionShort());
            newLines.add(":supportLevel: " + model.getSupportLevel().toString() + (model.isDeprecated() ? "-deprecated" : ""));
            if (model.isDeprecated()) {
                newLines.add(":deprecated: *deprecated*");
            }
            if (model instanceof ComponentModel) {
                newLines.add(":component-header: " + UpdateReadmeMojo.generateComponentHeader((ComponentModel)model));
                if (Arrays.asList(model.getLabel().split(",")).contains("core")) {
                    newLines.add(":core:");
                }
            }
            newLines.add("include::{cq-version}@camel-quarkus:ROOT:partial$reference/" + kind + "s/" + name + ".adoc[]");
            if (!manualAttributes.isEmpty()) {
                newLines.add("//Manually maintained attributes");
                for (Map.Entry entry : manualAttributes.entrySet()) {
                    newLines.add(":" + (String)entry.getKey() + ": " + (String)entry.getValue());
                }
            }
            newLines.add("");
            for (int i = 0; i < lines.length && i <= newLines.size() - 1; ++i) {
                if (((String)newLines.get(i)).equals(lines[i])) continue;
                updated = true;
                break;
            }
            boolean copy = false;
            if (updated) {
                for (int i = 0; i < lines.length; ++i) {
                    if (!copy && lines[i].isEmpty()) {
                        copy = true;
                        continue;
                    }
                    if (!copy) continue;
                    newLines.add(lines[i]);
                }
                if (!copy) {
                    throw new MojoFailureException("File " + file + " has unexpected structure with no empty line.");
                }
            }
            if (updated) {
                if (!((String)newLines.get(newLines.size() - 1)).isEmpty()) {
                    newLines.add("");
                }
                String newText = String.join((CharSequence)"\n", newLines);
                PackageHelper.writeText((File)file, (String)newText);
            }
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error reading file " + file + " Reason: " + e, e);
        }
        return updated;
    }

    private void checkComponentHeader(File file, ComponentModel model) throws MojoExecutionException {
        String loadedText;
        if (!file.exists()) {
            return;
        }
        String headerText = "*{component-header}*";
        try {
            loadedText = PackageHelper.loadText((File)file);
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error reading file " + file + " Reason: " + e, e);
        }
        if (!loadedText.contains("*{component-header}*")) {
            throw new MojoExecutionException("File " + file + " does not contain required string `" + "*{component-header}*" + "'");
        }
    }

    private void checkSince(File file, ArtifactModel<?> model) throws MojoExecutionException {
        String loadedText;
        if (!file.exists()) {
            return;
        }
        String sinceText = "*Since Camel {since}*";
        try {
            loadedText = PackageHelper.loadText((File)file);
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error reading file " + file + " Reason: " + e, e);
        }
        if (!loadedText.contains("*Since Camel {since}*")) {
            throw new MojoExecutionException("File " + file + " does not contain required string '" + "*Since Camel {since}*" + "'");
        }
    }

    private static String generateComponentHeader(ComponentModel model) {
        boolean consumerOnly = model.isConsumerOnly();
        boolean producerOnly = model.isProducerOnly();
        if (!consumerOnly && producerOnly) {
            return "Only producer is supported";
        }
        if (consumerOnly && !producerOnly) {
            return "Only consumer is supported";
        }
        return "Both producer and consumer are supported";
    }

    private boolean updateOptionsIn(File file, String kind, String changed) throws MojoExecutionException {
        if (!file.exists()) {
            return false;
        }
        String updated = changed.trim();
        try {
            String text = PackageHelper.loadText((File)file);
            String existing = Strings.between((String)text, (String)("// " + kind + " options: START"), (String)("// " + kind + " options: END"));
            if (existing != null) {
                if ((existing = existing.trim()).equals(updated)) {
                    return false;
                }
                String before = Strings.before((String)text, (String)("// " + kind + " options: START"));
                String after = Strings.after((String)text, (String)("// " + kind + " options: END"));
                text = before + "// " + kind + " options: START\n" + updated + "\n// " + kind + " options: END" + after;
                PackageHelper.writeText((File)file, (String)text);
                return true;
            }
            this.getLog().warn((CharSequence)("Cannot find markers in file " + file));
            this.getLog().warn((CharSequence)"Add the following markers");
            this.getLog().warn((CharSequence)("\t// " + kind + " options: START"));
            this.getLog().warn((CharSequence)("\t// " + kind + " options: END"));
            if (this.isFailFast()) {
                throw new MojoExecutionException("Failed build due failFast=true");
            }
            return false;
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error reading file " + file + " Reason: " + e, (Exception)e);
        }
    }

    private static String loadJsonFrom(Set<File> jsonFiles, String kind, String name) {
        for (File file : jsonFiles) {
            if (!file.getName().equals(name + ".json")) continue;
            try {
                String json = PackageHelper.loadText((File)file);
                if (!Objects.equals(kind, PackageHelper.getSchemaKind((String)json))) continue;
                return json;
            }
            catch (IOException iOException) {
            }
        }
        return null;
    }

    private static String loadJsonFrom(File file, String kind) {
        if (file.getName().endsWith(".json")) {
            try {
                String json = PackageHelper.loadText((File)file);
                if (Objects.equals(kind, PackageHelper.getSchemaKind((String)json))) {
                    return json;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }

    private static String loadEipJson(File file) {
        try {
            String json = PackageHelper.loadText((File)file);
            if ("model".equals(PackageHelper.getSchemaKind((String)json))) {
                return json;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    private ComponentModel generateComponentModel(String json) {
        ComponentModel component = JsonMapper.generateComponentModel((String)json);
        Stream.concat(component.getComponentOptions().stream(), component.getEndpointOptions().stream()).filter(BaseOptionModel::isRequired).forEach(option -> {
            String desc = "*Required* " + option.getDescription();
            option.setDescription(desc);
        });
        Stream.concat(component.getComponentOptions().stream(), component.getEndpointOptions().stream()).filter(BaseOptionModel::isDeprecated).forEach(option -> {
            String desc = "*Deprecated* " + option.getDescription();
            if (!Strings.isEmpty((String)option.getDeprecationNote())) {
                if (!desc.endsWith(".")) {
                    desc = desc + ".";
                }
                desc = desc + " Deprecation note: " + option.getDeprecationNote();
            }
            option.setDescription(desc);
        });
        Stream.concat(component.getComponentOptions().stream(), component.getEndpointOptions().stream()).filter(o -> o.getEnums() != null).forEach(option -> {
            String desc = option.getDescription();
            if (!desc.endsWith(".")) {
                desc = desc + ".";
            }
            desc = desc + " There are " + option.getEnums().size() + " enums and the value can be one of: " + this.wrapEnumValues(option.getEnums());
            option.setDescription(desc);
        });
        return component;
    }

    private OtherModel generateOtherModel(String json) {
        OtherModel other = JsonMapper.generateOtherModel((String)json);
        return other;
    }

    private DataFormatModel generateDataFormatModel(String json) {
        DataFormatModel model = JsonMapper.generateDataFormatModel((String)json);
        model.getOptions().removeIf(opt -> Objects.equals(opt.getName(), "id"));
        model.getOptions().stream().filter(BaseOptionModel::isDeprecated).forEach(option -> {
            String desc = "*Deprecated* " + option.getDescription();
            if (!Strings.isEmpty((String)option.getDeprecationNote())) {
                desc = option.getDescription();
                if (!desc.endsWith(".")) {
                    desc = desc + ".";
                }
                desc = desc + " Deprecation note: " + option.getDeprecationNote();
            }
            option.setDescription(desc);
        });
        model.getOptions().stream().filter(o -> o.getEnums() != null).forEach(option -> {
            String desc = option.getDescription();
            if (!desc.endsWith(".")) {
                desc = desc + ".";
            }
            desc = desc + " There are " + option.getEnums().size() + " enums and the value can be one of: " + this.wrapEnumValues(option.getEnums());
            option.setDescription(desc);
        });
        return model;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String evaluateTemplate(String templateName, Object model) throws MojoExecutionException {
        try (InputStream templateStream = UpdateReadmeMojo.class.getClassLoader().getResourceAsStream(templateName);){
            String template = PackageHelper.loadText((InputStream)templateStream);
            String string = (String)TemplateRuntime.eval((String)template, (Object)model, Collections.singletonMap("util", MvelHelper.INSTANCE));
            return string;
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error processing mvel template `" + templateName + "`", (Exception)e);
        }
    }

    private List<String> listDescriptorNamesOfType(String type) {
        File[] files;
        ArrayList<String> names = new ArrayList<String>();
        File f = new File(this.project.getBasedir(), "target/classes");
        if ((f = new File(f, "META-INF/services/org/apache/camel/" + type)).exists() && f.isDirectory() && (files = f.listFiles()) != null) {
            for (File file : files) {
                String name;
                if (file.isDirectory() || (name = file.getName()).charAt(0) == '.') continue;
                names.add(name);
            }
        }
        Collections.sort(names);
        return names;
    }

    private boolean isFailFast() {
        return this.failFast != null && this.failFast != false;
    }

    private String wrapEnumValues(List<String> enumValues) {
        return String.join((CharSequence)", ", enumValues);
    }
}

