/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.maven.packaging;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.camel.tooling.model.BaseModel;
import org.apache.camel.tooling.model.BaseOptionModel;
import org.apache.camel.tooling.model.ComponentModel;
import org.apache.camel.tooling.model.DataFormatModel;
import org.apache.camel.tooling.model.EipModel;
import org.apache.camel.tooling.model.JsonMapper;
import org.apache.camel.tooling.model.LanguageModel;
import org.apache.camel.tooling.model.OtherModel;
import org.apache.camel.tooling.util.FileUtil;
import org.apache.camel.tooling.util.PackageHelper;
import org.apache.camel.tooling.util.Strings;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;

@Mojo(name="prepare-catalog", threadSafe=true)
public class PrepareCatalogMojo
extends AbstractMojo {
    private static final String[] EXCLUDE_DOC_FILES = new String[]{"camel-core-model", "camel-core-xml", "camel-http-common", "camel-http-base", "camel-jetty-common", "camel-debezium-common"};
    private static final int UNUSED_LABELS_WARN = 15;
    @Parameter(property="project", required=true, readonly=true)
    protected MavenProject project;
    @Parameter(defaultValue="true")
    protected Boolean validate;
    @Parameter(defaultValue="${project.basedir}/src/generated/resources/org/apache/camel/catalog/components")
    protected File componentsOutDir;
    @Parameter(defaultValue="${project.basedir}/src/generated/resources/org/apache/camel/catalog/dataformats")
    protected File dataFormatsOutDir;
    @Parameter(defaultValue="${project.basedir}/src/generated/resources/org/apache/camel/catalog/languages")
    protected File languagesOutDir;
    @Parameter(defaultValue="${project.basedir}/src/generated/resources/org/apache/camel/catalog/others")
    protected File othersOutDir;
    @Parameter(defaultValue="${project.basedir}/src/generated/resources/org/apache/camel/catalog/docs")
    protected File documentsOutDir;
    @Parameter(defaultValue="${project.basedir}/src/generated/resources/org/apache/camel/catalog/models")
    protected File modelsOutDir;
    @Parameter(defaultValue="${project.basedir}/src/generated/resources/org/apache/camel/catalog/archetypes")
    protected File archetypesOutDir;
    @Parameter(defaultValue="${project.basedir}/src/generated/resources/org/apache/camel/catalog/schemas")
    protected File schemasOutDir;
    @Parameter(defaultValue="${project.basedir}/src/generated/resources/org/apache/camel/catalog/main")
    protected File mainOutDir;
    @Parameter(defaultValue="${project.build.directory}/../../../components")
    protected File componentsDir;
    @Parameter(defaultValue="${project.build.directory}/../../../core/camel-core-engine")
    protected File coreDir;
    @Parameter(defaultValue="${project.build.directory}/../../../core/camel-core-model")
    protected File modelDir;
    @Parameter(defaultValue="${project.build.directory}/../../../core/camel-base")
    protected File baseDir;
    @Parameter(defaultValue="${project.build.directory}/../../../core/camel-core-languages")
    protected File languagesDir;
    @Parameter(defaultValue="${project.build.directory}/../../../core/camel-xml-jaxp")
    protected File jaxpDir;
    @Parameter(defaultValue="${project.build.directory}/../../../components/camel-spring")
    protected File springDir;
    @Parameter(defaultValue="${project.build.directory}/../../../archetypes")
    protected File archetypesDir;
    @Parameter(defaultValue="${project.build.directory}/../../../components/camel-spring/target/schema")
    protected File springSchemaDir;
    @Parameter(defaultValue="${project.build.directory}/../../../components/camel-blueprint/target/schema")
    protected File blueprintSchemaDir;
    @Parameter(defaultValue="${project.build.directory}/../../../core/camel-main/target/classes/META-INF")
    protected File mainDir;
    @Component
    protected MavenProjectHelper projectHelper;
    private Collection<Path> allJsonFiles;
    private Collection<Path> allPropertiesFiles;
    private Map<Path, BaseModel<?>> allModels;

    private static String asComponentName(Path file) {
        String name = file.getFileName().toString();
        if (name.endsWith(".json")) {
            return name.substring(0, name.length() - ".json".length());
        }
        if (name.endsWith(".adoc")) {
            return name.substring(0, name.length() - ".adoc".length());
        }
        return name;
    }

    private static boolean excludeDocumentDir(String name) {
        for (String exclude : EXCLUDE_DOC_FILES) {
            if (!exclude.equals(name)) continue;
            return true;
        }
        return false;
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        try {
            this.allJsonFiles = new TreeSet<Path>();
            this.allPropertiesFiles = new TreeSet<Path>();
            Stream.concat(this.list(this.componentsDir.toPath()), Stream.of(this.coreDir.toPath(), this.modelDir.toPath(), this.baseDir.toPath(), this.languagesDir.toPath(), this.jaxpDir.toPath(), this.springDir.toPath())).filter(dir -> !"target".equals(dir.getFileName().toString())).flatMap(p -> this.getComponentPath((Path)p).stream()).filter(dir -> Files.isDirectory(dir.resolve("src"), new LinkOption[0])).map(p -> p.resolve("target/classes")).flatMap(PackageHelper::walk).forEach(p -> {
                String f = p.getFileName().toString();
                if (f.endsWith(".json")) {
                    this.allJsonFiles.add((Path)p);
                } else if (f.equals("component.properties") || f.equals("dataformat.properties") || f.equals("language.properties") || f.equals("other.properties")) {
                    this.allPropertiesFiles.add((Path)p);
                }
            });
            this.allModels = this.allJsonFiles.stream().collect(Collectors.toMap(p -> p, JsonMapper::generateModel));
            this.executeModel();
            Set<String> components = this.executeComponents();
            Set<String> dataformats = this.executeDataFormats();
            Set<String> languages = this.executeLanguages();
            Set<String> others = this.executeOthers();
            this.executeDocuments(components, dataformats, languages, others);
            this.executeArchetypes();
            this.executeXmlSchemas();
            this.executeMain();
        }
        catch (Exception e) {
            throw new MojoFailureException("Error preparing catalog", (Throwable)e);
        }
    }

    protected void executeModel() throws Exception {
        Path coreDir = this.modelDir.toPath();
        Path springDir = this.springDir.toPath();
        Path modelsOutDir = this.modelsOutDir.toPath();
        this.getLog().info((CharSequence)"================================================================================");
        this.getLog().info((CharSequence)"Copying all Camel model json descriptors");
        TreeSet<Path> missingLabels = new TreeSet<Path>();
        TreeSet<Path> missingJavaDoc = new TreeSet<Path>();
        TreeMap<String, Set<String>> usedLabels = new TreeMap<String, Set<String>>();
        Path coreDirTarget = coreDir.resolve("target/classes/org/apache/camel/model");
        Path springTarget1 = springDir.resolve("target/classes/org/apache/camel/spring");
        Path springTarget2 = springDir.resolve("target/classes/org/apache/camel/core/xml");
        Set jsonFiles = this.allJsonFiles.stream().filter(p -> p.startsWith(coreDirTarget) || p.startsWith(springTarget1) || p.startsWith(springTarget2)).collect(Collectors.toCollection(TreeSet::new));
        this.getLog().info((CharSequence)("Found " + jsonFiles.size() + " model json files"));
        Files.createDirectories(modelsOutDir, new FileAttribute[0]);
        Set<Path> duplicateJsonFiles = this.getDuplicates(jsonFiles);
        Map<Path, Path> newJsons = this.map(jsonFiles, p -> p, p -> modelsOutDir.resolve(p.getFileName()));
        this.list(modelsOutDir).filter(p -> !newJsons.containsValue(p)).forEach(this::delete);
        newJsons.forEach(this::copy);
        for (Path file : jsonFiles) {
            EipModel model = (EipModel)this.allModels.get(file);
            String name = PrepareCatalogMojo.asComponentName(file);
            String label = model.getLabel();
            if (Strings.isNullOrEmpty((String)label)) {
                missingLabels.add(file);
            } else {
                String[] labels;
                for (String s : labels = label.split(",")) {
                    usedLabels.computeIfAbsent(s, k -> new TreeSet()).add(name);
                }
            }
            if (!model.getOptions().stream().filter(option -> !"outputs".equals(option.getName()) && !"transforms".equals(option.getName())).map(BaseOptionModel::getDescription).anyMatch(Strings::isNullOrEmpty)) continue;
            missingJavaDoc.add(file);
        }
        Path all = modelsOutDir.resolve("../models.properties");
        Set modelNames = jsonFiles.stream().map(PrepareCatalogMojo::asComponentName).collect(Collectors.toCollection(TreeSet::new));
        FileUtil.updateFile((Path)all, (String)(String.join((CharSequence)"\n", modelNames) + "\n"));
        this.printModelsReport(jsonFiles, duplicateJsonFiles, missingLabels, usedLabels, missingJavaDoc);
    }

    protected Set<String> executeComponents() throws Exception {
        Path componentsOutDir = this.componentsOutDir.toPath();
        this.getLog().info((CharSequence)"Copying all Camel component json descriptors");
        TreeSet<Path> missingComponents = new TreeSet<Path>();
        TreeMap<String, Set<String>> usedComponentLabels = new TreeMap<String, Set<String>>();
        TreeSet<String> usedOptionLabels = new TreeSet<String>();
        TreeSet<String> unlabeledOptions = new TreeSet<String>();
        TreeSet<Path> missingFirstVersions = new TreeSet<Path>();
        Set componentFiles = this.allPropertiesFiles.stream().filter(p -> p.endsWith("component.properties")).collect(Collectors.toCollection(TreeSet::new));
        Set jsonFiles = this.allJsonFiles.stream().filter(p -> this.allModels.get(p) instanceof ComponentModel).collect(Collectors.toCollection(TreeSet::new));
        componentFiles.stream().filter(p -> p.endsWith("component.properties")).forEach(p -> {
            Path parent = this.getModule((Path)p);
            List jsons = jsonFiles.stream().filter(f -> f.startsWith(parent)).collect(Collectors.toList());
            if (jsons.isEmpty()) {
                missingComponents.add(parent);
            }
        });
        this.getLog().info((CharSequence)("Found " + componentFiles.size() + " component.properties files"));
        this.getLog().info((CharSequence)("Found " + jsonFiles.size() + " component json files"));
        Files.createDirectories(componentsOutDir, new FileAttribute[0]);
        Set<Path> duplicateJsonFiles = this.getDuplicates(jsonFiles);
        Map<Path, Path> newJsons = this.map(jsonFiles, p -> p, p -> componentsOutDir.resolve(p.getFileName()));
        this.list(componentsOutDir).filter(p -> !newJsons.containsValue(p)).forEach(this::delete);
        newJsons.forEach(this::copy);
        HashSet<String> alternativeSchemes = new HashSet<String>();
        for (Path file : jsonFiles) {
            try {
                String firstVersion;
                String alternativeScheme;
                String[] labels;
                String text = PackageHelper.loadText((Path)file);
                ComponentModel model = JsonMapper.generateComponentModel((String)text);
                String name = PrepareCatalogMojo.asComponentName(file);
                String label = model.getLabel();
                for (String s : labels = label.split(",")) {
                    Set components = usedComponentLabels.computeIfAbsent(s, k -> new TreeSet());
                    components.add(name);
                }
                model.getComponentOptions().stream().map(BaseOptionModel::getLabel).filter(l -> !Strings.isNullOrEmpty((String)l)).flatMap(l -> Stream.of(label.split(","))).forEach(usedOptionLabels::add);
                model.getEndpointOptions().stream().map(BaseOptionModel::getLabel).filter(l -> !Strings.isNullOrEmpty((String)l)).flatMap(l -> Stream.of(label.split(","))).forEach(usedOptionLabels::add);
                long unused = model.getEndpointOptions().stream().map(BaseOptionModel::getLabel).filter(Strings::isNullOrEmpty).count();
                if (unused >= 15L) {
                    unlabeledOptions.add(name);
                }
                if (!Strings.isNullOrEmpty((String)(alternativeScheme = model.getAlternativeSchemes()))) {
                    String[] parts = alternativeScheme.split(",");
                    alternativeSchemes.addAll(Arrays.asList(parts).subList(1, parts.length));
                }
                if (!Strings.isNullOrEmpty((String)(firstVersion = model.getFirstVersion()))) continue;
                missingFirstVersions.add(file);
            }
            catch (IOException iOException) {}
        }
        Path all = componentsOutDir.resolve("../components.properties");
        Set componentNames = jsonFiles.stream().map(PrepareCatalogMojo::asComponentName).collect(Collectors.toCollection(TreeSet::new));
        FileUtil.updateFile((Path)all, (String)(String.join((CharSequence)"\n", componentNames) + "\n"));
        this.printComponentsReport(jsonFiles, duplicateJsonFiles, missingComponents, usedComponentLabels, usedOptionLabels, unlabeledOptions, missingFirstVersions);
        componentNames.removeAll(alternativeSchemes);
        return componentNames;
    }

    protected Set<String> executeDataFormats() throws Exception {
        Path dataFormatsOutDir = this.dataFormatsOutDir.toPath();
        this.getLog().info((CharSequence)"Copying all Camel dataformat json descriptors");
        TreeMap<String, Set<String>> usedLabels = new TreeMap<String, Set<String>>();
        TreeSet<Path> missingFirstVersions = new TreeSet<Path>();
        Set dataFormatFiles = this.allPropertiesFiles.stream().filter(p -> p.endsWith("dataformat.properties")).collect(Collectors.toCollection(TreeSet::new));
        Set jsonFiles = this.allJsonFiles.stream().filter(p -> this.allModels.get(p) instanceof DataFormatModel).collect(Collectors.toCollection(TreeSet::new));
        this.getLog().info((CharSequence)("Found " + dataFormatFiles.size() + " dataformat.properties files"));
        this.getLog().info((CharSequence)("Found " + jsonFiles.size() + " dataformat json files"));
        Files.createDirectories(dataFormatsOutDir, new FileAttribute[0]);
        Set<Path> duplicateJsonFiles = this.getDuplicates(jsonFiles);
        Map<Path, Path> newJsons = this.map(jsonFiles, p -> p, p -> dataFormatsOutDir.resolve(p.getFileName()));
        this.list(dataFormatsOutDir).filter(p -> !newJsons.containsValue(p)).forEach(this::delete);
        newJsons.forEach(this::copy);
        for (Path file : jsonFiles) {
            DataFormatModel model = (DataFormatModel)this.allModels.get(file);
            String name = PrepareCatalogMojo.asComponentName(file);
            for (String s : model.getLabel().split(",")) {
                usedLabels.computeIfAbsent(s, k -> new TreeSet()).add(name);
            }
            String firstVersion = model.getFirstVersion();
            if (!Strings.isNullOrEmpty((String)firstVersion)) continue;
            missingFirstVersions.add(file);
        }
        Path all = dataFormatsOutDir.resolve("../dataformats.properties");
        Set dataFormatNames = jsonFiles.stream().map(PrepareCatalogMojo::asComponentName).collect(Collectors.toCollection(TreeSet::new));
        FileUtil.updateFile((Path)all, (String)(String.join((CharSequence)"\n", dataFormatNames) + "\n"));
        this.printDataFormatsReport(jsonFiles, duplicateJsonFiles, usedLabels, missingFirstVersions);
        return dataFormatNames;
    }

    protected Set<String> executeLanguages() throws Exception {
        Path languagesOutDir = this.languagesOutDir.toPath();
        this.getLog().info((CharSequence)"Copying all Camel language json descriptors");
        TreeMap<String, Set<String>> usedLabels = new TreeMap<String, Set<String>>();
        TreeSet<Path> missingFirstVersions = new TreeSet<Path>();
        Set languageFiles = this.allPropertiesFiles.stream().filter(p -> p.endsWith("language.properties")).collect(Collectors.toCollection(TreeSet::new));
        Set jsonFiles = this.allJsonFiles.stream().filter(p -> this.allModels.get(p) instanceof LanguageModel).collect(Collectors.toCollection(TreeSet::new));
        this.getLog().info((CharSequence)("Found " + languageFiles.size() + " language.properties files"));
        this.getLog().info((CharSequence)("Found " + jsonFiles.size() + " language json files"));
        Files.createDirectories(languagesOutDir, new FileAttribute[0]);
        Set<Path> duplicateJsonFiles = this.getDuplicates(jsonFiles);
        Map<Path, Path> newJsons = this.map(jsonFiles, p -> p, p -> languagesOutDir.resolve(p.getFileName()));
        this.list(languagesOutDir).filter(p -> !newJsons.containsValue(p)).forEach(this::delete);
        newJsons.forEach(this::copy);
        for (Path file : jsonFiles) {
            LanguageModel model = (LanguageModel)this.allModels.get(file);
            String name = PrepareCatalogMojo.asComponentName(file);
            for (String s : model.getLabel().split(",")) {
                usedLabels.computeIfAbsent(s, k -> new TreeSet()).add(name);
            }
            String firstVersion = model.getFirstVersion();
            if (!Strings.isNullOrEmpty((String)firstVersion)) continue;
            missingFirstVersions.add(file);
        }
        Path all = languagesOutDir.resolve("../languages.properties");
        Set languagesNames = jsonFiles.stream().map(PrepareCatalogMojo::asComponentName).collect(Collectors.toCollection(TreeSet::new));
        FileUtil.updateFile((Path)all, (String)(String.join((CharSequence)"\n", languagesNames) + "\n"));
        this.printLanguagesReport(jsonFiles, duplicateJsonFiles, usedLabels, missingFirstVersions);
        return languagesNames;
    }

    private Set<String> executeOthers() throws Exception {
        Path othersOutDir = this.othersOutDir.toPath();
        this.getLog().info((CharSequence)"Copying all Camel other json descriptors");
        TreeMap<String, Set<String>> usedLabels = new TreeMap<String, Set<String>>();
        TreeSet<Path> missingFirstVersions = new TreeSet<Path>();
        Set otherFiles = this.allPropertiesFiles.stream().filter(p -> p.endsWith("other.properties")).collect(Collectors.toCollection(TreeSet::new));
        Set jsonFiles = this.allJsonFiles.stream().filter(p -> {
            Path m = this.getModule((Path)p);
            switch (m.getFileName().toString()) {
                case "camel-core-model": 
                case "camel-core-xml": 
                case "camel-box": 
                case "camel-http-base": 
                case "camel-http-common": 
                case "camel-jetty-common": 
                case "camel-as2": 
                case "camel-olingo2": 
                case "camel-olingo4": 
                case "camel-servicenow": 
                case "camel-salesforce": 
                case "camel-fhir": 
                case "camel-debezium-common": 
                case "camel-vertx-kafka": 
                case "camel-infinispan": {
                    return false;
                }
            }
            return true;
        }).filter(p -> this.allModels.get(p) instanceof OtherModel).collect(Collectors.toCollection(TreeSet::new));
        this.getLog().info((CharSequence)("Found " + otherFiles.size() + " other.properties files"));
        this.getLog().info((CharSequence)("Found " + jsonFiles.size() + " other json files"));
        Files.createDirectories(othersOutDir, new FileAttribute[0]);
        Set<Path> duplicateJsonFiles = this.getDuplicates(jsonFiles);
        Map<Path, Path> newJsons = this.map(jsonFiles, p -> p, p -> othersOutDir.resolve(p.getFileName()));
        this.list(othersOutDir).filter(p -> !newJsons.containsValue(p)).forEach(this::delete);
        newJsons.forEach(this::copy);
        for (Path file : jsonFiles) {
            String firstVersion;
            OtherModel model = (OtherModel)this.allModels.get(file);
            String name = PrepareCatalogMojo.asComponentName(file);
            String label = model.getLabel();
            if (!Strings.isNullOrEmpty((String)label)) {
                String[] labels;
                for (String s : labels = label.split(",")) {
                    usedLabels.computeIfAbsent(s, k -> new TreeSet()).add(name);
                }
            }
            if (!Strings.isNullOrEmpty((String)(firstVersion = model.getFirstVersion()))) continue;
            missingFirstVersions.add(file);
        }
        Path all = othersOutDir.resolve("../others.properties");
        Set otherNames = jsonFiles.stream().map(PrepareCatalogMojo::asComponentName).collect(Collectors.toCollection(TreeSet::new));
        FileUtil.updateFile((Path)all, (String)(String.join((CharSequence)"\n", otherNames) + "\n"));
        this.printOthersReport(jsonFiles, duplicateJsonFiles, usedLabels, missingFirstVersions);
        return otherNames;
    }

    protected void executeArchetypes() throws Exception {
        Path archetypesDir = this.archetypesDir.toPath();
        Path archetypesOutDir = this.archetypesOutDir.toPath();
        this.getLog().info((CharSequence)"Copying Archetype Catalog");
        this.copyFile(archetypesDir.resolve("target/classes/archetype-catalog.xml"), archetypesOutDir);
    }

    protected void executeXmlSchemas() throws Exception {
        Path schemasOutDir = this.schemasOutDir.toPath();
        Path springSchemaDir = this.springSchemaDir.toPath();
        Path blueprintSchemaDir = this.blueprintSchemaDir.toPath();
        this.getLog().info((CharSequence)"Copying Spring/Blueprint XML schemas");
        this.copyFile(springSchemaDir.resolve("camel-spring.xsd"), schemasOutDir);
        this.copyFile(blueprintSchemaDir.resolve("camel-blueprint.xsd"), schemasOutDir);
    }

    protected void executeMain() throws Exception {
        this.getLog().info((CharSequence)"Copying camel-main metadata");
        this.copyFile(this.mainDir.toPath().resolve("camel-main-configuration-metadata.json"), this.mainOutDir.toPath());
    }

    protected void executeDocuments(Set<String> components, Set<String> dataformats, Set<String> languages, Set<String> others) throws Exception {
        Path documentsOutDir = this.documentsOutDir.toPath();
        this.getLog().info((CharSequence)"Copying all Camel documents (ascii docs)");
        TreeSet<Path> adocFiles = new TreeSet<Path>();
        TreeSet<Path> missingAdocFiles = new TreeSet<Path>();
        TreeSet<Path> duplicateAdocFiles = new TreeSet();
        Stream.concat(this.list(this.componentsDir.toPath()).filter(dir -> !dir.getFileName().startsWith(".") && !"target".equals(dir.getFileName().toString())).flatMap(p -> this.getComponentPath((Path)p).stream()), Stream.of(this.coreDir.toPath(), this.baseDir.toPath(), this.languagesDir.toPath(), this.jaxpDir.toPath())).forEach(dir -> {
            List l = PackageHelper.walk((Path)dir.resolve("src/main/docs")).filter(f -> f.getFileName().toString().endsWith(".adoc")).collect(Collectors.toList());
            if (l.isEmpty()) {
                boolean valid;
                String n = dir.getFileName().toString();
                boolean isDir = dir.toFile().isDirectory();
                boolean bl = valid = isDir && !n.startsWith(".") && !n.endsWith("-base") && !n.endsWith("-common");
                if (valid) {
                    missingAdocFiles.add((Path)dir);
                }
            } else {
                adocFiles.addAll(l);
            }
        });
        this.getLog().info((CharSequence)("Found " + adocFiles.size() + " ascii document files"));
        Files.createDirectories(documentsOutDir, new FileAttribute[0]);
        duplicateAdocFiles = this.getDuplicates(adocFiles);
        Map<Path, Path> newJsons = this.map(adocFiles, p -> p, p -> documentsOutDir.resolve(p.getFileName()));
        this.list(documentsOutDir).filter(p -> !newJsons.containsValue(p) && !newJsons.containsValue(p.resolveSibling(p.getFileName().toString().replace(".html", ".adoc")))).forEach(this::delete);
        newJsons.forEach(this::copy);
        Path all = documentsOutDir.resolve("../docs.properties");
        Set docNames = adocFiles.stream().map(PrepareCatalogMojo::asComponentName).collect(Collectors.toCollection(TreeSet::new));
        FileUtil.updateFile((Path)all, (String)(String.join((CharSequence)"\n", docNames) + "\n"));
        this.printDocumentsReport(adocFiles, duplicateAdocFiles, missingAdocFiles);
        this.printMissingDocumentsReport(docNames, components, dataformats, languages, others);
    }

    private void printMissingDocumentsReport(Set<String> docs, Set<String> components, Set<String> dataformats, Set<String> languages, Set<String> others) {
        String name;
        this.getLog().info((CharSequence)"");
        this.getLog().info((CharSequence)"Camel missing documents report");
        this.getLog().info((CharSequence)"");
        ArrayList<String> missing = new ArrayList<String>();
        Iterator<String> iterator = components.iterator();
        while (iterator.hasNext()) {
            String component;
            switch (component = iterator.next()) {
                case "imap": 
                case "imaps": 
                case "pop3": 
                case "pop3s": 
                case "smtp": 
                case "smtps": {
                    component = "mail";
                    break;
                }
                case "ftp": 
                case "sftp": 
                case "ftps": {
                    component = "ftp";
                }
            }
            if (docs.contains(name = component + "-component") || component.equalsIgnoreCase("salesforce") || component.equalsIgnoreCase("servicenow")) continue;
            missing.add(name);
        }
        if (!missing.isEmpty()) {
            this.getLog().info((CharSequence)"");
            this.getLog().warn((CharSequence)("\tMissing .adoc component documentation: " + missing.size()));
            for (String name2 : missing) {
                this.getLog().warn((CharSequence)("\t\t" + name2));
            }
        }
        missing.clear();
        for (String dataformat : dataformats) {
            if (dataformat.startsWith("bindy")) {
                dataformat = "bindy";
            }
            if (docs.contains(name = dataformat + "-dataformat")) continue;
            missing.add(name);
        }
        if (!missing.isEmpty()) {
            this.getLog().info((CharSequence)"");
            this.getLog().warn((CharSequence)("\tMissing .adoc dataformat documentation: " + missing.size()));
            for (String name2 : missing) {
                this.getLog().warn((CharSequence)("\t\t" + name2));
            }
        }
        missing.clear();
        for (String language : languages) {
            name = language + "-language";
            if (docs.contains(name)) continue;
            missing.add(name);
        }
        if (!missing.isEmpty()) {
            this.getLog().info((CharSequence)"");
            this.getLog().warn((CharSequence)("\tMissing .adoc language documentation: " + missing.size()));
            for (String name2 : missing) {
                this.getLog().warn((CharSequence)("\t\t" + name2));
            }
        }
        missing.clear();
        for (String other : others) {
            name = other;
            if (docs.contains(name)) continue;
            missing.add(name);
        }
        if (!missing.isEmpty()) {
            this.getLog().info((CharSequence)"");
            this.getLog().warn((CharSequence)("\tMissing .adoc other documentation: " + missing.size()));
            for (String name2 : missing) {
                this.getLog().warn((CharSequence)("\t\t" + name2));
            }
        }
        missing.clear();
        this.getLog().info((CharSequence)"");
        this.getLog().info((CharSequence)"================================================================================");
    }

    private void printModelsReport(Set<Path> json, Set<Path> duplicate, Set<Path> missingLabels, Map<String, Set<String>> usedLabels, Set<Path> missingJavaDoc) {
        this.getLog().info((CharSequence)"================================================================================");
        this.getLog().info((CharSequence)"");
        this.getLog().info((CharSequence)"Camel model catalog report");
        this.getLog().info((CharSequence)"");
        this.getLog().info((CharSequence)("\tModels found: " + json.size()));
        for (Path path : json) {
            this.getLog().info((CharSequence)("\t\t" + PrepareCatalogMojo.asComponentName(path)));
        }
        if (!duplicate.isEmpty()) {
            this.getLog().info((CharSequence)"");
            this.getLog().warn((CharSequence)("\tDuplicate models detected: " + duplicate.size()));
            for (Path path : duplicate) {
                this.getLog().warn((CharSequence)("\t\t" + PrepareCatalogMojo.asComponentName(path)));
            }
        }
        if (!missingLabels.isEmpty()) {
            this.getLog().info((CharSequence)"");
            this.getLog().warn((CharSequence)("\tMissing labels detected: " + missingLabels.size()));
            for (Path path : missingLabels) {
                this.getLog().warn((CharSequence)("\t\t" + PrepareCatalogMojo.asComponentName(path)));
            }
        }
        if (!usedLabels.isEmpty()) {
            this.getLog().info((CharSequence)"");
            this.getLog().info((CharSequence)("\tUsed labels: " + usedLabels.size()));
            for (Map.Entry entry : usedLabels.entrySet()) {
                this.getLog().info((CharSequence)("\t\t" + (String)entry.getKey() + ":"));
                for (String name : (Set)entry.getValue()) {
                    this.getLog().info((CharSequence)("\t\t\t" + name));
                }
            }
        }
        if (!missingJavaDoc.isEmpty()) {
            this.getLog().info((CharSequence)"");
            this.getLog().warn((CharSequence)("\tMissing javadoc on models: " + missingJavaDoc.size()));
            for (Path path : missingJavaDoc) {
                this.getLog().warn((CharSequence)("\t\t" + PrepareCatalogMojo.asComponentName(path)));
            }
        }
        this.getLog().info((CharSequence)"");
        this.getLog().info((CharSequence)"================================================================================");
    }

    private void printComponentsReport(Set<Path> json, Set<Path> duplicate, Set<Path> missing, Map<String, Set<String>> usedComponentLabels, Set<String> usedOptionsLabels, Set<String> unusedLabels, Set<Path> missingFirstVersions) {
        this.getLog().info((CharSequence)"================================================================================");
        this.getLog().info((CharSequence)"");
        this.getLog().info((CharSequence)"Camel component catalog report");
        this.getLog().info((CharSequence)"");
        this.getLog().info((CharSequence)("\tComponents found: " + json.size()));
        for (Path path : json) {
            this.getLog().info((CharSequence)("\t\t" + PrepareCatalogMojo.asComponentName(path)));
        }
        if (!duplicate.isEmpty()) {
            this.getLog().info((CharSequence)"");
            this.getLog().warn((CharSequence)("\tDuplicate components detected: " + duplicate.size()));
            for (Path path : duplicate) {
                this.getLog().warn((CharSequence)("\t\t" + PrepareCatalogMojo.asComponentName(path)));
            }
        }
        if (!usedComponentLabels.isEmpty()) {
            this.getLog().info((CharSequence)"");
            this.getLog().info((CharSequence)("\tUsed component labels: " + usedComponentLabels.size()));
            for (Map.Entry entry : usedComponentLabels.entrySet()) {
                this.getLog().info((CharSequence)("\t\t" + (String)entry.getKey() + ":"));
                for (String name : (Set)entry.getValue()) {
                    this.getLog().info((CharSequence)("\t\t\t" + name));
                }
            }
        }
        if (!usedOptionsLabels.isEmpty()) {
            this.getLog().info((CharSequence)"");
            this.getLog().info((CharSequence)("\tUsed component/endpoint options labels: " + usedOptionsLabels.size()));
            for (String string : usedOptionsLabels) {
                this.getLog().info((CharSequence)("\t\t\t" + string));
            }
        }
        if (!unusedLabels.isEmpty()) {
            this.getLog().info((CharSequence)"");
            this.getLog().info((CharSequence)("\tComponent with more than 15 unlabelled options: " + unusedLabels.size()));
            for (String string : unusedLabels) {
                this.getLog().info((CharSequence)("\t\t\t" + string));
            }
        }
        if (!missing.isEmpty()) {
            this.getLog().info((CharSequence)"");
            this.getLog().warn((CharSequence)("\tMissing components detected: " + missing.size()));
            for (Path path : missing) {
                this.getLog().warn((CharSequence)("\t\t" + path.getFileName().toString()));
            }
        }
        if (!missingFirstVersions.isEmpty()) {
            this.getLog().info((CharSequence)"");
            this.getLog().warn((CharSequence)("\tComponents without firstVersion defined: " + missingFirstVersions.size()));
            for (Path path : missingFirstVersions) {
                this.getLog().warn((CharSequence)("\t\t" + path.getFileName().toString()));
            }
        }
        this.getLog().info((CharSequence)"");
        this.getLog().info((CharSequence)"================================================================================");
    }

    private void printDataFormatsReport(Set<Path> json, Set<Path> duplicate, Map<String, Set<String>> usedLabels, Set<Path> missingFirstVersions) {
        this.getLog().info((CharSequence)"================================================================================");
        this.getLog().info((CharSequence)"");
        this.getLog().info((CharSequence)"Camel data format catalog report");
        this.getLog().info((CharSequence)"");
        this.getLog().info((CharSequence)("\tDataFormats found: " + json.size()));
        for (Path path : json) {
            this.getLog().info((CharSequence)("\t\t" + PrepareCatalogMojo.asComponentName(path)));
        }
        if (!duplicate.isEmpty()) {
            this.getLog().info((CharSequence)"");
            this.getLog().warn((CharSequence)("\tDuplicate dataformat detected: " + duplicate.size()));
            for (Path path : duplicate) {
                this.getLog().warn((CharSequence)("\t\t" + PrepareCatalogMojo.asComponentName(path)));
            }
        }
        if (!usedLabels.isEmpty()) {
            this.getLog().info((CharSequence)"");
            this.getLog().info((CharSequence)("\tUsed labels: " + usedLabels.size()));
            for (Map.Entry entry : usedLabels.entrySet()) {
                this.getLog().info((CharSequence)("\t\t" + (String)entry.getKey() + ":"));
                for (String name : (Set)entry.getValue()) {
                    this.getLog().info((CharSequence)("\t\t\t" + name));
                }
            }
        }
        if (!missingFirstVersions.isEmpty()) {
            this.getLog().info((CharSequence)"");
            this.getLog().warn((CharSequence)("\tDataFormats without firstVersion defined: " + missingFirstVersions.size()));
            for (Path path : missingFirstVersions) {
                this.getLog().warn((CharSequence)("\t\t" + path.getFileName().toString()));
            }
        }
        this.getLog().info((CharSequence)"");
        this.getLog().info((CharSequence)"================================================================================");
    }

    private void printLanguagesReport(Set<Path> json, Set<Path> duplicate, Map<String, Set<String>> usedLabels, Set<Path> missingFirstVersions) {
        this.getLog().info((CharSequence)"================================================================================");
        this.getLog().info((CharSequence)"");
        this.getLog().info((CharSequence)"Camel language catalog report");
        this.getLog().info((CharSequence)"");
        this.getLog().info((CharSequence)("\tLanguages found: " + json.size()));
        for (Path path : json) {
            this.getLog().info((CharSequence)("\t\t" + PrepareCatalogMojo.asComponentName(path)));
        }
        if (!duplicate.isEmpty()) {
            this.getLog().info((CharSequence)"");
            this.getLog().warn((CharSequence)("\tDuplicate language detected: " + duplicate.size()));
            for (Path path : duplicate) {
                this.getLog().warn((CharSequence)("\t\t" + PrepareCatalogMojo.asComponentName(path)));
            }
        }
        if (!usedLabels.isEmpty()) {
            this.getLog().info((CharSequence)"");
            this.getLog().info((CharSequence)("\tUsed labels: " + usedLabels.size()));
            for (Map.Entry entry : usedLabels.entrySet()) {
                this.getLog().info((CharSequence)("\t\t" + (String)entry.getKey() + ":"));
                for (String name : (Set)entry.getValue()) {
                    this.getLog().info((CharSequence)("\t\t\t" + name));
                }
            }
        }
        if (!missingFirstVersions.isEmpty()) {
            this.getLog().info((CharSequence)"");
            this.getLog().warn((CharSequence)("\tLanguages without firstVersion defined: " + missingFirstVersions.size()));
            for (Path path : missingFirstVersions) {
                this.getLog().warn((CharSequence)("\t\t" + path.getFileName().toString()));
            }
        }
        this.getLog().info((CharSequence)"");
        this.getLog().info((CharSequence)"================================================================================");
    }

    private void printOthersReport(Set<Path> json, Set<Path> duplicate, Map<String, Set<String>> usedLabels, Set<Path> missingFirstVersions) {
        this.getLog().info((CharSequence)"================================================================================");
        this.getLog().info((CharSequence)"");
        this.getLog().info((CharSequence)"Camel other catalog report");
        this.getLog().info((CharSequence)"");
        this.getLog().info((CharSequence)("\tOthers found: " + json.size()));
        for (Path path : json) {
            this.getLog().info((CharSequence)("\t\t" + PrepareCatalogMojo.asComponentName(path)));
        }
        if (!duplicate.isEmpty()) {
            this.getLog().info((CharSequence)"");
            this.getLog().warn((CharSequence)("\tDuplicate other detected: " + duplicate.size()));
            for (Path path : duplicate) {
                this.getLog().warn((CharSequence)("\t\t" + PrepareCatalogMojo.asComponentName(path)));
            }
        }
        if (!usedLabels.isEmpty()) {
            this.getLog().info((CharSequence)"");
            this.getLog().info((CharSequence)("\tUsed labels: " + usedLabels.size()));
            for (Map.Entry entry : usedLabels.entrySet()) {
                this.getLog().info((CharSequence)("\t\t" + (String)entry.getKey() + ":"));
                for (String name : (Set)entry.getValue()) {
                    this.getLog().info((CharSequence)("\t\t\t" + name));
                }
            }
        }
        if (!missingFirstVersions.isEmpty()) {
            this.getLog().info((CharSequence)"");
            this.getLog().warn((CharSequence)("\tOthers without firstVersion defined: " + missingFirstVersions.size()));
            for (Path path : missingFirstVersions) {
                this.getLog().warn((CharSequence)("\t\t" + path.getFileName().toString()));
            }
        }
        this.getLog().info((CharSequence)"");
        this.getLog().info((CharSequence)"================================================================================");
    }

    private void printDocumentsReport(Set<Path> docs, Set<Path> duplicate, Set<Path> missing) {
        this.getLog().info((CharSequence)"================================================================================");
        this.getLog().info((CharSequence)"");
        this.getLog().info((CharSequence)"Camel document catalog report");
        this.getLog().info((CharSequence)"");
        this.getLog().info((CharSequence)("\tDocuments found: " + docs.size()));
        for (Path file : docs) {
            this.getLog().info((CharSequence)("\t\t" + PrepareCatalogMojo.asComponentName(file)));
        }
        if (!duplicate.isEmpty()) {
            this.getLog().info((CharSequence)"");
            this.getLog().warn((CharSequence)("\tDuplicate document detected: " + duplicate.size()));
            for (Path file : duplicate) {
                this.getLog().warn((CharSequence)("\t\t" + PrepareCatalogMojo.asComponentName(file)));
            }
        }
        this.getLog().info((CharSequence)"");
        if (!missing.isEmpty()) {
            this.getLog().info((CharSequence)"");
            this.getLog().warn((CharSequence)("\tMissing document detected: " + missing.size()));
            for (Path name : missing) {
                this.getLog().warn((CharSequence)("\t\t" + name.getFileName().toString()));
            }
        }
        this.getLog().info((CharSequence)"");
        this.getLog().info((CharSequence)"================================================================================");
    }

    private void copyFile(Path file, Path toDir) throws IOException, MojoFailureException {
        if (Files.isRegularFile(file, new LinkOption[0])) {
            Files.createDirectories(toDir, new FileAttribute[0]);
            Path to = toDir.resolve(file.getFileName());
            try {
                FileUtil.updateFile((Path)file, (Path)to);
            }
            catch (IOException e) {
                throw new MojoFailureException("Cannot copy file from " + file + " -> " + to, (Throwable)e);
            }
        }
    }

    private List<Path> concat(List<Path> l1, List<Path> l2) {
        return Stream.concat(l1.stream(), l2.stream()).collect(Collectors.toList());
    }

    private Stream<Path> list(Path dir) {
        try {
            if (Files.isDirectory(dir, new LinkOption[0])) {
                return Files.list(dir);
            }
            return Stream.empty();
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to list files in directory: " + dir, e);
        }
    }

    private void delete(Path dir) {
        try {
            Files.delete(dir);
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to delete file: " + dir, e);
        }
    }

    private void copy(Path file, Path to) {
        try {
            try {
                BasicFileAttributes af = Files.readAttributes(file, BasicFileAttributes.class, new LinkOption[0]);
                BasicFileAttributes at = Files.readAttributes(to, BasicFileAttributes.class, new LinkOption[0]);
                if (af.isRegularFile() && at.isRegularFile() && af.size() == at.size() && af.lastModifiedTime().compareTo(at.lastAccessTime()) < 0) {
                    return;
                }
            }
            catch (IOException af) {
                // empty catch block
            }
            FileUtil.updateFile((Path)file, (Path)to);
        }
        catch (IOException e) {
            throw new RuntimeException("Cannot copy file from " + file + " -> " + to, e);
        }
    }

    private <U, K, V> Map<K, V> map(Collection<U> col, Function<U, K> key, Function<U, V> value) {
        return col.stream().collect(Collectors.toMap(key, value));
    }

    private <U, K, V> Map<K, V> map(Collection<U> col, Function<U, K> key, Function<U, V> value, BinaryOperator<V> merger) {
        return col.stream().collect(Collectors.toMap(key, value, merger));
    }

    private Path getModule(Path p) {
        Path parent = p;
        while (!parent.endsWith("target")) {
            parent = parent.getParent();
        }
        return parent.getParent();
    }

    private Set<Path> getDuplicates(Set<Path> jsonFiles) {
        Map<String, List> byName = this.map(jsonFiles, PrepareCatalogMojo::asComponentName, Collections::singletonList, this::concat);
        return byName.values().stream().flatMap(l -> l.stream().skip(1L)).collect(Collectors.toCollection(TreeSet::new));
    }

    private List<Path> getComponentPath(Path dir) {
        switch (dir.getFileName().toString()) {
            case "camel-as2": {
                return Collections.singletonList(dir.resolve("camel-as2-component"));
            }
            case "camel-salesforce": {
                return Collections.singletonList(dir.resolve("camel-salesforce-component"));
            }
            case "camel-olingo2": {
                return Collections.singletonList(dir.resolve("camel-olingo2-component"));
            }
            case "camel-olingo4": {
                return Collections.singletonList(dir.resolve("camel-olingo4-component"));
            }
            case "camel-box": {
                return Collections.singletonList(dir.resolve("camel-box-component"));
            }
            case "camel-servicenow": {
                return Collections.singletonList(dir.resolve("camel-servicenow-component"));
            }
            case "camel-fhir": {
                return Collections.singletonList(dir.resolve("camel-fhir-component"));
            }
            case "camel-vertx-kafka": {
                return Collections.singletonList(dir.resolve("camel-vertx-kafka-component"));
            }
            case "camel-infinispan": {
                return Arrays.asList(dir.resolve("camel-infinispan"), dir.resolve("camel-infinispan-embedded"));
            }
        }
        return Collections.singletonList(dir);
    }
}

