/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.maven.packaging;

import java.io.IOException;
import java.io.Writer;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.camel.tooling.model.BaseOptionModel;
import org.apache.camel.tooling.model.ComponentModel;

public final class PropertyConfigurerGenerator {
    private PropertyConfigurerGenerator() {
    }

    public static void generatePropertyConfigurer(String pn, String cn, String en, String pfqn, String psn, boolean hasSuper, boolean component, boolean extended, boolean bootstrap, Collection<? extends BaseOptionModel> options, ComponentModel model, Writer w) throws IOException {
        w.write("/* Generated by camel build tools - do NOT edit this file! */\n");
        w.write("package " + pn + ";\n");
        w.write("\n");
        w.write("import java.util.Map;\n");
        w.write("\n");
        w.write("import org.apache.camel.CamelContext;\n");
        w.write("import org.apache.camel.spi.ExtendedPropertyConfigurerGetter;\n");
        w.write("import org.apache.camel.spi.PropertyConfigurerGetter;\n");
        w.write("import org.apache.camel.spi.ConfigurerStrategy;\n");
        w.write("import org.apache.camel.spi.GeneratedPropertyConfigurer;\n");
        w.write("import org.apache.camel.util.CaseInsensitiveMap;\n");
        w.write("import " + pfqn + ";\n");
        w.write("\n");
        w.write("/**\n");
        w.write(" * Generated by camel build tools - do NOT edit this file!\n");
        w.write(" */\n");
        w.write("@SuppressWarnings(\"unchecked\")\n");
        w.write("public class " + cn + " extends " + psn + " implements GeneratedPropertyConfigurer");
        if (extended) {
            w.write(", ExtendedPropertyConfigurerGetter");
        } else {
            w.write(", PropertyConfigurerGetter");
        }
        w.write(" {\n");
        w.write("\n");
        if (!options.isEmpty()) {
            options = options.stream().sorted(Comparator.comparing(BaseOptionModel::getName)).collect(Collectors.toList());
        }
        if (extended && (model != null || !hasSuper)) {
            w.write("    private static final Map<String, Object> ALL_OPTIONS;\n");
            if (model != null) {
                w.write(PropertyConfigurerGenerator.generateAllOptions(cn, bootstrap, component, model));
            } else {
                w.write(PropertyConfigurerGenerator.generateAllOptions(cn, bootstrap, options));
            }
            w.write("\n");
        }
        if (!options.isEmpty() || !hasSuper) {
            String type;
            String getOrSet;
            if (component) {
                for (BaseOptionModel bo : PropertyConfigurerGenerator.findConfigurations(options)) {
                    w.write(PropertyConfigurerGenerator.createGetOrCreateConfiguration(en, bo.getConfigurationClass(), bo.getConfigurationField()));
                    w.write("\n");
                }
            }
            w.write("    @Override\n");
            w.write("    public boolean configure(CamelContext camelContext, Object obj, String name, Object value, boolean ignoreCase) {\n");
            if (!options.isEmpty()) {
                w.write("        " + en + " target = (" + en + ") obj;\n");
                w.write("        switch (ignoreCase ? name.toLowerCase() : name) {\n");
                for (BaseOptionModel option : options) {
                    getOrSet = option.getName();
                    getOrSet = Character.toUpperCase(getOrSet.charAt(0)) + getOrSet.substring(1);
                    String setterLambda = PropertyConfigurerGenerator.setterLambda(getOrSet, option.getJavaType(), option.getSetterMethod(), option.getConfigurationField(), component, option.getType());
                    if (!option.getName().toLowerCase().equals(option.getName())) {
                        w.write(String.format("        case \"%s\":\n", option.getName().toLowerCase()));
                    }
                    w.write(String.format("        case \"%s\": %s; return true;\n", option.getName(), setterLambda));
                }
                if (hasSuper) {
                    w.write("        default: return super.configure(camelContext, obj, name, value, ignoreCase);\n");
                } else {
                    w.write("        default: return false;\n");
                }
                w.write("        }\n");
            }
            w.write("    }\n");
            if (extended) {
                w.write("\n");
                w.write("    @Override\n");
                w.write("    public Map<String, Object> getAllOptions(Object target) {\n");
                if (model != null || !hasSuper) {
                    w.write("        return ALL_OPTIONS;\n");
                    w.write("    }\n");
                } else {
                    w.write("        Map<String, Object> answer = super.getAllOptions(target);\n");
                    if (!options.isEmpty()) {
                        for (BaseOptionModel option : options) {
                            type = option.getJavaType();
                            if (type.indexOf(60) != -1) {
                                type = type.substring(0, type.indexOf(60));
                            }
                            type = type.replace('$', '.');
                            w.write(String.format("        answer.put(\"%s\", %s.class);\n", option.getName(), type));
                        }
                        w.write("        return answer;\n");
                        w.write("    }\n");
                    }
                }
            }
            if (bootstrap && extended) {
                w.write("\n");
                w.write("    public static void clearBootstrapConfigurers() {\n");
                w.write("        ALL_OPTIONS.clear();\n");
                w.write("    }\n");
            }
            if (options.stream().anyMatch(BaseOptionModel::isAutowired)) {
                w.write("\n");
                w.write("    @Override\n");
                w.write("    public String[] getAutowiredNames() {\n");
                Iterator names = options.stream().filter(BaseOptionModel::isAutowired).map(BaseOptionModel::getName).map(PropertyConfigurerGenerator::quote).collect(Collectors.joining(","));
                w.write("        return new String[]{");
                w.write((String)((Object)names));
                w.write("};\n");
                w.write("    }\n");
            }
            w.write("\n");
            w.write("    @Override\n");
            w.write("    public Class<?> getOptionType(String name, boolean ignoreCase) {\n");
            if (!options.isEmpty()) {
                w.write("        switch (ignoreCase ? name.toLowerCase() : name) {\n");
                for (BaseOptionModel option : options) {
                    type = option.getJavaType();
                    if (type.indexOf(60) != -1) {
                        type = type.substring(0, type.indexOf(60));
                    }
                    type = type.replace('$', '.');
                    if (!option.getName().toLowerCase().equals(option.getName())) {
                        w.write(String.format("        case \"%s\":\n", option.getName().toLowerCase()));
                    }
                    w.write(String.format("        case \"%s\": return %s.class;\n", option.getName(), type));
                }
                if (hasSuper) {
                    w.write("        default: return super.getOptionType(name, ignoreCase);\n");
                } else {
                    w.write("        default: return null;\n");
                }
                w.write("        }\n");
            }
            w.write("    }\n");
            w.write("\n");
            w.write("    @Override\n");
            w.write("    public Object getOptionValue(Object obj, String name, boolean ignoreCase) {\n");
            if (!options.isEmpty()) {
                w.write("        " + en + " target = (" + en + ") obj;\n");
                w.write("        switch (ignoreCase ? name.toLowerCase() : name) {\n");
                for (BaseOptionModel option : options) {
                    getOrSet = option.getName();
                    getOrSet = Character.toUpperCase(getOrSet.charAt(0)) + getOrSet.substring(1);
                    String getterLambda = PropertyConfigurerGenerator.getterLambda(getOrSet, option.getJavaType(), option.getGetterMethod(), option.getConfigurationField(), component);
                    if (!option.getName().toLowerCase().equals(option.getName())) {
                        w.write(String.format("        case \"%s\":\n", option.getName().toLowerCase()));
                    }
                    w.write(String.format("        case \"%s\": return %s;\n", option.getName(), getterLambda));
                }
                if (hasSuper) {
                    w.write("        default: return super.getOptionValue(obj, name, ignoreCase);\n");
                } else {
                    w.write("        default: return null;\n");
                }
                w.write("        }\n");
            }
            w.write("    }\n");
            boolean hasNestedTypes = options.stream().map(BaseOptionModel::getNestedType).anyMatch(s -> s != null && !s.trim().isEmpty());
            if (hasNestedTypes) {
                w.write("\n");
                w.write("    @Override\n");
                w.write("    public Object getCollectionValueType(Object target, String name, boolean ignoreCase) {\n");
                if (!options.isEmpty()) {
                    w.write("        switch (ignoreCase ? name.toLowerCase() : name) {\n");
                    for (BaseOptionModel option : options) {
                        String nestedType = option.getNestedType();
                        if (nestedType == null || nestedType.isEmpty()) continue;
                        nestedType = nestedType.replace('$', '.');
                        if (!option.getName().toLowerCase().equals(option.getName())) {
                            w.write(String.format("        case \"%s\":\n", option.getName().toLowerCase()));
                        }
                        w.write(String.format("        case \"%s\": return %s.class;\n", option.getName(), nestedType));
                    }
                    if (hasSuper) {
                        w.write("        default: return super.getCollectionValueType(target, name, ignoreCase);\n");
                    } else {
                        w.write("        default: return null;\n");
                    }
                    w.write("        }\n");
                }
                w.write("    }\n");
            }
        }
        w.write("}\n");
        w.write("\n");
    }

    private static String generateAllOptions(String className, boolean bootstrap, boolean component, ComponentModel model) {
        StringBuilder sb = new StringBuilder();
        sb.append("    static {\n");
        sb.append("        Map<String, Object> map = new CaseInsensitiveMap();\n");
        if (component) {
            for (ComponentModel.ComponentOptionModel option : model.getComponentOptions()) {
                String type = option.getJavaType();
                if (type.indexOf(60) != -1) {
                    type = type.substring(0, type.indexOf(60));
                }
                type = type.replace('$', '.');
                sb.append(String.format("        map.put(\"%s\", %s.class);\n", option.getName(), type));
            }
        } else {
            for (ComponentModel.EndpointOptionModel option : model.getEndpointOptions()) {
                String type = option.getJavaType();
                if (type.indexOf(60) != -1) {
                    type = type.substring(0, type.indexOf(60));
                }
                type = type.replace('$', '.');
                sb.append(String.format("        map.put(\"%s\", %s.class);\n", option.getName(), type));
            }
        }
        sb.append("        ALL_OPTIONS = map;\n");
        if (bootstrap) {
            sb.append("        ConfigurerStrategy.addBootstrapConfigurerClearer(").append(className).append("::clearBootstrapConfigurers);\n");
        }
        sb.append("    }\n");
        return sb.toString();
    }

    private static String generateAllOptions(String className, boolean bootstrap, Collection<? extends BaseOptionModel> options) {
        StringBuilder sb = new StringBuilder();
        sb.append("    static {\n");
        sb.append("        Map<String, Object> map = new CaseInsensitiveMap();\n");
        for (BaseOptionModel baseOptionModel : options) {
            String type = baseOptionModel.getJavaType();
            if (type.indexOf(60) != -1) {
                type = type.substring(0, type.indexOf(60));
            }
            type = type.replace('$', '.');
            sb.append(String.format("        map.put(\"%s\", %s.class);\n", baseOptionModel.getName(), type));
        }
        sb.append("        ALL_OPTIONS = map;\n");
        if (bootstrap) {
            sb.append("        ConfigurerStrategy.addBootstrapConfigurerClearer(").append(className).append("::clearBootstrapConfigurers);\n");
        }
        sb.append("    }\n");
        return sb.toString();
    }

    private static Set<BaseOptionModel> findConfigurations(Collection<? extends BaseOptionModel> options) {
        LinkedHashSet<String> found = new LinkedHashSet<String>();
        LinkedHashSet<BaseOptionModel> answer = new LinkedHashSet<BaseOptionModel>();
        for (BaseOptionModel bo : options.stream().filter(o -> o.getConfigurationField() != null).collect(Collectors.toList())) {
            if (found.contains(bo.getConfigurationClass())) continue;
            found.add(bo.getConfigurationClass());
            answer.add(bo);
        }
        return answer;
    }

    private static String setterLambda(String getOrSet, String type, String setterMethod, String configurationField, boolean component, String optionKind) {
        if (type.indexOf(60) != -1) {
            type = type.substring(0, type.indexOf(60));
        }
        type = type.replace('$', '.');
        if (configurationField != null) {
            if (component) {
                String methodName = "getOrCreate" + Character.toUpperCase(configurationField.charAt(0)) + configurationField.substring(1);
                getOrSet = methodName + "(target).set" + getOrSet;
            } else {
                getOrSet = "target.get" + Character.toUpperCase(configurationField.charAt(0)) + configurationField.substring(1) + "().set" + getOrSet;
            }
        } else {
            getOrSet = "target.set" + getOrSet;
        }
        String rv = "duration".equals(optionKind) && "long".equals(type) ? "property(camelContext, java.time.Duration.class, value).toMillis()" : String.format("property(camelContext, %s.class, value)", type);
        String v = setterMethod != null ? String.format(setterMethod, rv) : rv;
        return String.format("%s(%s)", getOrSet, v);
    }

    private static String getterLambda(String getOrSet, String type, String getterMethod, String configurationField, boolean component) {
        String prefix;
        if (getterMethod == null || getterMethod.isEmpty()) {
            prefix = "boolean".equals(type) ? "is" : "get";
        } else {
            prefix = "";
            getOrSet = getterMethod;
        }
        if (configurationField != null) {
            if (component) {
                String methodName = "getOrCreate" + Character.toUpperCase(configurationField.charAt(0)) + configurationField.substring(1);
                getOrSet = methodName + "(target)." + prefix + getOrSet;
            } else {
                getOrSet = "target.get" + Character.toUpperCase(configurationField.charAt(0)) + configurationField.substring(1) + "()." + prefix + getOrSet;
            }
        } else {
            getOrSet = "target." + prefix + getOrSet;
        }
        return getOrSet + "()";
    }

    private static String createGetOrCreateConfiguration(String targetClass, String configurationClass, String configurationField) {
        String getter = "get" + Character.toUpperCase(configurationField.charAt(0)) + configurationField.substring(1);
        String setter = "set" + Character.toUpperCase(configurationField.charAt(0)) + configurationField.substring(1);
        String methodName = "getOrCreate" + Character.toUpperCase(configurationField.charAt(0)) + configurationField.substring(1);
        StringBuilder sb = new StringBuilder();
        String line1 = String.format("    private %s %s(%s target) {\n", configurationClass, methodName, targetClass);
        String line2 = String.format("        if (target.%s() == null) {\n", getter);
        String line3 = String.format("            target.%s(new %s());\n", setter, configurationClass);
        String line4 = String.format("        }\n", new Object[0]);
        String line5 = String.format("        return target.%s();\n", getter);
        String line6 = String.format("    }\n", new Object[0]);
        sb.append(line1).append(line2).append(line3).append(line4).append(line5).append(line6);
        return sb.toString();
    }

    private static String quote(String n) {
        return "\"" + n + "\"";
    }
}

