/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.maven.packaging;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.processing.Generated;
import org.apache.camel.maven.packaging.AbstractGeneratorMojo;
import org.apache.camel.maven.packaging.dsl.DslHelper;
import org.apache.camel.maven.packaging.generics.JavadocUtil;
import org.apache.camel.maven.packaging.generics.PackagePluginUtils;
import org.apache.camel.tooling.model.BaseModel;
import org.apache.camel.tooling.model.BaseOptionModel;
import org.apache.camel.tooling.model.ComponentModel;
import org.apache.camel.tooling.model.JsonMapper;
import org.apache.camel.tooling.util.JavadocHelper;
import org.apache.camel.tooling.util.PackageHelper;
import org.apache.camel.tooling.util.Strings;
import org.apache.camel.tooling.util.srcgen.Field;
import org.apache.camel.tooling.util.srcgen.GenericType;
import org.apache.camel.tooling.util.srcgen.JavaClass;
import org.apache.camel.tooling.util.srcgen.Method;
import org.apache.commons.text.CaseUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.codehaus.plexus.build.BuildContext;
import org.jboss.forge.roaster.Roaster;
import org.jboss.forge.roaster.model.Type;
import org.jboss.forge.roaster.model.source.JavaClassSource;
import org.jboss.forge.roaster.model.source.MethodSource;
import org.jboss.forge.roaster.model.source.ParameterSource;

@Mojo(name="generate-endpoint-dsl", threadSafe=true, requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME, defaultPhase=LifecyclePhase.PROCESS_CLASSES)
public class EndpointDslMojo
extends AbstractGeneratorMojo {
    private static final Pattern COMMA_PRESERVER_PATTERN = Pattern.compile(",(\\S)");
    @Parameter(defaultValue="${project.build.directory}")
    protected File buildDir;
    @Parameter(defaultValue="${project.basedir}")
    protected File baseDir;
    @Parameter(defaultValue="org.apache.camel.builder.endpoint")
    protected String endpointFactoriesPackageName;
    @Parameter(defaultValue="org.apache.camel.builder.endpoint.dsl")
    protected String componentsFactoriesPackageName;
    @Parameter
    protected File sourcesOutputDir;
    @Parameter
    protected File componentsMetadata;
    @Parameter
    protected File outputResourcesDir;
    @Parameter(defaultValue="${project.basedir}/../../catalog/camel-catalog/src/generated/resources/org/apache/camel/catalog/components")
    protected File jsonDir;
    private transient String licenseHeader;

    @Override
    public void execute(MavenProject project, MavenProjectHelper projectHelper, BuildContext buildContext) throws MojoFailureException, MojoExecutionException {
        this.buildDir = new File(project.getBuild().getDirectory());
        this.baseDir = project.getBasedir();
        this.endpointFactoriesPackageName = "org.apache.camel.builder.endpoint";
        this.componentsFactoriesPackageName = "org.apache.camel.builder.endpoint.dsl";
        super.execute(project, projectHelper, buildContext);
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        File camelDir = PackageHelper.findCamelDirectory((File)this.baseDir, (String)"dsl/camel-endpointdsl");
        if (camelDir == null) {
            this.getLog().debug((CharSequence)"No dsl/camel-endpointdsl folder found, skipping execution");
            return;
        }
        Path root = camelDir.toPath();
        if (this.sourcesOutputDir == null) {
            this.sourcesOutputDir = root.resolve("src/generated/java").toFile();
        }
        if (this.outputResourcesDir == null) {
            this.outputResourcesDir = root.resolve("src/generated/resources").toFile();
        }
        if (this.componentsMetadata == null) {
            this.componentsMetadata = this.outputResourcesDir.toPath().resolve("metadata.json").toFile();
        }
        ArrayList<ComponentModel> models = new ArrayList<ComponentModel>();
        for (File file : this.jsonDir.listFiles()) {
            BaseModel model = JsonMapper.generateModel((Path)file.toPath());
            models.add((ComponentModel)model);
        }
        this.executeComponent(models);
    }

    private void executeComponent(List<ComponentModel> allModels) throws MojoFailureException {
        if (!allModels.isEmpty()) {
            if (this.getLog().isDebugEnabled()) {
                this.getLog().debug((CharSequence)("Found " + allModels.size() + " components"));
            }
            Map<String, List<ComponentModel>> grModels = allModels.stream().collect(Collectors.groupingBy(BaseModel::getJavaType));
            try (InputStream is = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("license-header-java.txt");){
                this.licenseHeader = PackageHelper.loadText((InputStream)is);
            }
            catch (Exception e) {
                throw new MojoFailureException("Error loading license-header-java.txt file", (Throwable)e);
            }
            for (List<ComponentModel> compModels : grModels.values()) {
                if (compModels.size() > 1) {
                    compModels.sort((o1, o2) -> {
                        String s1 = o1.getScheme();
                        String s2 = o2.getScheme();
                        String as = o1.getAlternativeSchemes();
                        int i1 = as.indexOf(s1);
                        int i2 = as.indexOf(s2);
                        return Integer.compare(i1, i2);
                    });
                }
                ComponentModel model = compModels.get(0);
                this.createEndpointDsl(model, compModels);
            }
        }
    }

    private void createEndpointDsl(ComponentModel model, List<ComponentModel> aliases) throws MojoFailureException {
        ArrayList<Method> staticBuilders = new ArrayList<Method>();
        boolean updated = this.doCreateEndpointDsl(model, aliases, staticBuilders);
        this.getLog().debug((CharSequence)"Load components EndpointFactories");
        List<File> endpointFactories = this.loadAllComponentsDslEndpointFactoriesAsFile();
        this.getLog().debug((CharSequence)"Regenerate EndpointBuilderFactory");
        updated |= this.synchronizeEndpointBuilderFactoryInterface(endpointFactories);
        this.getLog().debug((CharSequence)"Regenerate EndpointBuilders");
        updated |= this.synchronizeEndpointBuildersInterface(endpointFactories);
        this.getLog().debug((CharSequence)"Regenerate StaticEndpointBuilders");
        if (updated |= this.synchronizeEndpointBuildersStaticClass(staticBuilders)) {
            this.getLog().info((CharSequence)("Updated EndpointDsl: " + model.getScheme()));
        }
    }

    private boolean doCreateEndpointDsl(ComponentModel model, List<ComponentModel> aliases, List<Method> staticBuilders) throws MojoFailureException {
        JavaClass headerNameBuilderClass;
        String componentClassName = model.getJavaType();
        String builderName = this.getEndpointName(componentClassName);
        JavaClass javaClass = this.createJavaClass(builderName);
        boolean hasAdvanced = this.hasAdvancedCheck(model);
        JavaClass consumerClass = null;
        JavaClass advancedConsumerClass = null;
        JavaClass producerClass = null;
        JavaClass advancedProducerClass = null;
        if (!model.isProducerOnly() && !model.isConsumerOnly()) {
            String consumerName = builderName.replace("Endpoint", "EndpointConsumer");
            consumerClass = javaClass.addNestedType().setPublic().setClass(false);
            consumerClass.setName(consumerName);
            consumerClass.implementInterface("EndpointConsumerBuilder");
            this.generateDummyClass(consumerClass.getCanonicalName());
            consumerClass.getJavaDoc().setText("Builder for endpoint consumers for the " + model.getTitle() + " component.");
            if (hasAdvanced) {
                advancedConsumerClass = javaClass.addNestedType().setPublic().setClass(false);
                advancedConsumerClass.setName("Advanced" + consumerName);
                advancedConsumerClass.implementInterface("EndpointConsumerBuilder");
                this.generateDummyClass(advancedConsumerClass.getCanonicalName());
                advancedConsumerClass.getJavaDoc().setText("Advanced builder for endpoint consumers for the " + model.getTitle() + " component.");
                consumerClass.addMethod().setName("advanced").setReturnType(this.loadClass(advancedConsumerClass.getCanonicalName())).setDefault().setBody("return (Advanced" + consumerName + ") this;");
                advancedConsumerClass.addMethod().setName("basic").setReturnType(this.loadClass(consumerClass.getCanonicalName())).setDefault().setBody("return (" + consumerName + ") this;");
            }
            String producerName = builderName.replace("Endpoint", "EndpointProducer");
            producerClass = javaClass.addNestedType().setPublic().setClass(false);
            producerClass.setName(producerName);
            producerClass.implementInterface("EndpointProducerBuilder");
            this.generateDummyClass(producerClass.getCanonicalName());
            producerClass.getJavaDoc().setText("Builder for endpoint producers for the " + model.getTitle() + " component.");
            if (hasAdvanced) {
                advancedProducerClass = javaClass.addNestedType().setPublic().setClass(false);
                advancedProducerClass.setName("Advanced" + producerName);
                advancedProducerClass.implementInterface("EndpointProducerBuilder");
                this.generateDummyClass(advancedProducerClass.getCanonicalName());
                advancedProducerClass.getJavaDoc().setText("Advanced builder for endpoint producers for the " + model.getTitle() + " component.");
                producerClass.addMethod().setName("advanced").setReturnType(this.loadClass(advancedProducerClass.getCanonicalName())).setDefault().setBody("return (Advanced" + producerName + ") this;");
                advancedProducerClass.addMethod().setName("basic").setReturnType(this.loadClass(producerClass.getCanonicalName())).setDefault().setBody("return (" + producerName + ") this;");
            }
        }
        JavaClass advancedBuilderClass = null;
        JavaClass builderClass = javaClass.addNestedType().setPublic().setClass(false);
        builderClass.setName(builderName);
        if (model.isProducerOnly()) {
            builderClass.implementInterface("EndpointProducerBuilder");
        } else if (model.isConsumerOnly()) {
            builderClass.implementInterface("EndpointConsumerBuilder");
        } else {
            builderClass.implementInterface(consumerClass.getName());
            builderClass.implementInterface(producerClass.getName());
        }
        this.generateDummyClass(builderClass.getCanonicalName());
        builderClass.getJavaDoc().setText("Builder for endpoint for the " + model.getTitle() + " component.");
        if (hasAdvanced) {
            advancedBuilderClass = javaClass.addNestedType().setPublic().setClass(false);
            advancedBuilderClass.setName("Advanced" + builderName);
            if (model.isProducerOnly()) {
                advancedBuilderClass.implementInterface("EndpointProducerBuilder");
            } else if (model.isConsumerOnly()) {
                advancedBuilderClass.implementInterface("EndpointConsumerBuilder");
            } else {
                advancedBuilderClass.implementInterface(advancedConsumerClass.getName());
                advancedBuilderClass.implementInterface(advancedProducerClass.getName());
            }
            this.generateDummyClass(advancedBuilderClass.getCanonicalName());
            advancedBuilderClass.getJavaDoc().setText("Advanced builder for endpoint for the " + model.getTitle() + " component.");
            builderClass.addMethod().setName("advanced").setReturnType(this.loadClass(advancedBuilderClass.getCanonicalName())).setDefault().setBody("return (Advanced" + builderName + ") this;");
            advancedBuilderClass.addMethod().setName("basic").setReturnType(this.loadClass(builderClass.getCanonicalName())).setDefault().setBody("return (" + builderName + ") this;");
        }
        this.generateDummyClass(this.componentsFactoriesPackageName + ".T");
        Object doc = "Generated by camel build tools - do NOT edit this file!";
        if (!Strings.isEmpty((String)model.getDescription())) {
            doc = model.getDescription() + "\n\n" + (String)doc;
        }
        javaClass.getJavaDoc().setText((String)doc);
        javaClass.addAnnotation(Generated.class).setStringValue("value", EndpointDslMojo.class.getName());
        this.processEndpoints(model, consumerClass, advancedConsumerClass, producerClass, advancedProducerClass, builderClass, advancedBuilderClass);
        javaClass.removeImport("T");
        JavaClass dslClass = javaClass.addNestedType();
        dslClass.setName(this.getComponentNameFromType(componentClassName) + "Builders");
        dslClass.setClass(false);
        Object adv = hasAdvanced ? ", Advanced" + builderName : "";
        Method method = javaClass.addMethod().setStatic().setName("endpointBuilder").addParameter(String.class, "componentName").addParameter(String.class, "path").setReturnType(new GenericType(this.loadClass(builderClass.getCanonicalName()))).setBody(new String[]{"class " + builderName + "Impl extends AbstractEndpointBuilder implements " + builderName + (String)adv + " {", "    public " + builderName + "Impl(String path) {", "        super(componentName, path);", "    }", "}", "return new " + builderName + "Impl(path);", ""});
        if (model.isDeprecated()) {
            method.addAnnotation(Deprecated.class);
        }
        if ((headerNameBuilderClass = this.addHeaderNameBuilderClass(javaClass, model)) != null) {
            this.addHeaderNameBuilderMethod(dslClass, headerNameBuilderClass, model);
        }
        if (aliases.size() == 1) {
            this.processAliases(model, staticBuilders, javaClass, builderClass, dslClass);
        } else {
            this.processMasterScheme(aliases, staticBuilders, javaClass, builderClass, dslClass);
        }
        return this.writeSourceIfChanged(javaClass, this.componentsFactoriesPackageName.replace('.', '/'), builderName + "Factory.java", false);
    }

    private JavaClass addHeaderNameBuilderClass(JavaClass javaClass, ComponentModel model) {
        List endpointHeaders = model.getEndpointHeaders();
        if (endpointHeaders.isEmpty()) {
            return null;
        }
        JavaClass builderClass = javaClass.addNestedType();
        builderClass.setName(this.getComponentNameFromType(model.getJavaType()) + "HeaderNameBuilder").setPublic().setStatic(true);
        builderClass.getJavaDoc().setText("The builder of headers' name for the " + model.getTitle() + " component.");
        this.generateDummyClass(builderClass.getCanonicalName());
        Field singleton = builderClass.addField();
        singleton.setPrivate().setStatic(true).setFinal(true).setName("INSTANCE").setType(this.loadClass(builderClass.getCanonicalName())).setLiteralInitializer(String.format("new %s()", builderClass.getName()));
        singleton.getJavaDoc().setText("The internal instance of the builder used to access to all the methods representing the name of headers.");
        for (ComponentModel.EndpointHeaderModel header : endpointHeaders) {
            this.addHeaderNameMethod(builderClass, header);
        }
        return builderClass;
    }

    private void addHeaderNameMethod(JavaClass builderClass, ComponentModel.EndpointHeaderModel header) {
        String headerName = header.getName();
        String camelPrefix = "camel";
        if (headerName.toLowerCase().startsWith("camel")) {
            headerName = headerName.substring("camel".length());
        }
        Object name = headerName.chars().anyMatch(c -> c == 58 || c == 45 || c == 46 || c == 95) ? CaseUtils.toCamelCase((String)headerName, (boolean)false, (char[])new char[]{':', '-', '.', '_'}) : headerName.substring(0, 1).toLowerCase() + headerName.substring(1);
        Method method = builderClass.addMethod().setPublic().setReturnType(String.class).setName((String)name);
        Object javaDoc = this.createBaseDescription((BaseOptionModel)header, "header", true).replace("@@REPLACE_ME@@", "\nThe option is a: {@code " + header.getJavaType() + "} type.");
        javaDoc = (String)javaDoc + String.format("%n%n@return the name of the header {@code %s}.%n", headerName);
        method.getJavaDoc().setText((String)javaDoc);
        method.setBodyF("return \"%s\";", new Object[]{headerName});
        if (header.isDeprecated()) {
            method.addAnnotation(Deprecated.class);
        }
    }

    private void addHeaderNameBuilderMethod(JavaClass dslClass, JavaClass builderClass, ComponentModel model) {
        Method method = dslClass.addMethod();
        method.setDefault().setReturnType(this.loadClass(builderClass.getCanonicalName())).setName(EndpointDslMojo.camelCaseLower(model.getScheme())).setBodyF("return %s.INSTANCE;", new Object[]{builderClass.getName()});
        Object javaDoc = JavadocUtil.getMainDescription(model, false);
        javaDoc = (String)javaDoc + "\n\n@return the dsl builder for the headers' name.\n";
        method.getJavaDoc().setText((String)javaDoc);
    }

    private void processMasterScheme(List<ComponentModel> aliases, List<Method> staticBuilders, JavaClass javaClass, JavaClass builderClass, JavaClass dslClass) {
        boolean firstAlias = true;
        for (ComponentModel componentModel : aliases) {
            String desc = JavadocUtil.getMainDescription(componentModel);
            String methodName = EndpointDslMojo.camelCaseLower(componentModel.getScheme());
            Method method = this.doAddMethod(javaClass, builderClass, dslClass, componentModel, methodName);
            Object javaDoc = desc;
            javaDoc = (String)javaDoc + "\n\n@param path " + JavadocUtil.pathParameterJavaDoc(componentModel);
            javaDoc = (String)javaDoc + "\n@return the dsl builder\n";
            method.getJavaDoc().setText((String)javaDoc);
            if (componentModel.isDeprecated()) {
                method.addAnnotation(Deprecated.class);
            }
            if (firstAlias) {
                method = method.copy();
                method.setPublic().setStatic();
                method.setReturnType(builderClass.getCanonicalName().replace('$', '.'));
                method.setBodyF("return %s.%s(%s);", new Object[]{javaClass.getCanonicalName(), "endpointBuilder", "\"" + componentModel.getScheme() + "\", path"});
                staticBuilders.add(method);
            }
            if (firstAlias) {
                method = dslClass.addMethod().setStatic().setName(methodName).addParameter(String.class, "componentName").addParameter(String.class, "path").setReturnType(new GenericType(this.loadClass(builderClass.getCanonicalName()))).setDefault().setBodyF("return %s.%s(%s);", new Object[]{javaClass.getName(), "endpointBuilder", "componentName, path"});
                javaDoc = desc;
                javaDoc = (String)javaDoc + "\n\n@param componentName to use a custom component name for the endpoint instead of the default name";
                javaDoc = (String)javaDoc + "\n@param path " + JavadocUtil.pathParameterJavaDoc(componentModel);
                javaDoc = (String)javaDoc + "\n@return the dsl builder\n";
                method.getJavaDoc().setText((String)javaDoc);
                if (componentModel.isDeprecated()) {
                    method.addAnnotation(Deprecated.class);
                }
            }
            if (firstAlias) {
                method = method.copy();
                method.setPublic().setStatic();
                method.setReturnType(builderClass.getCanonicalName().replace('$', '.'));
                method.setBodyF("return %s.%s(%s);", new Object[]{javaClass.getCanonicalName(), "endpointBuilder", "componentName, path"});
                staticBuilders.add(method);
            }
            firstAlias = false;
        }
    }

    private Method doAddMethod(JavaClass javaClass, JavaClass builderClass, JavaClass dslClass, ComponentModel componentModel, String methodName) {
        return dslClass.addMethod().setStatic().setName(methodName).addParameter(String.class, "path").setReturnType(new GenericType(this.loadClass(builderClass.getCanonicalName()))).setDefault().setBodyF("return %s.%s(%s);", new Object[]{javaClass.getName(), "endpointBuilder", "\"" + componentModel.getScheme() + "\", path"});
    }

    private void processAliases(ComponentModel model, List<Method> staticBuilders, JavaClass javaClass, JavaClass builderClass, JavaClass dslClass) {
        String desc = JavadocUtil.getMainDescription(model);
        String methodName = EndpointDslMojo.camelCaseLower(model.getScheme());
        Method method = this.doAddMethod(javaClass, builderClass, dslClass, model, methodName);
        Object javaDoc = desc;
        javaDoc = (String)javaDoc + "\n\n@param path " + JavadocUtil.pathParameterJavaDoc(model);
        javaDoc = (String)javaDoc + "\n@return the dsl builder\n";
        method.getJavaDoc().setText((String)javaDoc);
        if (model.isDeprecated()) {
            method.addAnnotation(Deprecated.class);
        }
        method = method.copy();
        method.setPublic().setStatic();
        method.setReturnType(builderClass.getCanonicalName().replace('$', '.'));
        method.setBodyF("return %s.%s(%s);", new Object[]{javaClass.getCanonicalName(), "endpointBuilder", "\"" + model.getScheme() + "\", path"});
        staticBuilders.add(method);
        method = dslClass.addMethod().setStatic().setName(methodName).addParameter(String.class, "componentName").addParameter(String.class, "path").setReturnType(new GenericType(this.loadClass(builderClass.getCanonicalName()))).setDefault().setBodyF("return %s.%s(%s);", new Object[]{javaClass.getName(), "endpointBuilder", "componentName, path"});
        javaDoc = desc;
        javaDoc = (String)javaDoc + "\n\n@param componentName to use a custom component name for the endpoint instead of the default name";
        javaDoc = (String)javaDoc + "\n@param path " + JavadocUtil.pathParameterJavaDoc(model);
        javaDoc = (String)javaDoc + "\n@return the dsl builder\n";
        method.getJavaDoc().setText((String)javaDoc);
        if (model.isDeprecated()) {
            method.addAnnotation(Deprecated.class);
        }
        method = method.copy();
        method.setPublic().setStatic();
        method.setReturnType(builderClass.getCanonicalName().replace('$', '.'));
        method.setBodyF("return %s.%s(%s);", new Object[]{javaClass.getCanonicalName(), "endpointBuilder", "componentName, path"});
        staticBuilders.add(method);
    }

    private void processEndpoints(ComponentModel model, JavaClass consumerClass, JavaClass advancedConsumerClass, JavaClass producerClass, JavaClass advancedProducerClass, JavaClass builderClass, JavaClass advancedBuilderClass) {
        for (ComponentModel.EndpointOptionModel option : model.getEndpointOptions()) {
            if ("path".equals(option.getKind())) continue;
            List<JavaClass> targets = this.evalTargetsToProcess(consumerClass, advancedConsumerClass, producerClass, advancedProducerClass, builderClass, advancedBuilderClass, option);
            for (JavaClass target : targets) {
                this.processTarget(option, target);
            }
        }
    }

    private void processTarget(ComponentModel.EndpointOptionModel option, JavaClass target) {
        if (target == null) {
            return;
        }
        String baseDesc = this.createBaseDescription((BaseOptionModel)option);
        boolean multiValued = option.isMultiValue();
        if (multiValued) {
            this.createMultivaluedDesc(option, target, baseDesc);
        } else {
            this.createRegularDesc(option, target, baseDesc);
        }
    }

    private void createRegularDesc(ComponentModel.EndpointOptionModel option, JavaClass target, String baseDesc) {
        String desc = baseDesc.replace("@@REPLACE_ME@@", "\nThe option is a: <code>" + option.getJavaType().replace("<", "&lt;").replace(">", "&gt;") + "</code> type.");
        desc = JavadocHelper.xmlEncode((String)desc);
        Method fluent = target.addMethod().setDefault().setName(option.getName()).setReturnType(new GenericType(this.loadClass(target.getCanonicalName()))).addParameter(EndpointDslMojo.optionJavaType(option), option.getName()).setBody(new String[]{"doSetProperty(\"" + option.getName() + "\", " + option.getName() + ");", "return this;\n"});
        if (option.isDeprecated()) {
            fluent.addAnnotation(Deprecated.class);
        }
        StringBuilder textBuilder = new StringBuilder(desc);
        textBuilder.append("\n\n@param ").append(option.getName()).append(" the value to set");
        textBuilder.append("\n@return the dsl builder\n");
        fluent.getJavaDoc().setText(textBuilder.toString());
        if (!"String".equals(EndpointDslMojo.optionJavaType(option))) {
            desc = baseDesc.replace("@@REPLACE_ME@@", "\nThe option will be converted to a <code>" + option.getJavaType().replace("<", "&lt;").replace(">", "&gt;") + "</code> type.");
            desc = JavadocHelper.xmlEncode((String)desc);
            fluent = target.addMethod().setDefault().setName(option.getName()).setReturnType(new GenericType(this.loadClass(target.getCanonicalName()))).addParameter(new GenericType(String.class), option.getName()).setBody(new String[]{"doSetProperty(\"" + option.getName() + "\", " + option.getName() + ");", "return this;\n"});
            if (option.isDeprecated()) {
                fluent.addAnnotation(Deprecated.class);
            }
            StringBuilder optionTextSb = new StringBuilder(desc);
            optionTextSb.append("\n\n@param ").append(option.getName()).append(" the value to set");
            optionTextSb.append("\n@return the dsl builder\n");
            fluent.getJavaDoc().setText(optionTextSb.toString());
        }
    }

    private void createMultivaluedDesc(ComponentModel.EndpointOptionModel option, JavaClass target, String baseDesc) {
        String desc = baseDesc.replace("@@REPLACE_ME@@", "\nThe option is a: <code>" + option.getJavaType().replace("<", "&lt;").replace(">", "&gt;") + "</code> type.");
        desc = JavadocHelper.xmlEncode((String)desc);
        Method fluent = target.addMethod().setDefault().setName(option.getName()).setReturnType(new GenericType(this.loadClass(target.getCanonicalName()))).addParameter(new GenericType(String.class), "key").addParameter(new GenericType(Object.class), "value").setBody(new String[]{"doSetMultiValueProperty(\"" + option.getName() + "\", \"" + option.getPrefix() + "\" + key, value);", "return this;\n"});
        if (option.isDeprecated()) {
            fluent.addAnnotation(Deprecated.class);
        }
        StringBuilder textBuilder = new StringBuilder(desc);
        textBuilder.append("\n\n@param key the option key");
        textBuilder.append("\n@param value the option value");
        textBuilder.append("\n@return the dsl builder\n");
        fluent.getJavaDoc().setText(textBuilder.toString());
        fluent = target.addMethod().setDefault().setName(option.getName()).setReturnType(new GenericType(this.loadClass(target.getCanonicalName()))).addParameter(new GenericType(Map.class), "values").setBody(new String[]{"doSetMultiValueProperties(\"" + option.getName() + "\", \"" + option.getPrefix() + "\", values);", "return this;\n"});
        if (option.isDeprecated()) {
            fluent.addAnnotation(Deprecated.class);
        }
        StringBuilder sb = new StringBuilder(desc);
        sb.append("\n\n@param values the values");
        sb.append("\n@return the dsl builder\n");
        fluent.getJavaDoc().setText(sb.toString());
    }

    private String createBaseDescription(BaseOptionModel option) {
        return this.createBaseDescription(option, "parameter", false);
    }

    private String createBaseDescription(BaseOptionModel option, String kind, boolean ignoreMultiValue) {
        String baseDesc = option.getDescription();
        if (Strings.isEmpty((String)baseDesc)) {
            return baseDesc;
        }
        baseDesc = JavadocHelper.xmlEncode((String)baseDesc);
        StringBuilder baseDescBuilder = new StringBuilder(baseDesc);
        if (!baseDesc.endsWith(".")) {
            baseDescBuilder.append(".");
        }
        if (option.isSupportFileReference()) {
            baseDescBuilder.append("\n");
            baseDescBuilder.append("\nThis option can also be loaded from an existing file, by prefixing with file: or classpath: followed by the location of the file.");
        }
        baseDescBuilder.append("\n@@REPLACE_ME@@");
        if (option.isMultiValue()) {
            baseDescBuilder.append("\nThe option is multivalued, and you can use the ").append(option.getName()).append("(String, Object) method to add a value (call the method multiple times to set more values).");
        }
        baseDescBuilder.append("\n");
        if (kind.equals(option.getKind()) && option.isRequired()) {
            baseDescBuilder.append("\nRequired: true");
        }
        if (option.getDefaultValue() != null) {
            String value = JavadocHelper.xmlEncode((String)option.getDefaultValue().toString());
            baseDescBuilder.append("\nDefault: ").append(value);
        }
        baseDescBuilder.append("\nGroup: ").append(option.getGroup());
        return baseDescBuilder.toString();
    }

    private List<JavaClass> evalTargetsToProcess(JavaClass consumerClass, JavaClass advancedConsumerClass, JavaClass producerClass, JavaClass advancedProducerClass, JavaClass builderClass, JavaClass advancedBuilderClass, ComponentModel.EndpointOptionModel option) {
        String label;
        ArrayList<JavaClass> targets = new ArrayList<JavaClass>();
        String string = label = option.getLabel() != null ? option.getLabel() : "";
        if (label != null) {
            if (label.contains("producer")) {
                if (label.contains("advanced")) {
                    targets.add(advancedProducerClass != null ? advancedProducerClass : advancedBuilderClass);
                } else {
                    targets.add(producerClass != null ? producerClass : builderClass);
                }
            } else if (label.contains("consumer")) {
                if (label.contains("advanced")) {
                    targets.add(advancedConsumerClass != null ? advancedConsumerClass : advancedBuilderClass);
                } else {
                    targets.add(consumerClass != null ? consumerClass : builderClass);
                }
            } else if (label.contains("advanced")) {
                targets.add(advancedConsumerClass);
                targets.add(advancedProducerClass);
                targets.add(advancedBuilderClass);
            } else {
                targets.add(consumerClass);
                targets.add(producerClass);
                targets.add(builderClass);
            }
        }
        return targets;
    }

    private boolean hasAdvancedCheck(ComponentModel model) {
        for (ComponentModel.EndpointOptionModel option : model.getEndpointOptions()) {
            if (option.getLabel() == null || !option.getLabel().contains("advanced")) continue;
            return true;
        }
        return false;
    }

    private JavaClass createJavaClass(String builderName) {
        JavaClass javaClass = new JavaClass((ClassLoader)this.getProjectClassLoader());
        javaClass.setPackage(this.componentsFactoriesPackageName);
        javaClass.setName(builderName + "Factory");
        javaClass.setClass(false);
        javaClass.addImport("java.util.*");
        javaClass.addImport("java.util.concurrent.*");
        javaClass.addImport("java.util.function.*");
        javaClass.addImport("java.util.stream.*");
        javaClass.addImport("org.apache.camel.builder.EndpointConsumerBuilder");
        javaClass.addImport("org.apache.camel.builder.EndpointProducerBuilder");
        javaClass.addImport("org.apache.camel.builder.endpoint.AbstractEndpointBuilder");
        return javaClass;
    }

    private static String optionJavaType(ComponentModel.EndpointOptionModel option) {
        String answer = option.getJavaType();
        if (answer.startsWith("java.lang.")) {
            return answer.substring(10);
        }
        if (answer.startsWith("java.util.concurrent.")) {
            return answer.substring(21);
        }
        if (answer.startsWith("java.util.function.")) {
            return answer.substring(19);
        }
        if (answer.startsWith("java.util.stream.")) {
            return answer.substring(17);
        }
        if (answer.startsWith("java.util.")) {
            return answer.substring(10);
        }
        return answer;
    }

    private boolean synchronizeEndpointBuilderFactoryInterface(List<File> factories) throws MojoFailureException {
        JavaClass javaClass = new JavaClass((ClassLoader)this.getProjectClassLoader());
        javaClass.setPackage(this.endpointFactoriesPackageName);
        javaClass.setName("EndpointBuilderFactory");
        javaClass.setClass(false);
        javaClass.setPublic();
        javaClass.getJavaDoc().setText("Generated by camel build tools - do NOT edit this file!");
        javaClass.addAnnotation(Generated.class).setStringValue("value", EndpointDslMojo.class.getName());
        javaClass.addImport("java.util.List");
        javaClass.addImport("java.util.stream.Collectors");
        javaClass.addImport("java.util.stream.Stream");
        javaClass.addMethod().setDefault().setReturnType("org.apache.camel.Expression").setName("endpoints").addParameter("org.apache.camel.builder.EndpointProducerBuilder", "endpoints", true).setBody(new String[]{"return new org.apache.camel.support.ExpressionAdapter() {", "", "    private List<org.apache.camel.Expression> expressions = null;", "", "    @Override", "    public Object evaluate(org.apache.camel.Exchange exchange) {", "        return expressions.stream().map(e -> e.evaluate(exchange, Object.class)).collect(Collectors.toList());", "    }", "", "    @Override", "    public void init(org.apache.camel.CamelContext context) {", "        super.init(context);", "        expressions = Stream.of(endpoints)", "                .map(epb -> epb.expr(context))", "                .collect(Collectors.toList());", "    }", "};"});
        for (File factory : factories) {
            String factoryName = Strings.before((String)factory.getName(), (String)".");
            String endpointsName = factoryName.replace("EndpointBuilderFactory", "Builders");
            javaClass.implementInterface(this.componentsFactoriesPackageName + "." + factoryName + "." + endpointsName);
        }
        return this.writeSourceIfChanged(javaClass.printClass(), this.endpointFactoriesPackageName.replace('.', '/'), "EndpointBuilderFactory.java");
    }

    private boolean synchronizeEndpointBuildersInterface(List<File> factories) throws MojoFailureException {
        JavaClass javaClass = new JavaClass((ClassLoader)this.getProjectClassLoader());
        javaClass.setPackage(this.endpointFactoriesPackageName);
        javaClass.setName("EndpointBuilders");
        javaClass.setClass(false);
        javaClass.setPublic();
        javaClass.getJavaDoc().setText("Generated by camel build tools - do NOT edit this file!");
        javaClass.addAnnotation(Generated.class).setStringValue("value", EndpointDslMojo.class.getName());
        for (File factory : factories) {
            javaClass.implementInterface(this.componentsFactoriesPackageName + "." + Strings.before((String)factory.getName(), (String)"."));
        }
        return this.writeSourceIfChanged(javaClass.printClass(), this.endpointFactoriesPackageName.replace(".", "/"), "EndpointBuilders.java");
    }

    private boolean synchronizeEndpointBuildersStaticClass(List<Method> methods) throws MojoFailureException {
        File file = new File(this.sourcesOutputDir.getPath() + "/" + this.endpointFactoriesPackageName.replace(".", "/"), "StaticEndpointBuilders.java");
        if (file.exists()) {
            try {
                String sourceCode = PackageHelper.loadText((File)file);
                JavaClassSource source = (JavaClassSource)Roaster.parse((String)sourceCode);
                for (MethodSource ms : source.getMethods()) {
                    boolean exist = methods.stream().anyMatch(m -> m.getName().equals(ms.getName()) && m.getParameters().size() == ms.getParameters().size());
                    if (exist) continue;
                    Method method = new Method();
                    if (ms.isStatic()) {
                        method.setStatic();
                    }
                    method.setPublic();
                    method.setName(ms.getName());
                    String body = ms.getBody();
                    body = COMMA_PRESERVER_PATTERN.matcher(body).replaceAll(", $1");
                    method.setBody(body);
                    method.setReturnType(EndpointDslMojo.getQualifiedType(ms.getReturnType()));
                    for (Object o : ms.getParameters()) {
                        if (!(o instanceof ParameterSource)) continue;
                        ParameterSource ps = (ParameterSource)o;
                        method.addParameter(EndpointDslMojo.getQualifiedType(ps.getType()), ps.getName());
                    }
                    String doc = JavadocUtil.extractJavaDoc(sourceCode, ms);
                    method.getJavaDoc().setFullText(doc);
                    if (ms.getAnnotation(Deprecated.class) != null) {
                        method.addAnnotation(Deprecated.class);
                    }
                    methods.add(method);
                }
            }
            catch (IOException e) {
                throw new MojoFailureException("Cannot parse existing java source file: " + file + " due to " + e.getMessage(), (Throwable)e);
            }
        }
        JavaClass javaClass = new JavaClass((ClassLoader)this.getProjectClassLoader());
        javaClass.setPackage(this.endpointFactoriesPackageName);
        javaClass.setName("StaticEndpointBuilders");
        javaClass.setClass(true);
        javaClass.setPublic();
        javaClass.getJavaDoc().setText("Generated by camel build tools - do NOT edit this file!");
        javaClass.addAnnotation(Generated.class).setStringValue("value", EndpointDslMojo.class.getName());
        methods.sort((m1, m2) -> m1.getName().compareToIgnoreCase(m2.getName()));
        for (Method method : methods) {
            javaClass.addMethod(method);
        }
        String printClass = javaClass.printClass();
        return this.writeSourceIfChanged(printClass, this.endpointFactoriesPackageName.replace(".", "/"), "StaticEndpointBuilders.java");
    }

    private static String getQualifiedType(Type<?> type) {
        String val = type.getQualifiedName();
        if (val.startsWith("java.lang.")) {
            val = val.substring(10);
        }
        return val;
    }

    @Deprecated
    protected static String extractJavaDoc(String sourceCode, MethodSource<?> ms) throws IOException {
        return JavadocUtil.extractJavaDoc(sourceCode, ms);
    }

    private List<File> loadAllComponentsDslEndpointFactoriesAsFile() {
        FileFilter fileFilter;
        File allComponentsDslEndpointFactory = new File(this.sourcesOutputDir, this.componentsFactoriesPackageName.replace('.', '/'));
        File[] files = allComponentsDslEndpointFactory.listFiles(fileFilter = file -> file.isFile() && file.getName().endsWith(".java"));
        if (files == null) {
            return Collections.emptyList();
        }
        return Arrays.stream(files).sorted().toList();
    }

    private static String camelCaseLower(String s) {
        int i;
        while (s != null && (i = ((String)s).indexOf(45)) > 0) {
            s = EndpointDslMojo.camelCaseAtIndex((String)s, i);
        }
        while (s != null && (i = ((String)s).indexOf(43)) > 0) {
            s = EndpointDslMojo.camelCaseAtIndex((String)s, i);
        }
        if (s != null) {
            s = ((String)s).substring(0, 1).toLowerCase() + ((String)s).substring(1);
            s = DslHelper.sanitizeText((String)s);
        }
        return s;
    }

    private static String camelCaseAtIndex(String s, int i) {
        return s.substring(0, i) + Strings.capitalize((String)s.substring(i + 1));
    }

    private String getComponentNameFromType(String type) {
        int pos = type.lastIndexOf(46);
        String name = type.substring(pos + 1).replace("Component", "");
        switch (type) {
            case "org.apache.camel.component.atmosphere.websocket.WebsocketComponent": {
                return "AtmosphereWebsocket";
            }
            case "org.apache.camel.component.zookeepermaster.MasterComponent": {
                return "ZooKeeperMaster";
            }
            case "org.apache.camel.component.jetty9.JettyHttpComponent9": {
                return "JettyHttp";
            }
            case "org.apache.camel.component.elasticsearch.ElasticsearchComponent": {
                return "ElasticsearchRest";
            }
        }
        return name;
    }

    private String getEndpointName(String type) {
        return this.getComponentNameFromType(type) + "EndpointBuilder";
    }

    private Class<?> generateDummyClass(String clazzName) {
        return this.getProjectClassLoader().generateDummyClass(clazzName);
    }

    private boolean writeSourceIfChanged(JavaClass source, String filePath, String fileName, boolean innerClassesLast) throws MojoFailureException {
        return this.writeSourceIfChanged(source.printClass(innerClassesLast), filePath, fileName);
    }

    private boolean writeSourceIfChanged(String source, String filePath, String fileName) throws MojoFailureException {
        try {
            String code = PackagePluginUtils.joinHeaderAndSource(this.licenseHeader, source);
            if (this.getLog().isDebugEnabled()) {
                this.getLog().debug((CharSequence)("Source code generated:\n" + code));
            }
            return this.updateResource(this.sourcesOutputDir.toPath(), filePath + "/" + fileName, code);
        }
        catch (Exception e) {
            throw new MojoFailureException("IOError with file " + filePath + "/" + fileName, (Throwable)e);
        }
    }
}

