/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.maven.packaging;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.camel.maven.packaging.AbstractGeneratorMojo;
import org.apache.camel.maven.packaging.SupportLevelHelper;
import org.apache.camel.maven.packaging.generics.ClassUtil;
import org.apache.camel.tooling.model.BaseOptionModel;
import org.apache.camel.tooling.model.EipModel;
import org.apache.camel.tooling.model.JsonMapper;
import org.apache.camel.tooling.model.LanguageModel;
import org.apache.camel.tooling.model.SupportLevel;
import org.apache.camel.tooling.util.PackageHelper;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.codehaus.plexus.build.BuildContext;

@Mojo(name="generate-languages-list", threadSafe=true)
public class PackageLanguageMojo
extends AbstractGeneratorMojo {
    @Parameter(defaultValue="${project.basedir}/src/generated/resources")
    protected File languageOutDir;
    @Parameter(defaultValue="${project.basedir}/src/generated/resources")
    protected File schemaOutDir;
    @Parameter(defaultValue="${project.build.directory}")
    protected File buildDir;

    public PackageLanguageMojo() {
    }

    public PackageLanguageMojo(Log log, MavenProject project, MavenProjectHelper projectHelper, File buildDir, File languageOutDir, File schemaOutDir, BuildContext buildContext) {
        this.setLog(log);
        this.project = project;
        this.projectHelper = projectHelper;
        this.buildDir = buildDir;
        this.languageOutDir = languageOutDir;
        this.schemaOutDir = schemaOutDir;
        this.buildContext = buildContext;
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.prepareLanguage();
    }

    public int prepareLanguage() throws MojoExecutionException {
        int count;
        StringBuilder buffer;
        File camelMetaDir;
        Log log;
        block13: {
            Object javaType;
            File[] files;
            log = this.getLog();
            camelMetaDir = new File(this.languageOutDir, "META-INF/services/org/apache/camel/");
            if (this.projectHelper != null) {
                this.projectHelper.addResource(this.project, this.languageOutDir.getPath(), Collections.singletonList("**/language.properties"), Collections.emptyList());
            }
            if (!PackageLanguageMojo.haveResourcesChanged(log, this.project, this.buildContext, "META-INF/services/org/apache/camel/language")) {
                return 0;
            }
            HashMap<String, String> javaTypes = new HashMap<String, String>();
            buffer = new StringBuilder();
            count = 0;
            File f = new File(this.project.getBasedir(), "target/classes");
            if ((f = new File(f, "META-INF/services/org/apache/camel/language")).exists() && f.isDirectory() && (files = f.listFiles()) != null) {
                for (File file : files) {
                    javaType = PackageLanguageMojo.readClassFromCamelResource(file, buffer, this.buildContext);
                    if (!file.isDirectory() && file.getName().charAt(0) != '.') {
                        ++count;
                    }
                    if (javaType == null) continue;
                    javaTypes.put(file.getName(), (String)javaType);
                }
            }
            boolean apacheCamel = "org.apache.camel".equals(this.project.getGroupId());
            try {
                if (!apacheCamel || count <= 0) break block13;
                File core = PackageHelper.findCamelCoreModelDirectory((File)this.project.getBasedir());
                if (core != null) {
                    for (Map.Entry entry : javaTypes.entrySet()) {
                        String name = (String)entry.getKey();
                        javaType = this.loadClass((String)entry.getValue());
                        String modelName = PackageLanguageMojo.asModelName(name);
                        String json = PackageHelper.loadText((File)new File(core, "src/generated/resources/org/apache/camel/model/language/" + modelName + ".json"));
                        LanguageModel languageModel = PackageLanguageMojo.extractLanguageModel(this.project, json, name, javaType);
                        if (log.isDebugEnabled()) {
                            log.debug((CharSequence)("Model: " + languageModel));
                        }
                        String schema = JsonMapper.createParameterJsonSchema((LanguageModel)languageModel);
                        if (log.isDebugEnabled()) {
                            log.debug((CharSequence)("JSON schema\n" + schema));
                        }
                        Path out = this.schemaOutDir.toPath().resolve(PackageLanguageMojo.schemaSubDirectory(languageModel.getJavaType())).resolve(name + ".json");
                        this.updateResource(this.schemaOutDir.toPath(), PackageLanguageMojo.schemaSubDirectory(languageModel.getJavaType()) + "/" + name + ".json", schema);
                        if (!log.isDebugEnabled()) continue;
                        log.debug((CharSequence)("Generated " + out + " containing JSON schema for " + name + " language"));
                    }
                    break block13;
                }
                throw new MojoExecutionException("Error finding core/camel-core/target/camel-core-model-" + this.project.getVersion() + ".jar file. Make sure camel-core has been built first.");
            }
            catch (Exception e) {
                throw new MojoExecutionException("Error loading language model from camel-core. Reason: " + e, e);
            }
        }
        if (count > 0) {
            String names = Stream.of(buffer.toString().split(" ")).sorted().collect(Collectors.joining(" "));
            String properties = PackageLanguageMojo.createProperties(this.project, "languages", names);
            this.updateResource(camelMetaDir.toPath(), "language.properties", properties);
            log.info((CharSequence)("Generated language.properties containing " + count + " Camel " + (count > 1 ? "languages: " : "language: ") + names));
        } else {
            log.debug((CharSequence)"No META-INF/services/org/apache/camel/language directory found. Are you sure you have created a Camel language?");
        }
        return count;
    }

    protected static LanguageModel extractLanguageModel(MavenProject project, String json, String name, Class<?> javaType) {
        EipModel def = JsonMapper.generateEipModel((String)json);
        LanguageModel model = new LanguageModel();
        model.setName(name);
        model.setTitle(PackageLanguageMojo.asTitle(name, def.getTitle()));
        model.setDescription(PackageLanguageMojo.asDescription(name, def.getDescription()));
        model.setFirstVersion(def.getFirstVersion());
        model.setLabel(def.getLabel());
        model.setDeprecated(def.isDeprecated());
        model.setDeprecationNote(def.getDeprecationNote());
        model.setDeprecatedSince(project.getProperties().getProperty("deprecatedSince"));
        model.setJavaType(javaType.getCanonicalName());
        model.setModelName(def.getName());
        model.setModelJavaType(def.getJavaType());
        model.setGroupId(project.getGroupId());
        model.setArtifactId(project.getArtifactId());
        model.setVersion(project.getVersion());
        String level = project.getProperties().getProperty("supportLevel");
        boolean experimental = ClassUtil.hasAnnotation("org.apache.camel.Experimental", javaType);
        if (experimental) {
            model.setSupportLevel(SupportLevel.Experimental);
        } else if (level != null) {
            model.setSupportLevel(SupportLevel.safeValueOf((String)level));
        } else {
            model.setSupportLevel(SupportLevelHelper.defaultSupportLevel(model.getFirstVersion(), model.getVersion()));
        }
        for (EipModel.EipOptionModel opt : def.getOptions()) {
            LanguageModel.LanguageOptionModel option = new LanguageModel.LanguageOptionModel();
            option.setName(opt.getName());
            option.setKind(opt.getKind());
            option.setDisplayName(opt.getDisplayName());
            option.setGroup(opt.getGroup());
            option.setLabel(opt.getLabel());
            option.setRequired(opt.isRequired());
            option.setType(opt.getType());
            option.setJavaType(opt.getJavaType());
            option.setEnums(opt.getEnums());
            option.setOneOfs(opt.getOneOfs());
            option.setPrefix(opt.getPrefix());
            option.setOptionalPrefix(opt.getOptionalPrefix());
            option.setMultiValue(opt.isMultiValue());
            option.setDeprecated(opt.isDeprecated());
            option.setDeprecationNote(opt.getDeprecationNote());
            option.setSecret(opt.isSecret());
            option.setDefaultValue(opt.getDefaultValue());
            option.setDefaultValueNote(opt.getDefaultValueNote());
            option.setAsPredicate(opt.isAsPredicate());
            option.setConfigurationClass(opt.getConfigurationClass());
            option.setConfigurationField(opt.getConfigurationField());
            option.setDescription(opt.getDescription());
            model.addOption((BaseOptionModel)option);
        }
        return model;
    }

    private static String readClassFromCamelResource(File file, StringBuilder buffer, BuildContext buildContext) throws MojoExecutionException {
        if (file.isDirectory()) {
            return null;
        }
        String name = file.getName();
        if (name.charAt(0) != '.') {
            if (!buffer.isEmpty()) {
                buffer.append(" ");
            }
            buffer.append(name);
        }
        if (!buildContext.hasDelta(file)) {
            return null;
        }
        try {
            String text = PackageHelper.loadText((File)file);
            Map map = PackageHelper.parseAsMap((String)text);
            return (String)map.get("class");
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to read file " + file + ". Reason: " + e, (Exception)e);
        }
    }

    private static String asModelName(String name) {
        if ("bean".equals(name)) {
            return "method";
        }
        if ("file".equals(name)) {
            return "simple";
        }
        return name;
    }

    private static String asTitle(String name, String title) {
        if ("file".equals(name)) {
            return "File";
        }
        return title;
    }

    private static String asDescription(String name, String description) {
        if ("file".equals(name)) {
            return "File related capabilities for the Simple language";
        }
        return description;
    }

    private static String schemaSubDirectory(String javaType) {
        int idx = javaType.lastIndexOf(46);
        String pckName = javaType.substring(0, idx);
        return pckName.replace('.', '/');
    }
}

