/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.maven.packaging;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.stream.Collectors;
import org.apache.camel.maven.packaging.AbstractGeneratorMojo;
import org.apache.camel.maven.packaging.MvelHelper;
import org.apache.camel.maven.packaging.UpdateReadmeMojo;
import org.apache.camel.tooling.model.JsonMapper;
import org.apache.camel.tooling.model.MainModel;
import org.apache.camel.tooling.util.PackageHelper;
import org.apache.camel.tooling.util.Strings;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.codehaus.plexus.build.BuildContext;
import org.mvel2.templates.TemplateRuntime;

@Mojo(name="prepare-main", defaultPhase=LifecyclePhase.PROCESS_CLASSES, threadSafe=true, requiresDependencyResolution=ResolutionScope.COMPILE)
public class PrepareCamelMainDocMojo
extends AbstractGeneratorMojo {
    @Parameter(defaultValue="${project.basedir}/src/main/docs")
    protected File docDocDir;
    @Parameter(defaultValue="${project.basedir}/src/generated/resources/META-INF/camel-main-configuration-metadata.json")
    protected File mainJsonFile;

    @Override
    public void execute(MavenProject project, MavenProjectHelper projectHelper, BuildContext buildContext) throws MojoFailureException, MojoExecutionException {
        this.docDocDir = new File(project.getBasedir(), "src/main/docs");
        this.mainJsonFile = new File(project.getBasedir(), "src/generated/resources/META-INF/camel-main-configuration-metadata.json");
        super.execute(project, projectHelper, buildContext);
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        boolean updated;
        if (!this.mainJsonFile.exists()) {
            return;
        }
        File file = new File(this.docDocDir, "main.adoc");
        boolean exists = file.exists();
        try {
            String json = PackageHelper.loadText((File)this.mainJsonFile);
            MainModel model = JsonMapper.generateMainModel((String)json);
            String options = PrepareCamelMainDocMojo.evaluateTemplate("main-options.mvel", model);
            updated = this.updateOptionsIn(file, "main", options);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error preparing main docs", (Exception)e);
        }
        if (updated) {
            this.getLog().info((CharSequence)("Updated doc file: " + file));
        } else if (exists) {
            if (this.getLog().isDebugEnabled()) {
                this.getLog().debug((CharSequence)("No changes to doc file: " + file));
            }
        } else {
            this.getLog().warn((CharSequence)("No main doc file: " + file));
        }
    }

    private static String evaluateTemplate(String templateName, MainModel model) throws MojoExecutionException {
        StringBuilder sb = new StringBuilder();
        try (InputStream templateStream = UpdateReadmeMojo.class.getClassLoader().getResourceAsStream(templateName);){
            String template = PackageHelper.loadText((InputStream)templateStream);
            for (MainModel.MainGroupModel group : model.getGroups()) {
                HashMap<String, Object> root = new HashMap<String, Object>();
                root.put("group", group);
                root.put("options", model.getOptions().stream().filter(o -> o.getName().startsWith(group.getName())).collect(Collectors.toList()));
                String eval = (String)TemplateRuntime.eval((String)template, root, Collections.singletonMap("util", MvelHelper.INSTANCE));
                sb.append(eval);
                sb.append("\n");
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error processing mvel template `" + templateName + "`", (Exception)e);
        }
        return sb.toString();
    }

    private boolean updateOptionsIn(File file, String kind, String changed) throws MojoExecutionException {
        if (!file.exists()) {
            return false;
        }
        String updated = changed.trim();
        try {
            Object text = PackageHelper.loadText((File)file);
            String existing = Strings.between((String)text, (String)("// " + kind + " options: START"), (String)("// " + kind + " options: END"));
            if (existing != null) {
                if ((existing = existing.trim()).equals(updated)) {
                    return false;
                }
                String before = Strings.before((String)text, (String)("// " + kind + " options: START"));
                String after = Strings.after((String)text, (String)("// " + kind + " options: END"));
                text = before + "// " + kind + " options: START\n" + updated + "\n// " + kind + " options: END" + after;
                PackageHelper.writeText((File)file, (String)text);
                return true;
            }
            this.getLog().warn((CharSequence)("Cannot find markers in file " + file));
            this.getLog().warn((CharSequence)"Add the following markers");
            this.getLog().warn((CharSequence)("\t// " + kind + " options: START"));
            this.getLog().warn((CharSequence)("\t// " + kind + " options: END"));
            return false;
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error reading file " + file + " Reason: " + e, (Exception)e);
        }
    }
}

