/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.maven.packaging;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.inject.Inject;
import org.apache.camel.maven.packaging.AbstractGeneratorMojo;
import org.apache.camel.spi.Metadata;
import org.apache.camel.tooling.model.JBangModel;
import org.apache.camel.tooling.model.JsonMapper;
import org.apache.camel.tooling.util.JavadocHelper;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.codehaus.plexus.build.BuildContext;
import org.jboss.forge.roaster.Roaster;
import org.jboss.forge.roaster.model.StaticCapable;
import org.jboss.forge.roaster.model.source.AnnotationSource;
import org.jboss.forge.roaster.model.source.FieldSource;
import org.jboss.forge.roaster.model.source.JavaClassSource;

@Mojo(name="prepare-jbang", defaultPhase=LifecyclePhase.PROCESS_CLASSES, threadSafe=true, requiresDependencyResolution=ResolutionScope.COMPILE)
public class PrepareCamelJBangMojo
extends AbstractGeneratorMojo {
    @Parameter(defaultValue="${project.basedir}/src/generated/resources")
    protected File outFolder;

    @Inject
    public PrepareCamelJBangMojo(MavenProjectHelper projectHelper, BuildContext buildContext) {
        super(projectHelper, buildContext);
    }

    public static List<JBangModel.JBangOptionModel> parseConfigurationSource(String fileName) throws IOException {
        return PrepareCamelJBangMojo.parseConfigurationSource(new File(fileName));
    }

    public static List<JBangModel.JBangOptionModel> parseConfigurationSource(File file) throws IOException {
        ArrayList<JBangModel.JBangOptionModel> answer = new ArrayList<JBangModel.JBangOptionModel>();
        JavaClassSource clazz = (JavaClassSource)Roaster.parse((File)file);
        List<FieldSource> fields = clazz.getFields();
        fields = fields.stream().filter(StaticCapable::isStatic).toList();
        fields.forEach(f -> {
            AnnotationSource as = f.getAnnotation(Metadata.class);
            if (as != null) {
                String name = f.getStringInitializer();
                String javaType = as.getStringValue("javaType");
                String defaultValue = as.getStringValue("defaultValue");
                String desc = as.getStringValue("description");
                String label = as.getStringValue("label");
                boolean secret = "true".equals(as.getStringValue("secret"));
                boolean required = "true".equals(as.getStringValue("required"));
                boolean deprecated = clazz.getAnnotation(Deprecated.class) != null || f.getAnnotation(Deprecated.class) != null;
                String type = PrepareCamelJBangMojo.fromMainToType(javaType);
                JBangModel.JBangOptionModel model = new JBangModel.JBangOptionModel();
                model.setName(name);
                model.setType(type);
                model.setJavaType(javaType);
                model.setDescription(JavadocHelper.sanitizeDescription((String)desc, (boolean)false));
                model.setLabel(label);
                model.setSourceType(null);
                model.setDefaultValue(PrepareCamelJBangMojo.asDefaultValue(type, defaultValue));
                model.setDeprecated(deprecated);
                model.setSecret(secret);
                model.setRequired(required);
                List<String> enums = null;
                String text = as.getStringValue("enums");
                if (text != null) {
                    enums = Arrays.asList(text.split(","));
                }
                model.setEnums(enums);
                answer.add(model);
            }
        });
        return answer;
    }

    private static String fromMainToType(String type) {
        if ("boolean".equals(type) || "java.lang.Boolean".equals(type)) {
            return "boolean";
        }
        if ("int".equals(type) || "java.lang.Integer".equals(type)) {
            return "integer";
        }
        if ("long".equals(type) || "java.lang.Long".equals(type)) {
            return "integer";
        }
        if ("float".equals(type) || "java.lang.Float".equals(type)) {
            return "number";
        }
        if ("double".equals(type) || "java.lang.Double".equals(type)) {
            return "number";
        }
        if ("string".equals(type) || "java.lang.String".equals(type)) {
            return "string";
        }
        return "object";
    }

    private static Object asDefaultValue(String type, String defaultValue) {
        if (defaultValue != null) {
            if ("boolean".equals(type)) {
                return Boolean.parseBoolean(defaultValue);
            }
            if ("integer".equals(type)) {
                return Integer.parseInt(defaultValue);
            }
        }
        if (defaultValue == null && "boolean".equals(type)) {
            return "false";
        }
        return defaultValue;
    }

    @Override
    public void execute(MavenProject project) throws MojoFailureException, MojoExecutionException {
        this.outFolder = new File(project.getBasedir(), "src/generated/resources");
        super.execute(project);
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        File[] files = new File(this.project.getBasedir(), "src/main/java/org/apache/camel/dsl/jbang/core/common").listFiles(f -> f.isFile() && f.getName().endsWith("Constants.java"));
        if (files == null || files.length == 0) {
            return;
        }
        ArrayList<JBangModel.JBangOptionModel> data = new ArrayList<JBangModel.JBangOptionModel>();
        for (File file : files) {
            this.getLog().info((CharSequence)("Parsing Camel JBang configuration file: " + String.valueOf(file)));
            try {
                List<JBangModel.JBangOptionModel> model = PrepareCamelJBangMojo.parseConfigurationSource(file);
                data.addAll(model);
            }
            catch (Exception e) {
                throw new MojoFailureException("Error parsing file " + String.valueOf(file) + " due " + e.getMessage(), (Throwable)e);
            }
        }
        data.sort((o1, o2) -> o1.getName().compareToIgnoreCase(o2.getName()));
        if (!data.isEmpty()) {
            JBangModel model = new JBangModel();
            model.getOptions().addAll(data);
            model.getGroups().add(new JBangModel.JBangGroupModel("camel.jbang", "Camel JBang configurations", null));
            String json = JsonMapper.createJsonSchema((JBangModel)model);
            this.updateResource(this.outFolder.toPath(), "META-INF/camel-jbang-configuration-metadata.json", json);
        }
    }
}

