/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.maven.packaging;

import java.io.File;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.camel.maven.packaging.AbstractGeneratorMojo;
import org.apache.camel.maven.packaging.SchemaHelper;
import org.apache.camel.maven.packaging.generics.PackagePluginUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.Index;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.Type;

@Mojo(name="generate-type-converter-loader", threadSafe=true, requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME, defaultPhase=LifecyclePhase.PROCESS_CLASSES)
public class TypeConverterLoaderGeneratorMojo
extends AbstractGeneratorMojo {
    public static final DotName CONVERTER_ANNOTATION = DotName.createSimple((String)"org.apache.camel.Converter");
    @Parameter(defaultValue="${project.build.outputDirectory}")
    protected File classesDirectory;
    @Parameter(defaultValue="${project.basedir}/src/generated/java")
    protected File sourcesOutputDir;
    @Parameter(defaultValue="${project.basedir}/src/generated/resources")
    protected File resourcesOutputDir;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.classesDirectory == null) {
            this.classesDirectory = new File(this.project.getBuild().getOutputDirectory());
        }
        if (this.sourcesOutputDir == null) {
            this.sourcesOutputDir = new File(this.project.getBasedir(), "src/generated/java");
        }
        if (this.resourcesOutputDir == null) {
            this.resourcesOutputDir = new File(this.project.getBasedir(), "src/generated/resources");
        }
        if (!this.classesDirectory.isDirectory()) {
            return;
        }
        if ("pom".equals(this.project.getPackaging())) {
            return;
        }
        Index index = PackagePluginUtils.readJandexIndex(this.project);
        TreeMap<String, ClassConverters> converters = new TreeMap<String, ClassConverters>();
        ArrayList<MethodInfo> bulkConverters = new ArrayList<MethodInfo>();
        AtomicInteger classesCounter = new AtomicInteger();
        List annotations = index.getAnnotations(CONVERTER_ANNOTATION);
        annotations.stream().filter(annotation -> annotation.target().kind() == AnnotationTarget.Kind.CLASS).filter(annotation -> annotation.target().asClass().nestingType() == ClassInfo.NestingType.TOP_LEVEL).filter(annotation -> TypeConverterLoaderGeneratorMojo.asBoolean(annotation, "generateLoader") || TypeConverterLoaderGeneratorMojo.asBoolean(annotation, "generateBulkLoader")).forEach(annotation -> {
            classesCounter.incrementAndGet();
            String currentClass = annotation.target().asClass().name().toString();
            ClassConverters classConverters = new ClassConverters();
            if (TypeConverterLoaderGeneratorMojo.asBoolean(annotation, "generateLoader")) {
                converters.put(currentClass + "Loader", classConverters);
            }
            classConverters.setIgnoreOnLoadError(TypeConverterLoaderGeneratorMojo.asBoolean(annotation, "ignoreOnLoadError"));
            annotations.stream().filter(an -> an.target().kind() == AnnotationTarget.Kind.METHOD).filter(an -> currentClass.equals(an.target().asMethod().declaringClass().name().toString())).forEach(an -> {
                MethodInfo ee = an.target().asMethod();
                if (TypeConverterLoaderGeneratorMojo.asBoolean(an, "fallback")) {
                    classConverters.addFallbackTypeConverter(ee);
                } else {
                    Type to = ee.returnType();
                    Type from = (Type)ee.parameterTypes().get(0);
                    if (TypeConverterLoaderGeneratorMojo.asBoolean(annotation, "generateBulkLoader")) {
                        bulkConverters.add(ee);
                    } else {
                        classConverters.addTypeConverter(to, from, ee);
                    }
                }
            });
        });
        if (!bulkConverters.isEmpty()) {
            Object name;
            String pn = ((MethodInfo)bulkConverters.get(0)).declaringClass().name().prefix().toString();
            if (classesCounter.get() > 1) {
                name = SchemaHelper.dashToCamelCase(this.project.getArtifactId());
                name = Character.toUpperCase(((String)name).charAt(0)) + ((String)name).substring(1);
            } else {
                name = ((MethodInfo)bulkConverters.get(0)).declaringClass().name().local().replace("Converter", "");
            }
            String fqn = pn + "." + (String)name + "BulkConverterLoader";
            boolean base = "camel-base".equals(this.project.getArtifactId());
            String source = this.writeBulkLoader(fqn, bulkConverters, base);
            this.updateResource(this.sourcesOutputDir.toPath(), fqn.replace('.', '/') + ".java", source);
            this.updateResource(this.resourcesOutputDir.toPath(), "META-INF/services/org/apache/camel/TypeConverterLoader", "# Generated by camel build tools - do NOT edit this file!\n" + String.join((CharSequence)"\n", fqn) + "\n");
        }
        if (!converters.isEmpty()) {
            converters.forEach((currentClass, classConverters) -> {
                String source = this.writeLoader((String)currentClass, (ClassConverters)classConverters);
                this.updateResource(this.sourcesOutputDir.toPath(), currentClass.replace('.', '/') + ".java", source);
            });
            this.updateResource(this.resourcesOutputDir.toPath(), "META-INF/services/org/apache/camel/TypeConverterLoader", "# Generated by camel build tools - do NOT edit this file!\n" + String.join((CharSequence)"\n", converters.keySet()) + "\n");
        }
    }

    private String writeBulkLoader(String fqn, List<MethodInfo> converters, boolean base) {
        StringBuilder writer = new StringBuilder();
        converters.sort((o1, o2) -> {
            Integer order2;
            Integer order1;
            int sort = o1.returnType().name().compareTo(o2.returnType().name());
            if (sort == 0 && (sort = (order1 = Integer.valueOf(TypeConverterLoaderGeneratorMojo.asInteger(o1.annotation(CONVERTER_ANNOTATION), "order"))).compareTo(order2 = Integer.valueOf(TypeConverterLoaderGeneratorMojo.asInteger(o2.annotation(CONVERTER_ANNOTATION), "order")))) == 0) {
                String str1 = o1.parameterTypes().stream().findFirst().map(Type::toString).orElse("");
                String str2 = o2.parameterTypes().stream().findFirst().map(Type::toString).orElse("");
                return str1.compareTo(str2);
            }
            return sort;
        });
        TreeSet<String> converterClasses = new TreeSet<String>();
        int pos = fqn.lastIndexOf(46);
        String p = fqn.substring(0, pos);
        String c = fqn.substring(pos + 1);
        writer.append("/* ").append("Generated by camel build tools - do NOT edit this file!").append(" */\n");
        writer.append("package ").append(p).append(";\n");
        writer.append("\n");
        writer.append("import org.apache.camel.CamelContext;\n");
        writer.append("import org.apache.camel.CamelContextAware;\n");
        writer.append("import org.apache.camel.DeferredContextBinding;\n");
        writer.append("import org.apache.camel.Exchange;\n");
        writer.append("import org.apache.camel.Ordered;\n");
        writer.append("import org.apache.camel.TypeConversionException;\n");
        writer.append("import org.apache.camel.TypeConverterLoaderException;\n");
        writer.append("import org.apache.camel.TypeConverter;\n");
        writer.append("import org.apache.camel.spi.TypeConvertible;\n");
        writer.append("import org.apache.camel.spi.BulkTypeConverters;\n");
        writer.append("import org.apache.camel.spi.TypeConverterLoader;\n");
        writer.append("import org.apache.camel.spi.TypeConverterRegistry;\n");
        writer.append("\n");
        writer.append("/**\n");
        writer.append(" * ").append("Generated by camel build tools - do NOT edit this file!").append("\n");
        writer.append(" */\n");
        writer.append("@SuppressWarnings(\"unchecked\")\n");
        writer.append("@DeferredContextBinding\n");
        writer.append("public final class ").append(c).append(" implements TypeConverterLoader, BulkTypeConverters, CamelContextAware {\n");
        writer.append("\n");
        writer.append("    private CamelContext camelContext;\n");
        writer.append("\n");
        writer.append("    ").append("public ").append(c).append("() {\n");
        writer.append("    }\n");
        writer.append("\n");
        writer.append("    @Override\n");
        writer.append("    public void setCamelContext(CamelContext camelContext) {\n");
        writer.append("        this.camelContext = camelContext;\n");
        writer.append("    }\n");
        writer.append("\n");
        writer.append("    @Override\n");
        writer.append("    public CamelContext getCamelContext() {\n");
        writer.append("        return camelContext;\n");
        writer.append("    }\n");
        writer.append("\n");
        if (base) {
            writer.append("    @Override\n");
            writer.append("    public int getOrder() {\n");
            writer.append("        return Ordered.HIGHEST;\n");
            writer.append("    }\n");
            writer.append("\n");
        }
        writer.append("    @Override\n");
        writer.append("    public int size() {\n");
        writer.append("        return ").append(converters.size()).append(";\n");
        writer.append("    }\n");
        writer.append("\n");
        writer.append("    @Override\n");
        writer.append("    public void load(TypeConverterRegistry registry) throws TypeConverterLoaderException {\n");
        writer.append("        registry.addBulkTypeConverters(this);\n");
        writer.append("        doRegistration(registry);\n");
        writer.append("    }\n");
        writer.append("\n");
        writer.append("    @Override\n");
        writer.append("    public <T> T convertTo(Class<?> from, Class<T> to, Exchange exchange, Object value) throws TypeConversionException {\n");
        writer.append("        try {\n");
        writer.append("            Object obj = doConvertTo(from, to, exchange, value);\n");
        writer.append("            if (obj == Void.class) {;\n");
        writer.append("                return null;\n");
        writer.append("            } else {\n");
        writer.append("                return (T) obj;\n");
        writer.append("            }\n");
        writer.append("        } catch (TypeConversionException e) {\n");
        writer.append("            throw e;\n");
        writer.append("        } catch (Exception e) {\n");
        writer.append("            throw new TypeConversionException(value, to, e);\n");
        writer.append("        }\n");
        writer.append("    }\n");
        writer.append("\n");
        writer.append("    private Object doConvertTo(Class<?> from, Class<?> to, Exchange exchange, Object value) throws Exception {\n");
        this.writeLoader(converters, writer, converterClasses, false);
        writer.append("        }\n");
        writer.append("        return null;\n");
        writer.append("    }\n");
        writer.append("\n");
        writer.append("    private void doRegistration(TypeConverterRegistry registry) {\n");
        this.writeRegistration(converters, writer, converterClasses, false);
        writer.append("        \n");
        writer.append("        \n");
        writer.append("    }\n");
        writer.append("\n");
        writer.append("    public TypeConverter lookup(Class<?> to, Class<?> from) {\n");
        this.writeLoader(converters, writer, converterClasses, true);
        writer.append("        }\n");
        writer.append("        return null;\n");
        writer.append("    }\n");
        writer.append("\n");
        for (String f : converterClasses) {
            String s = f.substring(f.lastIndexOf(46) + 1);
            String v = s.substring(0, 1).toLowerCase() + s.substring(1);
            writer.append("    private volatile ").append(f).append(" ").append(v).append(";\n");
            writer.append("    private ").append(f).append(" get").append(s).append("() {\n");
            writer.append("        if (").append(v).append(" == null) {\n");
            writer.append("            ").append(v).append(" = new ").append(f).append("();\n");
            writer.append("            CamelContextAware.trySetCamelContext(").append(v).append(", camelContext);\n");
            writer.append("        }\n");
            writer.append("        return ").append(v).append(";\n");
            writer.append("    }\n");
        }
        writer.append("}\n");
        return writer.toString();
    }

    private void writeRegistration(List<MethodInfo> converters, StringBuilder writer, Set<String> converterClasses, boolean lookup) {
        for (MethodInfo method : converters) {
            writer.append("        registry.addConverter(new TypeConvertible<>(").append(TypeConverterLoaderGeneratorMojo.getGenericArgumentsForTypeConvertible(method)).append("), ").append("this);").append("\n");
        }
    }

    private static String resolveMethod(MethodInfo method) {
        if (Modifier.isStatic(method.flags())) {
            return method.declaringClass().toString() + "." + method.name();
        }
        return "get" + method.declaringClass().simpleName() + "()." + method.name();
    }

    private static String generateCast(MethodInfo method) {
        StringBuilder writer = new StringBuilder(128);
        if (((Type)method.parameterTypes().get(0)).kind() == Type.Kind.ARRAY || ((Type)method.parameterTypes().get(0)).kind() == Type.Kind.CLASS) {
            writer.append(((Type)method.parameterTypes().get(0)).toString());
        } else {
            writer.append(((Type)method.parameterTypes().get(0)).name().toString());
        }
        return writer.toString();
    }

    private static String getGenericArgumentsForTypeConvertible(MethodInfo method) {
        StringBuilder writer = new StringBuilder(4096);
        if (((Type)method.parameterTypes().get(0)).kind() == Type.Kind.ARRAY || ((Type)method.parameterTypes().get(0)).kind() == Type.Kind.CLASS) {
            writer.append(((Type)method.parameterTypes().get(0)).toString());
        } else {
            writer.append(((Type)method.parameterTypes().get(0)).name().toString());
        }
        writer.append(".class, ");
        writer.append(TypeConverterLoaderGeneratorMojo.getToMethod(method));
        writer.append(".class");
        return writer.toString();
    }

    private static String getArgumentsForConverter(MethodInfo method) {
        StringBuilder writer = new StringBuilder(128);
        for (Type type : method.parameterTypes()) {
            if (type.name().withoutPackagePrefix().equalsIgnoreCase("CamelContext")) {
                writer.append(", camelContext");
            }
            if (!type.name().withoutPackagePrefix().equalsIgnoreCase("Exchange")) continue;
            writer.append(", exchange");
        }
        return writer.toString();
    }

    private static String getToMethod(MethodInfo method) {
        if (Type.Kind.PRIMITIVE.equals((Object)method.returnType().kind())) {
            return method.returnType().toString();
        }
        if (Type.Kind.ARRAY.equals((Object)method.returnType().kind())) {
            return method.returnType().toString();
        }
        return method.returnType().name().toString();
    }

    private void writeLoader(List<MethodInfo> converters, StringBuilder writer, Set<String> converterClasses, boolean lookup) {
        String prevTo = null;
        for (MethodInfo method : converters) {
            String to = TypeConverterLoaderGeneratorMojo.getToMethod(method);
            String from = ((Type)method.parameterTypes().get(0)).toString();
            if (to.indexOf(60) != -1) {
                to = to.substring(0, to.indexOf(60));
            }
            if (from.indexOf(60) != -1) {
                from = from.substring(0, from.indexOf(60));
            }
            boolean newTo = false;
            if (prevTo == null) {
                writer.append("        if (to == ");
                newTo = true;
            } else if (!prevTo.equals(to)) {
                writer.append("        } else if (to == ");
                newTo = true;
            }
            if (newTo) {
                writer.append(to).append(".class");
                String primitiveTo = TypeConverterLoaderGeneratorMojo.asPrimitiveType(method);
                if (primitiveTo != null) {
                    writer.append(" || to == ").append(primitiveTo).append(".class");
                }
                writer.append(") {\n");
            }
            if (lookup) {
                writer.append("            if (from == ").append(from).append(".class) {\n");
            } else {
                writer.append("            if (value instanceof ").append(from).append(") {\n");
            }
            if (lookup) {
                writer.append("                return this;\n");
            } else if (TypeConverterLoaderGeneratorMojo.isAllowNull(method)) {
                writer.append("                Object obj = ").append(this.toJava(method, converterClasses)).append(";\n");
                writer.append("                if (obj == null) {\n");
                writer.append("                    return Void.class;\n");
                writer.append("                } else {\n");
                writer.append("                    return obj;\n");
                writer.append("                }\n");
            } else {
                writer.append("                return ").append(this.toJava(method, converterClasses)).append(";\n");
            }
            writer.append("            }\n");
            prevTo = to;
        }
    }

    private static String asPrimitiveType(MethodInfo method) {
        if (!Type.Kind.PRIMITIVE.equals((Object)method.returnType().kind())) {
            String to = method.returnType().name().toString();
            if ("java.lang.Integer".equals(to)) {
                return "int";
            }
            if ("java.lang.Long".equals(to)) {
                return "long";
            }
            if ("java.lang.Short".equals(to)) {
                return "short";
            }
            if ("java.lang.Character".equals(to)) {
                return "char";
            }
            if ("java.lang.Boolean".equals(to)) {
                return "boolean";
            }
            if ("java.lang.Float".equals(to)) {
                return "float";
            }
            if ("java.lang.Double".equals(to)) {
                return "double";
            }
        }
        return null;
    }

    private String writeLoader(String fqn, ClassConverters converters) {
        int pos = fqn.lastIndexOf(46);
        String p = fqn.substring(0, pos);
        String c = fqn.substring(pos + 1);
        LinkedHashSet<String> converterClasses = new LinkedHashSet<String>();
        StringBuilder writer = new StringBuilder();
        writer.append("/* ").append("Generated by camel build tools - do NOT edit this file!").append(" */\n");
        writer.append("package ").append(p).append(";\n");
        writer.append("\n");
        writer.append("import org.apache.camel.CamelContext;\n");
        writer.append("import org.apache.camel.CamelContextAware;\n");
        writer.append("import org.apache.camel.DeferredContextBinding;\n");
        writer.append("import org.apache.camel.Exchange;\n");
        writer.append("import org.apache.camel.TypeConversionException;\n");
        writer.append("import org.apache.camel.TypeConverterLoaderException;\n");
        writer.append("import org.apache.camel.spi.TypeConverterLoader;\n");
        writer.append("import org.apache.camel.spi.TypeConverterRegistry;\n");
        writer.append("import org.apache.camel.support.SimpleTypeConverter;\n");
        writer.append("import org.apache.camel.support.TypeConverterSupport;\n");
        writer.append("import org.apache.camel.util.DoubleMap;\n");
        writer.append("\n");
        writer.append("/**\n");
        writer.append(" * ").append("Generated by camel build tools - do NOT edit this file!").append("\n");
        writer.append(" */\n");
        writer.append("@SuppressWarnings(\"unchecked\")\n");
        writer.append("@DeferredContextBinding\n");
        writer.append("public final class ").append(c).append(" implements TypeConverterLoader, CamelContextAware {\n");
        writer.append("\n");
        writer.append("    private CamelContext camelContext;\n");
        writer.append("\n");
        writer.append("    ").append("public ").append(c).append("() {\n");
        writer.append("    }\n");
        writer.append("\n");
        writer.append("    @Override\n");
        writer.append("    public void setCamelContext(CamelContext camelContext) {\n");
        writer.append("        this.camelContext = camelContext;\n");
        writer.append("    }\n");
        writer.append("\n");
        writer.append("    @Override\n");
        writer.append("    public CamelContext getCamelContext() {\n");
        writer.append("        return camelContext;\n");
        writer.append("    }\n");
        writer.append("\n");
        writer.append("    @Override\n");
        writer.append("    public void load(TypeConverterRegistry registry) throws TypeConverterLoaderException {\n");
        if (converters.size() > 0L) {
            if (converters.isIgnoreOnLoadError()) {
                writer.append("        try {\n");
                writer.append("            registerConverters(registry);\n");
                writer.append("        } catch (Throwable e) {\n");
                writer.append("            // ignore on load error\n");
                writer.append("        }\n");
            } else {
                writer.append("        registerConverters(registry);\n");
            }
        }
        if (converters.sizeFallback() > 0L) {
            writer.append("        registerFallbackConverters(registry);\n");
        }
        writer.append("    }\n");
        writer.append("\n");
        if (converters.size() > 0L) {
            writer.append("    private void registerConverters(TypeConverterRegistry registry) {\n");
            for (Map.Entry entry : converters.getConverters().entrySet()) {
                for (Map.Entry from : ((Map)entry.getValue()).entrySet()) {
                    boolean allowNull = TypeConverterLoaderGeneratorMojo.isAllowNull((MethodInfo)from.getValue());
                    writer.append("        addTypeConverter(registry, ").append((String)entry.getKey()).append(".class").append(", ").append(this.toString((Type)from.getKey())).append(".class, ").append(allowNull).append(",\n");
                    writer.append("            (type, exchange, value) -> ").append(this.toJava((MethodInfo)from.getValue(), converterClasses)).append(");\n");
                }
            }
            writer.append("    }\n");
            writer.append("\n");
            writer.append("    private static void addTypeConverter(TypeConverterRegistry registry, Class<?> toType, Class<?> fromType, boolean allowNull, SimpleTypeConverter.ConversionMethod method) { \n");
            writer.append("        registry.addTypeConverter(toType, fromType, new SimpleTypeConverter(allowNull, method));\n");
            writer.append("    }\n");
            writer.append("\n");
        }
        if (converters.sizeFallback() > 0L) {
            writer.append("    private void registerFallbackConverters(TypeConverterRegistry registry) {\n");
            for (MethodInfo methodInfo : converters.getFallbackConverters()) {
                boolean allowNull = TypeConverterLoaderGeneratorMojo.isAllowNull(methodInfo);
                boolean canPromote = TypeConverterLoaderGeneratorMojo.isFallbackCanPromote(methodInfo);
                writer.append("        addFallbackTypeConverter(registry, ").append(allowNull).append(", ").append(canPromote).append(", ").append("(type, exchange, value) -> ").append(this.toJavaFallback(methodInfo, converterClasses)).append(");\n");
            }
            writer.append("    }\n");
            writer.append("\n");
            writer.append("    private static void addFallbackTypeConverter(TypeConverterRegistry registry, boolean allowNull, boolean canPromote, SimpleTypeConverter.ConversionMethod method) { \n");
            writer.append("        registry.addFallbackTypeConverter(new SimpleTypeConverter(allowNull, method), canPromote);\n");
            writer.append("    }\n");
            writer.append("\n");
        }
        for (String string : converterClasses) {
            String s = string.substring(string.lastIndexOf(46) + 1);
            String v = s.substring(0, 1).toLowerCase() + s.substring(1);
            writer.append("    private volatile ").append(string).append(" ").append(v).append(";\n");
            writer.append("    private ").append(string).append(" get").append(s).append("() {\n");
            writer.append("        if (").append(v).append(" == null) {\n");
            writer.append("            ").append(v).append(" = new ").append(string).append("();\n");
            writer.append("            CamelContextAware.trySetCamelContext(").append(v).append(", camelContext);\n");
            writer.append("        }\n");
            writer.append("        return ").append(v).append(";\n");
            writer.append("    }\n");
        }
        writer.append("}\n");
        return writer.toString();
    }

    private String toString(Type type) {
        return type.toString().replaceAll("<.*>", "").replace('$', '.');
    }

    private String toJava(MethodInfo converter, Set<String> converterClasses) {
        String type;
        String paramType;
        String pfx;
        if (Modifier.isStatic(converter.flags())) {
            pfx = converter.declaringClass().toString() + "." + converter.name();
        } else {
            converterClasses.add(converter.declaringClass().toString());
            pfx = "get" + converter.declaringClass().simpleName() + "()." + converter.name();
        }
        String param = "";
        String string = paramType = converter.parameterTypes().size() == 2 ? ((Type)converter.parameterTypes().get(1)).asClassType().name().toString() : null;
        if (paramType != null) {
            if ("org.apache.camel.Exchange".equals(paramType)) {
                param = ", exchange";
            } else if ("org.apache.camel.CamelContext".equals(paramType)) {
                param = ", camelContext";
            }
        }
        Object cast = (type = this.toString((Type)converter.parameterTypes().get(0))).equals("java.lang.Object") ? "" : "(" + type + ") ";
        return pfx + "(" + (String)cast + "value" + param + ")";
    }

    private String toJavaFallback(MethodInfo converter, Set<String> converterClasses) {
        String pfx;
        if (Modifier.isStatic(converter.flags())) {
            pfx = converter.declaringClass().toString() + "." + converter.name();
        } else {
            converterClasses.add(converter.declaringClass().toString());
            pfx = "get" + converter.declaringClass().simpleName() + "()." + converter.name();
        }
        String type = this.toString((Type)converter.parameterTypes().get(converter.parameterTypes().size() - 2));
        Object cast = type.equals("java.lang.Object") ? "" : "(" + type + ") ";
        return pfx + "(type, " + (converter.parameterTypes().size() == 4 ? "exchange, " : "") + (String)cast + "value, registry)";
    }

    private static boolean isFallbackCanPromote(MethodInfo element) {
        return TypeConverterLoaderGeneratorMojo.asBoolean(element.annotation(CONVERTER_ANNOTATION), "fallbackCanPromote");
    }

    private static boolean isAllowNull(MethodInfo element) {
        return TypeConverterLoaderGeneratorMojo.asBoolean(element.annotation(CONVERTER_ANNOTATION), "allowNull");
    }

    private static boolean asBoolean(AnnotationInstance ai, String name) {
        AnnotationValue av = ai.value(name);
        return av != null && av.asBoolean();
    }

    private static int asInteger(AnnotationInstance ai, String name) {
        AnnotationValue av = ai.value(name);
        return av != null ? av.asInt() : 0;
    }

    public static final class ClassConverters {
        private final Comparator<Type> comparator;
        private final Map<String, Map<Type, MethodInfo>> converters = new TreeMap<String, Map<Type, MethodInfo>>();
        private final List<MethodInfo> fallbackConverters = new ArrayList<MethodInfo>();
        private int size;
        private int sizeFallback;
        private boolean ignoreOnLoadError;

        ClassConverters() {
            this.comparator = Comparator.comparing(Type::toString);
        }

        public boolean isIgnoreOnLoadError() {
            return this.ignoreOnLoadError;
        }

        void setIgnoreOnLoadError(boolean ignoreOnLoadError) {
            this.ignoreOnLoadError = ignoreOnLoadError;
        }

        void addTypeConverter(Type to, Type from, MethodInfo ee) {
            this.converters.computeIfAbsent(ClassConverters.toString(to), c -> new TreeMap(this.comparator)).put(from, ee);
            ++this.size;
        }

        void addFallbackTypeConverter(MethodInfo ee) {
            this.fallbackConverters.add(ee);
            ++this.sizeFallback;
        }

        public Map<String, Map<Type, MethodInfo>> getConverters() {
            return this.converters;
        }

        public List<MethodInfo> getFallbackConverters() {
            return this.fallbackConverters;
        }

        public long size() {
            return this.size;
        }

        public long sizeFallback() {
            return this.sizeFallback;
        }

        public boolean isEmpty() {
            return this.size == 0 && this.sizeFallback == 0;
        }

        private static String toString(Type type) {
            return type.toString().replaceAll("<.*>", "").replace('$', '.');
        }
    }
}

