/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.maven.packaging;

import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.camel.maven.packaging.AbstractGenerateConfigurerMojo;
import org.apache.camel.tooling.model.BaseOptionModel;
import org.apache.camel.tooling.model.ComponentModel;

public final class PropertyConfigurerGenerator {
    private PropertyConfigurerGenerator() {
    }

    public static String generatePropertyConfigurer(String pn, String cn, String en, String pfqn, String psn, boolean hasSuper, boolean component, boolean extended, boolean bootstrap, Collection<? extends BaseOptionModel> options, ComponentModel model) {
        boolean stub;
        StringBuilder w = new StringBuilder();
        w.append("/* ").append("Generated by camel build tools - do NOT edit this file! */\n");
        w.append("package ").append(pn).append(";\n");
        w.append('\n');
        w.append("import java.util.Map;\n");
        w.append("\n");
        w.append("import org.apache.camel.CamelContext;\n");
        w.append("import org.apache.camel.spi.ExtendedPropertyConfigurerGetter;\n");
        w.append("import org.apache.camel.spi.PropertyConfigurerGetter;\n");
        w.append("import org.apache.camel.spi.ConfigurerStrategy;\n");
        w.append("import org.apache.camel.spi.GeneratedPropertyConfigurer;\n");
        w.append("import org.apache.camel.util.CaseInsensitiveMap;\n");
        w.append("import ").append(pfqn).append(";\n");
        w.append('\n');
        w.append("/**\n");
        w.append(" * ").append("Generated by camel build tools - do NOT edit this file!").append('\n');
        w.append(" */\n");
        w.append("@SuppressWarnings(\"unchecked\")\n");
        w.append("public class ").append(cn).append(" extends ").append(psn).append(" implements GeneratedPropertyConfigurer");
        if (extended) {
            w.append(", ExtendedPropertyConfigurerGetter");
        } else {
            w.append(", PropertyConfigurerGetter");
        }
        w.append(" {\n");
        w.append('\n');
        if (!options.isEmpty()) {
            options = options.stream().sorted(Comparator.comparing(BaseOptionModel::getName)).collect(Collectors.toList());
        }
        if (extended && (model != null || !hasSuper)) {
            w.append("    private static final Map<String, Object> ALL_OPTIONS;\n");
            if (model != null) {
                w.append(PropertyConfigurerGenerator.generateAllOptions(cn, bootstrap, component, model));
            } else {
                w.append(PropertyConfigurerGenerator.generateAllOptions(cn, bootstrap, options));
            }
            w.append('\n');
        }
        boolean bl = stub = model != null && model.getName().equals("stub");
        if (stub && options.isEmpty() && !component) {
            w.append("    @Override\n");
            w.append("    public boolean configure(CamelContext camelContext, Object obj, String name, Object value, boolean ignoreCase) {\n");
            w.append("        super.configure(camelContext, obj, name, value, ignoreCase);\n");
            w.append("        return true;\n");
            w.append("    }\n");
        } else if (!options.isEmpty() || !hasSuper) {
            Object n;
            String type;
            Object getOrSet;
            if (component) {
                for (BaseOptionModel bo : PropertyConfigurerGenerator.findConfigurations(options)) {
                    w.append(PropertyConfigurerGenerator.createGetOrCreateConfiguration(en, bo.getConfigurationClass(), bo.getConfigurationField()));
                    w.append('\n');
                }
            }
            w.append("    @Override\n");
            w.append("    public boolean configure(CamelContext camelContext, Object obj, String name, Object value, boolean ignoreCase) {\n");
            if (!options.isEmpty()) {
                w.append("        ").append(en).append(" target = (").append(en).append(") obj;\n");
                w.append("        switch (ignoreCase ? name.toLowerCase() : name) {\n");
                for (BaseOptionModel option : options) {
                    getOrSet = option.getName();
                    getOrSet = Character.toUpperCase(((String)getOrSet).charAt(0)) + ((String)getOrSet).substring(1);
                    boolean builder = option instanceof AbstractGenerateConfigurerMojo.ConfigurerOption && ((AbstractGenerateConfigurerMojo.ConfigurerOption)option).isBuilderMethod();
                    String setterLambda = PropertyConfigurerGenerator.setterLambda((String)getOrSet, option.getJavaType(), option.getSetterMethod(), option.getConfigurationField(), component, option.getType(), builder);
                    Object n2 = option.getName();
                    n2 = Character.toLowerCase(((String)n2).charAt(0)) + ((String)n2).substring(1);
                    if (!option.getName().toLowerCase().equals(n2)) {
                        w.append(String.format("        case \"%s\":\n", option.getName().toLowerCase()));
                    }
                    w.append(String.format("        case \"%s\": %s; return true;\n", n2, setterLambda));
                }
                if (stub) {
                    w.append("        default: return true;\n");
                } else if (hasSuper) {
                    w.append("        default: return super.configure(camelContext, obj, name, value, ignoreCase);\n");
                } else {
                    w.append("        default: return false;\n");
                }
                w.append("        }\n");
            } else {
                w.append("        return false;\n");
            }
            w.append("    }\n");
            if (extended) {
                w.append('\n');
                w.append("    @Override\n");
                w.append("    public Map<String, Object> getAllOptions(Object target) {\n");
                if (model != null || !hasSuper) {
                    w.append("        return ALL_OPTIONS;\n");
                    w.append("    }\n");
                } else {
                    w.append("        Map<String, Object> answer = super.getAllOptions(target);\n");
                    if (!options.isEmpty()) {
                        for (BaseOptionModel option : options) {
                            type = option.getJavaType();
                            if (type.indexOf(60) != -1) {
                                type = type.substring(0, type.indexOf(60));
                            }
                            type = type.replace('$', '.');
                            w.append(String.format("        answer.put(\"%s\", %s.class);\n", option.getName(), type));
                        }
                        w.append("        return answer;\n");
                        w.append("    }\n");
                    }
                }
            }
            if (bootstrap && extended) {
                w.append('\n');
                w.append("    public static void clearBootstrapConfigurers() {\n");
                w.append("        ALL_OPTIONS.clear();\n");
                w.append("    }\n");
            }
            if (options.stream().anyMatch(BaseOptionModel::isAutowired)) {
                w.append('\n');
                w.append("    @Override\n");
                w.append("    public String[] getAutowiredNames() {\n");
                Iterator names = options.stream().filter(BaseOptionModel::isAutowired).map(BaseOptionModel::getName).map(PropertyConfigurerGenerator::quote).collect(Collectors.joining(","));
                w.append("        return new String[]{");
                w.append((String)((Object)names));
                w.append("};\n");
                w.append("    }\n");
            }
            w.append('\n');
            w.append("    @Override\n");
            w.append("    public Class<?> getOptionType(String name, boolean ignoreCase) {\n");
            if (!options.isEmpty()) {
                w.append("        switch (ignoreCase ? name.toLowerCase() : name) {\n");
                for (BaseOptionModel option : options) {
                    type = option.getJavaType();
                    if (type.indexOf(60) != -1) {
                        type = type.substring(0, type.indexOf(60));
                    }
                    type = type.replace('$', '.');
                    Object n3 = option.getName();
                    n3 = Character.toLowerCase(((String)n3).charAt(0)) + ((String)n3).substring(1);
                    if (!option.getName().toLowerCase().equals(n3)) {
                        w.append(String.format("        case \"%s\":\n", option.getName().toLowerCase()));
                    }
                    w.append(String.format("        case \"%s\": return %s.class;\n", n3, type));
                }
                if (hasSuper) {
                    w.append("        default: return super.getOptionType(name, ignoreCase);\n");
                } else {
                    w.append("        default: return null;\n");
                }
                w.append("        }\n");
            } else {
                w.append("        return null;\n");
            }
            w.append("    }\n");
            w.append('\n');
            w.append("    @Override\n");
            w.append("    public Object getOptionValue(Object obj, String name, boolean ignoreCase) {\n");
            if (!options.isEmpty()) {
                w.append("        ").append(en).append(" target = (").append(en).append(") obj;\n");
                w.append("        switch (ignoreCase ? name.toLowerCase() : name) {\n");
                for (BaseOptionModel option : options) {
                    getOrSet = option.getName();
                    getOrSet = Character.toUpperCase(((String)getOrSet).charAt(0)) + ((String)getOrSet).substring(1);
                    String getterLambda = PropertyConfigurerGenerator.getterLambda((String)getOrSet, option.getJavaType(), option.getGetterMethod(), option.getConfigurationField(), component);
                    n = option.getName();
                    n = Character.toLowerCase(((String)n).charAt(0)) + ((String)n).substring(1);
                    if (!option.getName().toLowerCase().equals(n)) {
                        w.append(String.format("        case \"%s\":\n", option.getName().toLowerCase()));
                    }
                    w.append(String.format("        case \"%s\": return %s;\n", n, getterLambda));
                }
                if (hasSuper) {
                    w.append("        default: return super.getOptionValue(obj, name, ignoreCase);\n");
                } else {
                    w.append("        default: return null;\n");
                }
                w.append("        }\n");
            } else {
                w.append("        return null;\n");
            }
            w.append("    }\n");
            boolean hasNestedTypes = options.stream().map(BaseOptionModel::getNestedType).anyMatch(s -> s != null && !s.isBlank());
            if (hasNestedTypes) {
                w.append('\n');
                w.append("    @Override\n");
                w.append("    public Object getCollectionValueType(Object target, String name, boolean ignoreCase) {\n");
                if (!options.isEmpty()) {
                    w.append("        switch (ignoreCase ? name.toLowerCase() : name) {\n");
                    for (BaseOptionModel option : options) {
                        String nestedType = option.getNestedType();
                        if (nestedType == null || nestedType.isEmpty()) continue;
                        nestedType = nestedType.replace('$', '.');
                        n = option.getName();
                        n = Character.toLowerCase(((String)n).charAt(0)) + ((String)n).substring(1);
                        if (!option.getName().toLowerCase().equals(n)) {
                            w.append(String.format("        case \"%s\":\n", option.getName().toLowerCase()));
                        }
                        w.append(String.format("        case \"%s\": return %s.class;\n", n, nestedType));
                    }
                    if (hasSuper) {
                        w.append("        default: return super.getCollectionValueType(target, name, ignoreCase);\n");
                    } else {
                        w.append("        default: return null;\n");
                    }
                    w.append("        }\n");
                } else {
                    w.append("        return null;\n");
                }
                w.append("    }\n");
            }
        }
        w.append("}\n");
        w.append('\n');
        return w.toString();
    }

    private static String generateAllOptions(String className, boolean bootstrap, boolean component, ComponentModel model) {
        StringBuilder sb = new StringBuilder();
        sb.append("    static {\n");
        sb.append("        Map<String, Object> map = new CaseInsensitiveMap();\n");
        if (component) {
            for (ComponentModel.ComponentOptionModel option : model.getComponentOptions()) {
                String type = option.getJavaType();
                if (type.indexOf(60) != -1) {
                    type = type.substring(0, type.indexOf(60));
                }
                type = type.replace('$', '.');
                sb.append(String.format("        map.put(\"%s\", %s.class);\n", option.getName(), type));
            }
        } else {
            for (ComponentModel.EndpointOptionModel option : model.getEndpointOptions()) {
                String type = option.getJavaType();
                if (type.indexOf(60) != -1) {
                    type = type.substring(0, type.indexOf(60));
                }
                type = type.replace('$', '.');
                sb.append(String.format("        map.put(\"%s\", %s.class);\n", option.getName(), type));
            }
        }
        sb.append("        ALL_OPTIONS = map;\n");
        if (bootstrap) {
            sb.append("        ConfigurerStrategy.addBootstrapConfigurerClearer(").append(className).append("::clearBootstrapConfigurers);\n");
        }
        sb.append("    }\n");
        return sb.toString();
    }

    private static String generateAllOptions(String className, boolean bootstrap, Collection<? extends BaseOptionModel> options) {
        StringBuilder sb = new StringBuilder();
        sb.append("    static {\n");
        sb.append("        Map<String, Object> map = new CaseInsensitiveMap();\n");
        for (BaseOptionModel baseOptionModel : options) {
            String type = baseOptionModel.getJavaType();
            if (type.indexOf(60) != -1) {
                type = type.substring(0, type.indexOf(60));
            }
            type = type.replace('$', '.');
            sb.append(String.format("        map.put(\"%s\", %s.class);\n", baseOptionModel.getName(), type));
        }
        sb.append("        ALL_OPTIONS = map;\n");
        if (bootstrap) {
            sb.append("        ConfigurerStrategy.addBootstrapConfigurerClearer(").append(className).append("::clearBootstrapConfigurers);\n");
        }
        sb.append("    }\n");
        return sb.toString();
    }

    private static Set<BaseOptionModel> findConfigurations(Collection<? extends BaseOptionModel> options) {
        LinkedHashSet<String> found = new LinkedHashSet<String>();
        LinkedHashSet<BaseOptionModel> answer = new LinkedHashSet<BaseOptionModel>();
        for (BaseOptionModel bo : options.stream().filter(o -> o.getConfigurationField() != null).collect(Collectors.toList())) {
            if (found.contains(bo.getConfigurationClass())) continue;
            found.add(bo.getConfigurationClass());
            answer.add(bo);
        }
        return answer;
    }

    private static String setterLambda(String getOrSet, String type, String setterMethod, String configurationField, boolean component, String optionKind, boolean builder) {
        String prefix;
        if (type.indexOf(60) != -1) {
            type = type.substring(0, type.indexOf(60));
        }
        type = type.replace('$', '.');
        String string = prefix = builder ? "with" : "set";
        if (configurationField != null) {
            if (component) {
                String methodName = "getOrCreate" + Character.toUpperCase(configurationField.charAt(0)) + configurationField.substring(1);
                getOrSet = methodName + "(target)." + prefix + (String)getOrSet;
            } else {
                getOrSet = "target.get" + Character.toUpperCase(configurationField.charAt(0)) + configurationField.substring(1) + "()." + prefix + (String)getOrSet;
            }
        } else {
            getOrSet = "target." + prefix + (String)getOrSet;
        }
        String rv = "duration".equals(optionKind) && "long".equals(type) ? "property(camelContext, java.time.Duration.class, value).toMillis()" : String.format("property(camelContext, %s.class, value)", type);
        String v = setterMethod != null ? String.format(setterMethod, rv) : rv;
        return String.format("%s(%s)", getOrSet, v);
    }

    private static String getterLambda(String getOrSet, String type, String getterMethod, String configurationField, boolean component) {
        String prefix;
        if (getterMethod == null || getterMethod.isEmpty()) {
            prefix = "boolean".equals(type) ? "is" : "get";
        } else {
            prefix = "";
            getOrSet = getterMethod;
        }
        if (configurationField != null) {
            if (component) {
                String methodName = "getOrCreate" + Character.toUpperCase(configurationField.charAt(0)) + configurationField.substring(1);
                getOrSet = methodName + "(target)." + prefix + (String)getOrSet;
            } else {
                getOrSet = "target.get" + Character.toUpperCase(configurationField.charAt(0)) + configurationField.substring(1) + "()." + prefix + (String)getOrSet;
            }
        } else {
            getOrSet = "target." + prefix + (String)getOrSet;
        }
        return (String)getOrSet + "()";
    }

    private static String createGetOrCreateConfiguration(String targetClass, String configurationClass, String configurationField) {
        String getter = "get" + Character.toUpperCase(configurationField.charAt(0)) + configurationField.substring(1);
        String setter = "set" + Character.toUpperCase(configurationField.charAt(0)) + configurationField.substring(1);
        String methodName = "getOrCreate" + Character.toUpperCase(configurationField.charAt(0)) + configurationField.substring(1);
        StringBuilder sb = new StringBuilder();
        String line1 = String.format("    private %s %s(%s target) {\n", configurationClass, methodName, targetClass);
        String line2 = String.format("        if (target.%s() == null) {\n", getter);
        String line3 = String.format("            target.%s(new %s());\n", setter, configurationClass);
        String line4 = "        }\n";
        String line5 = String.format("        return target.%s();\n", getter);
        String line6 = "    }\n";
        sb.append(line1).append(line2).append(line3).append(line4).append(line5).append(line6);
        return sb.toString();
    }

    private static String quote(String n) {
        return "\"" + n + "\"";
    }
}

