/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.maven.packaging;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.camel.maven.packaging.AbstractGeneratorMojo;
import org.apache.camel.maven.packaging.generics.PackagePluginUtils;
import org.apache.camel.spi.annotations.ConstantProvider;
import org.apache.camel.spi.annotations.ServiceFactory;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.CompositeIndex;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexReader;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.Indexer;

@Mojo(name="generate-spi", threadSafe=true, requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME, defaultPhase=LifecyclePhase.PROCESS_CLASSES)
public class SpiGeneratorMojo
extends AbstractGeneratorMojo {
    public static final DotName SERVICE_FACTORY = DotName.createSimple((String)ServiceFactory.class.getName());
    public static final DotName CONSTANT_PROVIDER = DotName.createSimple((String)ConstantProvider.class.getName());
    @Parameter(defaultValue="${project.build.outputDirectory}")
    protected File classesDirectory;
    @Parameter(defaultValue="${project.basedir}/src/generated/java")
    protected File sourcesOutputDir;
    @Parameter(defaultValue="${project.basedir}/src/generated/resources")
    protected File resourcesOutputDir;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.classesDirectory == null) {
            this.classesDirectory = new File(this.project.getBuild().getOutputDirectory());
        }
        if (this.sourcesOutputDir == null) {
            this.sourcesOutputDir = new File(this.project.getBasedir(), "src/generated/java");
        }
        if (this.resourcesOutputDir == null) {
            this.resourcesOutputDir = new File(this.project.getBasedir(), "src/generated/resources");
        }
        if (!this.classesDirectory.isDirectory()) {
            return;
        }
        IndexView index = this.getIndex();
        for (AnnotationInstance cpa : index.getAnnotations(CONSTANT_PROVIDER)) {
            if (cpa.target().kind() != AnnotationTarget.Kind.CLASS || cpa.target().asClass().nestingType() != ClassInfo.NestingType.TOP_LEVEL) continue;
            String providerClassName = cpa.value().asString();
            String className = cpa.target().asClass().name().toString();
            if (!this.isLocal(className)) continue;
            TreeMap<String, String> fields = new TreeMap<String, String>(String::compareToIgnoreCase);
            try {
                Class<?> cl = this.getProjectClassLoader().loadClass(className);
                for (Field field : cl.getDeclaredFields()) {
                    if (field.getType() != String.class || !Modifier.isPublic(field.getModifiers())) continue;
                    fields.put(field.getName(), field.get(null).toString());
                }
            }
            catch (Exception e) {
                throw new MojoExecutionException("Unable to load class", e);
            }
            String source = this.generateConstantProviderClass(providerClassName, fields);
            this.updateResource(this.sourcesOutputDir.toPath(), providerClassName.replace('.', '/') + ".java", source);
        }
        for (AnnotationInstance sfa : index.getAnnotations(SERVICE_FACTORY)) {
            if (sfa.target().kind() != AnnotationTarget.Kind.CLASS || sfa.target().asClass().nestingType() != ClassInfo.NestingType.TOP_LEVEL) continue;
            DotName sfaName = sfa.target().asClass().name();
            for (AnnotationInstance annotation : index.getAnnotations(sfaName)) {
                String className;
                if (annotation.target().kind() != AnnotationTarget.Kind.CLASS || annotation.target().asClass().nestingType() != ClassInfo.NestingType.TOP_LEVEL && annotation.target().asClass().nestingType() != ClassInfo.NestingType.INNER || !this.isLocal(className = annotation.target().asClass().name().toString())) continue;
                String pvals = annotation.value() == null ? annotation.values().stream().filter(annotationValue -> "name".equals(annotationValue.name())).map(name -> name.value().toString()).findFirst().get() : annotation.value().asString();
                for (String pval : pvals.split(",")) {
                    pval = this.sanitizeFileName(pval);
                    StringBuilder sb = new StringBuilder();
                    sb.append("# ").append("Generated by camel build tools - do NOT edit this file!").append("\n").append("class=").append(className).append("\n");
                    if ("#jdk#".equals(sfa.value().asString())) {
                        this.updateResource(this.resourcesOutputDir.toPath(), "META-INF/services/org/apache/camel/" + pval, sb.toString());
                        continue;
                    }
                    this.updateResource(this.resourcesOutputDir.toPath(), "META-INF/services/org/apache/camel/" + sfa.value().asString() + "/" + pval, sb.toString());
                }
            }
        }
    }

    private String sanitizeFileName(String fileName) {
        return fileName.replaceAll("[^A-Za-z0-9+-/]", "-").replace('.', '-');
    }

    private boolean isLocal(String className) {
        Path output = Paths.get(this.project.getBuild().getOutputDirectory(), new String[0]);
        Path file = output.resolve(className.replace('.', '/') + ".class");
        return Files.isRegularFile(file, new LinkOption[0]);
    }

    private IndexView getIndex() throws MojoExecutionException {
        Pattern cpePattern = Pattern.compile(".*/camel-[^/]+.jar");
        try {
            ArrayList<IndexView> indices = new ArrayList<IndexView>();
            indices.add((IndexView)PackagePluginUtils.readJandexIndex(this.project));
            for (String cpe : this.project.getCompileClasspathElements()) {
                Matcher matcher = cpePattern.matcher(cpe);
                if (!matcher.matches()) continue;
                this.addIndex(indices, cpe);
            }
            return CompositeIndex.create(indices);
        }
        catch (Exception e) {
            throw new MojoExecutionException("IOException: " + e.getMessage(), e);
        }
    }

    private void addIndex(List<IndexView> indices, String cpe) throws IOException {
        try (JarFile jf = new JarFile(cpe);){
            JarEntry indexEntry = jf.getJarEntry("META-INF/jandex.idx");
            if (indexEntry != null) {
                this.readIndexFromJandex(indices, jf, indexEntry);
            } else {
                this.createIndexFromClass(indices, jf);
            }
        }
    }

    private void createIndexFromClass(List<IndexView> indices, JarFile jf) throws IOException {
        Indexer indexer = new Indexer();
        List<JarEntry> classes = jf.stream().filter(je -> je.getName().endsWith(".class")).toList();
        for (JarEntry je2 : classes) {
            InputStream is = jf.getInputStream(je2);
            try {
                indexer.index(is);
            }
            finally {
                if (is == null) continue;
                is.close();
            }
        }
        indices.add((IndexView)indexer.complete());
    }

    private void readIndexFromJandex(List<IndexView> indices, JarFile jf, JarEntry indexEntry) throws IOException {
        try (InputStream is = jf.getInputStream(indexEntry);){
            indices.add((IndexView)new IndexReader(is).read());
        }
    }

    private String generateConstantProviderClass(String fqn, Map<String, String> fields) {
        String pn = fqn.substring(0, fqn.lastIndexOf(46));
        String cn = fqn.substring(fqn.lastIndexOf(46) + 1);
        StringBuilder w = new StringBuilder();
        w.append("/* ").append("Generated by camel build tools - do NOT edit this file!").append(" */\n");
        w.append("package ").append(pn).append(";\n");
        w.append("\n");
        w.append("import java.util.HashMap;\n");
        w.append("import java.util.Map;\n");
        w.append("\n");
        w.append("/**\n");
        w.append(" * ").append("Generated by camel build tools - do NOT edit this file!").append("\n");
        w.append(" */\n");
        w.append("public class ").append(cn).append(" {\n");
        w.append("\n");
        w.append("    private static final Map<String, String> MAP;\n");
        w.append("    static {\n");
        w.append("        Map<String, String> map = new HashMap<>(").append(fields.size()).append(");\n");
        for (Map.Entry<String, String> entry : fields.entrySet()) {
            w.append("        map.put(\"").append(entry.getKey()).append("\", \"").append(entry.getValue()).append("\");\n");
        }
        w.append("        MAP = map;\n");
        w.append("    }\n");
        w.append("\n");
        w.append("    public static String lookup(String key) {\n");
        w.append("        return MAP.get(key);\n");
        w.append("    }\n");
        w.append("}\n");
        w.append("\n");
        return w.toString();
    }
}

