/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.maven.packaging.generics;

import java.io.IOException;
import java.io.LineNumberReader;
import java.io.StringReader;
import java.util.List;
import org.apache.camel.tooling.model.ComponentModel;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.dom.ASTNode;
import org.jboss.forge.roaster.model.source.MethodSource;

public final class JavadocUtil {
    private JavadocUtil() {
    }

    public static String getMainDescription(ComponentModel model) {
        return JavadocUtil.getMainDescription(model, true);
    }

    public static String getMainDescription(ComponentModel model, boolean withPathParameterDetails) {
        StringBuilder descSb = new StringBuilder(512);
        descSb.append(model.getTitle()).append(" (").append(model.getArtifactId()).append(")");
        descSb.append("\n").append(model.getDescription());
        descSb.append("\n\nCategory: ").append(model.getLabel());
        descSb.append("\nSince: ").append(model.getFirstVersionShort());
        descSb.append("\nMaven coordinates: ").append(model.getGroupId()).append(":").append(model.getArtifactId());
        if (withPathParameterDetails) {
            descSb.append("\n\nSyntax: <code>").append(model.getSyntax()).append("</code>");
            for (ComponentModel.EndpointOptionModel option : model.getEndpointOptions()) {
                if (!"path".equals(option.getKind())) continue;
                descSb.append("\n\nPath parameter: ").append(option.getName());
                if (option.isRequired()) {
                    descSb.append(" (required)");
                }
                if (option.isDeprecated()) {
                    descSb.append(" <strong>deprecated</strong>");
                }
                descSb.append("\n").append(option.getDescription());
                if (option.isSupportFileReference()) {
                    descSb.append("\nThis option can also be loaded from an existing file, by prefixing with file: or classpath: followed by the location of the file.");
                }
                if (option.getDefaultValue() != null) {
                    descSb.append("\nDefault value: ").append(option.getDefaultValue());
                }
                if (option.getEnums() == null || option.getEnums().isEmpty()) continue;
                descSb.append("\nThere are ").append(option.getEnums().size()).append(" enums and the value can be one of: ").append(JavadocUtil.wrapEnumValues(option.getEnums()));
            }
        }
        return descSb.toString();
    }

    private static String wrapEnumValues(List<String> enumValues) {
        return String.join((CharSequence)", ", enumValues);
    }

    public static String pathParameterJavaDoc(ComponentModel model) {
        String doc = null;
        int pos = model.getSyntax().indexOf(58);
        doc = pos != -1 ? model.getSyntax().substring(pos + 1) : model.getSyntax();
        char ch = doc.charAt(0);
        while (!Character.isAlphabetic(ch)) {
            doc = doc.substring(1);
            ch = doc.charAt(0);
        }
        return doc;
    }

    public static String extractJavaDoc(String sourceCode, MethodSource<?> ms) throws IOException {
        Object internal = ms.getJavaDoc().getInternal();
        if (internal instanceof ASTNode) {
            int pos = ((ASTNode)internal).getStartPosition();
            int len = ((ASTNode)internal).getLength();
            if (pos > 0 && len > 0) {
                String line;
                String doc = sourceCode.substring(pos, pos + len);
                LineNumberReader ln = new LineNumberReader(new StringReader(doc));
                StringBuilder sb = new StringBuilder(256);
                while ((line = ln.readLine()) != null) {
                    if ((line = line.trim()).startsWith("/**") || line.startsWith("*/")) continue;
                    if (line.startsWith("*")) {
                        line = line.substring(1).trim();
                    }
                    sb.append(line);
                    sb.append("\n");
                }
                doc = sb.toString();
                return doc;
            }
        }
        return null;
    }
}

